/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBusConnection
extends AbstractConnection {
    public static final int SYSTEM = 0;
    public static final int SESSION = 1;
    public static final String DEFAULT_SYSTEM_BUS_ADDRESS = "unix:path=/var/run/dbus/system_bus_socket";
    private List<String> busnames;
    private static final Map<Object, DBusConnection> conn = new HashMap<Object, DBusConnection>();
    private int _refcount = 0;
    private Object _reflock = new Object();
    private DBus _dbus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusConnection getConnection(String string) throws DBusException {
        Map<Object, DBusConnection> map = conn;
        synchronized (map) {
            DBusConnection dBusConnection = conn.get(string);
            if (null != dBusConnection) {
                Object object = dBusConnection._reflock;
                synchronized (object) {
                    ++dBusConnection._refcount;
                }
                return dBusConnection;
            }
            dBusConnection = new DBusConnection(string);
            conn.put(string, dBusConnection);
            return dBusConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusConnection getConnection(int n) throws DBusException {
        Map<Object, DBusConnection> map = conn;
        synchronized (map) {
            Object object;
            Object object2;
            String string = null;
            switch (n) {
                case 0: {
                    string = System.getenv("DBUS_SYSTEM_BUS_ADDRESS");
                    if (null != string) break;
                    string = DEFAULT_SYSTEM_BUS_ADDRESS;
                    break;
                }
                case 1: {
                    string = System.getenv("DBUS_SESSION_BUS_ADDRESS");
                    if (null != string) break;
                    object2 = System.getenv("DISPLAY");
                    if (null == object2) {
                        throw new DBusException(Gettext._("Cannot Resolve Session Bus Address"));
                    }
                    object = new File("/var/lib/dbus/machine-id");
                    if (!((File)object).exists()) {
                        throw new DBusException(Gettext._("Cannot Resolve Session Bus Address"));
                    }
                    try {
                        String string2;
                        BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object));
                        String string3 = bufferedReader.readLine();
                        String string4 = System.getProperty("user.home");
                        File file = new File(string4 + "/.dbus/session-bus", string3 + "-" + ((String)object2).replaceAll(":([0-9]*)\\..*", "$1"));
                        if (!file.exists()) {
                            throw new DBusException(Gettext._("Cannot Resolve Session Bus Address"));
                        }
                        bufferedReader = new BufferedReader(new FileReader(file));
                        while (null != (string2 = bufferedReader.readLine())) {
                            if (!string2.matches("DBUS_SESSION_BUS_ADDRESS.*")) continue;
                            string = string2.replaceAll("^[^=]*=", "");
                        }
                        if (null == string || "".equals(string)) {
                            throw new DBusException(Gettext._("Cannot Resolve Session Bus Address"));
                        }
                        break;
                    }
                    catch (Exception exception) {
                        if (EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        throw new DBusException(Gettext._("Cannot Resolve Session Bus Address"));
                    }
                }
                default: {
                    throw new DBusException(Gettext._("Invalid Bus Type: ") + n);
                }
            }
            if (null != (object2 = conn.get(string))) {
                object = ((DBusConnection)object2)._reflock;
                synchronized (object) {
                    ++((DBusConnection)object2)._refcount;
                }
                return object2;
            }
            object2 = new DBusConnection(string);
            conn.put(string, (DBusConnection)object2);
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBusConnection(String string) throws DBusException {
        super(string);
        this.busnames = new Vector<String>();
        Object object = this._reflock;
        synchronized (object) {
            this._refcount = 1;
        }
        try {
            this.transport = new Transport(this.addr, 100000);
            this.connected = true;
        }
        catch (IOException iOException) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            this.disconnect();
            throw new DBusException(Gettext._("Failed to connect to bus ") + iOException.getMessage());
        }
        catch (ParseException parseException) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            this.disconnect();
            throw new DBusException(Gettext._("Failed to connect to bus ") + parseException.getMessage());
        }
        this.listen();
        object = new _sighandler();
        this.addSigHandlerWithoutMatch((Class<? extends DBusSignal>)DBus.Local.Disconnected.class, object);
        this.addSigHandlerWithoutMatch((Class<? extends DBusSignal>)DBus.NameAcquired.class, object);
        this._dbus = this.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        try {
            this.busnames.add(this._dbus.Hello());
        }
        catch (DBusExecutionException dBusExecutionException) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(dBusExecutionException.getMessage());
        }
    }

    DBusInterface dynamicProxy(String string, String string2) throws DBusException {
        try {
            DBus.Introspectable introspectable = this.getRemoteObject(string, string2, DBus.Introspectable.class);
            String string3 = introspectable.Introspect();
            String[] stringArray = string3.split("[<>]");
            Vector<String> vector = new Vector<String>();
            for (String string4 : stringArray) {
                if (!string4.startsWith("interface")) continue;
                vector.add(string4.replaceAll("^interface *name *= *['\"]([^'\"]*)['\"].*$", "$1"));
            }
            Vector vector2 = new Vector();
            block5: for (String string5 : vector) {
                int n = 0;
                while (n >= 0) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(string5);
                        if (vector2.contains(clazz)) continue block5;
                        vector2.add(clazz);
                        continue block5;
                    }
                    catch (Exception exception) {
                        n = string5.lastIndexOf(".");
                        clazz = (Class<?>)string5.toCharArray();
                        if (n < 0) continue;
                        clazz[n] = 36;
                        string5 = String.valueOf((char[])clazz);
                    }
                }
            }
            if (vector2.size() == 0) {
                throw new DBusException(Gettext._("Could not find an interface to cast to"));
            }
            RemoteObject remoteObject = new RemoteObject(string, string2, null, false);
            DBusInterface dBusInterface = (DBusInterface)Proxy.newProxyInstance(((Class)vector2.get(0)).getClassLoader(), vector2.toArray(new Class[0]), (InvocationHandler)new RemoteInvocationHandler(this, remoteObject));
            this.importedObjects.put(dBusInterface, remoteObject);
            return dBusInterface;
        }
        catch (Exception exception) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(MessageFormat.format(Gettext._("Failed to create proxy object for {0} exported by {1}. Reason: {2}"), string2, string, exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DBusInterface getExportedObject(String string, String string2) throws DBusException {
        ExportedObject exportedObject = null;
        Map map = this.exportedObjects;
        synchronized (map) {
            exportedObject = (ExportedObject)this.exportedObjects.get(string2);
        }
        if (null != exportedObject && null == exportedObject.object.get()) {
            this.unExportObject(string2);
            exportedObject = null;
        }
        if (null != exportedObject) {
            return exportedObject.object.get();
        }
        if (null == string) {
            throw new DBusException(Gettext._("Not an object exported by this connection and no remote specified"));
        }
        return this.dynamicProxy(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBusName(String string) throws DBusException {
        if (!string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name"));
        }
        List<String> list = this.busnames;
        synchronized (list) {
            try {
                UInt32 uInt32 = this._dbus.ReleaseName(string);
            }
            catch (DBusExecutionException dBusExecutionException) {
                if (EXCEPTION_DEBUG) {
                    // empty if block
                }
                throw new DBusException(dBusExecutionException.getMessage());
            }
            this.busnames.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBusName(String string) throws DBusException {
        if (!string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name"));
        }
        List<String> list = this.busnames;
        synchronized (list) {
            UInt32 uInt32;
            try {
                uInt32 = this._dbus.RequestName(string, new UInt32(6L));
            }
            catch (DBusExecutionException dBusExecutionException) {
                if (EXCEPTION_DEBUG) {
                    // empty if block
                }
                throw new DBusException(dBusExecutionException.getMessage());
            }
            switch (uInt32.intValue()) {
                case 1: {
                    break;
                }
                case 2: {
                    throw new DBusException(Gettext._("Failed to register bus name"));
                }
                case 3: {
                    throw new DBusException(Gettext._("Failed to register bus name"));
                }
                case 4: {
                    break;
                }
            }
            this.busnames.add(string);
        }
    }

    public String getUniqueName() {
        return this.busnames.get(0);
    }

    public String[] getNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.busnames);
        return treeSet.toArray(new String[0]);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String string, String string2, Class<I> clazz) throws DBusException {
        return this.getPeerRemoteObject(string, string2, clazz, true);
    }

    public DBusInterface getPeerRemoteObject(String string, String string2) throws DBusException {
        if (null == string) {
            throw new DBusException(Gettext._("Invalid bus name: null"));
        }
        if (!string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !string.matches("^:[0-9]*\\.[0-9]*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name: ") + string);
        }
        String string3 = this._dbus.GetNameOwner(string);
        return this.dynamicProxy(string3, string2);
    }

    public DBusInterface getRemoteObject(String string, String string2) throws DBusException {
        if (null == string) {
            throw new DBusException(Gettext._("Invalid bus name: null"));
        }
        if (null == string2) {
            throw new DBusException(Gettext._("Invalid object path: null"));
        }
        if (!string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !string.matches("^:[0-9]*\\.[0-9]*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name: ") + string);
        }
        if (!string2.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || string2.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string2);
        }
        return this.dynamicProxy(string, string2);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String string, String string2, Class<I> clazz, boolean bl) throws DBusException {
        if (null == string) {
            throw new DBusException(Gettext._("Invalid bus name: null"));
        }
        if (!string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !string.matches("^:[0-9]*\\.[0-9]*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name: ") + string);
        }
        String string3 = this._dbus.GetNameOwner(string);
        return this.getRemoteObject(string3, string2, clazz, bl);
    }

    public <I extends DBusInterface> I getRemoteObject(String string, String string2, Class<I> clazz) throws DBusException {
        return this.getRemoteObject(string, string2, clazz, true);
    }

    public <I extends DBusInterface> I getRemoteObject(String string, String string2, Class<I> clazz, boolean bl) throws DBusException {
        if (null == string) {
            throw new DBusException(Gettext._("Invalid bus name: null"));
        }
        if (null == string2) {
            throw new DBusException(Gettext._("Invalid object path: null"));
        }
        if (null == clazz) {
            throw new ClassCastException(Gettext._("Not A DBus Interface"));
        }
        if (!string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !string.matches("^:[0-9]*\\.[0-9]*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name: ") + string);
        }
        if (!string2.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || string2.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string2);
        }
        if (!DBusInterface.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Interface"));
        }
        if (clazz.getName().equals(clazz.getSimpleName())) {
            throw new DBusException(Gettext._("DBusInterfaces cannot be declared outside a package"));
        }
        RemoteObject remoteObject = new RemoteObject(string, string2, clazz, bl);
        DBusInterface dBusInterface = (DBusInterface)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new RemoteInvocationHandler(this, remoteObject));
        this.importedObjects.put(dBusInterface, remoteObject);
        return (I)dBusInterface;
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> clazz, String string, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        if (string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext._("Cannot watch for signals based on well known bus name as source, only unique names."));
        }
        if (!string.matches("^:[0-9]*\\.[0-9]*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name: ") + string);
        }
        this.removeSigHandler(new DBusMatchRule(clazz, string, null), dBusSigHandler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> clazz, String string, DBusInterface dBusInterface, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        if (string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext._("Cannot watch for signals based on well known bus name as source, only unique names."));
        }
        if (!string.matches("^:[0-9]*\\.[0-9]*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name: ") + string);
        }
        String string2 = ((RemoteObject)this.importedObjects.get((Object)dBusInterface)).objectpath;
        if (!string2.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || string2.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string2);
        }
        this.removeSigHandler(new DBusMatchRule(clazz, string, string2), dBusSigHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule dBusMatchRule, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        SignalTuple signalTuple = new SignalTuple(dBusMatchRule.getInterface(), dBusMatchRule.getMember(), dBusMatchRule.getObject(), dBusMatchRule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector vector = (Vector)this.handledSignals.get(signalTuple);
            if (null == vector) return;
            vector.remove(dBusSigHandler);
            if (0 != vector.size()) return;
            this.handledSignals.remove(signalTuple);
            try {
                this._dbus.RemoveMatch(dBusMatchRule.toString());
            }
            catch (NotConnected notConnected) {
                if (!EXCEPTION_DEBUG) return;
            }
            catch (DBusExecutionException dBusExecutionException) {
                if (!EXCEPTION_DEBUG) throw new DBusException(dBusExecutionException.getMessage());
                throw new DBusException(dBusExecutionException.getMessage());
            }
            {
                // empty if block
            }
            return;
        }
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> clazz, String string, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        if (string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext._("Cannot watch for signals based on well known bus name as source, only unique names."));
        }
        if (!string.matches("^:[0-9]*\\.[0-9]*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name: ") + string);
        }
        this.addSigHandler(new DBusMatchRule(clazz, string, null), dBusSigHandler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> clazz, String string, DBusInterface dBusInterface, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        if (string.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext._("Cannot watch for signals based on well known bus name as source, only unique names."));
        }
        if (!string.matches("^:[0-9]*\\.[0-9]*$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid bus name: ") + string);
        }
        String string2 = ((RemoteObject)this.importedObjects.get((Object)dBusInterface)).objectpath;
        if (!string2.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || string2.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string2);
        }
        this.addSigHandler(new DBusMatchRule(clazz, string, string2), dBusSigHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void addSigHandler(DBusMatchRule dBusMatchRule, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        try {
            this._dbus.AddMatch(dBusMatchRule.toString());
        }
        catch (DBusExecutionException dBusExecutionException) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(dBusExecutionException.getMessage());
        }
        SignalTuple signalTuple = new SignalTuple(dBusMatchRule.getInterface(), dBusMatchRule.getMember(), dBusMatchRule.getObject(), dBusMatchRule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<T>> vector = (Vector<DBusSigHandler<T>>)this.handledSignals.get(signalTuple);
            if (null == vector) {
                vector = new Vector<DBusSigHandler<T>>();
                vector.add(dBusSigHandler);
                this.handledSignals.put(signalTuple, vector);
            } else {
                vector.add(dBusSigHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Map<Object, DBusConnection> map = conn;
        synchronized (map) {
            Object object = this._reflock;
            synchronized (object) {
                if (0 == --this._refcount) {
                    try {
                        Error error = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", Gettext._("Disconnected"));
                        Object object2 = this.pendingCalls;
                        synchronized (object2) {
                            long[] lArray;
                            for (long l : lArray = this.pendingCalls.getKeys()) {
                                MethodCall methodCall;
                                if (-1L == l || null == (methodCall = this.pendingCalls.remove(l))) continue;
                                methodCall.setReply(error);
                            }
                            this.pendingCalls = null;
                        }
                        object2 = this.pendingErrors;
                        synchronized (object2) {
                            this.pendingErrors.add(error);
                        }
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                    conn.remove(this.addr);
                    super.disconnect();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _sighandler
    implements DBusSigHandler<DBusSignal> {
        private _sighandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(DBusSignal dBusSignal) {
            if (dBusSignal instanceof DBus.Local.Disconnected) {
                try {
                    Object object;
                    Error error = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", Gettext._("Disconnected"));
                    if (null != DBusConnection.this.pendingCalls) {
                        object = DBusConnection.this.pendingCalls;
                        synchronized (object) {
                            long[] lArray;
                            for (long l : lArray = DBusConnection.this.pendingCalls.getKeys()) {
                                MethodCall methodCall;
                                if (-1L == l || null == (methodCall = DBusConnection.this.pendingCalls.remove(l))) continue;
                                methodCall.setReply(error);
                            }
                        }
                    }
                    object = DBusConnection.this.pendingErrors;
                    synchronized (object) {
                        DBusConnection.this.pendingErrors.add(error);
                    }
                }
                catch (DBusException dBusException) {}
            } else if (dBusSignal instanceof DBus.NameAcquired) {
                DBusConnection.this.busnames.add(((DBus.NameAcquired)dBusSignal).name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PeerSet
    implements Set<String>,
    DBusSigHandler<DBus.NameOwnerChanged> {
        private Set<String> addresses = new TreeSet<String>();

        public PeerSet() {
            try {
                DBusConnection.this.addSigHandler(new DBusMatchRule(DBus.NameOwnerChanged.class, null, null), this);
            }
            catch (DBusException dBusException) {
                if (AbstractConnection.EXCEPTION_DEBUG) {
                    // empty if block
                }
            }
        }

        @Override
        public void handle(DBus.NameOwnerChanged nameOwnerChanged) {
            if ("".equals(nameOwnerChanged.new_owner) && this.addresses.contains(nameOwnerChanged.name)) {
                this.remove(nameOwnerChanged.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(String string) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.add(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends String> collection) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Set<String> set = this.addresses;
            synchronized (set) {
                this.addresses.clear();
            }
        }

        @Override
        public boolean contains(Object object) {
            return this.addresses.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.addresses.containsAll(collection);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof PeerSet) {
                return ((Object)((PeerSet)object).addresses).equals(this.addresses);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.addresses).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.addresses.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return this.addresses.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.retainAll(collection);
            }
        }

        @Override
        public int size() {
            return this.addresses.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.toArray(TArray);
            }
        }
    }
}

