/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import javax.media.Format;

class FormatTable {
    public Format[] keys;
    public Format[][] table;
    public int[] hits;
    public int last;

    public FormatTable(int size) {
        this.keys = new Format[size];
        this.table = new Format[size][];
        this.hits = new int[size];
        this.last = 0;
    }

    public int findLeastHit() {
        int min = this.hits[0];
        int idx = 0;
        for (int i = 1; i < this.last; ++i) {
            if (this.hits[i] >= min) continue;
            min = this.hits[i];
            idx = i;
        }
        return idx;
    }

    Format[] get(Format input) {
        Format[] res = null;
        for (int i = 0; i < this.last; ++i) {
            if (res == null && this.keys[i].matches(input)) {
                res = this.table[i];
                this.hits[i] = this.keys.length;
                continue;
            }
            this.hits[i] = this.hits[i] - 1;
        }
        return res;
    }

    public void save(Format input, Format[] supported) {
        int idx = this.last >= this.keys.length ? this.findLeastHit() : this.last++;
        this.keys[idx] = input;
        this.table[idx] = supported;
        this.hits[idx] = this.keys.length;
    }
}

