/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.audio;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Owned;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.control.BufferControl;
import javax.media.control.FrameProcessingControl;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.sf.fmj.media.AbstractGainControl;
import net.sf.fmj.media.AudioFormatCompleter;
import net.sf.fmj.media.codec.audio.alaw.Decoder;
import net.sf.fmj.media.renderer.audio.JavaSoundGainControl;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.ControlCollection;
import net.sf.fmj.utility.LoggerSingleton;

public class JavaSoundRenderer
implements Renderer {
    private static final Logger logger = LoggerSingleton.logger;
    private String name = "FMJ Audio Renderer";
    private int buflen;
    private long buflenMS = -1L;
    private Boolean bufferSizeChanged = new Boolean(false);
    private SourceDataLine sourceLine;
    private AudioFormat inputFormat;
    private javax.sound.sampled.AudioFormat audioFormat;
    private javax.sound.sampled.AudioFormat sampledFormat;
    private final ControlCollection controls = new ControlCollection();
    private Codec codec;
    private final Buffer codecBuffer = new Buffer();
    private long lastSequenceNumber = -1L;
    private int framesDropped = 0;
    private PeakVolumeMeter levelControl;
    private Format[] supportedInputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("alaw", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    private static final boolean NON_BLOCKING = false;

    public JavaSoundRenderer() {
        this.levelControl = new PeakVolumeMeter();
        this.levelControl.setMute(true);
    }

    public void close() {
        logger.info("JavaSoundRenderer closing...");
        this.controls.clear();
        if (this.codec != null) {
            this.codec.close();
            this.codec = null;
        }
        this.sourceLine.close();
        this.sourceLine = null;
    }

    public Object getControl(String controlType) {
        return this.controls.getControl(controlType);
    }

    public Object[] getControls() {
        return this.controls.getControls();
    }

    public String getName() {
        return this.name;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void logControls(Control[] controls) {
        for (int i = 0; i < controls.length; ++i) {
            Control control = controls[i];
            logger.fine("control: " + control);
            Control.Type controlType = control.getType();
            if (!(controlType instanceof CompoundControl.Type)) continue;
            this.logControls(((CompoundControl)control).getMemberControls());
        }
    }

    public void open() throws ResourceUnavailableException {
        this.audioFormat = JavaSoundUtils.convertFormat(this.inputFormat);
        logger.info("JavaSoundRenderer opening with javax.sound format: " + this.audioFormat);
        try {
            if (!this.inputFormat.getEncoding().equals("LINEAR")) {
                logger.info("JavaSoundRenderer: Audio format is not linear, creating conversion");
                if (this.inputFormat.getEncoding().equals("ULAW")) {
                    this.codec = new net.sf.fmj.media.codec.audio.ulaw.Decoder();
                } else if (this.inputFormat.getEncoding().equals("alaw")) {
                    this.codec = new Decoder();
                } else {
                    throw new ResourceUnavailableException("Unsupported input format encoding: " + this.inputFormat.getEncoding());
                }
                if (this.codec.setInputFormat(this.inputFormat) == null) {
                    throw new ResourceUnavailableException("Codec rejected input format: " + this.inputFormat);
                }
                Format[] outputFormats = this.codec.getSupportedOutputFormats(this.inputFormat);
                if (outputFormats.length < 1) {
                    throw new ResourceUnavailableException("Unable to get an output format for input format: " + this.inputFormat);
                }
                AudioFormat codecOutputFormat = AudioFormatCompleter.complete((AudioFormat)outputFormats[0]);
                if (this.codec.setOutputFormat(codecOutputFormat) == null) {
                    throw new ResourceUnavailableException("Codec rejected output format: " + codecOutputFormat);
                }
                this.audioFormat = JavaSoundUtils.convertFormat(codecOutputFormat);
                this.codec.open();
                logger.info("JavaSoundRenderer: Audio format is not linear, created conversion from " + this.inputFormat + " to " + codecOutputFormat);
            }
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            this.sourceLine = (SourceDataLine)AudioSystem.getLine(info);
            logger.info("JavaSoundRenderer: sourceLine=" + this.sourceLine);
            this.sourceLine.open(this.audioFormat);
            logger.info("JavaSoundRenderer: buflen=" + this.sourceLine.getBufferSize());
            FloatControl gainFloatControl = null;
            try {
                gainFloatControl = (FloatControl)this.sourceLine.getControl(FloatControl.Type.MASTER_GAIN);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            logger.fine("JavaSoundRenderer: gainFloatControl=" + gainFloatControl);
            BooleanControl muteBooleanControl = null;
            try {
                muteBooleanControl = (BooleanControl)this.sourceLine.getControl(BooleanControl.Type.MUTE);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            logger.fine("JavaSoundRenderer: muteBooleanControl=" + muteBooleanControl);
            JavaSoundGainControl gainControl = new JavaSoundGainControl(gainFloatControl, muteBooleanControl);
            this.controls.addControl(gainControl);
            this.controls.addControl(new JavaSoundRendererBufferControl());
            this.controls.addControl(new FPC());
            this.controls.addControl(this.levelControl);
        }
        catch (LineUnavailableException e) {
            throw new ResourceUnavailableException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer) {
        if (this.codec != null) {
            int codecResult = this.codec.process(buffer, this.codecBuffer);
            if (codecResult == 1) {
                return 1;
            }
            if (codecResult == 4) {
                return 0;
            }
            this.codecBuffer.setRtpTimeStamp(buffer.getRtpTimeStamp());
            this.codecBuffer.setHeaderExtension(buffer.getHeaderExtension());
            this.codecBuffer.setTimeStamp(buffer.getTimeStamp());
            this.codecBuffer.setFlags(buffer.getFlags());
            this.codecBuffer.setSequenceNumber(buffer.getSequenceNumber());
            buffer = this.codecBuffer;
        }
        this.levelControl.processData(buffer);
        int length = buffer.getLength();
        int offset = buffer.getOffset();
        Format format = buffer.getFormat();
        Class<?> type = format.getDataType();
        if (type != Format.byteArray) {
            return 1;
        }
        byte[] data = (byte[])buffer.getData();
        try {
            Boolean bl = this.bufferSizeChanged;
            synchronized (bl) {
                if (this.bufferSizeChanged.booleanValue()) {
                    this.bufferSizeChanged = Boolean.FALSE;
                    this.sourceLine.stop();
                    this.sourceLine.flush();
                    this.sourceLine.close();
                    this.buflen = (int)((float)this.audioFormat.getFrameSize() * this.audioFormat.getSampleRate() * (float)this.buflenMS / 1000.0f);
                    this.sourceLine.open(this.audioFormat, this.buflen);
                    logger.info("JavaSoundRenderer: buflen=" + this.sourceLine.getBufferSize());
                    this.sourceLine.start();
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "" + ex, ex);
        }
        boolean bufferNotConsumed = false;
        int newBufferLength = 0;
        int newBufferOffset = 0;
        if (length == 0) {
            logger.finer("Buffer has zero length, flags = " + buffer.getFlags());
        }
        if (-1L == this.lastSequenceNumber) {
            this.lastSequenceNumber = buffer.getSequenceNumber();
        } else {
            if ((short)(this.lastSequenceNumber + 1L) != (short)buffer.getSequenceNumber()) {
                int count = ((short)buffer.getSequenceNumber() - (short)this.lastSequenceNumber & 0xFFFF) - 1;
                this.framesDropped += count;
            }
            this.lastSequenceNumber = buffer.getSequenceNumber();
        }
        while (length > 0) {
            int n = this.sourceLine.write(data, offset, length);
            Thread.yield();
            if (n >= length) break;
            if (n == 0) {
                logger.warning("sourceLine.write returned 0, offset=" + offset + "; length=" + length + "; available=" + this.sourceLine.available() + "; frame size in bytes" + this.sourceLine.getFormat().getFrameSize() + "; sourceLine.isActive() = " + this.sourceLine.isActive() + "; " + this.sourceLine.isOpen() + "; sourceLine.isRunning()=" + this.sourceLine.isRunning());
                return 1;
            }
            offset += n;
            length -= n;
        }
        if (bufferNotConsumed) {
            buffer.setLength(newBufferLength);
            buffer.setOffset(newBufferOffset);
            return 2;
        }
        if (buffer.isEOM()) {
            this.sourceLine.drain();
        }
        return 0;
    }

    public void reset() {
        logger.info("JavaSoundRenderer resetting...");
    }

    public Format setInputFormat(Format format) {
        logger.info("JavaSoundRenderer setting input format to: " + format);
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.inputFormat = (AudioFormat)format;
        return this.inputFormat;
    }

    public void start() {
        logger.info("JavaSoundRenderer starting...");
        this.sourceLine.start();
    }

    public void stop() {
        logger.info("JavaSoundRenderer stopping...");
        this.sourceLine.stop();
    }

    private class PeakVolumeMeter
    extends AbstractGainControl {
        float peakLevel = 0.0f;

        private PeakVolumeMeter() {
        }

        public float getLevel() {
            return this.peakLevel;
        }

        public void processData(Buffer buf) {
            if (this.getMute() || buf.isDiscard() || buf.getLength() <= 0) {
                return;
            }
            AudioFormat af = (AudioFormat)buf.getFormat();
            byte[] data = (byte[])buf.getData();
            if (af.getEncoding().equalsIgnoreCase("LINEAR") && af.getSampleSizeInBits() == 16) {
                int msb = 0;
                int lsb = 1;
                if (af.getEndian() == 0) {
                    msb = 1;
                    lsb = 0;
                }
                if (af.getSigned() == 1) {
                    int peak = 0;
                    int samples = data.length / 2;
                    for (int i = 0; i < samples; ++i) {
                        int value = (data[i * 2 + msb] << 8) + (data[i * 2 + lsb] & 0xFF);
                        if (value < 0) {
                            value = -value;
                        }
                        if (value <= peak) continue;
                        peak = value;
                    }
                    this.peakLevel = (float)peak / 32768.0f;
                }
            }
        }

        public float setLevel(float level) {
            float result = this.getLevel();
            return result;
        }
    }

    private class JavaSoundRendererBufferControl
    implements BufferControl,
    Owned {
        private JavaSoundRendererBufferControl() {
        }

        public long getBufferLength() {
            return JavaSoundRenderer.this.buflenMS;
        }

        public Component getControlComponent() {
            return null;
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public long getMinimumThreshold() {
            return -1L;
        }

        public Object getOwner() {
            return JavaSoundRenderer.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long setBufferLength(long time) {
            JavaSoundRenderer.this.buflenMS = time;
            Boolean bl = JavaSoundRenderer.this.bufferSizeChanged;
            synchronized (bl) {
                JavaSoundRenderer.this.bufferSizeChanged = Boolean.TRUE;
            }
            return JavaSoundRenderer.this.buflenMS;
        }

        public void setEnabledThreshold(boolean b) {
        }

        public long setMinimumThreshold(long time) {
            return -1L;
        }
    }

    private class FPC
    implements FrameProcessingControl,
    Owned {
        private FPC() {
        }

        public Component getControlComponent() {
            return null;
        }

        public int getFramesDropped() {
            return JavaSoundRenderer.this.framesDropped;
        }

        public Object getOwner() {
            return JavaSoundRenderer.this;
        }

        public void setFramesBehind(float numFrames) {
        }

        public boolean setMinimalProcessing(boolean newMinimalProcessing) {
            return false;
        }
    }
}

