/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.profiler4j.agent.Log;
import net.sf.profiler4j.agent.Profiler4JError;
import net.sf.profiler4j.agent.Rule;
import net.sf.profiler4j.agent.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private Map<Rule.Option, String> defaultRuleOptions = new HashMap<Rule.Option, String>();
    private Map<Rule.Option, String> lastDefaultRuleOptions = new HashMap<Rule.Option, String>();
    private List<Rule> rules;
    private List<Rule> lastRules;
    private boolean traceAllocations = false;
    private int verbosity = 0;
    private boolean enabled = true;
    private int port = 7890;
    private boolean exitVmOnFailure = true;
    private boolean waitConnection = true;
    private boolean saveSnapshotOnExit;
    private static File tempDir;
    private boolean dumpClasses = false;
    private String password = null;
    private File dumpDir;
    private String[] exclusions;
    private int sessionVersion;

    public int getSessionVersion() {
        return this.sessionVersion;
    }

    public Config(String agentArgs) {
        this.loadExclusions();
        this.defaultRuleOptions = Utils.parseOptions("-access:public -beanprops:off");
        try {
            File sysTmpDir = new File(System.getProperty("java.io.tmpdir"));
            File seed = File.createTempFile("profiler4j_", "", sysTmpDir);
            tempDir = new File(seed.getAbsolutePath() + ".tmp");
            tempDir.mkdir();
            seed.delete();
        }
        catch (IOException e) {
            throw new Profiler4JError("Could not create temporary dir", e);
        }
        this.dumpDir = new File(tempDir, "instrumented_classes");
        if (agentArgs == null) {
            return;
        }
        for (String arg : agentArgs.split(",")) {
            String key;
            String value = null;
            int p = arg.indexOf(61);
            if (p == -1) {
                key = arg;
            } else {
                key = arg.substring(0, p);
                if (p + 1 < arg.length()) {
                    value = arg.substring(p + 1, arg.length());
                }
            }
            if ("waitconn".equals(key)) {
                this.waitConnection = Boolean.parseBoolean(value);
                continue;
            }
            if ("verbosity".equals(key)) {
                this.verbosity = Integer.parseInt(value);
                continue;
            }
            if ("port".equals(key)) {
                this.port = Integer.parseInt(value);
                continue;
            }
            if ("enabled".equals(key)) {
                this.enabled = Boolean.parseBoolean(value);
                continue;
            }
            if ("password".equals(key)) {
                this.password = value;
                continue;
            }
            throw new Profiler4JError("Invalid agent option '" + key + "'");
        }
    }

    public String[] getExclusions() {
        return this.exclusions;
    }

    private void loadExclusions() {
        String s = this.detectInstallDirUrl() + "/p4j-exclusions.txt";
        ArrayList<String> exclusions = new ArrayList<String>();
        try {
            String cn;
            URL u = new URL(s);
            Log.print(0, "loading exclusions from " + u);
            BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream()));
            while ((cn = r.readLine()) != null) {
                if ((cn = cn.trim()).startsWith("#") || cn.length() == 0) continue;
                exclusions.add(cn);
                Log.print(0, "exluding class " + cn);
            }
            this.exclusions = exclusions.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new Profiler4JError("Could not load exclusions");
        }
    }

    private String detectInstallDirUrl() {
        Class<?> c = this.getClass();
        String cn = "/" + c.getName().replace('.', '/') + ".class";
        URL url = c.getResource(cn);
        String s = url.toString();
        int pos = s.lastIndexOf(33);
        s = s.substring(0, pos);
        pos = s.lastIndexOf(47);
        s = s.substring(4, pos);
        return s;
    }

    public String getPassword() {
        return this.password;
    }

    public void parseRules(String optionsAsStr, String rulesAsStr) {
        this.lastDefaultRuleOptions = this.defaultRuleOptions;
        this.defaultRuleOptions = Utils.parseOptions(optionsAsStr);
        this.lastRules = this.rules;
        this.rules = Utils.parseRules(rulesAsStr);
        ++this.sessionVersion;
    }

    public Map<Rule.Option, String> getDefaultRuleOptions() {
        return this.defaultRuleOptions;
    }

    public boolean isDumpClasses() {
        return this.dumpClasses;
    }

    public File getDumpDir() {
        return this.dumpDir;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isExitVmOnFailure() {
        return this.exitVmOnFailure;
    }

    public int getPort() {
        return this.port;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public List<Rule> getLastRules() {
        return this.lastRules;
    }

    public boolean isSaveSnapshotOnExit() {
        return this.saveSnapshotOnExit;
    }

    public boolean isTraceAllocations() {
        return this.traceAllocations;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public boolean isWaitConnection() {
        return this.waitConnection;
    }
}

