/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.plaf.IAppScrollBarArtworkUtils;
import com.explodingpixels.painter.ImagePainter;
import com.explodingpixels.widgets.ImageBasedJComponent;
import com.explodingpixels.widgets.plaf.ButtonsTogetherScrollBarSkin;
import com.explodingpixels.widgets.plaf.ScrollBarOrientation;
import com.explodingpixels.widgets.plaf.ScrollBarSkin;
import com.explodingpixels.widgets.plaf.ScrollThumbImagePainter;
import com.explodingpixels.widgets.plaf.SkinnableScrollBarUI;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class IAppScrollBarUI
extends SkinnableScrollBarUI {
    public IAppScrollBarUI() {
        super(IAppScrollBarUI.createScrollBarSkinProvider());
    }

    public static ComponentUI createUI(JComponent c) {
        return new IAppScrollBarUI();
    }

    private static SkinnableScrollBarUI.ScrollBarSkinProvider createScrollBarSkinProvider() {
        return new SkinnableScrollBarUI.ScrollBarSkinProvider(){

            public ScrollBarSkin provideSkin(ScrollBarOrientation orientation) {
                return orientation == ScrollBarOrientation.HORIZONTAL ? IAppScrollBarUI.createHorizontalSkin() : IAppScrollBarUI.createVerticalSkin();
            }
        };
    }

    private static ScrollBarSkin createHorizontalSkin() {
        ImageBasedJComponent topCap = new ImageBasedJComponent(IAppScrollBarArtworkUtils.getScrollBarLeftCap().getImage());
        Dimension minimumThumbSize = IAppScrollBarArtworkUtils.getHorizontalScrollBarMinimumSize();
        AbstractButton decrementButton = IAppScrollBarArtworkUtils.createHorizontalTogetherDecrementButton();
        AbstractButton incrementButton = IAppScrollBarArtworkUtils.createHorizontalTogetherIncrementButton();
        ImagePainter trackPainter = new ImagePainter(IAppScrollBarArtworkUtils.getHorizontalTrack().getImage());
        ScrollThumbImagePainter scrollerThumb = IAppScrollBarArtworkUtils.createHorizontalScrollerThumb();
        int topCapRecess = IAppScrollBarArtworkUtils.getScrollBarTopCapRecess();
        int decrementButtonRecess = IAppScrollBarArtworkUtils.getDecrementButtonRecess();
        Dimension preferredSize = new Dimension(100, decrementButton.getPreferredSize().height);
        return new ButtonsTogetherScrollBarSkin(topCap, decrementButton, incrementButton, trackPainter, scrollerThumb, topCapRecess, decrementButtonRecess, minimumThumbSize, preferredSize);
    }

    private static ScrollBarSkin createVerticalSkin() {
        Image topCapImage = IAppScrollBarArtworkUtils.getScrollBarTopCap().getImage();
        ImageBasedJComponent topCap = new ImageBasedJComponent(topCapImage);
        Dimension minimumThumbSize = IAppScrollBarArtworkUtils.getVerticalScrollBarMinimumSize();
        AbstractButton decrementButton = IAppScrollBarArtworkUtils.createVerticalTogetherDecrementButton();
        AbstractButton incrementButton = IAppScrollBarArtworkUtils.createVerticalTogetherIncrementButton();
        ImagePainter trackPainter = new ImagePainter(IAppScrollBarArtworkUtils.getVerticalTrack().getImage());
        ScrollThumbImagePainter scrollerThumb = IAppScrollBarArtworkUtils.createVerticalScrollerThumb();
        int topCapRecess = IAppScrollBarArtworkUtils.getScrollBarTopCapRecess();
        int decrementButtonRecess = IAppScrollBarArtworkUtils.getDecrementButtonRecess();
        Dimension preferredSize = new Dimension(decrementButton.getPreferredSize().width, 100);
        return new ButtonsTogetherScrollBarSkin(topCap, decrementButton, incrementButton, trackPainter, scrollerThumb, topCapRecess, decrementButtonRecess, minimumThumbSize, preferredSize);
    }
}

