/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.soap;

import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jml.protocol.soap.XmlEntity;
import net.sf.jml.util.Base64;
import net.sf.jml.util.XmlUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SSO {
    private static final Log logger = LogFactory.getLog(SSO.class);
    private String userName = null;
    private String password = null;
    private String policy = null;
    private String nonce = null;
    private String webTicket = null;
    private String contactTicket = null;
    private String oimTicket = null;
    private String spaceTicket = null;
    private String storageTicket = null;
    Pattern redirectPattern = Pattern.compile("<psf:redirectUrl>(.*)</psf:redirectUrl>");

    public SSO(String userName, String password, String policy, String nonce) {
        this.userName = userName;
        this.password = password;
        this.policy = policy;
        this.nonce = nonce;
    }

    public String getTicket() {
        return this.getTicket(null);
    }

    public String getTicket(String urlStr) {
        try {
            Matcher m;
            if (urlStr == null) {
                urlStr = "http://login.live.com/RST.srf";
            }
            URL url = new URL(urlStr);
            StringBuilder mess = new StringBuilder();
            mess.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            mess.append("<Envelope xmlns=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n");
            mess.append(" xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2003/06/secext\"\r\n");
            mess.append(" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"\r\n");
            mess.append(" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2002/12/policy\"\r\n");
            mess.append(" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"\r\n");
            mess.append(" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/03/addressing\"\r\n");
            mess.append(" xmlns:wssc=\"http://schemas.xmlsoap.org/ws/2004/04/sc\"\r\n");
            mess.append(" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2004/04/trust\">\r\n");
            mess.append("<Header>\r\n");
            mess.append("  <ps:AuthInfo xmlns:ps=\"http://schemas.microsoft.com/Passport/SoapServices/PPCRL\" Id=\"PPAuthInfo\">\r\n");
            mess.append("    <ps:HostingApp>{7108E71A-9926-4FCB-BCC9-9A9D3F32E423}</ps:HostingApp>\r\n");
            mess.append("    <ps:BinaryVersion>4</ps:BinaryVersion>\r\n");
            mess.append("    <ps:UIVersion>1</ps:UIVersion>\r\n");
            mess.append("    <ps:Cookies></ps:Cookies>\r\n");
            mess.append("    <ps:RequestParams>AQAAAAIAAABsYwQAAAAxMDMz</ps:RequestParams>\r\n");
            mess.append("  </ps:AuthInfo>\r\n");
            mess.append("  <wsse:Security>\r\n");
            mess.append("    <wsse:UsernameToken Id=\"user\">\r\n");
            mess.append("      <wsse:Username>" + this.userName + "</wsse:Username>\r\n");
            mess.append("      <wsse:Password>" + this.password + "</wsse:Password>\r\n");
            mess.append("    </wsse:UsernameToken>\r\n");
            mess.append("  </wsse:Security>\r\n");
            mess.append("</Header>\r\n");
            mess.append("<Body>\r\n");
            mess.append("<ps:RequestMultipleSecurityTokens xmlns:ps=\"http://schemas.microsoft.com/Passport/SoapServices/PPCRL\" Id=\"RSTS\">\r\n");
            mess.append("  <wst:RequestSecurityToken Id=\"RST0\">\r\n");
            mess.append("    <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            mess.append("    <wsp:AppliesTo>\r\n");
            mess.append("      <wsa:EndpointReference>\r\n");
            mess.append("        <wsa:Address>http://Passport.NET/tb</wsa:Address>\r\n");
            mess.append("      </wsa:EndpointReference>\r\n");
            mess.append("    </wsp:AppliesTo>\r\n");
            mess.append("  </wst:RequestSecurityToken>\r\n");
            mess.append("<wst:RequestSecurityToken Id=\"RST1\">\r\n");
            mess.append("  <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            mess.append("  <wsp:AppliesTo>\r\n");
            mess.append("    <wsa:EndpointReference>\r\n");
            mess.append("      <wsa:Address>messengerclear.live.com</wsa:Address>\r\n");
            mess.append("     </wsa:EndpointReference>\r\n");
            mess.append("    </wsp:AppliesTo>\r\n");
            mess.append("   <wsse:PolicyReference URI=\"" + this.policy + "\"></wsse:PolicyReference>\r\n");
            mess.append("</wst:RequestSecurityToken>\r\n");
            mess.append("<wst:RequestSecurityToken Id=\"RST2\">\r\n");
            mess.append("  <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            mess.append("  <wsp:AppliesTo>\r\n");
            mess.append("   <wsa:EndpointReference>\r\n");
            mess.append("     <wsa:Address>messenger.msn.com</wsa:Address>\r\n");
            mess.append("   </wsa:EndpointReference>\r\n");
            mess.append("  </wsp:AppliesTo>\r\n");
            mess.append("  <wsse:PolicyReference URI=\"?id=507\"></wsse:PolicyReference>\r\n");
            mess.append("</wst:RequestSecurityToken>\r\n");
            mess.append("<wst:RequestSecurityToken Id=\"RST3\">\r\n");
            mess.append("  <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            mess.append("   <wsp:AppliesTo>\r\n");
            mess.append("        <wsa:EndpointReference>\r\n");
            mess.append("          <wsa:Address>contacts.msn.com</wsa:Address>\r\n");
            mess.append("        </wsa:EndpointReference>\r\n");
            mess.append("      </wsp:AppliesTo>\r\n");
            mess.append("      <wsse:PolicyReference URI=\"MBI\"></wsse:PolicyReference>\r\n");
            mess.append("    </wst:RequestSecurityToken>\r\n");
            mess.append("    <wst:RequestSecurityToken Id=\"RST4\">\r\n");
            mess.append("      <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            mess.append("      <wsp:AppliesTo>\r\n");
            mess.append("        <wsa:EndpointReference>\r\n");
            mess.append("          <wsa:Address>messengersecure.live.com</wsa:Address>\r\n");
            mess.append("        </wsa:EndpointReference>\r\n");
            mess.append("      </wsp:AppliesTo>\r\n");
            mess.append("      <wsse:PolicyReference URI=\"MBI_SSL\"></wsse:PolicyReference>\r\n");
            mess.append("    </wst:RequestSecurityToken>\r\n");
            mess.append("    <wst:RequestSecurityToken Id=\"RST5\">\r\n");
            mess.append("      <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            mess.append("      <wsp:AppliesTo>\r\n");
            mess.append("        <wsa:EndpointReference>\r\n");
            mess.append("          <wsa:Address>spaces.live.com</wsa:Address>\r\n");
            mess.append("        </wsa:EndpointReference>\r\n");
            mess.append("      </wsp:AppliesTo>\r\n");
            mess.append("      <wsse:PolicyReference URI=\"MBI\"></wsse:PolicyReference>\r\n");
            mess.append("    </wst:RequestSecurityToken>\r\n");
            mess.append("    <wst:RequestSecurityToken Id=\"RST6\">\r\n");
            mess.append("      <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            mess.append("      <wsp:AppliesTo>\r\n");
            mess.append("        <wsa:EndpointReference>\r\n");
            mess.append("          <wsa:Address>storage.msn.com</wsa:Address>\r\n");
            mess.append("        </wsa:EndpointReference>\r\n");
            mess.append("      </wsp:AppliesTo>\r\n");
            mess.append("      <wsse:PolicyReference URI=\"MBI\"></wsse:PolicyReference>\r\n");
            mess.append("    </wst:RequestSecurityToken>\r\n");
            mess.append("  </ps:RequestMultipleSecurityTokens>\r\n");
            mess.append("</Body>\r\n");
            mess.append("</Envelope>");
            DefaultHttpClientConnection conn = new DefaultHttpClientConnection();
            BasicHttpParams params = null;
            BasicHttpProcessor httpproc = null;
            params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            HttpProtocolParams.setUserAgent((HttpParams)params, (String)"MSN Explorer/9.0 (MSN 8.0; TmstmpExt)");
            HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
            httpproc = new BasicHttpProcessor();
            httpproc.addInterceptor((HttpRequestInterceptor)new RequestContent());
            httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
            httpproc.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
            httpproc.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
            httpproc.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
            HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
            BasicHttpContext context = new BasicHttpContext(null);
            HttpHost host = new HttpHost(url.getHost(), 443, "https");
            context.setAttribute("http.connection", (Object)conn);
            context.setAttribute("http.target_host", (Object)host);
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Socket socket = factory.createSocket(host.getHostName(), host.getPort());
            conn.bind(socket, (HttpParams)params);
            BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", url.getPath());
            request.setEntity((HttpEntity)new XmlEntity(mess.toString()));
            context.setAttribute("http.request", (Object)request);
            request.setParams((HttpParams)params);
            request.addHeader("Host", url.getHost());
            httpexecutor.preProcess((HttpRequest)request, (HttpProcessor)httpproc, (HttpContext)context);
            HttpResponse response = httpexecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)context);
            httpexecutor.postProcess(response, (HttpProcessor)httpproc, (HttpContext)context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)response.getStatusLine());
            }
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(response.getStatusLine() + " / " + responseStr));
            }
            conn.close();
            int code = response.getStatusLine().getStatusCode();
            if (code > -1 && code != 200) {
                if (responseStr.indexOf("<faultcode>psf:Redirect</faultcode>") == -1) {
                    logger.error((Object)("*** Can't get passport ticket! http code = " + code));
                    return null;
                }
                Matcher m2 = this.redirectPattern.matcher(responseStr);
                if (!m2.find()) {
                    logger.error((Object)"*** redirect, but can't get redirect URL!");
                    return null;
                }
                String redirectUrl = m2.group(1);
                if (urlStr.equals(redirectUrl)) {
                    logger.error((Object)"*** redirect, but redirect to same URL!");
                    return null;
                }
                return this.getTicket(redirectUrl);
            }
            if (responseStr.indexOf("<faultcode>psf:Redirect</faultcode>") != -1 && (m = this.redirectPattern.matcher(responseStr)).find()) {
                String redirectUrl = m.group(1);
                if (urlStr.equals(redirectUrl)) {
                    logger.error((Object)"*** redirect, but redirect to same URL!");
                    return null;
                }
                return this.getTicket(redirectUrl);
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                logger.error((Object)"something wrong!", (Throwable)new Exception());
                return null;
            }
            return this.getTicketFromResponseXml(responseStr);
        }
        catch (Exception e) {
            logger.error((Object)"Login error ", (Throwable)e);
            return null;
        }
    }

    private String getTicketFromResponseXml(String xml) {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            dbfactory.setIgnoringComments(true);
            DocumentBuilder docBuilder = dbfactory.newDocumentBuilder();
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Document doc = docBuilder.parse(in);
            Element el1 = XmlUtils.locateElement(doc.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact1");
            Element p1 = (Element)el1.getParentNode().getParentNode();
            Element p2 = XmlUtils.findChild(p1, "wst:RequestedProofToken");
            Element el2 = XmlUtils.findChild(p2, "wst:BinarySecret");
            String ticket = XmlUtils.getText(el1);
            String binSecret = XmlUtils.getText(el2).trim();
            Element webTicketEl = XmlUtils.locateElement(doc.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact2");
            this.webTicket = XmlUtils.getText(webTicketEl);
            Element contactTicketEl = XmlUtils.locateElement(doc.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact3");
            this.contactTicket = XmlUtils.getText(contactTicketEl);
            Element oimTicketEl = XmlUtils.locateElement(doc.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact4");
            this.oimTicket = XmlUtils.getText(oimTicketEl);
            Element spaceTicketEl = XmlUtils.locateElement(doc.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact5");
            this.spaceTicket = XmlUtils.getText(spaceTicketEl);
            Element storageTicketEl = XmlUtils.locateElement(doc.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact6");
            this.storageTicket = XmlUtils.getText(storageTicketEl);
            SSOticket SSOTicket = new SSOticket(binSecret, this.nonce.trim());
            return ticket.trim() + " " + SSOTicket.value;
        }
        catch (Exception e) {
            logger.error((Object)"Login error ", (Throwable)e);
            return null;
        }
    }

    public String getContactTicket() {
        return this.contactTicket;
    }

    public String getOimTicket() {
        return this.oimTicket;
    }

    public String getSpaceTicket() {
        return this.spaceTicket;
    }

    public String getStorageTicket() {
        return this.storageTicket;
    }

    public String getWebTicket() {
        return this.webTicket;
    }

    static class SSOticket {
        public String value;
        private byte[] beginning = new byte[28];

        public SSOticket(String key, String nonce) throws Exception {
            this.beginning[0] = 28;
            this.beginning[1] = 0;
            this.beginning[2] = 0;
            this.beginning[3] = 0;
            this.beginning[4] = 1;
            this.beginning[5] = 0;
            this.beginning[6] = 0;
            this.beginning[7] = 0;
            this.beginning[8] = 3;
            this.beginning[9] = 102;
            this.beginning[10] = 0;
            this.beginning[11] = 0;
            this.beginning[12] = 4;
            this.beginning[13] = -128;
            this.beginning[14] = 0;
            this.beginning[15] = 0;
            this.beginning[16] = 8;
            this.beginning[17] = 0;
            this.beginning[18] = 0;
            this.beginning[19] = 0;
            this.beginning[20] = 20;
            this.beginning[21] = 0;
            this.beginning[22] = 0;
            this.beginning[23] = 0;
            this.beginning[24] = 72;
            this.beginning[25] = 0;
            this.beginning[26] = 0;
            this.beginning[27] = 0;
            byte[] key1 = Base64.decode(key);
            byte[] key2 = this.deriveKey(key1, "WS-SecureConversationSESSION KEY HASH");
            byte[] key3 = this.deriveKey(key1, "WS-SecureConversationSESSION KEY ENCRYPTION");
            byte[] hash = this.HMAC(key2, nonce.getBytes("UTF-8"));
            byte[] iv = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            byte[] restOfNonce = new byte[]{8, 8, 8, 8, 8, 8, 8, 8};
            byte[] output = this.DES3(key3, this.combine(nonce.getBytes("UTF-8"), restOfNonce), iv);
            String struc = new String(this.beginning, "ISO-8859-1") + new String(iv, "ISO-8859-1") + new String(hash, "ISO-8859-1") + new String(output, "ISO-8859-1");
            this.value = new String(Base64.encode(struc.getBytes("ISO-8859-1")));
        }

        private byte[] combine(byte[] a, byte[] b) {
            byte[] c = new byte[a.length + b.length];
            System.arraycopy(a, 0, c, 0, a.length);
            System.arraycopy(b, 0, c, a.length, b.length);
            return c;
        }

        private byte[] deriveKey(byte[] key, String magic) throws Exception {
            byte[] hash1 = this.HMAC(key, magic.getBytes("UTF-8"));
            byte[] hash2 = this.HMAC(key, this.combine(hash1, magic.getBytes("UTF-8")));
            byte[] hash3 = this.HMAC(key, hash1);
            byte[] hash4 = this.HMAC(key, this.combine(hash3, magic.getBytes("UTF-8")));
            byte[] out = new byte[]{hash4[0], hash4[1], hash4[2], hash4[3]};
            return this.combine(hash2, out);
        }

        private byte[] HMAC(byte[] key, byte[] subject) {
            try {
                Mac mac = Mac.getInstance("HmacSHA1");
                SecretKeySpec sk = new SecretKeySpec(key, "HmacSHA1");
                mac.init(sk);
                return mac.doFinal(subject);
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
            }
            catch (InvalidKeyException ex) {
                ex.printStackTrace();
            }
            return null;
        }

        private byte[] DES3(byte[] key, byte[] subject, byte[] iv) {
            try {
                Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
                SecretKeySpec sk = new SecretKeySpec(key, "DESede");
                IvParameterSpec sr = new IvParameterSpec(iv);
                cipher.init(1, (Key)sk, sr);
                return cipher.doFinal(subject);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

