/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.ext.macros;

import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.workgroup.ext.macros.Macro;
import org.jivesoftware.smackx.workgroup.ext.macros.MacroGroup;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class Macros
extends IQ {
    private MacroGroup rootGroup;
    private boolean personal;
    private MacroGroup personalMacroGroup;
    public static final String ELEMENT_NAME = "macros";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";

    public MacroGroup getRootGroup() {
        return this.rootGroup;
    }

    public void setRootGroup(MacroGroup rootGroup) {
        this.rootGroup = rootGroup;
    }

    public boolean isPersonal() {
        return this.personal;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public MacroGroup getPersonalMacroGroup() {
        return this.personalMacroGroup;
    }

    public void setPersonalMacroGroup(MacroGroup personalMacroGroup) {
        this.personalMacroGroup = personalMacroGroup;
    }

    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        if (this.isPersonal()) {
            buf.append("<personal>true</personal>");
        }
        if (this.getPersonalMacroGroup() != null) {
            buf.append("<personalMacro>");
            buf.append(StringUtils.escapeForXML((String)this.getPersonalMacroGroup().toXML()));
            buf.append("</personalMacro>");
        }
        buf.append("</").append(ELEMENT_NAME).append("> ");
        return buf.toString();
    }

    public static class InternalProvider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            Macros macroGroup = new Macros();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (!parser.getName().equals("model")) continue;
                    String macros = parser.nextText();
                    MacroGroup group = this.parseMacroGroups(macros);
                    macroGroup.setRootGroup(group);
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals(Macros.ELEMENT_NAME)) continue;
                done = true;
            }
            return macroGroup;
        }

        public Macro parseMacro(XmlPullParser parser) throws Exception {
            Macro macro = new Macro();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (parser.getName().equals("title")) {
                        parser.next();
                        macro.setTitle(parser.getText());
                        continue;
                    }
                    if (parser.getName().equals("description")) {
                        macro.setDescription(parser.nextText());
                        continue;
                    }
                    if (parser.getName().equals("response")) {
                        macro.setResponse(parser.nextText());
                        continue;
                    }
                    if (!parser.getName().equals("type")) continue;
                    macro.setType(Integer.valueOf(parser.nextText()));
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("macro")) continue;
                done = true;
            }
            return macro;
        }

        public MacroGroup parseMacroGroup(XmlPullParser parser) throws Exception {
            MacroGroup group = new MacroGroup();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (parser.getName().equals("macrogroup")) {
                        group.addMacroGroup(this.parseMacroGroup(parser));
                    }
                    if (parser.getName().equals("title")) {
                        group.setTitle(parser.nextText());
                    }
                    if (!parser.getName().equals("macro")) continue;
                    group.addMacro(this.parseMacro(parser));
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("macrogroup")) continue;
                done = true;
            }
            return group;
        }

        public MacroGroup parseMacroGroups(String macros) throws Exception {
            MacroGroup group = null;
            MXParser parser = new MXParser();
            parser.setInput((Reader)new StringReader(macros));
            int eventType = parser.getEventType();
            while (eventType != 1) {
                eventType = parser.next();
                if (eventType != 2 || !parser.getName().equals("macrogroup")) continue;
                group = this.parseMacroGroup((XmlPullParser)parser);
            }
            return group;
        }
    }
}

