/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.rtpdumpfile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jitsi.impl.neomedia.RawPacket;

public class RtpdumpFileReader {
    public static final int FILE_HEADER_LENGTH = 16;
    private RandomAccessFile stream;

    public RtpdumpFileReader(String filePath) {
        try {
            this.stream = new RandomAccessFile(filePath, "r");
            this.resetFile();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public RawPacket getNextPacket(boolean loopFile) throws IOException {
        if (loopFile && this.stream.getFilePointer() >= this.stream.length()) {
            this.resetFile();
        }
        this.stream.readShort();
        int sizeInBytes = this.stream.readUnsignedShort();
        byte[] rtpdumpPacket = new byte[sizeInBytes];
        this.stream.readInt();
        this.stream.read(rtpdumpPacket);
        return new RawPacket(rtpdumpPacket, 0, rtpdumpPacket.length);
    }

    private void resetFile() throws IOException {
        this.stream.seek(0L);
        this.stream.readLine();
        this.stream.seek(this.stream.getFilePointer() + 16L);
    }
}

