/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jts.admin.cli;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.Param;

public class RecoverTransactionsBase {
    static StringManager localStrings = StringManager.getManager(RecoverTransactionsBase.class);
    static Logger _logger = LogDomains.getLogger(RecoverTransactionsBase.class, (String)"javax.enterprise.system.core.transaction");
    @Inject
    Servers servers;
    @Param(name="transactionlogdir", optional=true)
    String transactionLogDir;
    @Param(name="server_name", primary=true)
    String serverToRecover;

    String validate(String destinationServer, boolean validateAllParams) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("==> validating target: " + destinationServer + " ... server: " + this.serverToRecover);
        }
        if (this.servers.getServer(this.serverToRecover) == null) {
            return localStrings.getString("recover.transactions.serverBeRecoveredIsNotKnown", (Object)this.serverToRecover);
        }
        if (this.isServerRunning(this.serverToRecover)) {
            if (destinationServer != null && !this.serverToRecover.equals(destinationServer)) {
                return localStrings.getString("recover.transactions.runningServerBeRecoveredFromAnotherServer", (Object)this.serverToRecover, (Object)destinationServer);
            }
            if (this.transactionLogDir != null) {
                return localStrings.getString("recover.transactions.logDirShouldNotBeSpecifiedForSelfRecovery");
            }
        } else {
            if (destinationServer == null) {
                return localStrings.getString("recover.transactions.noDestinationServer");
            }
            if (this.servers.getServer(destinationServer) == null) {
                return localStrings.getString("recover.transactions.DestinationServerIsNotKnown");
            }
            if (!this.isServerRunning(destinationServer)) {
                return localStrings.getString("recover.transactions.destinationServerIsNotAlive", (Object)destinationServer);
            }
            if (validateAllParams && this.transactionLogDir == null) {
                return localStrings.getString("recover.transactions.logDirNotSpecifiedForDelegatedRecovery");
            }
        }
        return null;
    }

    private boolean isServerRunning(String serverName) {
        boolean rs = false;
        for (Server server : this.servers.getServer()) {
            if (!serverName.equals(server.getName())) continue;
            rs = server.isRunning();
            break;
        }
        return rs;
    }
}

