/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.jmx.stringifier;

import javax.management.MBeanOperationInfo;
import org.glassfish.admin.amx.util.jmx.stringifier.MBeanFeatureInfoStringifier;
import org.glassfish.admin.amx.util.jmx.stringifier.MBeanFeatureInfoStringifierOptions;
import org.glassfish.admin.amx.util.stringifier.Stringifier;

public class MBeanOperationInfoStringifier
extends MBeanFeatureInfoStringifier
implements Stringifier {
    public static final MBeanOperationInfoStringifier DEFAULT = new MBeanOperationInfoStringifier();

    public MBeanOperationInfoStringifier() {
    }

    public MBeanOperationInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        super(options);
    }

    public static String getImpact(MBeanOperationInfo info) {
        String impactStr = null;
        switch (info.getImpact()) {
            default: {
                impactStr = "unknown";
                break;
            }
            case 0: {
                impactStr = "info";
                break;
            }
            case 1: {
                impactStr = "action";
                break;
            }
            case 2: {
                impactStr = "action-info";
            }
        }
        return impactStr;
    }

    public static String getSignature(MBeanOperationInfo info) {
        return MBeanOperationInfoStringifier.getSignature(info, MBeanFeatureInfoStringifierOptions.DEFAULT);
    }

    public static String getSignature(MBeanOperationInfo info, MBeanFeatureInfoStringifierOptions options) {
        return MBeanOperationInfoStringifier.paramsToString(info.getSignature(), options);
    }

    public static String getDescription(MBeanOperationInfo info) {
        return ",\"" + info.getDescription() + "\"";
    }

    @Override
    public String stringify(Object o) {
        assert (o != null);
        MBeanOperationInfo op = (MBeanOperationInfo)o;
        String result = MBeanOperationInfoStringifier.getPresentationTypeString(op.getReturnType()) + " " + op.getName() + "(";
        result = result + MBeanOperationInfoStringifier.getSignature(op, this.mOptions) + ")";
        String impactStr = MBeanOperationInfoStringifier.getImpact(op);
        result = result + "," + "impact=" + impactStr;
        if (this.mOptions.mIncludeDescription) {
            result = result + MBeanOperationInfoStringifier.getDescription(op);
        }
        return result;
    }
}

