/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public final class JSQLType
implements Formatable {
    public static final byte SQLTYPE = 0;
    public static final byte JAVA_CLASS = 1;
    public static final byte JAVA_PRIMITIVE = 2;
    public static final byte NOT_PRIMITIVE = -1;
    public static final byte BOOLEAN = 0;
    public static final byte CHAR = 1;
    public static final byte BYTE = 2;
    public static final byte SHORT = 3;
    public static final byte INT = 4;
    public static final byte LONG = 5;
    public static final byte FLOAT = 6;
    public static final byte DOUBLE = 7;
    private static final String[] wrapperClassNames = new String[]{"java.lang.Boolean", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private static final String[] primitiveNames = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private byte category = (byte)2;
    private DataTypeDescriptor sqlType;
    private String javaClassName;
    private byte primitiveKind;

    public JSQLType() {
        this.initialize((byte)4);
    }

    public JSQLType(DataTypeDescriptor dataTypeDescriptor) {
        this.initialize(dataTypeDescriptor);
    }

    public JSQLType(String string) {
        byte by = JSQLType.getPrimitiveID(string);
        if (by != -1) {
            this.initialize(by);
        } else {
            this.initialize(string);
        }
    }

    public JSQLType(byte by) {
        this.initialize(by);
    }

    public byte getCategory() {
        return this.category;
    }

    public byte getPrimitiveKind() {
        return this.primitiveKind;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public DataTypeDescriptor getSQLType() throws StandardException {
        if (this.sqlType == null) {
            String string = this.category == 1 ? this.javaClassName : JSQLType.getWrapperClassName(this.primitiveKind);
            this.sqlType = DataTypeDescriptor.getSQLDataTypeDescriptor(string);
        }
        return this.sqlType;
    }

    public static String getPrimitiveName(byte by) {
        return primitiveNames[by];
    }

    public int getTypeFormatId() {
        return 307;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by) {
            case 0: {
                this.initialize((DataTypeDescriptor)objectInput.readObject());
                break;
            }
            case 1: {
                this.initialize((String)objectInput.readObject());
                break;
            }
            case 2: {
                this.initialize(objectInput.readByte());
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.category);
        switch (this.category) {
            case 0: {
                objectOutput.writeObject(this.sqlType);
                break;
            }
            case 1: {
                objectOutput.writeObject(this.javaClassName);
                break;
            }
            case 2: {
                objectOutput.writeByte(this.primitiveKind);
            }
        }
    }

    private void initialize(byte by) {
        this.initialize((byte)2, null, null, by);
    }

    private void initialize(DataTypeDescriptor dataTypeDescriptor) {
        this.initialize((byte)0, dataTypeDescriptor, null, (byte)-1);
    }

    private void initialize(String string) {
        this.initialize((byte)1, null, string, (byte)-1);
    }

    private void initialize(byte by, DataTypeDescriptor dataTypeDescriptor, String string, byte by2) {
        this.category = by;
        this.sqlType = dataTypeDescriptor;
        this.javaClassName = string;
        this.primitiveKind = by2;
    }

    private static String getWrapperClassName(byte by) {
        if (by == -1) {
            return "";
        }
        return wrapperClassNames[by];
    }

    private static byte getPrimitiveID(String string) {
        for (byte by = 0; by <= 7; by = (byte)(by + 1)) {
            if (!primitiveNames[by].equals(string)) continue;
            return by;
        }
        return -1;
    }
}

