/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.catalina.core.StandardServer;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.util.IntrospectionUtils;

public abstract class FilterBase
implements Filter {
    protected static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    @LogMessageInfo(message="The property \"{0}\" is not defined for filters of type \"{1}\"", level="WARNING")
    public static final String PROPERTY_NOT_DEFINED_EXCEPTION = "AS-WEB-CORE-00287";

    protected abstract Logger getLogger();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration<String> paramNames = filterConfig.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            if (IntrospectionUtils.setProperty((Object)this, (String)paramName, (String)filterConfig.getInitParameter(paramName))) continue;
            String msg = MessageFormat.format(rb.getString(PROPERTY_NOT_DEFINED_EXCEPTION), paramName, this.getClass().getName());
            if (this.isConfigProblemFatal()) {
                throw new ServletException(msg);
            }
            this.getLogger().log(Level.WARNING, msg);
        }
    }

    @Override
    public void destroy() {
    }

    protected boolean isConfigProblemFatal() {
        return false;
    }
}

