/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import org.limewire.util.ExceptionUtils;

public class SwingUtils {
    private SwingUtils() {
    }

    public static void invokeNowOrWaitWithInterrupted(Runnable runnable) throws InterruptedException {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InvocationTargetException ite) {
                ExceptionUtils.rethrow(ite.getCause());
            }
        }
    }

    public static void invokeNowOrWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InvocationTargetException ite) {
                ExceptionUtils.rethrow(ite.getCause());
            }
            catch (InterruptedException ignored) {
                throw new RuntimeException(ignored);
            }
        }
    }

    public static void invokeNowOrLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }
}

