/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.limewire.core.api.Application;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.action.DelayedMenuItemCreator;
import org.limewire.ui.swing.action.MnemonicMenu;
import org.limewire.ui.swing.browser.HistoryEntry;
import org.limewire.ui.swing.mainframe.StoreMediator;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.OSUtils;

@Singleton
class StoreMenu
extends MnemonicMenu
implements DelayedMenuItemCreator {
    @InspectablePrimitive(value="store visited", category=DataCategory.USAGE)
    private int storeVisited;
    private final Application application;
    private final Navigator navigator;
    private final StoreMediator storeMediator;

    @Inject
    public StoreMenu(Application application, Navigator navigator, StoreMediator storeMediator) {
        super(I18n.tr("&Store"));
        this.application = application;
        this.navigator = navigator;
        this.storeMediator = storeMediator;
        navigator.createNavItem(NavCategory.LIMEWIRE, "LimeWire Store", storeMediator);
    }

    @Override
    public void createMenuItems() {
        this.add(new AbstractAction(I18n.tr("&Home")){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreMenu.this.storeVisited++;
                StoreMenu.this.navigator.getNavItem(NavCategory.LIMEWIRE, "LimeWire Store").select();
                StoreMenu.this.storeMediator.getComponent().loadDefaultUrl();
            }
        });
        this.add(new StoreUrlAction(I18n.tr("&Log In"), "https://www.store.limewire.com/store/app/pages/account/LogIn/noDest/1/"));
        this.add(new StoreUrlAction(I18n.tr("&Sign Up"), "https://www.store.limewire.com/store/app/pages/register/RegisterSelection/"));
        MnemonicMenu genres = new MnemonicMenu(I18n.tr("&Genres"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&Alternative"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/31/"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&Country"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/14/"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&Electronica"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/20/"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&Folk"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/3/"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&Jazz"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/6/"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&Pop"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/27/"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&Rap"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/8/"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&Rhythm and Blues"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/26/"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&Rock"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/1/"));
        ((JMenu)genres).add(new StoreUrlAction(I18n.tr("&World"), "http://www.store.limewire.com/store/app/pages/genre/GenreHome/genreId/2/"));
        this.add(genres);
        this.add(new StoreUrlAction(I18n.tr("LimeWire Store Hel&p"), "http://www.store.limewire.com/store/app/pages/help/Help/"));
        if (!OSUtils.isMacOSX()) {
            final MnemonicMenu history = new MnemonicMenu(I18n.tr("His&tory"));
            history.addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent e) {
                    history.removeAll();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    history.removeAll();
                }

                @Override
                public void menuSelected(MenuEvent e) {
                    AtomicReference<Integer> currentPosition = new AtomicReference<Integer>();
                    for (HistoryEntry entry : StoreMenu.this.storeMediator.getComponent().getHistory(currentPosition)) {
                        JMenuItem item = history.add(new HistoryAction(entry));
                        if (entry.getIndex() != currentPosition.get().intValue()) continue;
                        FontUtils.bold(item);
                    }
                }
            });
            this.add(history);
        }
    }

    private class StoreUrlAction
    extends AbstractAction {
        private final String url;

        public StoreUrlAction(String name, String url) {
            super(name);
            this.url = StoreMenu.this.application.addClientInfoToUrl(url);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StoreMenu.this.navigator.getNavItem(NavCategory.LIMEWIRE, "LimeWire Store").select();
            StoreMenu.this.storeMediator.getComponent().load(this.url);
        }
    }

    private class HistoryAction
    extends AbstractAction {
        private final HistoryEntry entry;

        public HistoryAction(HistoryEntry entry) {
            super(entry.getName());
            this.putValue("ToolTipText", entry.getUri());
            this.entry = entry;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StoreMenu.this.navigator.getNavItem(NavCategory.LIMEWIRE, "LimeWire Store").select();
            StoreMenu.this.storeMediator.getComponent().loadHistoryEntry(this.entry);
        }
    }
}

