/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.EventUtils;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.MessageComponent;
import org.limewire.ui.swing.components.PanelResizer;
import org.limewire.ui.swing.components.Resizable;
import org.limewire.ui.swing.components.RolloverCursorListener;
import org.limewire.ui.swing.components.decorators.MessageDecorator;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.library.LibraryTableRect;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.library.sharing.LibrarySharingEvent;
import org.limewire.ui.swing.mainframe.GlobalLayeredPane;
import org.limewire.ui.swing.mainframe.TopPanel;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.NavItem;
import org.limewire.ui.swing.nav.NavMediator;
import org.limewire.ui.swing.nav.NavSelectable;
import org.limewire.ui.swing.nav.NavigationListener;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class SignOnMessageLayer {
    @Resource
    private Color messageForeground;
    @Resource
    private Font libraryFont;
    @Resource
    private Font sharingFont;
    @Resource
    private Icon addFileIcon;
    @Resource
    private Icon checkedIcon;
    @Resource
    private Icon closeIcon;
    @Resource
    private Icon closeHoverIcon;
    @Resource
    private Icon upArrowIcon;
    @Resource
    private Icon leftArrowIcon;
    private final JLayeredPane layeredPane;
    private final TopPanel topPanel;
    private final Navigator navigator;
    private final Provider<LibraryNavigatorPanel> libraryNavProvider;
    private final LibraryMediator libraryMediator;
    private final EventListenerList<LibrarySharingEvent> libraryListenerList;
    private final Provider<Rectangle> libraryTableRect;
    private final EventBean<FriendConnectionEvent> connectionEventBean;
    private final Provider<MessageDecorator> messageDecoratorProvider;
    private Component messageComponent;
    private Type messageType = Type.NONE;
    private PanelResizer panelResizer;
    private EventListener<LibrarySharingEvent> libraryListener;

    @Inject
    public SignOnMessageLayer(@GlobalLayeredPane JLayeredPane limeWireLayeredPane, TopPanel topPanel, Navigator navigator, Provider<LibraryNavigatorPanel> libraryNavProvider, LibraryMediator libraryMediator, EventListenerList<LibrarySharingEvent> libraryListenerList, @LibraryTableRect Provider<Rectangle> libraryTableRect, EventBean<FriendConnectionEvent> connectionEventBean, Provider<MessageDecorator> messageDecoratorProvider) {
        this.layeredPane = limeWireLayeredPane;
        this.topPanel = topPanel;
        this.navigator = navigator;
        this.libraryMediator = libraryMediator;
        this.libraryNavProvider = libraryNavProvider;
        this.libraryListenerList = libraryListenerList;
        this.libraryTableRect = libraryTableRect;
        this.connectionEventBean = connectionEventBean;
        this.messageDecoratorProvider = messageDecoratorProvider;
        GuiUtils.assignResources(this);
    }

    @Inject
    void register() {
        this.navigator.addNavigationListener(new NavigationListener(){

            @Override
            public void categoryAdded(NavCategory category) {
            }

            @Override
            public void categoryRemoved(NavCategory category, boolean wasSelected) {
            }

            @Override
            public void itemAdded(NavCategory category, NavItem navItem) {
            }

            @Override
            public void itemRemoved(NavCategory category, NavItem navItem, boolean wasSelected) {
            }

            @Override
            public void itemSelected(NavCategory category, NavItem navItem, NavSelectable selectable, NavMediator navMediator) {
                switch (SignOnMessageLayer.this.messageType) {
                    case LIBRARY: {
                        if (category != NavCategory.LIBRARY) break;
                        SignOnMessageLayer.this.hideMessage();
                        break;
                    }
                    case SHARING: {
                        if (category == NavCategory.LIBRARY) break;
                        SignOnMessageLayer.this.hideMessage();
                    }
                }
                LibraryNavItem.NavType selectedType = SignOnMessageLayer.this.getSelectedNavType();
                if (category == NavCategory.LIBRARY && selectedType == LibraryNavItem.NavType.LIST && SignOnMessageLayer.this.isSignedOn()) {
                    SignOnMessageLayer.this.showMessage();
                }
            }
        });
        this.libraryNavProvider.get().addTableSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LibraryNavItem.NavType navType = SignOnMessageLayer.this.getSelectedNavType();
                switch (SignOnMessageLayer.this.messageType) {
                    case LIBRARY: {
                        if (navType != LibraryNavItem.NavType.LIBRARY) {
                            SignOnMessageLayer.this.hideMessage();
                        }
                        if (navType != LibraryNavItem.NavType.LIST || !SignOnMessageLayer.this.isSignedOn()) break;
                        SignOnMessageLayer.this.showMessage();
                        break;
                    }
                    case SHARING: {
                        if (navType == LibraryNavItem.NavType.LIST) break;
                        SignOnMessageLayer.this.hideMessage();
                        break;
                    }
                    case NONE: {
                        if (navType != LibraryNavItem.NavType.LIST || !SignOnMessageLayer.this.isSignedOn()) break;
                        SignOnMessageLayer.this.showMessage();
                    }
                }
            }
        });
    }

    public static boolean isSignOnMessageEnabled() {
        return SwingUiSettings.SHOW_LIBRARY_OVERLAY_MESSAGE.getValue() || SwingUiSettings.SHOW_SHARING_OVERLAY_MESSAGE.getValue();
    }

    private boolean isSignedOn() {
        FriendConnection connection = (FriendConnection)EventUtils.getSource(this.connectionEventBean);
        return connection != null && connection.isLoggedIn();
    }

    public void showMessage() {
        boolean showLibraryMsg = SwingUiSettings.SHOW_LIBRARY_OVERLAY_MESSAGE.getValue();
        boolean showSharingMsg = SwingUiSettings.SHOW_SHARING_OVERLAY_MESSAGE.getValue();
        NavItem libraryItem = this.navigator.getNavItem(NavCategory.LIBRARY, "Library");
        LibraryNavItem.NavType selectedType = this.getSelectedNavType();
        if (this.panelResizer != null) {
            this.layeredPane.removeComponentListener(this.panelResizer);
            this.panelResizer = null;
        }
        if (this.messageComponent != null) {
            this.layeredPane.remove(this.messageComponent);
            this.messageComponent = null;
        }
        if (libraryItem == null || !libraryItem.isSelected()) {
            if (showLibraryMsg) {
                Point location = new Point(16, this.topPanel.getSize().height - 4);
                this.messageComponent = new LibraryMessagePanel(location, false);
                this.messageType = Type.LIBRARY;
            }
        } else if (selectedType == LibraryNavItem.NavType.LIBRARY || selectedType == LibraryNavItem.NavType.PUBLIC_SHARED) {
            if (showLibraryMsg) {
                LibraryNavigatorPanel libraryNavPanel = this.libraryNavProvider.get();
                Point location = new Point(libraryNavPanel.getSize().width - 6, 75);
                this.messageComponent = new LibraryMessagePanel(location, true);
                this.messageType = Type.LIBRARY;
            }
        } else {
            SwingUiSettings.SHOW_LIBRARY_OVERLAY_MESSAGE.setValue(false);
            if (showSharingMsg) {
                this.messageComponent = new SharingMessagePanel();
                this.messageType = Type.SHARING;
                this.libraryListener = new EventListener<LibrarySharingEvent>(){

                    @Override
                    @SwingEDTEvent
                    public void handleEvent(LibrarySharingEvent event) {
                        SignOnMessageLayer.this.hideMessage();
                    }
                };
                this.libraryListenerList.addListener(this.libraryListener);
            }
        }
        if (this.messageComponent == null) {
            this.messageType = Type.NONE;
            return;
        }
        this.panelResizer = new PanelResizer((Resizable)((Object)this.messageComponent));
        this.layeredPane.add(this.messageComponent, JLayeredPane.PALETTE_LAYER);
        this.layeredPane.addComponentListener(this.panelResizer);
        this.layeredPane.validate();
        this.messageComponent.setVisible(true);
        ((Resizable)((Object)this.messageComponent)).resize();
    }

    private LibraryNavItem.NavType getSelectedNavType() {
        LibraryNavItem selectedItem = this.libraryMediator.getSelectedNavItem();
        LibraryNavItem.NavType selectedType = selectedItem == null ? LibraryNavItem.NavType.LIBRARY : selectedItem.getType();
        return selectedType;
    }

    public void hideMessage() {
        if (this.panelResizer != null) {
            this.layeredPane.removeComponentListener(this.panelResizer);
            this.panelResizer = null;
        }
        if (this.messageComponent != null) {
            this.messageComponent.setVisible(false);
            this.layeredPane.remove(this.messageComponent);
            this.messageComponent = null;
        }
        this.layeredPane.validate();
        if (this.libraryListener != null) {
            this.libraryListenerList.removeListener(this.libraryListener);
            this.libraryListener = null;
        }
        switch (this.messageType) {
            case LIBRARY: {
                SwingUiSettings.SHOW_LIBRARY_OVERLAY_MESSAGE.setValue(false);
                break;
            }
            case SHARING: {
                SwingUiSettings.SHOW_LIBRARY_OVERLAY_MESSAGE.setValue(false);
                SwingUiSettings.SHOW_SHARING_OVERLAY_MESSAGE.setValue(false);
            }
        }
        this.messageType = Type.NONE;
    }

    private JButton createCloseButton() {
        JButton closeButton = new JButton();
        closeButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        closeButton.setContentAreaFilled(false);
        closeButton.setFocusPainted(false);
        closeButton.setIcon(this.closeIcon);
        closeButton.setRolloverIcon(this.closeHoverIcon);
        closeButton.setRolloverEnabled(true);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignOnMessageLayer.this.hideMessage();
            }
        });
        new RolloverCursorListener().install(closeButton);
        return closeButton;
    }

    private class SharingMessagePanel
    extends JPanel
    implements Resizable {
        private MessageComponent messageComponent;
        private JButton closeButton;
        private JLabel leftMessageLabel;
        private JLabel rightMessageLabel;

        public SharingMessagePanel() {
            this.setLayout(new MigLayout("insets 0 0 0 0"));
            this.setOpaque(false);
            this.messageComponent = new MessageComponent(5, 5, 18, 8);
            ((MessageDecorator)SignOnMessageLayer.this.messageDecoratorProvider.get()).decorateGreenMessage(this.messageComponent);
            this.closeButton = SignOnMessageLayer.this.createCloseButton();
            this.leftMessageLabel = new JLabel();
            this.leftMessageLabel.setFont(SignOnMessageLayer.this.sharingFont);
            this.leftMessageLabel.setForeground(SignOnMessageLayer.this.messageForeground);
            this.leftMessageLabel.setIcon(SignOnMessageLayer.this.checkedIcon);
            this.leftMessageLabel.setText(I18n.tr("Share this list with friends"));
            this.rightMessageLabel = new JLabel();
            this.rightMessageLabel.setFont(SignOnMessageLayer.this.sharingFont);
            this.rightMessageLabel.setForeground(SignOnMessageLayer.this.messageForeground);
            this.rightMessageLabel.setIcon(SignOnMessageLayer.this.addFileIcon);
            this.rightMessageLabel.setText(I18n.tr("Add files to it"));
            this.messageComponent.addComponent(this.closeButton, "span 2, align right, push, wrap");
            this.messageComponent.addComponent(this.leftMessageLabel, "gap 18 6, align left, wrap");
            this.messageComponent.addComponent(this.rightMessageLabel, "gap 15 15, align left");
            this.add((Component)this.messageComponent, "pos 0.5al 0.5al");
        }

        @Override
        public void resize() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int y0 = ((SignOnMessageLayer)SignOnMessageLayer.this).topPanel.getSize().height;
                    Rectangle tableRect = (Rectangle)SignOnMessageLayer.this.libraryTableRect.get();
                    SharingMessagePanel.this.setBounds(tableRect.x, y0 + tableRect.y, tableRect.width, tableRect.height);
                    SignOnMessageLayer.this.layeredPane.revalidate();
                }
            });
        }
    }

    private class LibraryMessagePanel
    extends Panel
    implements Resizable {
        private final Point messageLocation;
        private JXPanel messagePanel;
        private JButton closeButton;

        public LibraryMessagePanel(Point messageLocation, boolean librarySelected) {
            super(new BorderLayout());
            this.messageLocation = messageLocation;
            this.messagePanel = new JXPanel(new MigLayout("insets 3 3 3 3, gap 0!"));
            this.messagePanel.setOpaque(false);
            ((MessageDecorator)SignOnMessageLayer.this.messageDecoratorProvider.get()).decorateGreenRectangleMessage(this.messagePanel);
            this.closeButton = SignOnMessageLayer.this.createCloseButton();
            JLabel arrowLabel = new JLabel();
            arrowLabel.setIcon(librarySelected ? SignOnMessageLayer.this.leftArrowIcon : SignOnMessageLayer.this.upArrowIcon);
            JLabel messageLabel = new JLabel();
            messageLabel.setFont(SignOnMessageLayer.this.libraryFont);
            messageLabel.setForeground(SignOnMessageLayer.this.messageForeground);
            messageLabel.setText(I18n.tr("Share with friends using your Private Shared list"));
            if (librarySelected) {
                this.messagePanel.add((Component)arrowLabel, "gap 6 0 0 0, aligny center");
            } else {
                this.messagePanel.add((Component)arrowLabel, "gap 6 0 6 0, aligny top");
            }
            this.messagePanel.add((Component)messageLabel, "gap 6 6 10 10, aligny center");
            this.messagePanel.add((Component)this.closeButton, "aligny top");
            this.add((Component)this.messagePanel, "Center");
        }

        @Override
        public void resize() {
            Dimension preferredSize = this.getPreferredSize();
            this.setBounds(this.messageLocation.x, this.messageLocation.y, preferredSize.width, preferredSize.height);
        }
    }

    private static enum Type {
        NONE,
        LIBRARY,
        SHARING;

    }
}

