/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.util.I18n;

class DeleteListAction
extends AbstractAction {
    private final Provider<LibraryNavigatorPanel> libraryNavigatorPanel;
    private final Provider<SharedFileListManager> sharedFileListManager;

    @Inject
    public DeleteListAction(Provider<LibraryNavigatorPanel> libraryNavigatorPanel, Provider<SharedFileListManager> sharedFileListManager) {
        super(I18n.tr("Delete"));
        this.libraryNavigatorPanel = libraryNavigatorPanel;
        this.sharedFileListManager = sharedFileListManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LibraryNavItem item = this.libraryNavigatorPanel.get().getSelectedNavItem();
        int confirmation = FocusJOptionPane.showConfirmDialog(null, this.getMessage(item), I18n.tr("Delete List"), 2);
        if (confirmation == 0) {
            this.sharedFileListManager.get().deleteSharedFileList((SharedFileList)item.getLocalFileList());
        }
    }

    private String getMessage(LibraryNavItem nav) {
        switch (nav.getType()) {
            case LIST: {
                if (nav.isShared()) {
                    return I18n.tr("Delete list {0}?  This will stop sharing all of these files, but won't delete them from disk.", nav.getDisplayText());
                }
                return I18n.tr("Delete list {0}?", nav.getDisplayText());
            }
            case PUBLIC_SHARED: {
                if (nav.isShared()) {
                    return I18n.tr("Delete list {0}?  This will stop sharing all of these files with the world, but won't delete them from disk.", nav.getDisplayText());
                }
                return I18n.tr("Delete list {0}?", nav.getDisplayText());
            }
        }
        throw new IllegalStateException("unknown type: " + (Object)((Object)nav.getType()));
    }
}

