/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.limewire.friend.api.FriendConnection;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.Objects;

public class AddFriendDialog
extends LimeJDialog {
    public AddFriendDialog(final FriendConnection connection) {
        super((Frame)GuiUtils.getMainFrame(), I18n.tr("Add Friend"));
        Objects.nonNull(connection, "connection");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setLayout(new MigLayout());
        this.setResizable(false);
        JLabel usernameLabel = new JLabel(I18n.tr("Username:"));
        JLabel nicknameLabel = new JLabel(I18n.tr("Nickname:"));
        final JTextField usernameField = new JTextField(18);
        final JTextField nicknameField = new JTextField(18);
        final AbstractAction okAction = new AbstractAction(I18n.tr("Add Friend")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.isEnabled()) {
                    return;
                }
                String user = usernameField.getText().trim();
                if (user.indexOf(64) == -1) {
                    user = user + "@" + connection.getConfiguration().getServiceName();
                }
                String username = user;
                String nick = nicknameField.getText().trim();
                if (nick.equals("")) {
                    nick = usernameField.getText();
                }
                String nickname = nick;
                AddFriendDialog.this.setVisible(false);
                AddFriendDialog.this.dispose();
                connection.addNewFriend(username, nickname);
            }
        };
        JButton ok = new JButton(okAction);
        okAction.setEnabled(false);
        usernameField.addActionListener(okAction);
        nicknameField.addActionListener(okAction);
        JButton cancel = new JButton(I18n.tr("Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddFriendDialog.this.setVisible(false);
                AddFriendDialog.this.dispose();
            }
        });
        usernameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkIfEmpty();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkIfEmpty();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkIfEmpty();
            }

            private void checkIfEmpty() {
                okAction.setEnabled(!usernameField.getText().trim().equals(""));
            }
        });
        this.add(usernameLabel);
        this.add((Component)usernameField, "span, wrap");
        this.add(nicknameLabel);
        this.add((Component)nicknameField, "span, wrap");
        this.add((Component)ok, "cell 1 2");
        this.add((Component)cancel, "cell 2 2");
        this.pack();
        this.setLocationRelativeTo(GuiUtils.getMainFrame());
        this.setVisible(true);
    }
}

