/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.limewire.ui.swing.components.ActionLabel;
import org.limewire.ui.swing.util.ResizeUtils;
import org.limewire.ui.swing.util.SwingHacks;
import org.limewire.util.Objects;

public class LimeComboBox
extends JXButton {
    private final List<Action> actions;
    private Action selectedAction;
    private JComponent selectedComponent;
    private ActionLabel selectedLabel;
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private final List<MenuCreationListener> menuCreationListeners = new ArrayList<MenuCreationListener>();
    private boolean customMenu = false;
    private boolean menuDirty = false;
    private JPopupMenu menu = null;
    private boolean menuVisible = false;
    private long menuInvizTime = -1L;
    private boolean clickForcesVisible = false;
    private Point popupPosition = new Point(1, -1);
    private final MouseListener mouseListener;
    private final ActionListener actionListener;

    public LimeComboBox() {
        this((List<Action>)null);
    }

    public LimeComboBox(List<Action> newActions) {
        this.setText(null);
        this.actions = new ArrayList<Action>();
        this.addActions(newActions);
        this.selectedAction = !this.actions.isEmpty() ? this.actions.get(0) : null;
        this.initModel();
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionLabel label = (ActionLabel)e.getSource();
                Action action = label.getAction();
                LimeComboBox.this.selectedAction = action;
                LimeComboBox.this.selectedComponent = (JComponent)label.getParent();
                LimeComboBox.this.selectedLabel = label;
                LimeComboBox.this.fireChangeEvent(action);
                LimeComboBox.this.repaint();
                LimeComboBox.this.menu.setVisible(false);
            }
        };
        this.mouseListener = new MouseAdapter(){
            private final Color foreground = UIManager.getColor("MenuItem.foreground");
            private final Color selectedForeground = UIManager.getColor("MenuItem.selectionForeground");

            @Override
            public void mouseEntered(MouseEvent e) {
                this.paintNormal(e.getSource(), true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.paintNormal(e.getSource(), false);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.paintNormal(e.getSource(), true);
            }

            private void paintNormal(Object source, boolean selected) {
                JComponent label = (JComponent)source;
                label.setForeground(selected ? this.selectedForeground : this.foreground);
                JComponent parent = (JComponent)label.getParent();
                parent.setOpaque(selected);
                parent.repaint();
                if (LimeComboBox.this.selectedComponent != null && LimeComboBox.this.selectedComponent != parent) {
                    LimeComboBox.this.selectedLabel.setForeground(this.foreground);
                    LimeComboBox.this.selectedComponent.setOpaque(false);
                    LimeComboBox.this.selectedComponent.repaint();
                    LimeComboBox.this.selectedLabel = null;
                    LimeComboBox.this.selectedComponent = null;
                }
            }
        };
    }

    public void overrideMenu(JPopupMenu menu) {
        this.menu = menu;
        this.customMenu = true;
        this.initMenu(true);
    }

    public void overrideMenuNoRestyle(JPopupMenu menu) {
        this.menu = menu;
        this.customMenu = true;
        this.initMenu(false);
    }

    public JComponent decorateMenuComponent(JComponent item) {
        item.setFont(this.getFont());
        item.setBackground(Color.WHITE);
        item.setForeground(Color.BLACK);
        item.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        return item;
    }

    protected JComponent attachListeners(JComponent comp) {
        comp.addMouseListener(this.mouseListener);
        if (comp instanceof ActionLabel) {
            ((ActionLabel)comp).addActionListener(this.actionListener);
        }
        return comp;
    }

    protected JComponent wrapItemForSelection(JComponent comp) {
        JPanel panel = new JPanel(new VerticalLayout());
        panel.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
        panel.add(comp);
        panel.setOpaque(false);
        return panel;
    }

    public JMenuItem createMenuItem(Action a) {
        JMenuItem item = new JMenuItem(a);
        this.decorateMenuComponent(item);
        return item;
    }

    public void addActions(List<Action> newActions) {
        if (newActions == null) {
            return;
        }
        this.menuDirty = true;
        this.actions.addAll(newActions);
        if (this.selectedAction == null) {
            this.selectedAction = this.actions.get(0);
        }
        ResizeUtils.updateSize(this, this.actions);
        if (this.menu == null) {
            this.createPopupMenu();
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.createPopupMenu();
        }
        return this.menu;
    }

    public void setPopupPosition(Point p) {
        this.popupPosition = p;
    }

    public void addAction(Action action) {
        this.actions.add(Objects.nonNull(action, "action"));
        this.menuDirty = true;
        if (this.selectedAction == null) {
            this.selectedAction = this.actions.get(0);
        }
        ResizeUtils.updateSize(this, this.actions);
        if (this.menu == null) {
            this.createPopupMenu();
        }
    }

    public void removeAllActions() {
        this.menuDirty = true;
        this.actions.clear();
        this.selectedAction = null;
    }

    public void removeAction(Action action) {
        this.menuDirty = true;
        this.actions.remove(action);
        if (action == this.selectedAction) {
            this.selectedAction = this.actions.isEmpty() ? null : this.actions.get(0);
            this.selectedComponent = null;
            this.selectedLabel = null;
        }
    }

    public void setSelectedAction(Action action) {
        if (this.actions.contains(action)) {
            this.selectedAction = action;
            this.repaint();
        }
    }

    public Action getSelectedAction() {
        return this.selectedAction;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public void setText(String promptText) {
        super.setText(promptText);
        if (promptText != null) {
            ResizeUtils.updateSize(this, this.actions);
        }
    }

    public void forceResize() {
        ResizeUtils.updateSize(this, this.actions);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.menuDirty = true;
        ResizeUtils.updateSize(this, this.actions);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void addMenuCreationListener(MenuCreationListener listener) {
        this.menuCreationListeners.add(listener);
    }

    @Override
    public void setModel(final ButtonModel delegate) {
        super.setModel(new ButtonModel(){

            @Override
            public boolean isArmed() {
                return delegate.isArmed();
            }

            @Override
            public boolean isSelected() {
                return delegate.isSelected();
            }

            @Override
            public boolean isEnabled() {
                return delegate.isEnabled();
            }

            @Override
            public boolean isPressed() {
                return delegate.isPressed() || LimeComboBox.this.menu != null && LimeComboBox.this.menu.isVisible();
            }

            @Override
            public boolean isRollover() {
                return delegate.isRollover();
            }

            @Override
            public void setArmed(boolean b) {
                delegate.setArmed(b);
            }

            @Override
            public void setSelected(boolean b) {
                delegate.setSelected(b);
            }

            @Override
            public void setEnabled(boolean b) {
                delegate.setEnabled(b);
            }

            @Override
            public void setPressed(boolean b) {
                delegate.setPressed(b);
            }

            @Override
            public void setRollover(boolean b) {
                delegate.setRollover(b);
            }

            @Override
            public void setMnemonic(int i) {
                delegate.setMnemonic(i);
            }

            @Override
            public int getMnemonic() {
                return delegate.getMnemonic();
            }

            @Override
            public void setActionCommand(String string) {
                delegate.setActionCommand(string);
            }

            @Override
            public String getActionCommand() {
                return delegate.getActionCommand();
            }

            @Override
            public void setGroup(ButtonGroup buttonGroup) {
                delegate.setGroup(buttonGroup);
            }

            @Override
            public void addActionListener(ActionListener actionListener) {
                delegate.addActionListener(actionListener);
            }

            @Override
            public void removeActionListener(ActionListener actionListener) {
                delegate.removeActionListener(actionListener);
            }

            @Override
            public Object[] getSelectedObjects() {
                return delegate.getSelectedObjects();
            }

            @Override
            public void addItemListener(ItemListener itemListener) {
                delegate.addItemListener(itemListener);
            }

            @Override
            public void removeItemListener(ItemListener itemListener) {
                delegate.removeItemListener(itemListener);
            }

            @Override
            public void addChangeListener(ChangeListener changeListener) {
                delegate.addChangeListener(changeListener);
            }

            @Override
            public void removeChangeListener(ChangeListener changeListener) {
                delegate.removeChangeListener(changeListener);
            }
        });
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        ResizeUtils.updateSize(this, this.actions);
    }

    @Override
    public Icon getRolloverIcon() {
        Icon icon = super.getRolloverIcon();
        if (icon == null) {
            return this.getIcon();
        }
        return icon;
    }

    @Override
    public Icon getPressedIcon() {
        Icon icon = super.getPressedIcon();
        if (icon == null) {
            return this.getIcon();
        }
        return icon;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public void setClickForcesVisible(boolean clickForcesVisible) {
        this.clickForcesVisible = clickForcesVisible;
    }

    private void initModel() {
        this.setModel(this.getModel());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (LimeComboBox.this.menu != null && LimeComboBox.this.isEnabled()) {
                    if (!LimeComboBox.this.clickForcesVisible && (LimeComboBox.this.menuVisible || (float)(System.currentTimeMillis() - LimeComboBox.this.menuInvizTime) <= 10.0f)) {
                        LimeComboBox.this.menu.setVisible(false);
                    } else {
                        LimeComboBox.this.menu.revalidate();
                        LimeComboBox.this.menu.show((Component)e.getSource(), ((LimeComboBox)LimeComboBox.this).popupPosition.x, LimeComboBox.this.getHeight() + ((LimeComboBox)LimeComboBox.this).popupPosition.y);
                    }
                }
            }
        });
    }

    private void createPopupMenu() {
        this.menu = new JPopupMenu();
        this.initMenu(true);
    }

    private void updateMenu() {
        if (this.customMenu || !this.menuDirty) {
            return;
        }
        this.menuDirty = false;
        this.menu.removeAll();
        EmptyIcon emptyIcon = null;
        for (Action action : this.actions) {
            if (action.getValue("SmallIcon") == null) continue;
            emptyIcon = new EmptyIcon(16, 16);
            break;
        }
        this.selectedComponent = null;
        this.selectedLabel = null;
        for (Action action : this.actions) {
            ActionLabel menuItem = new ActionLabel(action);
            JComponent panel = this.wrapItemForSelection(menuItem);
            if (action != this.selectedAction) {
                panel.setOpaque(false);
                menuItem.setForeground(UIManager.getColor("MenuItem.foreground"));
            } else {
                this.selectedComponent = panel;
                this.selectedLabel = menuItem;
                this.selectedComponent.setOpaque(true);
                this.selectedLabel.setForeground(UIManager.getColor("MenuItem.selectionForeground"));
            }
            if (menuItem.getIcon() == null) {
                menuItem.setIcon(emptyIcon);
            }
            this.attachListeners(menuItem);
            this.decorateMenuComponent(menuItem);
            menuItem.setBorder(BorderFactory.createEmptyBorder(0, 6, 2, 6));
            this.menu.add(panel);
        }
        if (this.getText() == null) {
            this.menu.add(Box.createHorizontalStrut(this.getWidth() - 4));
        }
        for (MenuCreationListener listener : this.menuCreationListeners) {
            listener.menuCreated(this, this.menu);
        }
    }

    protected void fireChangeEvent(Action action) {
        for (SelectionListener listener : this.selectionListeners) {
            listener.selectionChanged(action);
        }
    }

    private void initMenu(boolean style) {
        if (style) {
            this.decorateMenuComponent(this.menu);
            this.menu.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        }
        SwingHacks.fixPopupMenuForWindows(this.menu);
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                LimeComboBox.this.menuVisible = false;
                LimeComboBox.this.menuInvizTime = System.currentTimeMillis();
                LimeComboBox.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                LimeComboBox.this.menuVisible = false;
                LimeComboBox.this.menuInvizTime = System.currentTimeMillis();
                LimeComboBox.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                LimeComboBox.this.menuVisible = true;
                LimeComboBox.this.updateMenu();
            }
        });
    }

    public static interface SelectionListener {
        public void selectionChanged(Action var1);
    }

    public static interface MenuCreationListener {
        public void menuCreated(LimeComboBox var1, JPopupMenu var2);
    }
}

