/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.activation;

import com.google.inject.Inject;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.ui.swing.components.Paintable;
import org.limewire.ui.swing.components.TextFieldClipboardControl;

public class LicenseKeyTextField
extends JTextField
implements Paintable {
    public static final String LICENSE_IS_CORRECT_LENGTH = "License Complete";
    private Painter<JTextField> backgroundPainter;
    private Insets paintedInsets;

    @Inject
    public LicenseKeyTextField() {
        super(15);
        TextFieldClipboardControl.install(this);
    }

    @Inject
    public LicenseKeyTextField(int columns) {
        super(columns);
        TextFieldClipboardControl.install(this);
    }

    @Override
    protected Document createDefaultModel() {
        return new LicenseKeyDocument();
    }

    @Override
    public Insets getPaintedInsets() {
        return this.backgroundPainter == null ? new Insets(0, 0, 0, 0) : this.paintedInsets;
    }

    public void setBackgroundPainter(Painter<JTextField> painter) {
        this.backgroundPainter = painter;
        if (painter != null) {
            this.paintedInsets = new Insets(1, 1, 1, 1);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paint((Graphics2D)g, this, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
    }

    class LicenseKeyDocument
    extends PlainDocument {
        LicenseKeyDocument() {
        }

        @Override
        public void insertString(int offs, String stringToInsert, AttributeSet a) throws BadLocationException {
            if (stringToInsert == null) {
                return;
            }
            int stringLength = stringToInsert.length();
            stringToInsert = stringToInsert.toUpperCase();
            StringBuffer modifiedStringToInsert = new StringBuffer();
            for (int counter = offs; counter < offs + stringLength; ++counter) {
                if (offs + modifiedStringToInsert.length() < 14 && stringToInsert.charAt(counter - offs) != '-') {
                    modifiedStringToInsert.append(stringToInsert.charAt(counter - offs));
                }
                if (offs + modifiedStringToInsert.length() != 4 && offs + modifiedStringToInsert.length() != 9) continue;
                modifiedStringToInsert.append("-");
            }
            super.insertString(offs, modifiedStringToInsert.toString(), a);
            if (this.getLength() > 14) {
                this.remove(14, this.getLength() - 14);
            }
            this.checkLicenseForCompleteness();
        }

        @Override
        public void remove(int offs, int len) {
            try {
                super.remove(offs, len);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.checkLicenseForCompleteness();
        }

        private void checkLicenseForCompleteness() {
            boolean isCorrectLength = this.getLength() == 14 || this.getLength() == 0;
            LicenseKeyTextField.this.firePropertyChange(LicenseKeyTextField.LICENSE_IS_CORRECT_LENGTH, !isCorrectLength, isCorrectLength);
        }
    }
}

