/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.limewire.setting.AbstractSetting;

public class PropertiesSetting
extends AbstractSetting<Properties> {
    private Properties value;

    PropertiesSetting(Properties defaultProps, Properties props, String key, Properties defaultValue) {
        super(defaultProps, props, key, PropertiesSetting.toString(defaultValue));
    }

    @Override
    protected void loadValue(String value) {
        this.value = PropertiesSetting.fromString(value);
    }

    @Override
    public Properties get() {
        return this.value;
    }

    @Override
    public void set(Properties properties) {
        this.value = properties;
        super.setValueInternal(PropertiesSetting.toString(properties));
    }

    static String toString(Properties props) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            props.store(out, "props");
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Properties fromString(String value) {
        Properties props = new Properties();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes("UTF-8"));
            props.load(in);
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

