/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.SynMessage;
import org.limewire.rudp.messages.impl.RUDPMessageImpl;

public class SynMessageImpl
extends RUDPMessageImpl
implements SynMessage {
    private final byte _senderConnectionID;
    private final short _protocolVersionNumber;
    private final SynMessage.Role role;

    SynMessageImpl(byte connectionID, SynMessage.Role role) {
        this(connectionID, 0, role);
    }

    SynMessageImpl(byte connectionID, byte theirConnectionID, SynMessage.Role role) {
        super(theirConnectionID, RUDPMessage.OpCode.OP_SYN, 0L, SynMessageImpl.deriveData(connectionID, (short)1, role));
        this._senderConnectionID = connectionID;
        this.role = role;
        this._protocolVersionNumber = 1;
    }

    static byte[] deriveData(byte connectionID, short protocolVersionNumber, SynMessage.Role role) {
        ByteBuffer data = ByteBuffer.allocate(4);
        data.order(ByteOrder.BIG_ENDIAN);
        data.put(connectionID);
        data.putShort(protocolVersionNumber);
        data.put(role.byteValue());
        return data.array();
    }

    SynMessageImpl(byte connectionId, long sequenceNumber, ByteBuffer data1, ByteBuffer data2) throws MessageFormatException {
        super(RUDPMessage.OpCode.OP_SYN, connectionId, sequenceNumber, data1, data2);
        byte value;
        SynMessage.Role role;
        if (data1.remaining() < 3) {
            throw new MessageFormatException("Message not long enough, message length " + data1.remaining() + " < 3");
        }
        this._senderConnectionID = data1.get();
        data1.order(ByteOrder.BIG_ENDIAN);
        this._protocolVersionNumber = data1.getShort();
        this.role = this._protocolVersionNumber >= 1 ? ((role = SynMessage.Role.valueOf(value = data1.get())) != null ? role : SynMessage.Role.UNDEFINED) : SynMessage.Role.UNDEFINED;
        data1.rewind();
    }

    @Override
    public byte getSenderConnectionID() {
        return this._senderConnectionID;
    }

    @Override
    public int getProtocolVersionNumber() {
        return this._protocolVersionNumber;
    }

    public String toString() {
        return "SynMessage DestID:" + this.getConnectionID() + " SrcID:" + this._senderConnectionID + " vNo:" + this._protocolVersionNumber;
    }

    @Override
    public SynMessage.Role getRole() {
        return this.role;
    }
}

