/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl;

import com.google.inject.Inject;
import org.apache.http.auth.Credentials;
import org.limewire.friend.api.feature.AuthToken;
import org.limewire.friend.impl.feature.AuthTokenImpl;
import org.limewire.friend.impl.feature.AuthTokenRegistry;
import org.limewire.http.auth.Authenticator;
import org.limewire.http.auth.AuthenticatorRegistry;
import org.limewire.inject.EagerSingleton;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.security.SHA1;
import org.limewire.security.SecurityUtils;
import org.limewire.util.StringUtils;

@EagerSingleton
class DefaultFriendAuthenticator
implements Authenticator,
AuthTokenRegistry {
    private static final Log LOG = LogFactory.getLog(DefaultFriendAuthenticator.class);
    private final byte[] seed = new byte[20];

    DefaultFriendAuthenticator() {
        SecurityUtils.createSecureRandomNoBlock().nextBytes(this.seed);
    }

    @Override
    @Inject
    public void register(AuthenticatorRegistry registry) {
        registry.register(this);
    }

    @Override
    public AuthToken getAuthToken(String userId) {
        SHA1 sha1 = new SHA1();
        byte[] hash = sha1.digest(StringUtils.toUTF8Bytes(userId));
        for (int i = 0; i < hash.length; ++i) {
            hash[i] = (byte)(hash[i] ^ this.seed[i]);
        }
        sha1.reset();
        return new AuthTokenImpl(sha1.digest(hash));
    }

    @Override
    public boolean authenticate(Credentials credentials) {
        String password = credentials.getPassword();
        if (password == null) {
            return false;
        }
        AuthTokenImpl received = new AuthTokenImpl(password);
        AuthToken local = this.getAuthToken(credentials.getUserPrincipal().getName());
        if (!((Object)received).equals(local)) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("passwords did not match: {0}", (Object)password);
                LOG.debugf("received: {0}, local: {1}", (Object)received, (Object)local);
            }
            return false;
        }
        return true;
    }
}

