/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.UnmodifiableIterator;

public class RandomSequence
implements Iterable<Integer> {
    private final int end;
    private final long pow2;
    private final long a;
    private long seed;

    public RandomSequence(int end) {
        long pow;
        this.end = end;
        if (end <= 1) {
            this.pow2 = 0L;
            this.a = 0L;
            return;
        }
        for (pow = 1L; pow < (long)end; pow <<= 1) {
        }
        this.pow2 = pow - 1L;
        this.a = ((int)(Math.random() * (double)(this.pow2 >> 2)) << 2) + 1;
        this.seed = (int)(Math.random() * (double)end);
    }

    public int nextInt() {
        if (this.end < 1) {
            throw new NoSuchElementException();
        }
        if (this.end == 1) {
            return 0;
        }
        do {
            this.seed = this.a * this.seed + 3L & this.pow2;
        } while (this.seed >= (long)this.end || this.seed < 0L);
        return (int)this.seed;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new RandomIterator();
    }

    private class RandomIterator
    extends UnmodifiableIterator<Integer> {
        private int given;

        private RandomIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.given < RandomSequence.this.end;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.given;
            return RandomSequence.this.nextInt();
        }
    }
}

