/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

public class GIFFormat
extends VideoFormat {
    public GIFFormat() {
        super("gif");
        this.dataType = Format.byteArray;
    }

    public GIFFormat(Dimension size, int maxDataLength, Class dataType, float frameRate) {
        super("gif", size, maxDataLength, dataType, frameRate);
    }

    public Object clone() {
        return new GIFFormat(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate);
    }

    protected void copy(Format f) {
        super.copy(f);
        GIFFormat oCast = (GIFFormat)f;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("GIF video format:");
        if (FormatUtils.specified(this.size)) {
            b.append(" size = " + this.size.width + "x" + this.size.height);
        }
        if (FormatUtils.specified(this.frameRate)) {
            b.append(" FrameRate = " + this.frameRate);
        }
        if (FormatUtils.specified(this.maxDataLength)) {
            b.append(" maxDataLength = " + this.maxDataLength);
        }
        if (FormatUtils.specified(this.dataType)) {
            b.append(" dataType = " + this.dataType);
        }
        return b.toString();
    }

    public boolean equals(Object format) {
        if (!super.equals(format)) {
            return false;
        }
        if (!(format instanceof GIFFormat)) {
            return false;
        }
        GIFFormat oCast = (GIFFormat)format;
        return true;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatTraceUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof GIFFormat)) {
            boolean result = true;
            FormatTraceUtils.traceMatches(this, format, true);
            return true;
        }
        GIFFormat oCast = (GIFFormat)format;
        boolean result = true;
        FormatTraceUtils.traceMatches(this, format, true);
        return true;
    }

    public Format intersects(Format other) {
        Format result = super.intersects(other);
        if (other instanceof GIFFormat) {
            GIFFormat resultCast = (GIFFormat)result;
            GIFFormat oCast = (GIFFormat)other;
            if (this.getClass().isAssignableFrom(other.getClass()) || other.getClass().isAssignableFrom(this.getClass())) {
                // empty if block
            }
        }
        FormatTraceUtils.traceIntersects(this, other, result);
        return result;
    }
}

