/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.media.Controller;
import javax.media.Time;
import net.sf.fmj.ejmf.toolkit.gui.controls.MouseListenerControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

public class StandardFastForwardControl
extends MouseListenerControl {
    private static final float DEFAULT_FF_RATE = 2.0f;
    private float fastForwardRate;

    public StandardFastForwardControl(Skin skin, Controller controller, float rate) {
        super(skin, controller);
        this.fastForwardRate = rate < 1.0f ? 2.0f : rate;
        this.getControlComponent().setEnabled(true);
    }

    public StandardFastForwardControl(Skin skin, Controller controller) {
        this(skin, controller, 2.0f);
    }

    public StandardFastForwardControl(Skin skin) {
        super(skin);
        this.fastForwardRate = 2.0f;
        this.getControlComponent().setEnabled(true);
    }

    protected Component createControlComponent(Skin skin) {
        return skin.createFastForwardButton();
    }

    protected EventListener createControlListener() {
        return new MouseAdapter(){
            private float saveRate;
            private int priorState;

            public void mousePressed(MouseEvent mouseEvent) {
                Controller controller = StandardFastForwardControl.this.getController();
                this.saveRate = controller.getRate();
                this.priorState = controller.getState();
                if (this.priorState == 600) {
                    controller.stop();
                }
                controller.setRate(StandardFastForwardControl.this.fastForwardRate);
                Time now = controller.getTimeBase().getTime();
                controller.syncStart(now);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Controller controller = StandardFastForwardControl.this.getController();
                controller.setRate(this.saveRate);
                if (this.priorState != 600) {
                    controller.stop();
                }
            }
        };
    }
}

