/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.security.Certificate;
import com.limegroup.gnutella.security.CertificateProvider;
import com.limegroup.gnutella.security.CertifiedMessageSourceType;
import com.limegroup.gnutella.security.CertifiedMessageVerifier;
import com.limegroup.gnutella.security.DefaultSignedMessageDataProvider;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.DownloadInformation;
import com.limegroup.gnutella.version.Update;
import com.limegroup.gnutella.version.UpdateCollection;
import com.limegroup.gnutella.version.UpdateCollectionFactory;
import com.limegroup.gnutella.version.UpdateData;
import com.limegroup.gnutella.version.UpdateEvent;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.version.UpdateInformation;
import com.limegroup.gnutella.version.UpdateMessageVerifier;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.activation.api.ActivationManager;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.UpdateSettings;
import org.limewire.http.httpclient.HttpClientInstanceUtils;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IOUtils;
import org.limewire.io.InvalidDataException;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.Clock;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;
import org.limewire.util.VersionUtils;

@EagerSingleton
public class UpdateHandlerImpl
implements UpdateHandler,
EventListener<LibraryStatusEvent>,
Service {
    private static final Log LOG = LogFactory.getLog(UpdateHandlerImpl.class);
    private static final long THREE_DAYS = 259200000L;
    private static final long ONE_MONTH = 2592000000L;
    private static final String FILENAME = "version.xml";
    protected static final int IGNORE_ID = Integer.MAX_VALUE;
    private static final Random RANDOM = new Random();
    private final Clock clock;
    private volatile UpdateInformation _updateInfo;
    private volatile List<DownloadInformation> _updatesToDownload;
    private volatile int _lastId;
    private volatile int newVersion;
    private volatile byte[] _lastBytes;
    private long _lastTimestamp;
    private long _nextDownloadTime;
    private boolean _killingObsoleteNecessary;
    private final HttpRequestControl httpRequestControl = new HttpRequestControl();
    private final ScheduledExecutorService backgroundExecutor;
    private final ConnectionServices connectionServices;
    private final Provider<HttpExecutor> httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<DownloadManager> downloadManager;
    private final Library library;
    private final FileView gnutellaFileView;
    private final UpdateCollectionFactory updateCollectionFactory;
    private final UpdateMessageVerifier updateMessageVerifier;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final EventListenerList<UpdateEvent> listeners;
    private final ActivationManager activationManager;
    private volatile String timeoutUpdateLocation = "http://update0.limewire.com/v3/update.def";
    private volatile List<String> maxedUpdateList = Arrays.asList("http://update1.limewire.com/v3/update.def", "http://update2.limewire.com/v3/update.def", "http://update3.limewire.com/v3/update.def", "http://update4.limewire.com/v3/update.def", "http://update5.limewire.com/v3/update.def", "http://update6.limewire.com/v3/update.def", "http://update7.limewire.com/v3/update.def", "http://update8.limewire.com/v3/update.def", "http://update9.limewire.com/v3/update.def", "http://update10.limewire.com/v3/update.def");
    private volatile int minMaxHttpRequestDelay = 60000;
    private volatile int maxMaxHttpRequestDelay = 1800000;
    private volatile int silentPeriodForMaxHttpRequest = 300000;
    private volatile UpdateCollection updateCollection;
    private final HttpClientInstanceUtils httpClientInstanceUtils;
    private final CertificateProvider certificateProvider;
    private final CertifiedMessageVerifier certifiedMessageVerifier;
    private final DefaultSignedMessageDataProvider updateDataProvider;

    @Inject
    UpdateHandlerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, ConnectionServices connectionServices, Provider<HttpExecutor> httpExecutor, @Named(value="defaults") Provider<HttpParams> defaultParams, CapabilitiesVMFactory capabilitiesVMFactory, Provider<ConnectionManager> connectionManager, Provider<DownloadManager> downloadManager, UpdateCollectionFactory updateCollectionFactory, Clock clock, UpdateMessageVerifier updateMessageVerifier, RemoteFileDescFactory remoteFileDescFactory, @GnutellaFiles FileView gnutellaFileView, Library library, ActivationManager activationManager, HttpClientInstanceUtils httpClientInstanceUtils, @Update CertificateProvider certificateProvider, @Update CertifiedMessageVerifier certifiedMessageVerifier, @Update DefaultSignedMessageDataProvider updateDataProvider) {
        this.backgroundExecutor = backgroundExecutor;
        this.connectionServices = connectionServices;
        this.httpExecutor = httpExecutor;
        this.defaultParams = defaultParams;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.connectionManager = connectionManager;
        this.downloadManager = downloadManager;
        this.library = library;
        this.updateCollectionFactory = updateCollectionFactory;
        this.clock = clock;
        this.updateMessageVerifier = updateMessageVerifier;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.gnutellaFileView = gnutellaFileView;
        this.activationManager = activationManager;
        this.httpClientInstanceUtils = httpClientInstanceUtils;
        this.certificateProvider = certificateProvider;
        this.certifiedMessageVerifier = certifiedMessageVerifier;
        this.updateDataProvider = updateDataProvider;
        this.listeners = new EventListenerList();
    }

    @Inject
    void register(ListenerSupport<LibraryStatusEvent> listener) {
        listener.addListener(this);
    }

    String getTimeoutUrl() {
        return this.timeoutUpdateLocation;
    }

    List<String> getMaxUrls() {
        return this.maxedUpdateList;
    }

    void setMaxUrls(List<String> urls) {
        this.maxedUpdateList = urls;
    }

    void setSilentPeriodForMaxHttpRequest(int silentPeriodForMaxHttpRequest) {
        this.silentPeriodForMaxHttpRequest = silentPeriodForMaxHttpRequest;
    }

    @Override
    public void start() {
        LOG.trace("Initializing UpdateHandler");
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                UpdateHandlerImpl.this.handleDataInternal(FileUtils.readFileFully(UpdateHandlerImpl.this.getStoredFile()), CertifiedMessageSourceType.FROM_DISK, null);
                UpdateHandlerImpl.this.handleDataInternal(UpdateHandlerImpl.this.updateDataProvider.getDefaultSignedMessageData(), CertifiedMessageSourceType.FROM_DISK, null);
            }
        });
        this.backgroundExecutor.schedule(new Poller(), UpdateSettings.UPDATE_RETRY_DELAY.getValue(), TimeUnit.MILLISECONDS);
    }

    private void tryToDownloadUpdates() {
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                UpdateInformation updateInfo = UpdateHandlerImpl.this._updateInfo;
                if (updateInfo != null && updateInfo.getUpdateURN() != null && UpdateHandlerImpl.this.isMyUpdateDownloaded(updateInfo)) {
                    UpdateHandlerImpl.this.fireUpdate(updateInfo);
                }
                UpdateHandlerImpl.this.downloadUpdates(UpdateHandlerImpl.this._updatesToDownload, null);
            }
        });
    }

    @Override
    public void handleUpdateAvailable(final ReplyHandler rh, final int newVersion) {
        if (newVersion == this.newVersion) {
            this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    UpdateHandlerImpl.this.addSourceIfIdMatches(rh, newVersion);
                }
            });
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version from rh: " + rh + ", them: " + newVersion + ", me: " + this.newVersion);
        }
    }

    @Override
    public void handleNewData(byte[] data, ReplyHandler handler) {
        LOG.debug("handling new network data");
        if (data != null) {
            this.backgroundExecutor.execute(new NetworkDataRunnable(data, handler));
        }
    }

    @Override
    public int getLatestId() {
        return this._lastId;
    }

    @Override
    public byte[] getLatestBytes() {
        return this._lastBytes;
    }

    protected void handleDataInternal(byte[] data, CertifiedMessageSourceType updateType, ReplyHandler handler) {
        if (data == null) {
            LOG.warn("No data to handle.");
            return;
        }
        String xml = this.updateMessageVerifier.getVerifiedData(data);
        if (xml == null) {
            LOG.warn("Couldn't verify signature on data.");
            return;
        }
        UpdateCollection uc = null;
        try {
            uc = this.updateCollectionFactory.createUpdateCollection(xml);
        }
        catch (InvalidDataException e) {
            LOG.debug("invalid update data", e);
            return;
        }
        CertifiedMessageVerifier.CertifiedMessage certifiedMessage = uc.getCertifiedMessage();
        Certificate certificate = null;
        try {
            certificate = this.certifiedMessageVerifier.verify(certifiedMessage, handler);
        }
        catch (SignatureException se) {
            LOG.error("message did not verify", se);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got a collection with id: " + uc.getNewVersion() + ", from " + (Object)((Object)updateType) + ".  Current id is: " + this.newVersion);
        }
        int networkKeyVersion = certificate.getKeyVersion();
        int localKeyVersion = this.getKeyVersion();
        int networkNewVersion = uc.getNewVersion();
        switch (updateType) {
            case FROM_NETWORK: {
                if (localKeyVersion == Integer.MAX_VALUE) break;
                if (networkKeyVersion > localKeyVersion) {
                    if (networkKeyVersion == Integer.MAX_VALUE) {
                        this.doHttpMaxFailover(uc);
                        break;
                    }
                    this.storeAndUpdate(data, uc, updateType, certificate);
                    break;
                }
                if (networkKeyVersion == localKeyVersion && networkNewVersion > this.newVersion) {
                    this.storeAndUpdate(data, uc, updateType, certificate);
                    break;
                }
                this.checkForStaleUpdateAndMaybeDoHttpFailover();
                this.addSourceIfIdMatches(handler, networkNewVersion);
                break;
            }
            case FROM_DISK: {
                this.checkForStaleUpdateAndMaybeDoHttpFailover();
                if (networkKeyVersion <= localKeyVersion && (networkKeyVersion != localKeyVersion || networkNewVersion <= this.newVersion)) break;
                this.storeAndUpdate(data, uc, updateType, certificate);
                break;
            }
            case FROM_HTTP: {
                if (networkKeyVersion <= localKeyVersion && (networkKeyVersion != localKeyVersion || networkNewVersion < this.newVersion)) break;
                this.storeAndUpdate(data, uc, updateType, certificate);
            }
        }
    }

    private void storeAndUpdate(byte[] data, UpdateCollection uc, CertifiedMessageSourceType updateType, Certificate certificate) {
        Version limeV;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Retrieved new data from: " + (Object)((Object)updateType) + ", storing & updating.");
        }
        if (uc.getId() == Integer.MAX_VALUE && updateType == CertifiedMessageSourceType.FROM_NETWORK) {
            throw new IllegalStateException("shouldn't be here!");
        }
        if (updateType == CertifiedMessageSourceType.FROM_NETWORK && this.httpRequestControl.isRequestPending() && this.httpRequestControl.getRequestReason() == HttpRequestControl.RequestReason.MAX) {
            return;
        }
        this._lastId = uc.getId();
        this.newVersion = uc.getNewVersion();
        this.updateCollection = uc;
        this.certificateProvider.set(certificate);
        this._lastTimestamp = uc.getTimestamp();
        UpdateSettings.LAST_UPDATE_TIMESTAMP.setValue(this._lastTimestamp);
        long delay = UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue();
        long random = Math.abs(RANDOM.nextLong() % delay);
        this._nextDownloadTime = this._lastTimestamp + random;
        this._lastBytes = data;
        if (updateType != CertifiedMessageSourceType.FROM_DISK) {
            if (this.httpRequestControl.getRequestReason() == HttpRequestControl.RequestReason.TIMEOUT) {
                this.httpRequestControl.cancelRequest();
            }
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(this.clock.now());
            FileUtils.verySafeSave(CommonUtils.getUserSettingsDir(), FILENAME, data);
            this.capabilitiesVMFactory.updateCapabilities();
            this.connectionManager.get().sendUpdatedCapabilities();
        }
        try {
            limeV = new Version(LimeWireUtils.getLimeWireVersion());
        }
        catch (VersionFormatException vfe) {
            LOG.warn("Invalid LimeWire version", vfe);
            return;
        }
        Version javaV = null;
        try {
            javaV = new Version(VersionUtils.getJavaVersion());
        }
        catch (VersionFormatException vfe) {
            LOG.warn("Invalid java version", vfe);
        }
        int style = Math.min(2, UpdateSettings.UPDATE_STYLE.getValue());
        UpdateData updateInfo = uc.getUpdateDataFor(limeV, ApplicationSettings.getLanguage(), this.activationManager.isProActive(), style, javaV);
        List<DownloadInformation> updatesToDownload = uc.getUpdatesWithDownloadInformation();
        this._killingObsoleteNecessary = true;
        if (updateInfo != null && updateInfo.getUpdateURN() != null) {
            UpdateHandlerImpl.prepareUpdateCommand(updateInfo);
            updatesToDownload = new LinkedList<DownloadInformation>(updatesToDownload);
            updatesToDownload.add(0, updateInfo);
        }
        this._updateInfo = updateInfo;
        this._updatesToDownload = updatesToDownload;
        this.downloadUpdates(updatesToDownload, null);
        if (updateInfo == null) {
            LOG.warn("No relevant update info to notify about.");
            return;
        }
        if (updateInfo.getUpdateURN() == null || UpdateHandlerImpl.isHopeless(updateInfo)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("we have an update, but it doesn't need a download.  or all our updates are hopeles. Scheduling URL notification...");
            }
            updateInfo.setUpdateCommand(null);
            this.backgroundExecutor.schedule(new NotificationFailover(this.newVersion), UpdateHandlerImpl.delay(this.clock.now(), uc.getTimestamp()), TimeUnit.MILLISECONDS);
        } else if (this.isMyUpdateDownloaded(updateInfo)) {
            LOG.debug("there is an update for me, but I happen to have it on disk");
            this.fireUpdate(updateInfo);
        } else {
            LOG.debug("we have an update, it needs a download.  Rely on callbacks");
        }
    }

    private void checkForStaleUpdateAndMaybeDoHttpFailover() {
        LOG.debug("checking for timeout http failover");
        long monthAgo = this.clock.now() - 2592000000L;
        if (UpdateSettings.LAST_UPDATE_TIMESTAMP.getValue() < monthAgo && UpdateSettings.LAST_HTTP_FAILOVER.getValue() < monthAgo && !this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.TIMEOUT)) {
            long when = (this.connectionServices.isConnected() ? 1 : 5) * 60 * 1000;
            if (LOG.isDebugEnabled()) {
                LOG.debug("scheduling http failover in " + when);
            }
            this.backgroundExecutor.schedule(new StaleHttpUpdateRunnable(), when, TimeUnit.MILLISECONDS);
        }
    }

    private void doHttpMaxFailover(UpdateCollection updateCollection) {
        long maxTimeAgo = this.clock.now() - (long)this.silentPeriodForMaxHttpRequest;
        if (!this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.MAX) && UpdateSettings.LAST_HTTP_FAILOVER.getValue() < maxTimeAgo) {
            LOG.debug("Scheduling http max failover...");
            this.backgroundExecutor.schedule(new HttpMaxFailOverRunnable(), (long)(RANDOM.nextInt(this.maxMaxHttpRequestDelay) + this.minMaxHttpRequestDelay), TimeUnit.MILLISECONDS);
        } else {
            LOG.debug("Ignoring http max failover.");
        }
    }

    private void launchHTTPUpdate(String url) throws URISyntaxException {
        if (!this.httpRequestControl.isRequestPending()) {
            return;
        }
        LOG.debug("about to issue http request method");
        HttpGet get = new HttpGet(this.httpClientInstanceUtils.addClientInfoToUrl(url));
        get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        get.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        this.httpRequestControl.requestActive();
        AbstractHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 10000);
        HttpConnectionParams.setSoTimeout(params, 10000);
        params = new DefaultedHttpParams(params, this.defaultParams.get());
        this.httpExecutor.get().execute(get, params, new RequestHandler());
    }

    private static void prepareUpdateCommand(UpdateData info) {
        if (info == null || info.getUpdateCommand() == null) {
            return;
        }
        File path = LibraryUtils.PREFERENCE_SHARE.getAbsoluteFile();
        String name = info.getUpdateFileName();
        try {
            path = FileUtils.getCanonicalFile(path);
        }
        catch (IOException bad) {
            // empty catch block
        }
        String command = info.getUpdateCommand();
        command = StringUtils.replace(command, "$", path.getPath() + File.separator);
        command = StringUtils.replace(command, "%", name);
        info.setUpdateCommand(command);
    }

    private static boolean isHopeless(DownloadInformation info) {
        return UpdateSettings.FAILED_UPDATES.contains(info.getUpdateURN().httpStringValue());
    }

    private void addSourceIfIdMatches(ReplyHandler rh, int version) {
        if (version == this.newVersion) {
            this.downloadUpdates(this._updatesToDownload, rh);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version? Me: " + version + ", here: " + this.newVersion);
        }
    }

    private void downloadUpdates(List<? extends DownloadInformation> toDownload, ReplyHandler source) {
        if (toDownload == null) {
            toDownload = Collections.emptyList();
        }
        this.killObsoleteUpdates(toDownload);
        for (DownloadInformation next : toDownload) {
            if (UpdateHandlerImpl.isHopeless(next) || !this.downloadManager.get().isSavedDownloadsLoaded() || !this.library.isLoadFinished()) continue;
            ManagedDownloader md = (ManagedDownloader)this.downloadManager.get().getDownloaderForURN(next.getUpdateURN());
            if (this.hasCompleteFile(next.getUpdateURN())) {
                if (md == null) continue;
                md.stop();
                continue;
            }
            if (md == null && !this.downloadManager.get().hasInNetworkDownload() && this.canStartDownload()) {
                LOG.debug("Starting a new InNetwork Download");
                try {
                    md = (ManagedDownloader)this.downloadManager.get().download(next, this.clock.now());
                }
                catch (DownloadException e) {
                    LOG.error("Unable to construct download", e);
                }
            }
            if (md == null) continue;
            if (source != null) {
                md.addDownload(this.rfd(source, next), false);
                continue;
            }
            this.addCurrentDownloadSources(md, next);
        }
    }

    private void killObsoleteUpdates(List<? extends DownloadInformation> toDownload) {
        if (!this.downloadManager.get().isSavedDownloadsLoaded() || !this.library.isLoadFinished()) {
            return;
        }
        if (this._killingObsoleteNecessary) {
            this._killingObsoleteNecessary = false;
            this.downloadManager.get().killDownloadersNotListed(toDownload);
            HashSet<URN> urns = new HashSet<URN>(toDownload.size());
            for (DownloadInformation downloadInformation : toDownload) {
                urns.add(downloadInformation.getUpdateURN());
            }
            List<FileDesc> shared = this.gnutellaFileView.getFilesInDirectory(LibraryUtils.PREFERENCE_SHARE);
            for (FileDesc fd : shared) {
                if (fd.getSHA1Urn() == null || urns.contains(fd.getSHA1Urn())) continue;
                this.library.remove(fd.getFile());
                fd.getFile().delete();
            }
        }
    }

    private void addCurrentDownloadSources(ManagedDownloader md, DownloadInformation info) {
        for (RoutedConnection mc : this.connectionManager.get().getConnections()) {
            if (mc.getConnectionCapabilities().getRemoteHostNewUpdateVersion() == this.newVersion) {
                LOG.debug("Adding source: " + mc);
                md.addDownload(this.rfd(mc, info), false);
                continue;
            }
            LOG.debug("Not adding source because bad id: " + mc.getConnectionCapabilities().getRemoteHostNewUpdateVersion() + ", us: " + this.newVersion);
        }
    }

    private RemoteFileDesc rfd(ReplyHandler rh, DownloadInformation info) {
        UrnSet urns = new UrnSet(info.getUpdateURN());
        return this.remoteFileDescFactory.createRemoteFileDesc(new ConnectableImpl(rh.getInetSocketAddress(), rh instanceof Connectable ? ((Connectable)((Object)rh)).isTLSCapable() : false), Integer.MAX_VALUE, info.getUpdateFileName(), info.getSize(), rh.getClientGUID(), 0, 2, false, null, urns, false, "LIME", -1L);
    }

    private boolean canStartDownload() {
        long now = this.clock.now();
        if (LOG.isDebugEnabled()) {
            LOG.debug("now is " + now + " next time is " + this._nextDownloadTime);
        }
        return now > this._nextDownloadTime;
    }

    private void notifyAboutInfo(int id) {
        if (id != this.newVersion) {
            return;
        }
        UpdateInformation update2 = this._updateInfo;
        assert (update2 != null);
        this.fireUpdate(update2);
    }

    private static long delay(long now, long timestamp) {
        if (timestamp - now > 259200000L) {
            return 0L;
        }
        long delay = UpdateSettings.UPDATE_DELAY.getValue();
        long random = Math.abs(new Random().nextLong() % delay);
        long then = timestamp + random;
        if (LOG.isInfoEnabled()) {
            LOG.info("Delaying Update.\nNow    : " + now + " (" + new Date(now) + ")" + "\nStamp  : " + timestamp + " (" + new Date(timestamp) + ")" + "\nDelay  : " + delay + " (" + CommonUtils.seconds2time(delay / 1000L) + ")" + "\nRandom : " + random + " (" + CommonUtils.seconds2time(random / 1000L) + ")" + "\nThen   : " + then + " (" + new Date(then) + ")" + "\nDiff   : " + (then - now) + " (" + CommonUtils.seconds2time((then - now) / 1000L) + ")");
        }
        return Math.max(0L, then - now);
    }

    @Override
    public void inNetworkDownloadFinished(final URN urn, final boolean good) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                UpdateData updateInfo;
                if (!good) {
                    UpdateSettings.FAILED_UPDATES.add(urn.httpStringValue());
                }
                if ((updateInfo = (UpdateData)UpdateHandlerImpl.this._updateInfo) != null && updateInfo.getUpdateURN() != null && updateInfo.getUpdateURN().equals(urn)) {
                    if (!good) {
                        updateInfo.setUpdateCommand(null);
                        long delay = UpdateHandlerImpl.delay(UpdateHandlerImpl.this.clock.now(), UpdateHandlerImpl.this._lastTimestamp);
                        UpdateHandlerImpl.this.backgroundExecutor.schedule(new NotificationFailover(UpdateHandlerImpl.this.newVersion), delay, TimeUnit.MILLISECONDS);
                    } else {
                        UpdateHandlerImpl.this.fireUpdate(updateInfo);
                        ((ConnectionManager)UpdateHandlerImpl.this.connectionManager.get()).sendUpdatedCapabilities();
                    }
                }
            }
        };
        this.backgroundExecutor.execute(r);
    }

    private void killHopelessUpdates(List<? extends DownloadInformation> updates) {
        if (updates == null) {
            return;
        }
        if (!this.downloadManager.get().hasInNetworkDownload()) {
            return;
        }
        long now = this.clock.now();
        for (DownloadInformation downloadInformation : updates) {
            InNetworkDownloader iDownloader;
            Downloader downloader = this.downloadManager.get().getDownloaderForURN(downloadInformation.getUpdateURN());
            if (downloader == null || !(downloader instanceof InNetworkDownloader) || !this.isHopeless(iDownloader = (InNetworkDownloader)downloader, now)) continue;
            iDownloader.stop();
        }
    }

    private boolean isHopeless(InNetworkDownloader downloader, long now) {
        if (now - downloader.getStartTime() < (long)UpdateSettings.UPDATE_GIVEUP_FACTOR.getValue() * UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue()) {
            return false;
        }
        return downloader.getDownloadAttempts() >= UpdateSettings.UPDATE_MIN_ATTEMPTS.getValue();
    }

    private boolean isMyUpdateDownloaded(UpdateInformation myInfo) {
        if (!this.library.isLoadFinished()) {
            return false;
        }
        URN myUrn = myInfo.getUpdateURN();
        if (myUrn == null) {
            return true;
        }
        return this.hasCompleteFile(myUrn);
    }

    private boolean hasCompleteFile(URN urn) {
        List<FileDesc> fds = this.library.getFileDescsMatching(urn);
        for (FileDesc fd : fds) {
            if (fd instanceof IncompleteFileDesc) continue;
            return true;
        }
        return false;
    }

    private File getStoredFile() {
        return new File(CommonUtils.getUserSettingsDir(), FILENAME);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Update Checks");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public void handleEvent(LibraryStatusEvent evt) {
        if (evt.getType() == LibraryStatusEvent.Type.LOAD_COMPLETE) {
            this.tryToDownloadUpdates();
        }
    }

    @Override
    public UpdateCollection getUpdateCollection() {
        return this.updateCollection;
    }

    private void fireUpdate(UpdateInformation update2) {
        this.listeners.broadcast(new UpdateEvent(update2, UpdateEvent.Type.UPDATE));
    }

    @Override
    public void addListener(EventListener<UpdateEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<UpdateEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    @Override
    public int getKeyVersion() {
        return this.certificateProvider.get().getKeyVersion();
    }

    @Override
    public byte[] getOldUpdateResponse() {
        return this.updateDataProvider.getDisabledKeysSignedMessageData();
    }

    @Override
    public int getNewVersion() {
        return this.newVersion;
    }

    @Override
    public boolean shouldRequestUpdateMessage(int version, int newVersion, int keyVersion) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("version {0}, new version {1}, key version {2}", (Object)version, (Object)newVersion, (Object)keyVersion);
        }
        if (newVersion != -1 ? newVersion > this.getNewVersion() && keyVersion == this.getKeyVersion() : version > this.getLatestId()) {
            return true;
        }
        return this.getKeyVersion() > 3 && keyVersion > this.getKeyVersion();
    }

    private static class HttpRequestControl {
        private final AtomicBoolean requestQueued = new AtomicBoolean(false);
        private final AtomicBoolean requestActive = new AtomicBoolean(false);
        private volatile RequestReason requestReason;

        private HttpRequestControl() {
        }

        boolean isRequestPending() {
            return this.requestActive.get() || this.requestQueued.get();
        }

        boolean requestQueued(RequestReason reason) {
            boolean prior = this.requestQueued.getAndSet(true);
            if (!prior || reason == RequestReason.MAX) {
                this.requestReason = reason;
            }
            return prior || this.requestActive.get();
        }

        void requestActive() {
            this.requestActive.set(true);
            this.requestQueued.set(false);
        }

        RequestReason getRequestReason() {
            return this.requestReason;
        }

        void cancelRequest() {
            this.requestQueued.set(false);
        }

        void requestFinished() {
            this.requestActive.set(false);
        }

        private static enum RequestReason {
            TIMEOUT,
            MAX;

        }
    }

    class RequestHandlerDataRunnable
    implements Runnable {
        private final byte[] data;

        public RequestHandlerDataRunnable(byte[] data) {
            this.data = data;
        }

        @Override
        public void run() {
            UpdateHandlerImpl.this.httpRequestControl.requestFinished();
            LOG.trace("Parsing new data...");
            UpdateHandlerImpl.this.handleDataInternal(this.data, CertifiedMessageSourceType.FROM_HTTP, null);
        }
    }

    private class RequestHandler
    implements HttpClientListener {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            byte[] inflated;
            LOG.debug("http request method succeeded");
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(UpdateHandlerImpl.this.clock.now());
            try {
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
                    throw new IOException("bad code " + response.getStatusLine().getStatusCode());
                }
                byte[] resp = null;
                if (response.getEntity() != null) {
                    resp = IOUtils.readFully(response.getEntity().getContent());
                }
                if (resp == null || resp.length == 0) {
                    throw new IOException("bad body");
                }
                inflated = UpdateHandlerImpl.this.updateMessageVerifier.inflateNetworkData(resp);
            }
            catch (IOException failed) {
                UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                LOG.warn("couldn't fetch data ", failed);
                boolean bl = false;
                return bl;
            }
            finally {
                ((HttpExecutor)UpdateHandlerImpl.this.httpExecutor.get()).releaseResources(response);
            }
            UpdateHandlerImpl.this.backgroundExecutor.execute(new RequestHandlerDataRunnable(inflated));
            return false;
        }

        @Override
        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
            LOG.warn("http failover failed", exc);
            UpdateHandlerImpl.this.httpRequestControl.requestFinished();
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(UpdateHandlerImpl.this.clock.now());
            ((HttpExecutor)UpdateHandlerImpl.this.httpExecutor.get()).releaseResources(response);
            return false;
        }

        @Override
        public boolean allowRequest(HttpUriRequest request) {
            return true;
        }
    }

    private class NotificationFailover
    implements Runnable {
        private final int id;
        private boolean shown;

        NotificationFailover(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            if (this.shown) {
                return;
            }
            this.shown = true;
            UpdateHandlerImpl.this.notifyAboutInfo(this.id);
        }
    }

    private class Poller
    implements Runnable {
        private Poller() {
        }

        @Override
        public void run() {
            UpdateHandlerImpl.this.downloadUpdates(UpdateHandlerImpl.this._updatesToDownload, null);
            UpdateHandlerImpl.this.killHopelessUpdates(UpdateHandlerImpl.this._updatesToDownload);
        }
    }

    class HttpMaxFailOverRunnable
    implements Runnable {
        HttpMaxFailOverRunnable() {
        }

        @Override
        public void run() {
            String url = (String)UpdateHandlerImpl.this.maxedUpdateList.get(RANDOM.nextInt(UpdateHandlerImpl.this.maxedUpdateList.size()));
            try {
                UpdateHandlerImpl.this.launchHTTPUpdate(url);
            }
            catch (URISyntaxException e) {
                UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                UpdateHandlerImpl.this.httpRequestControl.cancelRequest();
                LOG.warn(e.toString(), e);
            }
        }
    }

    class StaleHttpUpdateRunnable
    implements Runnable {
        StaleHttpUpdateRunnable() {
        }

        @Override
        public void run() {
            try {
                UpdateHandlerImpl.this.launchHTTPUpdate(UpdateHandlerImpl.this.timeoutUpdateLocation);
            }
            catch (URISyntaxException e) {
                UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                UpdateHandlerImpl.this.httpRequestControl.cancelRequest();
                LOG.warn(e.toString(), e);
            }
        }
    }

    class NetworkDataRunnable
    implements Runnable {
        private final byte[] data;
        private final ReplyHandler handler;

        public NetworkDataRunnable(byte[] data, ReplyHandler handler) {
            this.data = data;
            this.handler = handler;
        }

        @Override
        public void run() {
            LOG.trace("Parsing new data...");
            UpdateHandlerImpl.this.handleDataInternal(this.data, CertifiedMessageSourceType.FROM_NETWORK, this.handler);
        }
    }
}

