/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.uploader.HttpException;
import com.limegroup.gnutella.uploader.authentication.HttpRequestFileViewProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.http.protocol.HttpContext;
import org.limewire.util.StringUtils;

class FileRequestParser {
    FileRequestParser() {
    }

    public static FileRequest parseRequest(HttpRequestFileViewProvider fileListProvider, String uri, HttpContext context) throws IOException, HttpException {
        FileView fileList;
        RequestType requestType;
        int index = uri.toLowerCase(Locale.US).indexOf("/uri-res/");
        if (index == -1) {
            throw new IOException("invalid request");
        }
        String uriRes = uri.substring(index);
        URN urn = URN.createSHA1UrnFromHttpRequest(uriRes + " HTTP/1.1");
        String requestUpper = uriRes.toUpperCase(Locale.US);
        if (requestUpper.indexOf("N2X?") > 0) {
            requestType = RequestType.THEX;
        } else if (requestUpper.indexOf("N2R?") > 0) {
            requestType = RequestType.FILE;
        } else {
            return null;
        }
        FileDesc desc = null;
        String friendID = index == 0 ? null : FileRequestParser.parseFriendId(uri.substring(0, index));
        Iterator<FileView> i$ = fileListProvider.getFileViews(friendID, context).iterator();
        while (i$.hasNext() && (desc = (fileList = i$.next()).getFileDesc(urn)) == null) {
        }
        if (desc == null) {
            return null;
        }
        return new FileRequest(desc, requestType, friendID);
    }

    static String parseFriendId(String uriString) throws HttpException {
        try {
            URI uri = new URI(uriString);
            String path = uri.getPath();
            if (path == null) {
                throw new HttpException("no friend id:", 400);
            }
            if (path.endsWith("/")) {
                int previousSlash = path.lastIndexOf(47, path.length() - 2);
                if (previousSlash != -1) {
                    return path.substring(previousSlash + 1, path.length() - 1);
                }
            } else {
                int lastSlash = path.lastIndexOf(47);
                if (lastSlash != -1) {
                    return path.substring(lastSlash + 1);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        throw new HttpException("no friend id:", 400);
    }

    static class FileRequest {
        private final FileDesc fileDesc;
        private final String friendID;
        private final RequestType requestType;

        public FileRequest(FileDesc fileDesc, RequestType requestType, String friendID) {
            this.fileDesc = fileDesc;
            this.requestType = requestType;
            this.friendID = friendID;
        }

        public boolean isThexRequest() {
            return this.requestType == RequestType.THEX;
        }

        public FileDesc getFileDesc() {
            return this.fileDesc;
        }

        public String getFriendID() {
            return this.friendID;
        }

        public String toString() {
            return StringUtils.toString(this, new Object[0]);
        }
    }

    static enum RequestType {
        FILE,
        THEX;

    }
}

