/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.security.Certificate;
import com.limegroup.gnutella.security.CertificateProvider;
import com.limegroup.gnutella.security.CertificateVerifier;
import com.limegroup.gnutella.security.CertifiedMessageVerifier;
import java.security.SignatureException;
import org.limewire.io.IpPort;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.security.SignatureVerifier;

public class CertifiedMessageVerifierImpl
implements CertifiedMessageVerifier {
    private static final Log LOG = LogFactory.getLog(CertifiedMessageVerifierImpl.class);
    private final CertificateProvider certificateProvider;
    private final CertificateVerifier certificateVerifier;

    public CertifiedMessageVerifierImpl(CertificateProvider certificateProvider, CertificateVerifier certificateVerifier) {
        this.certificateProvider = certificateProvider;
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public Certificate verify(CertifiedMessageVerifier.CertifiedMessage message, IpPort messageSource) throws SignatureException {
        LOG.debugf("verifying message {0} from {1}", (Object)message, (Object)messageSource);
        Certificate certificate = message.getCertificate();
        if (certificate != null) {
            if (certificate.getKeyVersion() != message.getKeyVersion()) {
                throw new SignatureException("certificate key version and message key version don't match");
            }
            certificate = this.certificateVerifier.verify(certificate);
        } else {
            certificate = this.certificateProvider.get(message.getKeyVersion(), messageSource);
            if (certificate.getKeyVersion() != message.getKeyVersion()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("message key version {0} different from available key version {1}", (Object)message.getKeyVersion(), (Object)certificate.getKeyVersion());
                }
                throw new SignatureException("key version not equal to certificate version");
            }
        }
        SignatureVerifier signatureVerifier = new SignatureVerifier(message.getSignedPayload(), message.getSignature(), certificate.getPublicKey(), "DSA");
        if (!signatureVerifier.verifySignature()) {
            throw new SignatureException("Invalid signature for: " + message);
        }
        return certificate;
    }
}

