/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.search.ProbeQuery;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.ResultCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.io.GUID;

final class QueryHandlerImpl
implements Inspectable,
QueryHandler {
    private static final Log LOG = LogFactory.getLog(QueryHandlerImpl.class);
    private static final byte MAX_QUERY_TTL = 6;
    private static final int HASH_QUERY_RESULTS = 10;
    private static final int MAXIMUM_ROUTED_FOR_LEAVES = 75;
    private final int RESULTS;
    private volatile long _timeToWaitPerHop = 2400L;
    private volatile long _timeToDecreasePerHop = 10L;
    private volatile int _numDecrements = 0;
    private final List<Long> times = new ArrayList<Long>();
    private final List<Integer> results = new ArrayList<Integer>();
    private volatile int _numResultsReportedByLeaf = 0;
    private volatile long _nextQueryTime = 0L;
    private volatile int _theoreticalHostsQueried = 1;
    private final ResultCounter RESULT_COUNTER;
    private final List<RoutedConnection> QUERIED_CONNECTIONS = new ArrayList<RoutedConnection>();
    private final List<RoutedConnection> QUERIED_PROBE_CONNECTIONS = new ArrayList<RoutedConnection>();
    private volatile long _queryStartTime = 0L;
    private volatile long _curTime = 0L;
    private final ReplyHandler REPLY_HANDLER;
    private final QueryRequest QUERY;
    private volatile boolean _forwardedToLeaves = false;
    private boolean _probeQuerySent;
    private final String _prefLocale;
    private final QueryRequestFactory queryRequestFactory;
    private final ConnectionManager connectionManager;
    private final MessageRouter messageRouter;

    QueryHandlerImpl(QueryRequest query, int results, ReplyHandler handler, ResultCounter counter, QueryRequestFactory queryRequestFactory, ConnectionManager connectionManager, MessageRouter messageRouter) {
        this.connectionManager = connectionManager;
        this.messageRouter = messageRouter;
        if (query == null) {
            throw new IllegalArgumentException("null query");
        }
        if (handler == null) {
            throw new IllegalArgumentException("null reply handler");
        }
        if (counter == null) {
            throw new IllegalArgumentException("null result counter");
        }
        this.queryRequestFactory = queryRequestFactory;
        boolean isHashQuery = !query.getQueryUrns().isEmpty();
        this.QUERY = query;
        this.RESULTS = isHashQuery ? 10 : results;
        this.REPLY_HANDLER = handler;
        this.RESULT_COUNTER = counter;
        this._prefLocale = handler.getLocalePref();
    }

    List<RoutedConnection> getQueriedConnections() {
        return this.QUERIED_CONNECTIONS;
    }

    private QueryRequest createQuery(QueryRequest query, byte ttl) {
        if (ttl < 1 || ttl > 6) {
            throw new IllegalArgumentException("ttl too high: " + ttl);
        }
        if (query == null) {
            throw new NullPointerException("null query");
        }
        return this.queryRequestFactory.createQuery(query, ttl);
    }

    @Override
    public QueryRequest getTemplateQueryRequest() {
        return this.QUERY;
    }

    @Override
    public QueryRequest createQuery(byte ttl) {
        return this.createQuery(this.QUERY, ttl);
    }

    @Override
    public void sendQuery() {
        if (this.hasEnoughResults()) {
            return;
        }
        this._curTime = System.currentTimeMillis();
        if (this._curTime < this._nextQueryTime) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Query = " + this.QUERY.getQuery() + ", numHostsQueried: " + this._theoreticalHostsQueried);
        }
        if (this._queryStartTime == 0L) {
            this._queryStartTime = this._curTime;
        }
        if (!this._forwardedToLeaves) {
            this._forwardedToLeaves = true;
            QueryRouteTable qrt = this.messageRouter.getQueryRouteTable();
            QueryRequest query = this.createQuery(this.QUERY, (byte)1);
            this._theoreticalHostsQueried += 25;
            if (qrt != null && qrt.contains(query)) {
                this.messageRouter.forwardQueryRequestToLeaves(query, this.REPLY_HANDLER);
                this._nextQueryTime = System.currentTimeMillis() + this._timeToWaitPerHop;
                return;
            }
        }
        if (!this._probeQuerySent) {
            ProbeQuery pq = new ProbeQuery(this.connectionManager.getInitializedConnections(), this);
            long timeToWait = pq.getTimeToWait();
            this._theoreticalHostsQueried += pq.sendProbe();
            this._nextQueryTime = System.currentTimeMillis() + timeToWait;
            this._probeQuerySent = true;
            return;
        }
        int newHosts = this.sendQuery(new ArrayList<RoutedConnection>(this.connectionManager.getInitializedConnections()));
        if (newHosts == 0) {
            this._nextQueryTime = System.currentTimeMillis() + 6000L;
        }
        this._theoreticalHostsQueried += newHosts;
        if (this._timeToWaitPerHop > 100L && System.currentTimeMillis() - this._queryStartTime > 6000L) {
            this._timeToWaitPerHop -= this._timeToDecreasePerHop;
            int resultFactor = Math.max(1, this.RESULTS / 2 - 30 * this.RESULT_COUNTER.getNumResults());
            int decrementFactor = Math.max(1, this._numDecrements / 6);
            int currentDecrease = resultFactor * decrementFactor;
            currentDecrease = Math.max(5, currentDecrease);
            this._timeToDecreasePerHop += (long)currentDecrease;
            ++this._numDecrements;
            if (this._timeToWaitPerHop < 100L) {
                this._timeToWaitPerHop = 100L;
            }
        }
    }

    int sendQuery(List<? extends RoutedConnection> ultrapeersAll) {
        int hostsToQueryPerConnection;
        int reported;
        int remainingConnections;
        List<RoutedConnection> ultrapeers = this.connectionManager.getInitializedConnectionsMatchLocale(this._prefLocale);
        this.QUERIED_CONNECTIONS.retainAll(ultrapeersAll);
        this.QUERIED_PROBE_CONNECTIONS.retainAll(ultrapeersAll);
        if (!ultrapeers.isEmpty()) {
            ultrapeers.removeAll(this.QUERIED_CONNECTIONS);
            ultrapeers.removeAll(this.QUERIED_PROBE_CONNECTIONS);
        }
        if (ultrapeers.isEmpty()) {
            ultrapeers = ultrapeersAll;
            ultrapeers.removeAll(this.QUERIED_CONNECTIONS);
            ultrapeers.removeAll(this.QUERIED_PROBE_CONNECTIONS);
        }
        int length = ultrapeers.size();
        if (LOG.isTraceEnabled()) {
            LOG.trace("potential querier size: " + length);
        }
        int ttl = 0;
        RoutedConnection mc = null;
        Collections.shuffle(ultrapeers);
        for (int i = 0; i < length; ++i) {
            RoutedConnection curConnection = ultrapeers.get(i);
            if (!curConnection.isStable(this._curTime)) continue;
            mc = curConnection;
            break;
        }
        if ((remainingConnections = Math.max(length + this.QUERIED_PROBE_CONNECTIONS.size(), 0)) == 0) {
            return 0;
        }
        if (remainingConnections > 4) {
            remainingConnections -= 4;
        }
        boolean probeConnection = false;
        if (mc == null) {
            if (this.QUERIED_PROBE_CONNECTIONS.isEmpty()) {
                return 0;
            }
            mc = this.QUERIED_PROBE_CONNECTIONS.remove(0);
            probeConnection = true;
        }
        if ((reported = this._numResultsReportedByLeaf) <= 0) {
            reported = this.RESULT_COUNTER.getNumResults();
        }
        double resultsPerHost = (double)reported / (double)this._theoreticalHostsQueried;
        int resultsNeeded = this.RESULTS - reported;
        int hostsToQuery = 40000;
        if (resultsPerHost != 0.0) {
            hostsToQuery = (int)((double)resultsNeeded / resultsPerHost);
        }
        if ((ttl = QueryHandlerImpl.calculateNewTTL(hostsToQueryPerConnection = hostsToQuery / remainingConnections, mc.getConnectionCapabilities().getNumIntraUltrapeerConnections(), mc.getConnectionCapabilities().getHeadersRead().getMaxTTL())) == 1 && (mc.isUltrapeerQueryRoutingConnection() && !mc.shouldForwardQuery(this.QUERY) || probeConnection)) {
            ttl = 2;
        }
        QueryRequest query = this.createQuery(this.QUERY, (byte)ttl);
        return this.sendQueryToHost(query, mc);
    }

    @Override
    public int sendQueryToHost(QueryRequest query, RoutedConnection mc) {
        if (!this.messageRouter.sendInitialQuery(query, mc)) {
            return 0;
        }
        byte ttl = query.getTTL();
        if (ttl == 1 && mc.getConnectionCapabilities().supportsProbeQueries()) {
            this.QUERIED_PROBE_CONNECTIONS.add(mc);
        } else {
            this.QUERIED_CONNECTIONS.add(mc);
            if (LOG.isTraceEnabled()) {
                LOG.trace("QUERIED_CONNECTIONS.size() = " + this.QUERIED_CONNECTIONS.size());
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Querying host " + mc.getAddress() + " with ttl " + query.getTTL());
        }
        this._nextQueryTime = System.currentTimeMillis() + (long)ttl * this._timeToWaitPerHop;
        return QueryHandlerImpl.calculateNewHosts(mc, ttl);
    }

    static byte calculateNewTTL(int hostsToQueryPerConnection, int degree, byte maxTTL) {
        if (maxTTL > 6) {
            maxTTL = (byte)6;
        }
        for (byte i = 1; i < 6; i = (byte)(i + 1)) {
            int hosts = (int)(16.0 * (double)QueryHandlerImpl.calculateNewHosts(degree, i));
            if (hosts < hostsToQueryPerConnection) continue;
            if (i > maxTTL) {
                return maxTTL;
            }
            return i;
        }
        return maxTTL;
    }

    static int calculateNewHosts(RoutedConnection conn, byte ttl) {
        return QueryHandlerImpl.calculateNewHosts(conn.getConnectionCapabilities().getNumIntraUltrapeerConnections(), ttl);
    }

    static int calculateNewHosts(int degree, byte ttl) {
        double newHosts = 0.0;
        while (ttl > 0) {
            newHosts += Math.pow(degree - 1, ttl - 1);
            ttl = (byte)(ttl - 1);
        }
        return (int)newHosts;
    }

    @Override
    public boolean hasEnoughResults() {
        if (this._queryStartTime == 0L) {
            return false;
        }
        if (this._numResultsReportedByLeaf > 0) {
            if (this.RESULT_COUNTER.getNumResults() >= 75) {
                return true;
            }
            if (this._numResultsReportedByLeaf > this.RESULTS) {
                return true;
            }
        } else if (this.RESULT_COUNTER.getNumResults() >= this.RESULTS) {
            return true;
        }
        if (this._theoreticalHostsQueried > 110000) {
            return true;
        }
        int queryLength = (int)(System.currentTimeMillis() - this._queryStartTime);
        return queryLength > 200000;
    }

    @Override
    public void updateLeafResults(int numResults) {
        if (numResults > this._numResultsReportedByLeaf) {
            if (this.times.size() < 20) {
                this.times.add(System.currentTimeMillis() - this._queryStartTime);
                this.results.add(numResults);
            }
            this._numResultsReportedByLeaf = numResults;
        }
    }

    @Override
    public int getNumResultsReportedByLeaf() {
        return this._numResultsReportedByLeaf;
    }

    @Override
    public ReplyHandler getReplyHandler() {
        return this.REPLY_HANDLER;
    }

    @Override
    public long getTimeToWaitPerHop() {
        return this._timeToWaitPerHop;
    }

    public String toString() {
        return "QueryHandler: QUERY: " + this.QUERY;
    }

    @Override
    public GUID getGUID() {
        return new GUID(this.QUERY.getGUID());
    }

    @Override
    public Object inspect() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("ver", 1);
        ret.put("guid", this.QUERY.getGUID());
        ret.put("times", this.times);
        ret.put("res", this.results);
        ret.put("twh", this._timeToWaitPerHop);
        ret.put("tdh", this._timeToDecreasePerHop);
        ret.put("dec", this._numDecrements);
        ret.put("nqt", this._nextQueryTime);
        ret.put("qst", this._queryStartTime);
        ret.put("ct", this._curTime);
        ret.put("pqs", this._probeQuerySent);
        ret.put("ftw", this._forwardedToLeaves);
        ret.put("the", this._theoreticalHostsQueried);
        ret.put("rpl", this._numResultsReportedByLeaf);
        ret.put("RES", this.RESULTS);
        if (this.RESULT_COUNTER != null) {
            ret.put("rc", this.RESULT_COUNTER.getNumResults());
        }
        ret.put("rh", this.REPLY_HANDLER.getAddress());
        ArrayList<String> probes = new ArrayList<String>(this.QUERIED_PROBE_CONNECTIONS.size());
        for (RoutedConnection rc : this.QUERIED_PROBE_CONNECTIONS) {
            probes.add(rc.getAddress());
        }
        ret.put("probes", probes);
        ArrayList<String> queried = new ArrayList<String>(this.QUERIED_CONNECTIONS.size());
        for (RoutedConnection rc : this.QUERIED_CONNECTIONS) {
            queried.add(rc.getAddress());
        }
        ret.put("queried", queried);
        return ret;
    }
}

