/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.BadCCLicense;
import com.limegroup.gnutella.licenses.CCLicense;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.licenses.MutableLicense;
import com.limegroup.gnutella.licenses.UnknownLicense;
import com.limegroup.gnutella.licenses.WeedLicense;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.URIUtils;

@Singleton
public final class LicenseFactoryImpl
implements LicenseFactory {
    private static final Log LOG = LogFactory.getLog(LicenseFactoryImpl.class);
    private final Provider<LicenseCache> licenseCache;

    @Inject
    public LicenseFactoryImpl(Provider<LicenseCache> licenseCache) {
        this.licenseCache = licenseCache;
    }

    @Override
    public boolean isVerifiedAndValid(URN urn, String licenseString) {
        URI uri = LicenseFactoryImpl.getLicenseURI(licenseString);
        return uri != null && this.licenseCache.get().isVerifiedAndValid(urn, uri);
    }

    @Override
    public String getLicenseName(String licenseString) {
        if (LicenseFactoryImpl.isCCLicense(licenseString)) {
            return "Creative Commons License";
        }
        if (LicenseFactoryImpl.isWeedLicense(licenseString)) {
            return "Weed License";
        }
        if (LicenseFactoryImpl.isUnknownLicense(licenseString)) {
            return "Unknown License";
        }
        return null;
    }

    @Override
    public License create(String licenseString) {
        if (licenseString == null) {
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to create license from: " + licenseString);
        }
        License license = null;
        URI uri = LicenseFactoryImpl.getLicenseURI(licenseString);
        if (uri != null) {
            license = this.licenseCache.get().getLicense(licenseString, uri);
        }
        if (license == null) {
            if (LicenseFactoryImpl.isCCLicense(licenseString)) {
                license = uri != null ? new CCLicense(licenseString, uri) : new BadCCLicense(licenseString);
            } else if (LicenseFactoryImpl.isWeedLicense(licenseString) && uri != null) {
                license = new WeedLicense(uri);
            } else if (LicenseFactoryImpl.isUnknownLicense(licenseString)) {
                license = new UnknownLicense();
            }
        }
        if (license instanceof MutableLicense) {
            ((MutableLicense)license).setLicenseName(this.getLicenseName(licenseString));
        }
        return license;
    }

    private static boolean isCCLicense(String s) {
        return s.toLowerCase(Locale.US).indexOf("verify at") != -1;
    }

    private static boolean isWeedLicense(String s) {
        return s.startsWith("http://www.shmedlic.com/license/3play.aspx");
    }

    private static boolean isUnknownLicense(String s) {
        return s.startsWith("licensed: ");
    }

    @Override
    public void persistCache() {
        this.licenseCache.get().persistCache();
    }

    static URI getLicenseURI(String license) {
        if (license == null) {
            return null;
        }
        URI uri = LicenseFactoryImpl.getCCLicenseURI(license);
        if (uri == null) {
            uri = LicenseFactoryImpl.getWeedLicenseURI(license);
        }
        return uri;
    }

    private static URI getCCLicenseURI(String license) {
        int verifyAt = (license = license.toLowerCase(Locale.US)).indexOf("verify at");
        if (verifyAt == -1) {
            return null;
        }
        int urlStart = verifyAt + "verify at".length();
        if (urlStart >= license.length()) {
            return null;
        }
        String url = license.substring(urlStart).trim();
        url = url.split(" ")[0];
        URI uri = null;
        try {
            uri = URIUtils.toURI(url);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http")) {
                throw new URISyntaxException(uri.toString(), "Invalid scheme: " + scheme);
            }
            String authority = uri.getAuthority();
            if (authority == null || authority.equals("") || authority.indexOf(32) != -1) {
                throw new URISyntaxException(uri.toString(), "Invalid authority: " + authority);
            }
        }
        catch (URISyntaxException e) {
            uri = null;
            LOG.error("Unable to create URI", e);
        }
        return uri;
    }

    private static URI getWeedLicenseURI(String license) {
        int lainfo = license.indexOf("http://www.shmedlic.com/license/3play.aspx");
        if (lainfo == -1) {
            return null;
        }
        int cidx = license.indexOf(" cid: ");
        int vidx = license.indexOf(" vid: ");
        if (cidx == -1 || vidx == -1) {
            LOG.debug("No cid or vid, bailing.");
            return null;
        }
        int cend = license.indexOf(" ", cidx += " cid: ".length());
        int vend = license.indexOf(" ", vidx += " vid: ".length());
        if (cend == -1 && vend == -1) {
            LOG.debug("No endings for both cid & vid, bailing");
            return null;
        }
        if (cend == -1) {
            cend = license.length();
        }
        if (vend == -1) {
            vend = license.length();
        }
        String cid = license.substring(cidx, cend).trim();
        String vid = license.substring(vidx, vend).trim();
        if (cid.length() == 0 || vid.length() == 0) {
            LOG.debug("cid or vid is empty, bailing");
            return null;
        }
        if (cid.startsWith(" vid: ".trim()) || vid.startsWith(" cid: ".trim())) {
            LOG.debug("cid starts with vid, or vice versa, bailing.");
            return null;
        }
        return WeedLicense.buildURI(cid, vid);
    }
}

