/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.License;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.CommonUtils;
import org.limewire.util.GenericsUtils;

@Singleton
public class LicenseCache {
    private static final Log LOG = LogFactory.getLog(LicenseCache.class);
    private static final long EXPIRY_TIME = 604800000L;
    private final File CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "licenses.cache");
    private Map<URI, License> licenses;
    private Map<Object, Object> data;
    private boolean dirty = false;

    LicenseCache() {
        this.deserialize();
    }

    synchronized void addVerifiedLicense(License license) {
        this.licenses.put(license.getLicenseURI(), license);
        this.dirty = true;
    }

    synchronized void addData(Object key, Object value) {
        this.data.put(key, value);
        this.dirty = true;
    }

    synchronized License getLicense(String licenseString, URI licenseURI) {
        License license = this.licenses.get(licenseURI);
        if (license != null) {
            return license.copy(licenseString, licenseURI);
        }
        return null;
    }

    synchronized Object getData(Object key) {
        return this.data.get(key);
    }

    synchronized boolean isVerifiedAndValid(URN urn, URI uri) {
        License license = this.licenses.get(uri);
        return license != null && license.isValid(urn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserialize() {
        block15: {
            ObjectInputStream ois;
            block14: {
                ois = null;
                if (this.CACHE_FILE.exists()) break block14;
                IOUtils.close(ois);
                if (this.licenses == null) {
                    this.licenses = new HashMap<URI, License>();
                }
                if (this.data == null) {
                    this.data = new HashMap<Object, Object>();
                }
                return;
            }
            try {
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.CACHE_FILE)));
                Object o = ois.readObject();
                if (o != null) {
                    this.licenses = GenericsUtils.scanForMap(o, URI.class, License.class, GenericsUtils.ScanMode.REMOVE);
                }
                if ((o = ois.readObject()) != null) {
                    this.data = GenericsUtils.scanForMap(o, Object.class, Object.class, GenericsUtils.ScanMode.REMOVE);
                }
                this.removeOldEntries();
            }
            catch (Throwable t) {
                try {
                    LOG.error("Can't read licenses", t);
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.close(ois);
                    if (this.licenses == null) {
                        this.licenses = new HashMap<URI, License>();
                    }
                    if (this.data == null) {
                        this.data = new HashMap<Object, Object>();
                    }
                }
            }
            IOUtils.close(ois);
            if (this.licenses == null) {
                this.licenses = new HashMap<URI, License>();
            }
            if (this.data == null) {
                this.data = new HashMap<Object, Object>();
            }
        }
    }

    private void removeOldEntries() {
        long cutoff = System.currentTimeMillis() - 604800000L;
        Iterator<License> i = this.licenses.values().iterator();
        while (i.hasNext()) {
            License license = i.next();
            if (license.getLastVerifiedTime() >= cutoff) continue;
            this.dirty = true;
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistCache() {
        if (!this.dirty) {
            return;
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CACHE_FILE)));
            oos.writeObject(this.licenses);
            oos.writeObject(this.data);
            oos.flush();
            IOUtils.close(oos);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
        finally {
            IOUtils.close(oos);
        }
        this.dirty = false;
    }
}

