/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.library.FileCollectionManagerImpl;
import com.limegroup.gnutella.library.FileManager;
import com.limegroup.gnutella.library.LibraryConverter;
import com.limegroup.gnutella.library.LibraryFileData;
import com.limegroup.gnutella.library.LibraryImpl;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;

@EagerSingleton
class FileManagerImpl
implements FileManager,
Service {
    private final LibraryImpl library;
    private Saver saver;
    private volatile boolean shutdown;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<LibraryFileData> fileData;
    private final Provider<LibraryConverter> libraryConverter;
    private final FileCollectionManagerImpl fileCollectionManagerImpl;

    @Inject
    public FileManagerImpl(LibraryImpl managedFileList, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<LibraryFileData> libraryFileData, Provider<LibraryConverter> libraryConverter, FileCollectionManagerImpl collectionManager) {
        this.backgroundExecutor = backgroundExecutor;
        this.library = managedFileList;
        this.fileData = libraryFileData;
        this.fileCollectionManagerImpl = collectionManager;
        this.libraryConverter = libraryConverter;
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Shared Files");
    }

    @Override
    public void initialize() {
        this.library.initialize();
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        LibraryConverter converter = this.libraryConverter.get();
        if (converter.isOutOfDate()) {
            this.library.fireLoading();
            converter.convert(this.fileData.get());
        }
        this.fileCollectionManagerImpl.loadStoredCollections();
        this.library.loadManagedFiles();
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            if (this.saver == null) {
                this.saver = new Saver();
                this.backgroundExecutor.scheduleWithFixedDelay(this.saver, 1L, 1L, TimeUnit.MINUTES);
            }
        }
    }

    @Override
    public void stop() {
        this.library.save();
        this.shutdown = true;
    }

    private class Saver
    implements Runnable {
        private Saver() {
        }

        @Override
        public void run() {
            if (!FileManagerImpl.this.shutdown && FileManagerImpl.this.library.isLoadFinished()) {
                FileManagerImpl.this.library.save();
            }
        }
    }
}

