/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import java.io.IOException;

public final class NoGnutellaOkException
extends IOException {
    private final boolean wasMe;
    private final int code;
    private static final String FATAL_SERVER_MSG = "Server sent fatal response: ";
    private static final String FATAL_CLIENT_MSG = "We sent fatal response: ";
    public static final NoGnutellaOkException SERVER_REJECT = new NoGnutellaOkException(false, 503, "Server sent fatal response: 503");
    public static final NoGnutellaOkException CLIENT_REJECT = new NoGnutellaOkException(false, 503, "We sent fatal response: 503");
    public static final NoGnutellaOkException CLIENT_REJECT_LOCALE = new NoGnutellaOkException(false, 577, "We sent fatal response: 577");
    public static final NoGnutellaOkException UNRESOLVED_CLIENT = new NoGnutellaOkException(true, "Too much handshaking, no conclusion");
    public static final NoGnutellaOkException UNRESOLVED_SERVER = new NoGnutellaOkException(false, "Too much handshaking, no conclusion");

    public static NoGnutellaOkException createClientUnknown(int code) {
        return new NoGnutellaOkException(true, code, FATAL_SERVER_MSG + code);
    }

    public static NoGnutellaOkException createServerUnknown(int code) {
        return new NoGnutellaOkException(false, code, FATAL_SERVER_MSG + code);
    }

    private NoGnutellaOkException(boolean wasMe, int code, String message) {
        super(message);
        this.wasMe = wasMe;
        this.code = code;
    }

    private NoGnutellaOkException(boolean wasMe, String message) {
        this(wasMe, -1, message);
    }

    public boolean wasMe() {
        return this.wasMe;
    }

    public int getCode() {
        return this.code;
    }
}

