/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.altlocs.AltLocListener;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.DirectDHTAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.downloader.AbstractCoreDownloader;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import com.limegroup.gnutella.downloader.DownloadWorker;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloadWorkerSupport;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.GnutellaPieceInfo;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescContext;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryListener;
import com.limegroup.gnutella.downloader.RequeryManager;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceDetails;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.GnutellaDownloadMemento;
import com.limegroup.gnutella.downloader.serial.GnutellaDownloadMementoImpl;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.UrnCache;
import com.limegroup.gnutella.malware.DangerousFileChecker;
import com.limegroup.gnutella.malware.VirusScanException;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.spam.SpamManager;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.activation.api.ActivationID;
import org.limewire.activation.api.ActivationManager;
import org.limewire.collection.ApproximateMatcher;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.collection.IntervalSet;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.core.api.Category;
import org.limewire.core.api.download.DownloadPiecesInfo;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.network.BandwidthCollector;
import org.limewire.core.api.transfer.SourceInfo;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.friend.impl.address.FriendAddress;
import org.limewire.io.Address;
import org.limewire.io.DiskException;
import org.limewire.io.GUID;
import org.limewire.io.IOUtils;
import org.limewire.io.InvalidDataException;
import org.limewire.io.PermanentAddress;
import org.limewire.listener.AsynchronousMulticasterImpl;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventMulticaster;
import org.limewire.net.ConnectivityChangeEvent;
import org.limewire.net.SocketsManager;
import org.limewire.service.ErrorService;
import org.limewire.util.FileUtils;

class ManagedDownloaderImpl
extends AbstractCoreDownloader
implements AltLocListener,
ManagedDownloader,
DownloadWorkerSupport {
    private static final Log LOG = LogFactory.getLog(ManagedDownloaderImpl.class);
    private Set<RemoteFileDesc> cachedRFDs;
    private final Set<RemoteFileDesc> permanentRFDs = new ConcurrentSkipListSet<RemoteFileDesc>(new Comparator<RemoteFileDesc>(){

        @Override
        public int compare(RemoteFileDesc o1, RemoteFileDesc o2) {
            return o1.hashCode() - o2.hashCode();
        }
    });
    private ConcurrentMap<RemoteFileDesc, RemoteFileDescContext> remoteFileDescToContext = new ConcurrentHashMap<RemoteFileDesc, RemoteFileDescContext>();
    private SourceRanker ranker;
    private static final int GUESS_WAIT_TIME = 5000;
    private static final int MATCHER_BUF_SIZE = 120;
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private volatile Thread dloaderManagerThread;
    private volatile boolean stopped;
    private volatile boolean paused;
    private volatile boolean invalidated;
    private volatile List<DownloadWorker> _activeWorkers;
    private List<DownloadWorker> _workers;
    private volatile Map<DownloadWorker, Integer> _queuedWorkers;
    private Set<RemoteFileDesc> currentRFDs;
    private volatile URN downloadSHA1;
    private Set<AlternateLocation> validAlts;
    private Set<RemoteFileDesc> invalidAlts;
    private Set<AlternateLocation> recentInvalidAlts;
    protected volatile VerifyingFile commonOutFile;
    private volatile PushList pushes;
    private Downloader.DownloadState state = Downloader.DownloadState.INITIALIZING;
    private long stateTime;
    private volatile File incompleteFile;
    private int queuePosition;
    private volatile long corruptFileBytes;
    private volatile File corruptFile;
    private volatile boolean discardUnscannedPreview;
    private Object altLock;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile GUID originalQueryGUID;
    private boolean triedLocatingSources;
    private volatile boolean receivedNewSources;
    private volatile int triedHosts;
    private long contentLength = -1L;
    private final EventMulticaster<DownloadStateEvent> listeners;
    protected final DownloadManager downloadManager;
    protected final FileCollection gnutellaFileCollection;
    protected final IncompleteFileManager incompleteFileManager;
    protected final DownloadCallback downloadCallback;
    protected final NetworkManager networkManager;
    protected final AlternateLocationFactory alternateLocationFactory;
    protected final RequeryManager requeryManager;
    protected final QueryRequestFactory queryRequestFactory;
    protected final OnDemandUnicaster onDemandUnicaster;
    protected final DownloadWorkerFactory downloadWorkerFactory;
    protected final AltLocManager altLocManager;
    protected final ContentManager contentManager;
    protected final SourceRankerFactory sourceRankerFactory;
    protected final UrnCache urnCache;
    protected final VerifyingFileFactory verifyingFileFactory;
    protected final DiskController diskController;
    protected final IPFilter ipFilter;
    protected final ScheduledExecutorService backgroundExecutor;
    protected final Provider<MessageRouter> messageRouter;
    protected final Provider<HashTreeCache> tigerTreeCache;
    protected final ApplicationServices applicationServices;
    protected final RemoteFileDescFactory remoteFileDescFactory;
    protected final Provider<PushList> pushListProvider;
    protected final DangerousFileChecker dangerousFileChecker;
    protected final VirusScanner virusScanner;
    protected final SpamManager spamManager;
    protected final Library library;
    protected final CategoryManager categoryManager;
    private final BandwidthCollector bandwidthCollector;
    private final ActivationManager activationManager;
    private final SocketsManager socketsManager;
    private final ConnectivityChangeEventHandler connectivityChangeEventHandler = new ConnectivityChangeEventHandler();
    private boolean isFriendDownload;
    private static boolean initDone = false;

    @Inject
    protected ManagedDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, @GnutellaFiles FileCollection gnutellaFileCollection, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter ipFilter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<HashTreeCache> tigerTreeCache, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> pushListProvider, SocketsManager socketsManager, @Named(value="downloadStateProcessingQueue") ListeningExecutorService downloadStateProcessingQueue, DangerousFileChecker dangerousFileChecker, VirusScanner virusScanner, SpamManager spamManager, Library library, CategoryManager categoryManager, BandwidthCollector bandwidthCollector, ActivationManager activationManager) {
        super(saveLocationManager, categoryManager);
        this.listeners = new AsynchronousMulticasterImpl<DownloadStateEvent>(downloadStateProcessingQueue);
        this.downloadManager = downloadManager;
        this.gnutellaFileCollection = gnutellaFileCollection;
        this.incompleteFileManager = incompleteFileManager;
        this.downloadCallback = downloadCallback;
        this.networkManager = networkManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.socketsManager = socketsManager;
        this.requeryManager = requeryManagerFactory.createRequeryManager(new RequeryListenerImpl());
        this.queryRequestFactory = queryRequestFactory;
        this.onDemandUnicaster = onDemandUnicaster;
        this.downloadWorkerFactory = downloadWorkerFactory;
        this.altLocManager = altLocManager;
        this.contentManager = contentManager;
        this.sourceRankerFactory = sourceRankerFactory;
        this.urnCache = urnCache;
        this.verifyingFileFactory = verifyingFileFactory;
        this.diskController = diskController;
        this.ipFilter = ipFilter;
        this.backgroundExecutor = backgroundExecutor;
        this.messageRouter = messageRouter;
        this.tigerTreeCache = tigerTreeCache;
        this.applicationServices = applicationServices;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.cachedRFDs = new HashSet<RemoteFileDesc>();
        this.pushListProvider = pushListProvider;
        this.dangerousFileChecker = dangerousFileChecker;
        this.virusScanner = virusScanner;
        this.spamManager = spamManager;
        this.library = library;
        this.categoryManager = categoryManager;
        this.bandwidthCollector = bandwidthCollector;
        this.activationManager = activationManager;
    }

    @Override
    public synchronized void addInitialSources(Collection<RemoteFileDesc> rfds, String defaultFileName) {
        if (rfds == null) {
            LOG.debug("rfds are null");
            rfds = Collections.emptyList();
        }
        this.cachedRFDs.addAll(rfds);
        for (RemoteFileDesc rfd : rfds) {
            if (!(rfd.getAddress() instanceof PermanentAddress)) continue;
            this.permanentRFDs.add(rfd);
        }
        this.isFriendDownload = this.isFriendDownload(rfds);
        if (rfds.size() > 0) {
            RemoteFileDesc initialRfd = rfds.iterator().next();
            this.initPropertiesMap(initialRfd);
            this.setAttribute("LimeXMLDocument", initialRfd.getXMLDocument(), false);
        }
        assert (rfds.size() > 0 || defaultFileName != null);
        if (!this.hasDefaultFileName()) {
            this.setDefaultFileName(defaultFileName);
        }
    }

    private boolean isFriendDownload(Collection<RemoteFileDesc> rfds) {
        for (RemoteFileDesc rfd : rfds) {
            if (rfd.getAddress() instanceof FriendAddress) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setQueryGuid(GUID queryGuid) {
        this.originalQueryGUID = queryGuid;
    }

    protected synchronized void initPropertiesMap(RemoteFileDesc rfd) {
        if (!this.hasDefaultFileName()) {
            this.setDefaultFileName(rfd.getFileName());
        }
        if (this.getContentLength() == -1L) {
            this.setContentLength(rfd.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        this.setState(Downloader.DownloadState.INITIALIZING);
        Object object = this;
        synchronized (object) {
            this.currentRFDs = new HashSet<RemoteFileDesc>();
            this._activeWorkers = new LinkedList<DownloadWorker>();
            this._workers = new ArrayList<DownloadWorker>();
            this._queuedWorkers = new HashMap<DownloadWorker, Integer>();
            this.stopped = false;
            this.paused = false;
            this.pushes = this.pushListProvider.get();
            this.discardUnscannedPreview = true;
            this.altLock = new Object();
            this.numMeasures = 0;
            this.averageBandwidth = 0.0f;
            this.queuePosition = Integer.MAX_VALUE;
            this.triedLocatingSources = false;
            this.ranker = this.getSourceRanker(null);
            this.ranker.setMeshHandler(this);
            for (RemoteFileDesc rfd : this.cachedRFDs) {
                if (this.getSha1Urn() != null) break;
                if (rfd.getSHA1Urn() == null) continue;
                this.setSha1Urn(rfd.getSHA1Urn());
            }
        }
        this.setState(Downloader.DownloadState.QUEUED);
        if (this.getSha1Urn() != null) {
            this.altLocManager.addListener(this.getSha1Urn(), this);
        }
        this.socketsManager.addListener(this.connectivityChangeEventHandler);
        this.verifyAllFiles();
        object = this.altLock;
        synchronized (object) {
            this.validAlts = new HashSet<AlternateLocation>();
            this.invalidAlts = new FixedSizeExpiringSet<RemoteFileDesc>(1000, 3600000L);
            this.recentInvalidAlts = new FixedSizeExpiringSet<AlternateLocation>(10, 600000L);
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
        }
        catch (IOException bad) {
            this.setState(Downloader.DownloadState.DISK_PROBLEM);
            this.reportDiskProblem(bad);
            return;
        }
        this.setState(Downloader.DownloadState.QUEUED);
    }

    private void reportDiskProblem(IOException cause) {
        if (DownloadSettings.REPORT_DISK_PROBLEMS.getBoolean()) {
            if (!(cause instanceof DiskException)) {
                cause = new DiskException(cause);
            }
            ErrorService.error(cause);
        }
    }

    protected void reportDiskProblem(String cause) {
        if (DownloadSettings.REPORT_DISK_PROBLEMS.getBoolean()) {
            ErrorService.error(new DiskException(cause));
        }
    }

    private synchronized void verifyAllFiles() {
        if (this.getSha1Urn() == null) {
            return;
        }
        Iterator<RemoteFileDesc> iter = this.cachedRFDs.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = iter.next();
            if (rfd.getSHA1Urn() == null || this.getSha1Urn().equals(rfd.getSHA1Urn())) continue;
            iter.remove();
        }
    }

    @Override
    public synchronized void startDownload() {
        assert (this.dloaderManagerThread == null) : "already started";
        ThreadExecutor.startThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ManagedDownloaderImpl.this.dloaderManagerThread = Thread.currentThread();
                    ManagedDownloaderImpl.this.validateDownload();
                    ManagedDownloaderImpl.this.receivedNewSources = false;
                    ManagedDownloaderImpl.this.triedHosts = 0;
                    Downloader.DownloadState status = ManagedDownloaderImpl.this.performDownload();
                    ManagedDownloaderImpl.this.completeDownload(status);
                }
                catch (Throwable t) {
                    ManagedDownloaderImpl.this.stop();
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadState.ABORTED);
                    ManagedDownloaderImpl.this.downloadManager.remove(ManagedDownloaderImpl.this, true);
                    ErrorService.error(t);
                }
                finally {
                    ManagedDownloaderImpl.this.dloaderManagerThread = null;
                }
            }
        }, "ManagedDownload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeDownload(Downloader.DownloadState status) {
        block34: {
            boolean requery;
            block36: {
                boolean complete;
                boolean clearingNeeded = false;
                int waitTime = 0;
                Object object = this;
                synchronized (object) {
                    switch (status) {
                        case COMPLETE: 
                        case DISK_PROBLEM: 
                        case CORRUPT_FILE: 
                        case DANGEROUS: 
                        case THREAT_FOUND: 
                        case SCAN_FAILED: {
                            clearingNeeded = true;
                            this.setState(status);
                            break;
                        }
                        case BUSY: 
                        case GAVE_UP: {
                            if (this.invalidated) {
                                clearingNeeded = true;
                                this.setState(Downloader.DownloadState.INVALID);
                                break;
                            }
                            if (this.stopped) {
                                this.setState(Downloader.DownloadState.ABORTED);
                                break;
                            }
                            if (this.paused) {
                                this.setState(Downloader.DownloadState.PAUSED);
                                break;
                            }
                            this.setState(status);
                            break;
                        }
                        default: {
                            assert (false) : "Bad status from tad2: " + (Object)((Object)status);
                            break;
                        }
                    }
                    complete = this.isCompleted();
                    waitTime = this.ranker.calculateWaitTime();
                    this.ranker.stop();
                    if (clearingNeeded) {
                        this.ranker = null;
                    }
                }
                this.downloadManager.remove(this, complete);
                if (clearingNeeded) {
                    object = this.altLock;
                    synchronized (object) {
                        this.recentInvalidAlts.clear();
                        this.invalidAlts.clear();
                        this.validAlts.clear();
                    }
                    if (complete) {
                        object = this;
                        synchronized (object) {
                            this.cachedRFDs.clear();
                        }
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("MD completing <" + this.getSaveFile().getName() + "> completed download, state: " + (Object)((Object)this.getState()));
                }
                this.diskController.clearCaches();
                if (complete || this.getState() == Downloader.DownloadState.PAUSED || this.tryGUESSing()) break block34;
                requery = false;
                ManagedDownloaderImpl managedDownloaderImpl = this;
                synchronized (managedDownloaderImpl) {
                    block37: {
                        block35: {
                            if (this.getState() != Downloader.DownloadState.BUSY) break block35;
                            this.setState(Downloader.DownloadState.BUSY, waitTime);
                            break block36;
                        }
                        if (!this.requeryManager.isWaitingForResults()) break block37;
                        switch (this.requeryManager.getLastQueryType()) {
                            case DHT: {
                                this.setState(Downloader.DownloadState.QUERYING_DHT, this.requeryManager.getTimeLeftInQuery());
                                break block36;
                            }
                            case GNUTELLA: {
                                this.setState(Downloader.DownloadState.WAITING_FOR_GNET_RESULTS, this.requeryManager.getTimeLeftInQuery());
                                break block36;
                            }
                            default: {
                                throw new IllegalStateException("Not any query type!");
                            }
                        }
                    }
                    if (this.canSendRequeryNow()) {
                        requery = true;
                    } else if (this.requeryManager.canSendQueryAfterActivate()) {
                        this.setState(Downloader.DownloadState.WAITING_FOR_USER);
                    } else {
                        this.setState(Downloader.DownloadState.GAVE_UP);
                    }
                }
            }
            if (requery) {
                this.requeryManager.sendQuery();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("MD completed <" + this.getSaveFile().getName() + "> completed download, state: " + (Object)((Object)this.getState()));
        }
    }

    @Override
    public synchronized void handleInactivity() {
        switch (this.getState()) {
            case BUSY: 
            case WAITING_FOR_CONNECTIONS: 
            case ITERATIVE_GUESSING: {
                if (this.getRemainingStateTime() > 0 && !this.hasNewSources()) break;
                this.setState(Downloader.DownloadState.QUEUED);
                break;
            }
            case QUERYING_DHT: 
            case WAITING_FOR_GNET_RESULTS: {
                if (this.hasNewSources()) {
                    this.setState(Downloader.DownloadState.QUEUED);
                    break;
                }
                if (this.requeryManager.getTimeLeftInQuery() > 0L) break;
                this.setState(Downloader.DownloadState.GAVE_UP);
                break;
            }
            case WAITING_FOR_USER: {
                if (!this.hasNewSources() && !this.requeryManager.canSendQueryNow()) break;
                this.setState(Downloader.DownloadState.QUEUED);
                break;
            }
            case GAVE_UP: {
                if (this.hasNewSources() || this.requeryManager.canSendQueryAfterActivate()) {
                    this.setState(Downloader.DownloadState.QUEUED);
                }
            }
            case QUEUED: 
            case PAUSED: {
                break;
            }
            default: {
                throw new IllegalStateException("invalid state: " + (Object)((Object)this.getState()) + ", workers: " + this._workers.size() + ", _activeWorkers: " + this._activeWorkers.size() + ", _queuedWorkers: " + this._queuedWorkers.size());
            }
        }
    }

    private boolean tryGUESSing() {
        if (this.originalQueryGUID == null || this.triedLocatingSources || this.getSha1Urn() == null) {
            return false;
        }
        Set<GUESSEndpoint> guessLocs = this.messageRouter.get().getQueryLocs(this.originalQueryGUID);
        if (guessLocs.isEmpty()) {
            return false;
        }
        this.setState(Downloader.DownloadState.ITERATIVE_GUESSING, 5000L);
        this.triedLocatingSources = true;
        for (GUESSEndpoint ep : guessLocs) {
            this.onDemandUnicaster.query(ep, this.getSha1Urn());
            if (!this.receivedNewSources) continue;
            break;
        }
        return true;
    }

    @Override
    public boolean isAlive() {
        return this.dloaderManagerThread != null;
    }

    @Override
    public boolean isCompleted() {
        switch (this.getState()) {
            case COMPLETE: 
            case DISK_PROBLEM: 
            case CORRUPT_FILE: 
            case DANGEROUS: 
            case THREAT_FOUND: 
            case SCAN_FAILED: 
            case ABORTED: 
            case INVALID: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isRelocatable() {
        if (this.isInactive()) {
            return true;
        }
        switch (this.getState()) {
            case INITIALIZING: 
            case CONNECTING: 
            case DOWNLOADING: 
            case REMOTE_QUEUED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isActive() {
        switch (this.getState()) {
            case CONNECTING: 
            case DOWNLOADING: 
            case REMOTE_QUEUED: 
            case HASHING: 
            case SAVING: 
            case SCANNING: {
                return true;
            }
        }
        return false;
    }

    boolean isInactive() {
        switch (this.getState()) {
            case BUSY: 
            case GAVE_UP: 
            case WAITING_FOR_CONNECTIONS: 
            case ITERATIVE_GUESSING: 
            case QUERYING_DHT: 
            case WAITING_FOR_GNET_RESULTS: 
            case WAITING_FOR_USER: 
            case QUEUED: 
            case PAUSED: 
            case INITIALIZING: {
                return true;
            }
        }
        return false;
    }

    protected synchronized void initializeRanker(SourceRanker ranker) {
        ranker.setMeshHandler(this);
        ranker.addToPool(this.getContexts(this.cachedRFDs));
    }

    protected void initializeVerifyingFile() throws IOException {
        if (this.incompleteFile == null) {
            return;
        }
        this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
        if (this.commonOutFile == null) {
            long completedSize = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            if (completedSize > 0xFFFFFFFFFFL) {
                throw new IOException("invalid incomplete file " + completedSize);
            }
            this.commonOutFile = this.verifyingFileFactory.createVerifyingFile(completedSize);
            this.commonOutFile.setScanForExistingBlocks(true, this.incompleteFile.length());
            this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile, this.shouldPublishIFD());
        }
    }

    protected void initializeIncompleteFile() throws IOException {
        if (this.incompleteFile != null) {
            return;
        }
        URN sha1 = this.getSha1Urn();
        if (sha1 != null) {
            this.incompleteFile = this.incompleteFileManager.getFileForUrn(sha1);
        }
        if (this.incompleteFile == null) {
            this.incompleteFile = this.getIncompleteFile(this.getSaveFile().getName(), sha1, this.getContentLength());
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("Incomplete File: " + this.incompleteFile);
        }
    }

    protected File getIncompleteFile(String name, URN urn, long length) throws IOException {
        return this.incompleteFileManager.getFile(name, urn, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean conflictsWithIncompleteFile(File incFile) {
        File iFile = this.incompleteFile;
        if (iFile != null) {
            return iFile.equals(incFile);
        }
        URN urn = this.getSha1Urn();
        if (urn != null) {
            iFile = this.incompleteFileManager.getFileForUrn(urn);
        }
        if (iFile != null) {
            return iFile.equals(incFile);
        }
        RemoteFileDesc rfd = null;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            if (!this.hasRFD()) {
                return false;
            }
            rfd = this.cachedRFDs.iterator().next();
        }
        if (rfd != null) {
            try {
                File thisFile = this.incompleteFileManager.getFile(rfd);
                return thisFile.equals(incFile);
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean conflicts(URN urn, long fileSize, File ... fileName) {
        if (urn != null && this.getSha1Urn() != null) {
            return urn.equals(this.getSha1Urn());
        }
        if (fileSize > 0L) {
            try {
                File file = this.incompleteFileManager.getFile(fileName[0].getName(), null, fileSize);
                return this.conflictsWithIncompleteFile(file);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized QueryRequest newRequery() throws CantResumeException {
        String queryString = QueryUtils.createQueryString(this.getDefaultFileName());
        if (queryString == null || queryString.equals("")) {
            throw new CantResumeException(this.getSaveFile().getName());
        }
        return this.queryRequestFactory.createQuery(queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hostIsAllowed(RemoteFileDesc other) {
        if (!this.ipFilter.allow(other.getAddress())) {
            return false;
        }
        Object object = this.altLock;
        synchronized (object) {
            if (other.isFromAlternateLocation() && this.invalidAlts.contains(other)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc other) {
        if (!initDone) {
            ApproximateMatcher approximateMatcher = matcher;
            synchronized (approximateMatcher) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            initDone = true;
        }
        if (other.getQuality() < 1) {
            return false;
        }
        URN otherUrn = other.getSHA1Urn();
        String otherName = other.getFileName();
        long otherLength = other.getSize();
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            long ourLength = this.getContentLength();
            if (ourLength != -1L && ourLength != otherLength) {
                return false;
            }
            if (otherUrn != null && this.getSha1Urn() != null) {
                return otherUrn.equals(this.getSha1Urn());
            }
            for (RemoteFileDesc rfd : this.cachedRFDs) {
                String thisName = rfd.getFileName();
                long thisLength = rfd.getSize();
                if (otherLength != thisLength || !this.namesClose(otherName, thisName)) continue;
                return true;
            }
            String resumeFileName = this.getResumeFileName();
            if (resumeFileName != null) {
                return this.namesClose(otherName, resumeFileName);
            }
        }
        return false;
    }

    private String getResumeFileName() {
        File incompleteFile;
        String resumeFileName = null;
        if (this.getIncompleteFile() != null && (resumeFileName = (incompleteFile = this.getIncompleteFile()).getName()).contains("-")) {
            resumeFileName = resumeFileName.substring(resumeFileName.lastIndexOf("-", resumeFileName.length()));
        }
        return resumeFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean namesClose(String one, String two) {
        boolean retVal = false;
        int allowedDifferences = Math.round(Math.min(0.1f * (float)QueryUtils.ripExtension(one).length(), 0.1f * (float)QueryUtils.ripExtension(two).length()));
        allowedDifferences = Math.min(allowedDifferences, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            retVal = matcher.matches(matcher.process(one), matcher.process(two), allowedDifferences);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD.namesClose(): one = " + one);
            LOG.debug("MD.namesClose(): two = " + two);
            LOG.debug("MD.namesClose(): retVal = " + retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void locationAdded(AlternateLocation loc) {
        long fileSize;
        assert (loc.getSHA1Urn().equals(this.getSha1Urn()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("alt loc added: " + loc);
        }
        long contentLength = -1L;
        if (loc instanceof DirectDHTAltLoc && (fileSize = ((DirectDHTAltLoc)loc).getFileSize()) >= 0L) {
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                contentLength = this.getContentLength();
                if (contentLength < 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using file size from AltLocValue: " + fileSize);
                    }
                    if ((contentLength = fileSize) <= 0xFFFFFFFFFFL) {
                        this.setContentLength(contentLength);
                    }
                }
            }
            if (fileSize != contentLength) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("File sizes do not match: " + fileSize + " vs. " + contentLength);
                }
                return;
            }
        }
        if ((contentLength = this.getContentLength()) < 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unknown file size: " + contentLength);
            }
            return;
        }
        if (contentLength > 0xFFFFFFFFFFL) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content length is too big: " + contentLength);
            }
            return;
        }
        this.addDownload(loc.createRemoteFileDesc(contentLength, this.remoteFileDescFactory), false);
    }

    @Override
    public synchronized boolean addDownload(RemoteFileDesc rfd, boolean cache) {
        return this.addDownload(Collections.singleton(rfd), cache);
    }

    @Override
    public synchronized boolean addDownload(Collection<? extends RemoteFileDesc> c, boolean cache) {
        if (this.stopped || this.isCompleted()) {
            return false;
        }
        ArrayList<RemoteFileDesc> l = new ArrayList<RemoteFileDesc>(c.size());
        for (RemoteFileDesc remoteFileDesc : c) {
            if (!this.allowAddition(remoteFileDesc) || !this.hostIsAllowed(remoteFileDesc)) continue;
            l.add(remoteFileDesc);
        }
        if (l.size() > 0) {
            return this.addDownloadForced(l, cache);
        }
        return false;
    }

    protected synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        return this.addDownloadForced(Collections.singleton(rfd), cache);
    }

    protected final synchronized boolean addDownloadForced(Collection<? extends RemoteFileDesc> c, boolean cache) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("add download forced", new Exception());
        }
        HashSet<? extends RemoteFileDesc> copy = new HashSet<RemoteFileDesc>(c);
        if (this.currentRFDs != null) {
            copy.removeAll(this.currentRFDs);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("remaining new rfds: " + copy);
        }
        byte[] myGUID = this.applicationServices.getMyGUID();
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (rfd.isMe(myGUID)) {
                iter.remove();
                continue;
            }
            this.prepareRFD(rfd, cache);
            if (this.canResolve(rfd) || this.canConnect(rfd)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("rfd not connectable yet: " + rfd);
            }
            this.permanentRFDs.add(rfd);
            iter.remove();
        }
        if (this.ranker != null && this.ranker.addToPool(this.getContexts(copy))) {
            LOG.debug("got new sources");
            this.receivedNewSources = true;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(copy + " not added");
        }
        return true;
    }

    private boolean canResolve(RemoteFileDesc rfd) {
        return this.socketsManager.canResolve(rfd.getAddress());
    }

    private boolean canConnect(RemoteFileDesc rfd) {
        return this.socketsManager.canConnect(rfd.getAddress());
    }

    private void prepareRFD(RemoteFileDesc rfd, boolean cache) {
        if (this.getSha1Urn() == null && rfd.getSHA1Urn() != null) {
            this.setSha1Urn(rfd.getSHA1Urn());
            this.altLocManager.addListener(this.getSha1Urn(), this);
        }
        if (cache || rfd.getAddress() instanceof PermanentAddress) {
            this.cachedRFDs.add(rfd);
        }
    }

    @Override
    public boolean hasNewSources() {
        return !this.paused && this.receivedNewSources;
    }

    private Collection<RemoteFileDesc> getNewConnectableSources() {
        ArrayList<RemoteFileDesc> newlyConnectables = new ArrayList<RemoteFileDesc>();
        for (RemoteFileDesc rfd : this.permanentRFDs) {
            if (this.canResolve(rfd) || this.canConnect(rfd)) {
                newlyConnectables.add(rfd);
                continue;
            }
            LOG.debug(rfd + " not connectable");
        }
        return newlyConnectables;
    }

    @Override
    public boolean shouldBeRestarted() {
        Downloader.DownloadState status = this.getState();
        return this.hasNewSources() || this.getRemainingStateTime() <= 0 && status != Downloader.DownloadState.WAITING_FOR_GNET_RESULTS && status != Downloader.DownloadState.QUERYING_DHT;
    }

    @Override
    public boolean shouldBeRemoved() {
        return this.isCancelled() || this.isCompleted();
    }

    @Override
    public boolean isQueuable() {
        return !this.isPaused();
    }

    @Override
    public boolean acceptDownload(String file, Socket socket, int index, byte[] clientGUID) {
        if (this.stopped) {
            return false;
        }
        HTTPConnectObserver observer = this.pushes.getHostFor(clientGUID, socket.getInetAddress().getHostAddress());
        if (observer != null) {
            observer.handleConnect(socket);
        }
        return observer != null;
    }

    @Override
    public void registerPushObserver(HTTPConnectObserver observer, PushDetails details) {
        this.pushes.addPushHost(details, observer);
    }

    @Override
    public void unregisterPushObserver(PushDetails details, boolean shutdown) {
        HTTPConnectObserver observer = this.pushes.getExactHostFor(details);
        if (observer != null && shutdown) {
            observer.shutdown();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.stopped;
    }

    @Override
    public synchronized void pause() {
        if (!this.stopped && !this.isCompleted()) {
            this.stop();
            this.stopped = false;
            this.paused = true;
            if (this.isInactive()) {
                this.setState(Downloader.DownloadState.PAUSED);
            }
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isLaunchable() {
        if (this.state == Downloader.DownloadState.DANGEROUS || this.state == Downloader.DownloadState.THREAT_FOUND) {
            return false;
        }
        if (this.state == Downloader.DownloadState.COMPLETE || this.state == Downloader.DownloadState.SCAN_FAILED) {
            return true;
        }
        return this.amountForPreview() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.paused) {
            this.stopped = true;
            this.paused = false;
        }
        if (!this.stopped && !this.paused) {
            LOG.debug("STOPPING ManagedDownloader");
            this.stopped = true;
            this.killAllWorkers();
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                Thread dlMan = this.dloaderManagerThread;
                if (dlMan != null) {
                    dlMan.interrupt();
                } else {
                    LOG.warn("MANAGER: no thread to interrupt");
                }
            }
        }
    }

    private void killAllWorkers() {
        List<DownloadWorker> workers = this.getAllWorkers();
        for (DownloadWorker doomed : workers) {
            doomed.interrupt();
        }
        List<HTTPConnectObserver> pushObservers = this.pushes.getAllAndClear();
        for (HTTPConnectObserver next : pushObservers) {
            next.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void informMesh(RemoteFileDesc rfd, boolean good) {
        AlternateLocation local;
        AlternateLocation loc;
        if (LOG.isDebugEnabled()) {
            LOG.debug("informing mesh that " + rfd + " is " + good);
        }
        if (good) {
            this.cachedRFDs.add(rfd);
        }
        if (!rfd.isAltLocCapable()) {
            return;
        }
        assert (this.getSha1Urn() != null) : "null hash.";
        assert (this.getSha1Urn().equals(rfd.getSHA1Urn())) : "wrong loc SHA1";
        try {
            loc = this.alternateLocationFactory.create(rfd);
        }
        catch (IOException iox) {
            return;
        }
        if (loc instanceof PushAltLoc) {
            local = loc.createClone();
            PushAltLoc ploc = (PushAltLoc)loc;
            if (ploc.getPushAddress().getProxies().isEmpty()) {
                return;
            }
            ploc.updateProxies(good);
        } else {
            local = loc;
        }
        if (good) {
            this.altLocManager.add(loc, this);
        } else {
            this.altLocManager.remove(loc, this);
        }
        for (DownloadWorker worker : this.getActiveWorkers()) {
            HTTPDownloader httpDloader = worker.getDownloader();
            RemoteFileDesc r = httpDloader.getRemoteFileDesc();
            if (r.equals(rfd) || !(local instanceof DirectAltLoc) && !httpDloader.wantsFalts()) continue;
            if (good) {
                httpDloader.addSuccessfulAltLoc(local);
                continue;
            }
            httpDloader.addFailedAltLoc(local);
        }
        Object object = this.altLock;
        synchronized (object) {
            if (good) {
                if (!this.validAlts.contains(local)) {
                    this.validAlts.add(local);
                }
            } else {
                this.validAlts.remove(local);
                this.invalidAlts.add(rfd);
                this.recentInvalidAlts.add(local);
            }
        }
    }

    @Override
    public synchronized void addPossibleSources(Collection<? extends RemoteFileDesc> c) {
        this.addDownload(c, false);
    }

    protected boolean canSendRequeryNow() {
        return this.requeryManager.canSendQueryNow();
    }

    @Override
    public synchronized boolean resume() {
        if (!this.isInactive()) {
            return false;
        }
        if (this.getState() == Downloader.DownloadState.WAITING_FOR_USER) {
            this.requeryManager.activate();
        }
        for (RemoteFileDesc rfd : this.cachedRFDs) {
            this.resetRfdContext(this.getContext(rfd));
        }
        if (this.paused) {
            this.paused = false;
            this.stopped = false;
        }
        this.setState(Downloader.DownloadState.QUEUED);
        return true;
    }

    protected void resetRfdContext(RemoteFileDescContext rfdContext) {
        rfdContext.setRetryAfter(0);
        rfdContext.setLastHttpCode(-1);
    }

    @Override
    public File getFile() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == Downloader.DownloadState.COMPLETE) {
            return this.getSaveFile();
        }
        return this.incompleteFile;
    }

    @Override
    public URN getSha1Urn() {
        return this.downloadSHA1;
    }

    protected void setSha1Urn(URN sha1) {
        if (!sha1.isSHA1()) {
            throw new IllegalArgumentException("not sha1: " + sha1);
        }
        if (this.downloadSHA1 != null && !sha1.equals(this.downloadSHA1)) {
            throw new IllegalStateException("sha1 already set to: " + this.downloadSHA1);
        }
        this.downloadSHA1 = sha1;
    }

    @Override
    public File getDownloadFragment(Downloader.ScanListener listener) {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == Downloader.DownloadState.CORRUPT_FILE) {
            File corrupt = this.corruptFile;
            if (corrupt == null) {
                return null;
            }
            if (this.isInfectedOrDangerous(corrupt, listener)) {
                this.corruptFile = null;
                return null;
            }
            return corrupt;
        }
        if (this.state == Downloader.DownloadState.COMPLETE || this.state == Downloader.DownloadState.SCAN_FAILED) {
            return this.getSaveFile();
        }
        File copy = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
        long size = this.amountForPreview();
        if (size <= 0L) {
            return null;
        }
        if (FileUtils.copy(this.incompleteFile, size, copy) <= 0L) {
            return null;
        }
        if (this.isInfectedOrDangerous(copy, listener)) {
            this.incompleteFile.delete();
            return null;
        }
        return copy;
    }

    private boolean isInfectedOrDangerous(File fragment, Downloader.ScanListener listener) {
        block4: {
            if (this.virusScanner.isEnabled()) {
                listener.scanStarted();
                try {
                    boolean infected = this.isInfected(fragment);
                    listener.scanStopped();
                    if (infected) {
                        return true;
                    }
                }
                catch (VirusScanException e) {
                    listener.scanStopped();
                    if (!this.promptAboutUnscannedPreview()) break block4;
                    return true;
                }
            }
        }
        return this.isDangerous(fragment);
    }

    private synchronized long amountForPreview() {
        if (this.commonOutFile == null) {
            return 0L;
        }
        return this.commonOutFile.getOffsetForPreview();
    }

    @Override
    protected File getDefaultSaveFile() {
        String fileName = this.getDefaultFileName();
        Category category = null;
        if (fileName != null) {
            category = this.categoryManager.getCategoryForFilename(fileName);
        }
        return new File(SharingSettings.getSaveDirectory(category), fileName);
    }

    @Override
    public synchronized void finish() {
        if (this.getSha1Urn() != null) {
            this.altLocManager.removeListener(this.getSha1Urn(), this);
        }
        this.requeryManager.cleanUp();
        this.socketsManager.removeListener(this.connectivityChangeEventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Downloader.DownloadState performDownload() {
        if (this.checkHosts()) {
            this.setState(Downloader.DownloadState.GAVE_UP);
            return Downloader.DownloadState.GAVE_UP;
        }
        Downloader.DownloadState status = this.initializeDownload();
        if (status == Downloader.DownloadState.CONNECTING) {
            try {
                try {
                    status = this.fireDownloadWorkers();
                }
                finally {
                    this.commonOutFile.close();
                }
                if (status == Downloader.DownloadState.COMPLETE) {
                    status = this.verifyAndSave();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("stopping early with status: " + (Object)((Object)status));
                }
            }
            catch (InterruptedException e) {
                if (!this.stopped && !this.paused) {
                    ErrorService.error(e);
                }
                switch (this.getState()) {
                    case DANGEROUS: {
                        status = Downloader.DownloadState.DANGEROUS;
                        break;
                    }
                    case THREAT_FOUND: {
                        status = Downloader.DownloadState.THREAT_FOUND;
                        break;
                    }
                    case CORRUPT_FILE: {
                        this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
                        status = Downloader.DownloadState.CORRUPT_FILE;
                        break;
                    }
                    default: {
                        status = Downloader.DownloadState.GAVE_UP;
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MANAGER: TAD2 returned: " + (Object)((Object)status));
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Downloader.DownloadState initializeDownload() {
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            if (this.cachedRFDs.size() == 0 && !this.ranker.hasMore()) {
                return Downloader.DownloadState.GAVE_UP;
            }
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
            this.openVerifyingFile();
        }
        catch (IOException iox) {
            this.reportDiskProblem(iox);
            return Downloader.DownloadState.DISK_PROBLEM;
        }
        if (this.getSha1Urn() != null) {
            this.initializeHashTree();
        }
        this.initializeRanker(this.ranker);
        return Downloader.DownloadState.CONNECTING;
    }

    private Downloader.DownloadState verifyAndSave() throws InterruptedException {
        if (this.virusScanner.isEnabled()) {
            this.setState(Downloader.DownloadState.SCANNING);
        }
        Downloader.DownloadState scanFailed = null;
        try {
            if (this.isInfected(this.incompleteFile)) {
                return Downloader.DownloadState.THREAT_FOUND;
            }
        }
        catch (VirusScanException e) {
            this.setAttribute("scanner.failureHint", (Object)e.getDetail(), false);
            scanFailed = Downloader.DownloadState.SCAN_FAILED;
        }
        if (this.isDangerous(this.incompleteFile)) {
            return Downloader.DownloadState.DANGEROUS;
        }
        URN fileHash = this.scanForCorruption();
        if (fileHash == null) {
            this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
            return Downloader.DownloadState.CORRUPT_FILE;
        }
        Downloader.DownloadState saveState = this.saveFile(fileHash);
        if (saveState == Downloader.DownloadState.COMPLETE && scanFailed != null) {
            return scanFailed;
        }
        return saveState;
    }

    private boolean isDangerous(File file) {
        if (this.dangerousFileChecker.isDangerous(file)) {
            this.setState(Downloader.DownloadState.DANGEROUS);
            RemoteFileDesc[] type = new RemoteFileDesc[]{};
            this.spamManager.handleUserMarkedSpam(this.cachedRFDs.toArray(type));
            this.stop();
            this.library.remove(file);
            file.delete();
            return true;
        }
        return false;
    }

    private boolean isInfected(File file) throws VirusScanException {
        if (this.virusScanner.isEnabled() && this.virusScanner.isInfected(file)) {
            this.setState(Downloader.DownloadState.THREAT_FOUND);
            RemoteFileDesc[] type = new RemoteFileDesc[]{};
            this.spamManager.handleUserMarkedSpam(this.cachedRFDs.toArray(type));
            this.stop();
            this.library.remove(file);
            file.delete();
            return true;
        }
        return false;
    }

    private void validateDownload() {
        if (this.shouldValidate() && this.getSha1Urn() != null) {
            this.contentManager.request(this.getSha1Urn(), new ContentResponseObserver(){

                @Override
                public void handleResponse(URN urn, ContentResponseData response) {
                    if (response != null && !response.isOK()) {
                        ManagedDownloaderImpl.this.invalidated = true;
                        ManagedDownloaderImpl.this.stop();
                    }
                }
            }, 5000L);
        }
    }

    protected boolean shouldValidate() {
        return true;
    }

    private URN scanForCorruption() throws InterruptedException {
        URN fileHash = null;
        try {
            this.setState(Downloader.DownloadState.HASHING);
            fileHash = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.getSha1Urn() == null) {
            return fileHash;
        }
        if (this.getSha1Urn().equals(fileHash)) {
            return fileHash;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("hash verification problem, fileHash=" + fileHash + ", ourHash=" + this.getSha1Urn());
        }
        this.cancelCorruptDownload();
        return null;
    }

    private void initializeHashTree() {
        HashTree tree = this.tigerTreeCache.get().getHashTree(this.getSha1Urn());
        if (tree != null && tree.isDepthGoodEnough()) {
            this.commonOutFile.setHashTree(tree);
        }
    }

    protected Downloader.DownloadState saveFile(URN fileHash) {
        this.setState(Downloader.DownloadState.SAVING);
        File saveFile = this.getSaveFile();
        try {
            saveFile = this.getSuggestedSaveLocation(saveFile, this.incompleteFile);
            if (!FileUtils.setWriteable(saveFile.getParentFile())) {
                this.reportDiskProblem("could not set file writeable " + this.getSaveFile().getParentFile());
                return Downloader.DownloadState.DISK_PROBLEM;
            }
            if (!saveFile.equals(this.getSaveFile())) {
                this.setSaveFile(saveFile.getParentFile(), saveFile.getName(), true);
            }
        }
        catch (IOException e) {
            return Downloader.DownloadState.DISK_PROBLEM;
        }
        saveFile.delete();
        boolean success = FileUtils.forceRename(this.incompleteFile, saveFile);
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (!success) {
            this.reportDiskProblem("forceRename failed " + this.incompleteFile + " -> " + saveFile);
            return Downloader.DownloadState.DISK_PROBLEM;
        }
        if (saveFile.exists()) {
            this.library.remove(saveFile);
        }
        this.addFileHash(fileHash, saveFile);
        this.shareSavedFile(saveFile);
        return Downloader.DownloadState.COMPLETE;
    }

    protected File getSuggestedSaveLocation(File defaultSaveFile, File newDownloadFile) throws IOException {
        return defaultSaveFile;
    }

    private void addFileHash(URN fileHash, File saveFile) {
        if (fileHash != null) {
            UrnSet urns = new UrnSet(fileHash);
            File file = saveFile;
            try {
                file = FileUtils.getCanonicalFile(saveFile);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            URN ttroot = this.saveTreeHash(fileHash);
            if (ttroot != null) {
                urns.add(ttroot);
            }
            this.urnCache.addUrns(file, urns);
            this.library.add(file, this.getXMLDocuments());
        }
    }

    protected URN saveTreeHash(URN fileHash) {
        if (this.getSha1Urn() != null && this.getSha1Urn().equals(fileHash) && this.commonOutFile.getHashTree() != null) {
            this.tigerTreeCache.get().addHashTree(this.getSha1Urn(), this.commonOutFile.getHashTree());
            return this.commonOutFile.getHashTree().getTreeRootUrn();
        }
        return null;
    }

    protected void shareSavedFile(File saveFile) {
        if (SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue() && !this.isFriendDownload) {
            this.gnutellaFileCollection.add(saveFile, this.getXMLDocuments());
        }
    }

    private void cleanupCorrupt(File incFile, String name) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(incFile);
        boolean renamed = false;
        for (int i = 0; i < 10 && !renamed; ++i) {
            this.corruptFile = new File(incFile.getParent(), "CORRUPT-" + i + "-" + name);
            if (this.corruptFile.exists()) continue;
            renamed = incFile.renameTo(this.corruptFile);
        }
        if (!renamed) {
            incFile.delete();
            this.corruptFile = null;
        }
    }

    private void openVerifyingFile() throws IOException {
        try {
            this.commonOutFile.open(this.incompleteFile);
        }
        catch (IOException e) {
            IOUtils.handleException(e, IOUtils.ErrorType.DOWNLOAD);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker(RemoteFileDescContext rfdContext) {
        DownloadWorker worker = this.downloadWorkerFactory.create(this, rfdContext, this.commonOutFile);
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            this._workers.add(worker);
            this.currentRFDs.add(rfdContext.getRemoteFileDesc());
        }
        worker.start();
    }

    @Override
    public synchronized void workerFinished(DownloadWorker finished) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("worker " + finished + " finished.");
        }
        this.removeWorker(finished);
        this.notify();
    }

    @Override
    public synchronized void workerStarted(DownloadWorker worker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("worker " + worker + " started.");
        }
        if (!this._workers.contains(worker)) {
            throw new IllegalStateException("attempting to start invalid worker: " + worker);
        }
        this.setState(Downloader.DownloadState.DOWNLOADING);
        this.addActiveWorker(worker);
    }

    @Override
    public void workerFailed(DownloadWorker failed) {
    }

    synchronized void removeWorker(DownloadWorker worker) {
        boolean rA = this.removeActiveWorker(worker);
        this.workerFailed(worker);
        boolean rW = this._workers.remove(worker);
        if (rA && !rW) {
            throw new IllegalStateException("active removed but not in workers");
        }
    }

    @Override
    public synchronized boolean removeActiveWorker(DownloadWorker worker) {
        this.currentRFDs.remove(worker.getRFD());
        ArrayList<DownloadWorker> l = new ArrayList<DownloadWorker>(this.getActiveWorkers());
        boolean removed = l.remove(worker);
        this._activeWorkers = Collections.unmodifiableList(l);
        return removed;
    }

    synchronized void addActiveWorker(DownloadWorker worker) {
        if (!this.getActiveWorkers().contains(worker)) {
            ArrayList<DownloadWorker> l = new ArrayList<DownloadWorker>(this.getActiveWorkers());
            l.add(worker);
            this._activeWorkers = Collections.unmodifiableList(l);
        }
    }

    synchronized String getWorkersInfo() {
        String workerState = "";
        for (DownloadWorker worker : this._workers) {
            workerState = workerState + worker.getInfo();
        }
        return workerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AlternateLocation> getValidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            Set<AlternateLocation> ret = this.validAlts != null ? new HashSet<AlternateLocation>(this.validAlts) : Collections.emptySet();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AlternateLocation> getInvalidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            Set<AlternateLocation> ret = this.invalidAlts != null ? new HashSet<AlternateLocation>(this.recentInvalidAlts) : Collections.emptySet();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Downloader.DownloadState fireDownloadWorkers() throws InterruptedException {
        LOG.trace("MANAGER: entered fireDownloadWorkers");
        while (true) {
            if (this.stopped || this.paused) {
                LOG.warn("MANAGER: terminating because of stop|pause");
                throw new InterruptedException();
            }
            try {
                this.commonOutFile.waitForPendingIfNeeded();
            }
            catch (DiskException dio) {
                if (this.stopped || this.paused) {
                    LOG.warn("MANAGER: terminating because of stop|pause");
                    throw new InterruptedException();
                }
                this.stop();
                this.reportDiskProblem(dio);
                return Downloader.DownloadState.DISK_PROBLEM;
            }
            if (this.commonOutFile.isComplete()) {
                this.killAllWorkers();
                LOG.trace("MANAGER: terminating because of completion");
                return Downloader.DownloadState.COMPLETE;
            }
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                if (this._workers.size() == 0 && !this.ranker.hasUsableHosts()) {
                    this.receivedNewSources = false;
                    if (this.ranker.calculateWaitTime() > 0) {
                        LOG.trace("MANAGER: terminating with busy");
                        return Downloader.DownloadState.BUSY;
                    }
                    LOG.trace("MANAGER: terminating w/o hope");
                    return Downloader.DownloadState.GAVE_UP;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("MANAGER: kicking off workers.  state: " + (Object)((Object)this.getState()) + ", allWorkers: " + this._workers.size() + ", activeWorkers: " + this._activeWorkers.size() + ", queuedWorkers: " + this._queuedWorkers.size() + ", swarm cap: " + this.getSwarmCapacity());
                }
                if (this.shouldStartWorker()) {
                    this.ranker = this.getSourceRanker(this.ranker);
                    RemoteFileDescContext rfd = this.ranker.getBest();
                    if (rfd != null) {
                        if (rfd.isBusy()) {
                            this.addToRanker(rfd);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Staring worker for RFD: " + rfd);
                            }
                            this.startWorker(rfd);
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("no blocks but can't steal - sleeping.");
                }
                try {
                    this.wait(DownloadSettings.WORKER_INTERVAL.getValue());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected SourceRanker getSourceRanker(SourceRanker ranker) {
        return this.sourceRankerFactory.getAppropriateRanker(ranker);
    }

    private boolean shouldStartWorker() {
        return (this.commonOutFile.hasFreeBlocksToAssign() > 0L || this.victimsExist()) && this._workers.size() - this._queuedWorkers.size() < this.getSwarmCapacity() && this.ranker.hasMore();
    }

    private boolean victimsExist() {
        if (this._workers.isEmpty()) {
            return false;
        }
        for (DownloadWorker victim : this._workers) {
            if (victim.isStealing() || !victim.isSlow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addToRanker(RemoteFileDescContext rfd) {
        if (this.ranker != null) {
            this.ranker.addToPool(rfd);
        }
    }

    @Override
    public synchronized void forgetRFD(RemoteFileDesc rfd) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove rfd: " + rfd);
        }
        if (rfd.getAddress() instanceof PermanentAddress) {
            this.permanentRFDs.add(rfd);
            return;
        }
        if (this.cachedRFDs.remove(rfd) && this.cachedRFDs.isEmpty()) {
            this.cachedRFDs.add(rfd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAlternateLocations() {
        Object object = this.altLock;
        synchronized (object) {
            if (this.validAlts == null) {
                return 0;
            }
            return this.validAlts.size();
        }
    }

    @Override
    public synchronized int getQueuedHostCount() {
        return this._queuedWorkers.size();
    }

    int getSwarmCapacity() {
        int capacity = this.bandwidthCollector.getMaxMeasuredTotalDownloadBandwidth() * 8;
        if (capacity <= 0) {
            capacity = 350;
        }
        int maxDownloadSpeed = DownloadSettings.MAX_DOWNLOAD_SPEED.getValue() / 1024 * 8;
        if (DownloadSettings.LIMIT_MAX_DOWNLOAD_SPEED.getValue() && capacity > maxDownloadSpeed) {
            capacity = maxDownloadSpeed;
        }
        if (capacity <= 56) {
            return this.activationManager.isActive(ActivationID.TURBO_CHARGED_DOWNLOADS_MODULE) ? 4 : 2;
        }
        if (capacity <= 1000) {
            return this.activationManager.isActive(ActivationID.TURBO_CHARGED_DOWNLOADS_MODULE) ? 10 : 8;
        }
        return this.activationManager.isActive(ActivationID.TURBO_CHARGED_DOWNLOADS_MODULE) ? 14 : 10;
    }

    @Override
    public void cancelCorruptDownload() {
        this.setState(Downloader.DownloadState.CORRUPT_FILE);
        this.library.remove(this.incompleteFile);
        if (this.getSha1Urn() != null) {
            this.tigerTreeCache.get().purgeTree(this.getSha1Urn());
        }
        this.commonOutFile.setHashTree(null);
        this.stop();
        this.incompleteFile.delete();
    }

    private boolean promptAboutUnscannedPreview() {
        this.downloadCallback.promptAboutUnscannedPreview(this);
        return this.discardUnscannedPreview;
    }

    @Override
    public void discardUnscannedPreview(boolean delete) {
        this.discardUnscannedPreview = delete;
    }

    private synchronized List<LimeXMLDocument> getXMLDocuments() {
        ArrayList<LimeXMLDocument> allDocs = new ArrayList<LimeXMLDocument>();
        for (RemoteFileDesc rfd : this.cachedRFDs) {
            LimeXMLDocument doc = rfd.getXMLDocument();
            if (doc == null) continue;
            allDocs.add(doc);
        }
        return allDocs;
    }

    @Override
    public void setState(Downloader.DownloadState newState) {
        this.setState(newState, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(Downloader.DownloadState newState, long time) {
        Downloader.DownloadState oldState = null;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            oldState = this.state;
            this.state = newState;
            this.stateTime = System.currentTimeMillis() + time;
        }
        if (oldState != newState) {
            this.listeners.broadcast(new DownloadStateEvent(this, newState));
        }
    }

    synchronized boolean setStateIfExistingStateIs(Downloader.DownloadState newState, Downloader.DownloadState oldState) {
        if (this.getState() == oldState) {
            this.setState(newState);
            return true;
        }
        return false;
    }

    @Override
    public GUID getQueryGUID() {
        return this.originalQueryGUID;
    }

    @Override
    public synchronized Downloader.DownloadState getState() {
        return this.state;
    }

    @Override
    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case BUSY: 
            case WAITING_FOR_CONNECTIONS: 
            case ITERATIVE_GUESSING: 
            case CONNECTING: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.ceil((float)Math.max(remaining, 0L) / 1000.0f);
            }
            case QUERYING_DHT: 
            case WAITING_FOR_GNET_RESULTS: {
                return (int)Math.ceil((float)Math.max(this.requeryManager.getTimeLeftInQuery(), 0L) / 1000.0f);
            }
            case QUEUED: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    protected synchronized boolean hasRFD() {
        return this.cachedRFDs != null && !this.cachedRFDs.isEmpty();
    }

    @Override
    public synchronized long getContentLength() {
        return this.contentLength;
    }

    protected synchronized void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountRead() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            if (this.state == Downloader.DownloadState.CORRUPT_FILE) {
                return this.corruptFileBytes;
            }
            if (this.state == Downloader.DownloadState.HASHING) {
                if (this.incompleteFile == null) {
                    return 0L;
                }
                return URN.getHashingProgress(this.incompleteFile);
            }
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0L : ourFile.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAmountPending() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            ourFile = this.commonOutFile;
        }
        return (int)(ourFile == null ? 0L : ourFile.getPendingSize());
    }

    @Override
    public int getNumHosts() {
        return this._activeWorkers.size();
    }

    @Override
    public List<Address> getSourcesAsAddresses() {
        ArrayList<Address> sources = new ArrayList<Address>(this._activeWorkers.size());
        for (DownloadWorker worker : this._activeWorkers) {
            sources.add(worker.getRFD().getAddress());
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SourceInfo> getSourcesDetails() {
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            ArrayList<SourceInfo> sources = new ArrayList<SourceInfo>(this._workers.size());
            for (DownloadWorker worker : this._workers) {
                sources.add(new SourceDetails(worker));
            }
            return sources;
        }
    }

    private synchronized IntervalSet getAvailablePieces() {
        IntervalSet available = new IntervalSet();
        long length = this.getContentLength();
        for (DownloadWorker worker : this._workers) {
            RemoteFileDescContext context = this.getContext(worker.getRFD());
            if (context.isPartialSource()) {
                available.add(context.getAvailableRanges());
                continue;
            }
            if (length <= 0L) continue;
            return IntervalSet.createSingletonSet(0L, length);
        }
        return available;
    }

    @Override
    public DownloadPiecesInfo getPieceInfo() {
        IntervalSet active;
        IntervalSet written;
        VerifyingFile vfile = this.commonOutFile;
        if (vfile == null) {
            written = IntervalSet.createSingletonSet(0L, 0L);
            active = IntervalSet.createSingletonSet(0L, 0L);
        } else {
            written = vfile.getDownloadedBlocks();
            active = vfile.getLeasedBlocks();
        }
        return new GnutellaPieceInfo(written, active, this.getAvailablePieces(), this.getChunkSize(), this.getContentLength());
    }

    @Override
    public synchronized List<RemoteFileDesc> getRemoteFileDescs() {
        return new ArrayList<RemoteFileDesc>(this.currentRFDs);
    }

    @Override
    public synchronized int getQueuePosition() {
        return this.queuePosition;
    }

    @Override
    public int getNumDownloaders() {
        return this.getActiveWorkers().size() + this.getQueuedWorkers().size();
    }

    @Override
    public List<DownloadWorker> getActiveWorkers() {
        return this._activeWorkers;
    }

    @Override
    public synchronized List<DownloadWorker> getAllWorkers() {
        return new ArrayList<DownloadWorker>(this._workers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueuedWorker(DownloadWorker unQueued) {
        if (this.getQueuedWorkers().containsKey(unQueued)) {
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                HashMap<DownloadWorker, Integer> m = new HashMap<DownloadWorker, Integer>(this.getQueuedWorkers());
                m.remove(unQueued);
                this._queuedWorkers = Collections.unmodifiableMap(m);
            }
        }
    }

    private synchronized void addQueuedWorker(DownloadWorker queued, int position) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding queued worker " + queued + " at position " + position + " current queued workers:\n" + this._queuedWorkers);
        }
        if (!this._workers.contains(queued)) {
            throw new IllegalStateException("attempting to queue invalid worker: " + queued);
        }
        if (position < this.queuePosition) {
            this.queuePosition = position;
        }
        HashMap<DownloadWorker, Integer> m = new HashMap<DownloadWorker, Integer>(this.getQueuedWorkers());
        m.put(queued, new Integer(position));
        this._queuedWorkers = Collections.unmodifiableMap(m);
    }

    @Override
    public Map<DownloadWorker, Integer> getQueuedWorkers() {
        return this._queuedWorkers;
    }

    int getWorkerQueuePosition(DownloadWorker worker) {
        Integer i = this.getQueuedWorkers().get(worker);
        return i == null ? -1 : i;
    }

    @Override
    public synchronized boolean killQueuedIfNecessary(DownloadWorker worker, int queuePos) {
        int swarmCapacity;
        if (LOG.isDebugEnabled()) {
            LOG.debug("deciding whether to kill a queued host for (" + queuePos + ") worker " + worker);
        }
        DownloadWorker doomed = null;
        int numDownloaders = this.getNumDownloaders();
        if (numDownloaders <= (swarmCapacity = this.getSwarmCapacity()) && queuePos == -1) {
            return true;
        }
        if (this._queuedWorkers.containsKey(worker) && queuePos > -1) {
            this.addQueuedWorker(worker, queuePos);
            return true;
        }
        if (numDownloaders >= swarmCapacity) {
            int highest = queuePos;
            for (Map.Entry<DownloadWorker, Integer> current : this._queuedWorkers.entrySet()) {
                int currQueue = current.getValue();
                if (currQueue <= highest) continue;
                doomed = current.getKey();
                highest = currQueue;
            }
            if (doomed == null) {
                LOG.debug("not queueing myself");
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("will replace " + doomed);
            }
            doomed.interrupt();
        }
        if (queuePos > -1) {
            this.addQueuedWorker(worker, queuePos);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hashTreeRead(HashTree tree) {
        boolean set = false;
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            HashTree oldTree;
            this.commonOutFile.setHashTreeRequested(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Downloaded tree: " + tree);
            }
            if (tree != null && tree.isBetterTree(oldTree = this.commonOutFile.getHashTree())) {
                set = this.commonOutFile.setHashTree(tree);
            }
        }
        if (set && tree != null) {
            URN sha1 = this.getSha1Urn();
            URN ttroot = tree.getTreeRootUrn();
            this.tigerTreeCache.get().addRoot(sha1, ttroot);
            List<FileDesc> fds = this.library.getFileDescsMatching(sha1);
            for (FileDesc fd : fds) {
                fd.addUrn(ttroot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        for (DownloadWorker worker : this.getActiveWorkers()) {
            c = true;
            HTTPDownloader dloader = worker.getDownloader();
            dloader.measureBandwidth();
            currentTotal += dloader.getAverageBandwidth();
        }
        if (c) {
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
            }
        }
    }

    @Override
    public float getMeasuredBandwidth() {
        float retVal = 0.0f;
        for (DownloadWorker worker : this.getActiveWorkers()) {
            HTTPDownloader dloader = worker.getDownloader();
            float curr = 0.0f;
            try {
                curr = dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            retVal += curr;
        }
        return retVal;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountVerified() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0L : ourFile.getVerifiedBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountLost() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0L : ourFile.getAmountLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChunkSize() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            ourFile = this.commonOutFile;
        }
        return ourFile != null ? ourFile.getChunkSize() : 131072;
    }

    private boolean checkHosts() {
        String s = "LimeWire";
        return s.hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    @Override
    public synchronized void incrementTriedHostsCount() {
        ++this.triedHosts;
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.MANAGED;
    }

    protected synchronized void setIncompleteFile(File incompleteFile) {
        this.incompleteFile = incompleteFile;
    }

    protected synchronized File getIncompleteFile() {
        return this.incompleteFile;
    }

    @Override
    protected DownloadMemento createMemento() {
        return new GnutellaDownloadMementoImpl();
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento memento) throws InvalidDataException {
        super.initFromMemento(memento);
        GnutellaDownloadMemento gmem = (GnutellaDownloadMemento)memento;
        this.setContentLength(gmem.getContentLength());
        if (gmem.getSha1Urn() != null) {
            this.setSha1Urn(gmem.getSha1Urn());
        }
        this.setIncompleteFile(gmem.getIncompleteFile());
        if (gmem.getRemoteHosts().isEmpty() && gmem.getDefaultFileName() == null) {
            throw new InvalidDataException("must have a name!");
        }
        this.addInitialSources(this.toRfds(gmem.getRemoteHosts()), gmem.getDefaultFileName());
        if (this.getIncompleteFile() != null) {
            this.incompleteFileManager.initEntry(this.getIncompleteFile(), gmem.getSavedBlocks(), this.getSha1Urn(), this.shouldPublishIFD());
        }
    }

    protected boolean shouldPublishIFD() {
        return true;
    }

    @Override
    protected void fillInMemento(DownloadMemento memento) {
        GnutellaDownloadMemento gmem = (GnutellaDownloadMemento)memento;
        super.fillInMemento(gmem);
        gmem.setContentLength(this.getContentLength());
        gmem.setSha1Urn(this.getSha1Urn());
        if (this.commonOutFile != null) {
            gmem.setSavedBlocks(this.commonOutFile.getSerializableBlocks());
        }
        gmem.setIncompleteFile(this.getIncompleteFile());
        gmem.setRemoteHosts(this.getRemoteHostMementos());
    }

    private Set<RemoteHostMemento> getRemoteHostMementos() {
        HashSet<RemoteHostMemento> mementos = new HashSet<RemoteHostMemento>(this.cachedRFDs.size());
        for (RemoteFileDesc rfd : this.cachedRFDs) {
            mementos.add(rfd.toMemento());
        }
        return mementos;
    }

    private Collection<RemoteFileDesc> toRfds(Collection<? extends RemoteHostMemento> mementos) throws InvalidDataException {
        if (mementos == null) {
            return Collections.emptyList();
        }
        ArrayList<RemoteFileDesc> rfds = new ArrayList<RemoteFileDesc>(mementos.size());
        for (RemoteHostMemento remoteHostMemento : mementos) {
            rfds.add(this.remoteFileDescFactory.createFromMemento(remoteHostMemento));
        }
        return rfds;
    }

    @Override
    public void addListener(EventListener<DownloadStateEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<DownloadStateEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    protected synchronized SourceRanker getSourceRanker() {
        return this.ranker;
    }

    private RemoteFileDescContext getContext(RemoteFileDesc rfd) {
        RemoteFileDescContext context = (RemoteFileDescContext)this.remoteFileDescToContext.get(rfd);
        if (context != null) {
            return context;
        }
        RemoteFileDescContext newContext = new RemoteFileDescContext(rfd);
        context = this.remoteFileDescToContext.putIfAbsent(rfd, newContext);
        if (context != null) {
            return context;
        }
        return newContext;
    }

    private Collection<RemoteFileDescContext> getContexts(Collection<? extends RemoteFileDesc> rfds) {
        ArrayList<RemoteFileDescContext> contexts = new ArrayList<RemoteFileDescContext>();
        for (RemoteFileDesc remoteFileDesc : rfds) {
            contexts.add(this.getContext(remoteFileDesc));
        }
        return contexts;
    }

    @Override
    public void deleteIncompleteFiles() {
        File incompleteFile = this.getIncompleteFile();
        if (incompleteFile != null) {
            this.incompleteFileManager.removeEntry(incompleteFile);
            FileUtils.delete(incompleteFile, false);
        }
    }

    private class ConnectivityChangeEventHandler
    implements EventListener<ConnectivityChangeEvent> {
        private ConnectivityChangeEventHandler() {
        }

        @Override
        public void handleEvent(ConnectivityChangeEvent event) {
            LOG.debug("connectivity change");
            Collection newConnectableSources = ManagedDownloaderImpl.this.getNewConnectableSources();
            if (LOG.isDebugEnabled()) {
                LOG.debug("new connectables: " + newConnectableSources);
                LOG.debug("all non-connectables" + ManagedDownloaderImpl.this.permanentRFDs);
            }
            if (!newConnectableSources.isEmpty()) {
                ManagedDownloaderImpl.this.receivedNewSources = true;
                ManagedDownloaderImpl.this.addDownloadForced(newConnectableSources, true);
            }
        }
    }

    private class RequeryListenerImpl
    implements RequeryListener {
        private RequeryListenerImpl() {
        }

        @Override
        public QueryRequest createQuery() {
            try {
                return ManagedDownloaderImpl.this.newRequery();
            }
            catch (CantResumeException cre) {
                return null;
            }
        }

        @Override
        public URN getSHA1Urn() {
            return ManagedDownloaderImpl.this.getSha1Urn();
        }

        @Override
        public void lookupFinished(RequeryManager.QueryType queryType) {
            switch (queryType) {
                case DHT: {
                    ManagedDownloaderImpl.this.setStateIfExistingStateIs(Downloader.DownloadState.GAVE_UP, Downloader.DownloadState.QUERYING_DHT);
                    break;
                }
                case GNUTELLA: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadState.GAVE_UP);
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)queryType));
                }
            }
        }

        @Override
        public void lookupPending(RequeryManager.QueryType queryType, int length) {
            switch (queryType) {
                case GNUTELLA: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadState.WAITING_FOR_CONNECTIONS, length);
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)queryType));
                }
            }
        }

        @Override
        public void lookupStarted(RequeryManager.QueryType queryType, long length) {
            switch (queryType) {
                case DHT: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadState.QUERYING_DHT, length);
                    break;
                }
                case GNUTELLA: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadState.WAITING_FOR_GNET_RESULTS, length);
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)queryType));
                }
            }
        }
    }
}

