/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.AbstractDHTController;
import com.limegroup.gnutella.dht.DHTControllerFacade;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.PassiveDHTNodeRouteTable;
import com.limegroup.gnutella.util.EventDispatcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.limewire.core.settings.DHTSettings;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.SecureInputStream;
import org.limewire.io.SecureOutputStream;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.MojitoFactory;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.util.CommonUtils;

public class PassiveDHTNodeController
extends AbstractDHTController {
    private static final File FILE = new File(CommonUtils.getUserSettingsDir(), "passive.mojito");
    private PassiveDHTNodeRouteTable routeTable;

    PassiveDHTNodeController(Vendor vendor, Version version, EventDispatcher<DHTEvent, DHTEventListener> dispatcher, DHTControllerFacade dhtControllerFacade) {
        super(vendor, version, dispatcher, DHTManager.DHTMode.PASSIVE, dhtControllerFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MojitoDHT createMojitoDHT(Vendor vendor, Version version) {
        MojitoDHT dht = MojitoFactory.createFirewalledDHT("PassiveUltrapeerDHT", vendor, version);
        this.routeTable = new PassiveDHTNodeRouteTable(dht);
        dht.setRouteTable(this.routeTable);
        if (DHTSettings.PERSIST_PASSIVE_DHT_ROUTETABLE.getValue() && FILE.exists() && FILE.isFile()) {
            ObjectInputStream ois;
            block7: {
                ois = null;
                try {
                    ois = new ObjectInputStream(new BufferedInputStream(new SecureInputStream(new FileInputStream(FILE))));
                    int routeTableVersion = ois.readInt();
                    if (routeTableVersion < this.getRouteTableVersion()) break block7;
                    Contact node = null;
                    while ((node = (Contact)ois.readObject()) != null) {
                        this.routeTable.add(node);
                    }
                }
                catch (Throwable ignored) {
                    try {
                        this.LOG.error("Throwable", ignored);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.close(ois);
                    }
                }
            }
            IOUtils.close(ois);
        }
        return dht;
    }

    protected void addLeafDHTNode(String host, int port) {
        if (!this.isRunning()) {
            return;
        }
        InetSocketAddress addr = new InetSocketAddress(host, port);
        this.addActiveDHTNode(addr, false);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Adding host: " + addr + " to leaf dht nodes");
        }
        this.routeTable.addLeafDHTNode(host, port);
    }

    protected SocketAddress removeLeafDHTNode(String host, int port) {
        if (!this.isRunning()) {
            return null;
        }
        SocketAddress removed = this.routeTable.removeLeafDHTNode(host, port);
        if (this.LOG.isDebugEnabled() && removed != null) {
            this.LOG.debug("Removed host: " + removed + " from leaf dht nodes");
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void stop() {
        Collection<Contact> contacts;
        if (!this.isRunning()) {
            return;
        }
        super.stop();
        if (DHTSettings.PERSIST_PASSIVE_DHT_ROUTETABLE.getValue() && (contacts = this.routeTable.getActiveContacts()).size() >= 2) {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new BufferedOutputStream(new SecureOutputStream(new FileOutputStream(FILE))));
                oos.writeInt(this.getRouteTableVersion());
                contacts = ContactUtils.sort(contacts, DHTSettings.MAX_PERSISTED_NODES.getValue());
                KUID localNodeID = this.getMojitoDHT().getLocalNodeID();
                for (Contact node : contacts) {
                    if (node.getNodeID().equals(localNodeID)) continue;
                    oos.writeObject(node);
                }
                oos.writeObject(null);
                oos.flush();
            }
            catch (IOException iOException) {
                IOUtils.close(oos);
                catch (Throwable throwable) {
                    IOUtils.close(oos);
                    throw throwable;
                }
            }
            IOUtils.close(oos);
        }
    }

    @Override
    public List<IpPort> getActiveDHTNodes(int maxNodes) {
        if (!this.isRunning() || !this.getMojitoDHT().isBootstrapped()) {
            return Collections.emptyList();
        }
        return this.getMRSNodes(maxNodes, true);
    }

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
        RoutedConnection c = evt.getConnection();
        if (c == null) {
            return;
        }
        String host = c.getAddress();
        int port = c.getPort();
        if (evt.isConnectionClosedEvent()) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Got a connection closed event for connection: " + c);
            }
            this.removeLeafDHTNode(host, port);
        } else if (evt.isConnectionCapabilitiesEvent()) {
            if (c.getConnectionCapabilities().remostHostIsActiveDHTNode() > -1) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Connection is active dht node: " + c);
                }
                this.addLeafDHTNode(host, port);
            } else if (c.getConnectionCapabilities().remostHostIsPassiveDHTNode() > -1) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Connection is passive dht node: " + c);
                }
                this.addPassiveDHTNode(new InetSocketAddress(host, port));
            } else {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Connection is node not connected to the DHT network: " + c);
                }
                this.removeLeafDHTNode(host, port);
            }
        }
    }
}

