/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.UserPreferencesController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractSpinnerModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UserPreferencesPanel
extends JPanel
implements DialogView {
    private final UserPreferencesController controller;
    private JLabel languageLabel;
    private JComboBox languageComboBox;
    private JButton languageLibraryImportButton;
    private JLabel unitLabel;
    private JComboBox unitComboBox;
    private JLabel furnitureCatalogViewLabel;
    private JRadioButton treeRadioButton;
    private JRadioButton listRadioButton;
    private JLabel navigationPanelLabel;
    private JCheckBox navigationPanelCheckBox;
    private JLabel aerialViewCenteredOnSelectionLabel;
    private JCheckBox aerialViewCenteredOnSelectionCheckBox;
    private JLabel magnetismLabel;
    private JCheckBox magnetismCheckBox;
    private JLabel rulersLabel;
    private JCheckBox rulersCheckBox;
    private JLabel gridLabel;
    private JCheckBox gridCheckBox;
    private JLabel furnitureIconLabel;
    private JRadioButton catalogIconRadioButton;
    private JRadioButton topViewRadioButton;
    private JLabel roomRenderingLabel;
    private JRadioButton monochromeRadioButton;
    private JRadioButton floorColorOrTextureRadioButton;
    private JLabel wallPatternLabel;
    private JComboBox wallPatternComboBox;
    private JLabel newWallPatternLabel;
    private JComboBox newWallPatternComboBox;
    private JLabel newWallThicknessLabel;
    private JSpinner newWallThicknessSpinner;
    private JLabel newWallHeightLabel;
    private JSpinner newWallHeightSpinner;
    private JLabel newFloorThicknessLabel;
    private JSpinner newFloorThicknessSpinner;
    private JCheckBox checkUpdatesCheckBox;
    private JButton checkUpdatesNowButton;
    private JCheckBox autoSaveDelayForRecoveryCheckBox;
    private JSpinner autoSaveDelayForRecoverySpinner;
    private JLabel autoSaveDelayForRecoveryUnitLabel;
    private JButton resetDisplayedActionTipsButton;
    private String dialogTitle;

    public UserPreferencesPanel(UserPreferences userPreferences, UserPreferencesController userPreferencesController) {
        super(new GridBagLayout());
        this.controller = userPreferencesController;
        this.createComponents(userPreferences, userPreferencesController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
    }

    private void createComponents(UserPreferences userPreferences, final UserPreferencesController userPreferencesController) {
        Object object;
        boolean bl;
        Object object2;
        Serializable serializable;
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.LANGUAGE)) {
            this.languageLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "languageLabel.text", new Object[0]));
            this.languageComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(userPreferences.getSupportedLanguages()));
            this.languageComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = (String)object;
                    int n2 = string.indexOf("_");
                    Locale locale = n2 != -1 ? new Locale(string.substring(0, n2), string.substring(n2 + 1)) : new Locale(string);
                    String string2 = locale.getDisplayLanguage(locale);
                    string2 = Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                    if (n2 != -1) {
                        string2 = string2 + " - " + locale.getDisplayCountry(locale);
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
                }
            });
            this.languageComboBox.setMaximumRowCount(Integer.MAX_VALUE);
            this.languageComboBox.setSelectedItem(userPreferencesController.getLanguage());
            this.languageComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setLanguage((String)UserPreferencesPanel.this.languageComboBox.getSelectedItem());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.LANGUAGE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.languageComboBox.setSelectedItem(userPreferencesController.getLanguage());
                }
            });
            userPreferences.addPropertyChangeListener(UserPreferences.Property.SUPPORTED_LANGUAGES, new SupportedLanguagesChangeListener(this));
        }
        if (userPreferencesController.mayImportLanguageLibrary()) {
            this.languageLibraryImportButton = new JButton(new ResourceAction(userPreferences, UserPreferencesPanel.class, "IMPORT_LANGUAGE_LIBRARY", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    userPreferencesController.importLanguageLibrary();
                }
            });
            this.languageLibraryImportButton.setToolTipText(userPreferences.getLocalizedString(UserPreferencesPanel.class, "IMPORT_LANGUAGE_LIBRARY.tooltip", new Object[0]));
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.UNIT)) {
            this.unitLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "unitLabel.text", new Object[0]));
            this.unitComboBox = new JComboBox<LengthUnit>(LengthUnit.values());
            serializable = new HashMap<LengthUnit, String>();
            serializable.put(LengthUnit.MILLIMETER, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.millimeter.text", new Object[0]));
            serializable.put(LengthUnit.CENTIMETER, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.centimeter.text", new Object[0]));
            serializable.put(LengthUnit.METER, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.meter.text", new Object[0]));
            serializable.put(LengthUnit.INCH, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.inch.text", new Object[0]));
            serializable.put(LengthUnit.INCH_DECIMALS, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.inchDecimals.text", new Object[0]));
            this.unitComboBox.setRenderer(new DefaultListCellRenderer((Map)((Object)serializable)){
                final /* synthetic */ Map val$comboBoxTexts;
                {
                    this.val$comboBoxTexts = map;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    return super.getListCellRendererComponent((JList<?>)jList, this.val$comboBoxTexts.get(object), n, bl, bl2);
                }
            });
            this.unitComboBox.setSelectedItem((Object)userPreferencesController.getUnit());
            this.unitComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setUnit((LengthUnit)((Object)UserPreferencesPanel.this.unitComboBox.getSelectedItem()));
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.UNIT, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.unitComboBox.setSelectedItem((Object)userPreferencesController.getUnit());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.FURNITURE_CATALOG_VIEWED_IN_TREE)) {
            this.furnitureCatalogViewLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "furnitureCatalogViewLabel.text", new Object[0]));
            this.treeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "treeRadioButton.text", new Object[0]), userPreferencesController.isFurnitureCatalogViewedInTree());
            this.listRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "listRadioButton.text", new Object[0]), !userPreferencesController.isFurnitureCatalogViewedInTree());
            serializable = new ButtonGroup();
            ((ButtonGroup)serializable).add(this.treeRadioButton);
            ((ButtonGroup)serializable).add(this.listRadioButton);
            object2 = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setFurnitureCatalogViewedInTree(UserPreferencesPanel.this.treeRadioButton.isSelected());
                }
            };
            this.treeRadioButton.addItemListener((ItemListener)object2);
            this.listRadioButton.addItemListener((ItemListener)object2);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.FURNITURE_CATALOG_VIEWED_IN_TREE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.treeRadioButton.setSelected(userPreferencesController.isFurnitureCatalogViewedInTree());
                }
            });
        }
        try {
            bl = Boolean.getBoolean("com.eteks.sweethome3d.no3D");
        }
        catch (AccessControlException accessControlException) {
            bl = true;
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NAVIGATION_PANEL_VISIBLE) && !bl) {
            this.navigationPanelLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "navigationPanelLabel.text", new Object[0]));
            this.navigationPanelCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "navigationPanelCheckBox.text", new Object[0]));
            if (!OperatingSystem.isMacOSX() || OperatingSystem.isMacOSXLeopardOrSuperior()) {
                this.navigationPanelCheckBox.setSelected(userPreferencesController.isNavigationPanelVisible());
                this.navigationPanelCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        userPreferencesController.setNavigationPanelVisible(UserPreferencesPanel.this.navigationPanelCheckBox.isSelected());
                    }
                });
                userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NAVIGATION_PANEL_VISIBLE, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        UserPreferencesPanel.this.navigationPanelCheckBox.setSelected(userPreferencesController.isNavigationPanelVisible());
                    }
                });
            } else {
                this.navigationPanelCheckBox.setEnabled(false);
            }
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED)) {
            this.aerialViewCenteredOnSelectionLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "aerialViewCenteredOnSelectionLabel.text", new Object[0]));
            this.aerialViewCenteredOnSelectionCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "aerialViewCenteredOnSelectionCheckBox.text", new Object[0]), userPreferencesController.isAerialViewCenteredOnSelectionEnabled());
            this.aerialViewCenteredOnSelectionCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setAerialViewCenteredOnSelectionEnabled(UserPreferencesPanel.this.aerialViewCenteredOnSelectionCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.aerialViewCenteredOnSelectionCheckBox.setSelected(userPreferencesController.isAerialViewCenteredOnSelectionEnabled());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.MAGNETISM_ENABLED)) {
            this.magnetismLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "magnetismLabel.text", new Object[0]));
            this.magnetismCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "magnetismCheckBox.text", new Object[0]), userPreferencesController.isMagnetismEnabled());
            this.magnetismCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setMagnetismEnabled(UserPreferencesPanel.this.magnetismCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.MAGNETISM_ENABLED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.magnetismCheckBox.setSelected(userPreferencesController.isMagnetismEnabled());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.RULERS_VISIBLE)) {
            this.rulersLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "rulersLabel.text", new Object[0]));
            this.rulersCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "rulersCheckBox.text", new Object[0]), userPreferencesController.isRulersVisible());
            this.rulersCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setRulersVisible(UserPreferencesPanel.this.rulersCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.RULERS_VISIBLE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.rulersCheckBox.setSelected(userPreferencesController.isRulersVisible());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.GRID_VISIBLE)) {
            this.gridLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "gridLabel.text", new Object[0]));
            this.gridCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "gridCheckBox.text", new Object[0]), userPreferencesController.isGridVisible());
            this.gridCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setGridVisible(UserPreferencesPanel.this.gridCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.GRID_VISIBLE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.gridCheckBox.setSelected(userPreferencesController.isGridVisible());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.FURNITURE_VIEWED_FROM_TOP)) {
            this.furnitureIconLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "furnitureIconLabel.text", new Object[0]));
            this.catalogIconRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "catalogIconRadioButton.text", new Object[0]), !userPreferencesController.isFurnitureViewedFromTop());
            this.topViewRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "topViewRadioButton.text", new Object[0]), userPreferencesController.isFurnitureViewedFromTop());
            if (bl) {
                this.catalogIconRadioButton.setEnabled(false);
                this.topViewRadioButton.setEnabled(false);
            } else if (Component3DManager.getInstance().isOffScreenImageSupported()) {
                object2 = new ButtonGroup();
                ((ButtonGroup)object2).add(this.catalogIconRadioButton);
                ((ButtonGroup)object2).add(this.topViewRadioButton);
                object = new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        userPreferencesController.setFurnitureViewedFromTop(UserPreferencesPanel.this.topViewRadioButton.isSelected());
                    }
                };
                this.catalogIconRadioButton.addItemListener((ItemListener)object);
                this.topViewRadioButton.addItemListener((ItemListener)object);
                userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.FURNITURE_VIEWED_FROM_TOP, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        UserPreferencesPanel.this.topViewRadioButton.setSelected(userPreferencesController.isFurnitureViewedFromTop());
                    }
                });
            } else {
                this.catalogIconRadioButton.setEnabled(false);
                this.topViewRadioButton.setEnabled(false);
            }
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.ROOM_FLOOR_COLORED_OR_TEXTURED)) {
            this.roomRenderingLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "roomRenderingLabel.text", new Object[0]));
            this.monochromeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "monochromeRadioButton.text", new Object[0]), !userPreferencesController.isRoomFloorColoredOrTextured());
            this.floorColorOrTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "floorColorOrTextureRadioButton.text", new Object[0]), userPreferencesController.isRoomFloorColoredOrTextured());
            object2 = new ButtonGroup();
            ((ButtonGroup)object2).add(this.monochromeRadioButton);
            ((ButtonGroup)object2).add(this.floorColorOrTextureRadioButton);
            object = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setRoomFloorColoredOrTextured(UserPreferencesPanel.this.floorColorOrTextureRadioButton.isSelected());
                }
            };
            this.monochromeRadioButton.addItemListener((ItemListener)object);
            this.floorColorOrTextureRadioButton.addItemListener((ItemListener)object);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.ROOM_FLOOR_COLORED_OR_TEXTURED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.floorColorOrTextureRadioButton.setSelected(userPreferencesController.isRoomFloorColoredOrTextured());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_WALL_PATTERN)) {
            this.newWallPatternLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newWallPatternLabel.text", new Object[0]));
            object2 = userPreferences.getPatternsCatalog().getPatterns();
            this.newWallPatternComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(object2.toArray()));
            this.newWallPatternComboBox.setRenderer(this.getPatternRenderer());
            object = userPreferencesController.getNewWallPattern();
            this.newWallPatternComboBox.setSelectedItem(object != null ? object : userPreferencesController.getWallPattern());
            this.newWallPatternComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setNewWallPattern((TextureImage)UserPreferencesPanel.this.newWallPatternComboBox.getSelectedItem());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_WALL_PATTERN, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.newWallPatternComboBox.setSelectedItem(userPreferencesController.getNewWallPattern());
                }
            });
        } else if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.WALL_PATTERN)) {
            this.wallPatternLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "wallPatternLabel.text", new Object[0]));
            object2 = userPreferences.getPatternsCatalog().getPatterns();
            this.wallPatternComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(object2.toArray()));
            this.wallPatternComboBox.setRenderer(this.getPatternRenderer());
            this.wallPatternComboBox.setSelectedItem(userPreferencesController.getWallPattern());
            this.wallPatternComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setWallPattern((TextureImage)UserPreferencesPanel.this.wallPatternComboBox.getSelectedItem());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.WALL_PATTERN, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.wallPatternComboBox.setSelectedItem(userPreferencesController.getWallPattern());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_WALL_THICKNESS)) {
            this.newWallThicknessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newWallThicknessLabel.text", new Object[0]));
            object2 = new SpinnerLengthModel(0.5f, 0.125f, 5.0f, 0.005f, userPreferencesController);
            this.newWallThicknessSpinner = new AutoCommitSpinner((SpinnerModel)object2);
            ((SpinnerLengthModel)object2).setLength(userPreferencesController.getNewWallThickness());
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener((SpinnerLengthModel)object2){
                final /* synthetic */ SpinnerLengthModel val$newWallThicknessSpinnerModel;
                {
                    this.val$newWallThicknessSpinnerModel = spinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setNewWallThickness(this.val$newWallThicknessSpinnerModel.getLength());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_WALL_THICKNESS, new PropertyChangeListener((SpinnerLengthModel)object2, userPreferencesController){
                final /* synthetic */ SpinnerLengthModel val$newWallThicknessSpinnerModel;
                final /* synthetic */ UserPreferencesController val$controller;
                {
                    this.val$newWallThicknessSpinnerModel = spinnerLengthModel;
                    this.val$controller = userPreferencesController;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$newWallThicknessSpinnerModel.setLength(this.val$controller.getNewWallThickness());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_WALL_HEIGHT)) {
            this.newWallHeightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newWallHeightLabel.text", new Object[0]));
            object2 = new SpinnerLengthModel(10.0f, 2.0f, 100.0f, 0.1f, userPreferencesController);
            this.newWallHeightSpinner = new AutoCommitSpinner((SpinnerModel)object2);
            ((SpinnerLengthModel)object2).setLength(userPreferencesController.getNewWallHeight());
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener((SpinnerLengthModel)object2){
                final /* synthetic */ SpinnerLengthModel val$newWallHeightSpinnerModel;
                {
                    this.val$newWallHeightSpinnerModel = spinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setNewWallHeight(this.val$newWallHeightSpinnerModel.getLength());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_WALL_HEIGHT, new PropertyChangeListener((SpinnerLengthModel)object2, userPreferencesController){
                final /* synthetic */ SpinnerLengthModel val$newWallHeightSpinnerModel;
                final /* synthetic */ UserPreferencesController val$controller;
                {
                    this.val$newWallHeightSpinnerModel = spinnerLengthModel;
                    this.val$controller = userPreferencesController;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$newWallHeightSpinnerModel.setLength(this.val$controller.getNewWallHeight());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_FLOOR_THICKNESS)) {
            this.newFloorThicknessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newFloorThicknessLabel.text", new Object[0]));
            object2 = new SpinnerLengthModel(0.5f, 0.125f, 5.0f, 0.005f, userPreferencesController);
            this.newFloorThicknessSpinner = new AutoCommitSpinner((SpinnerModel)object2);
            ((SpinnerLengthModel)object2).setLength(userPreferencesController.getNewFloorThickness());
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener((SpinnerLengthModel)object2){
                final /* synthetic */ SpinnerLengthModel val$newFloorThicknessSpinnerModel;
                {
                    this.val$newFloorThicknessSpinnerModel = spinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setNewFloorThickness(this.val$newFloorThicknessSpinnerModel.getLength());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_FLOOR_THICKNESS, new PropertyChangeListener((SpinnerLengthModel)object2, userPreferencesController){
                final /* synthetic */ SpinnerLengthModel val$newFloorThicknessSpinnerModel;
                final /* synthetic */ UserPreferencesController val$controller;
                {
                    this.val$newFloorThicknessSpinnerModel = spinnerLengthModel;
                    this.val$controller = userPreferencesController;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$newFloorThicknessSpinnerModel.setLength(this.val$controller.getNewFloorThickness());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.CHECK_UPDATES_ENABLED)) {
            this.checkUpdatesCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "checkUpdatesCheckBox.text", new Object[0]), userPreferencesController.isCheckUpdatesEnabled());
            this.checkUpdatesCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setCheckUpdatesEnabled(UserPreferencesPanel.this.checkUpdatesCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.CHECK_UPDATES_ENABLED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.checkUpdatesCheckBox.setSelected(userPreferencesController.isCheckUpdatesEnabled());
                }
            });
            this.checkUpdatesNowButton = new JButton(new ResourceAction.ButtonAction(new ResourceAction(userPreferences, UserPreferencesPanel.class, "CHECK_UPDATES_NOW", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    userPreferencesController.checkUpdates();
                }
            }));
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.AUTO_SAVE_DELAY_FOR_RECOVERY)) {
            this.autoSaveDelayForRecoveryCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "autoSaveDelayForRecoveryCheckBox.text", new Object[0]));
            object2 = new SpinnerNumberModel(10, 1, 60, 5){

                public Object getNextValue() {
                    if (((Number)this.getValue()).intValue() == ((Number)((Object)this.getMinimum())).intValue()) {
                        return this.getStepSize();
                    }
                    return super.getNextValue();
                }

                public Object getPreviousValue() {
                    if (((Number)this.getValue()).intValue() - this.getStepSize().intValue() < ((Number)((Object)this.getMinimum())).intValue()) {
                        return super.getMinimum();
                    }
                    return super.getPreviousValue();
                }
            };
            this.autoSaveDelayForRecoverySpinner = new AutoCommitSpinner((SpinnerModel)object2);
            this.autoSaveDelayForRecoveryUnitLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "autoSaveDelayForRecoveryUnitLabel.text", new Object[0]));
            this.updateAutoSaveDelayForRecoveryComponents(userPreferencesController);
            this.autoSaveDelayForRecoveryCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setAutoSaveForRecoveryEnabled(UserPreferencesPanel.this.autoSaveDelayForRecoveryCheckBox.isSelected());
                }
            });
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener((SpinnerNumberModel)object2){
                final /* synthetic */ SpinnerNumberModel val$autoSaveDelayForRecoverySpinnerModel;
                {
                    this.val$autoSaveDelayForRecoverySpinnerModel = spinnerNumberModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setAutoSaveDelayForRecovery(((Number)this.val$autoSaveDelayForRecoverySpinnerModel.getValue()).intValue() * 60000);
                }
            });
            object = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.updateAutoSaveDelayForRecoveryComponents(userPreferencesController);
                }
            };
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.AUTO_SAVE_DELAY_FOR_RECOVERY, (PropertyChangeListener)object);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.AUTO_SAVE_FOR_RECOVERY_ENABLED, (PropertyChangeListener)object);
        }
        this.resetDisplayedActionTipsButton = new JButton(new ResourceAction.ButtonAction(new ResourceAction(userPreferences, UserPreferencesPanel.class, "RESET_DISPLAYED_ACTION_TIPS", true){

            public void actionPerformed(ActionEvent actionEvent) {
                userPreferencesController.resetDisplayedActionTips();
            }
        }));
        this.dialogTitle = userPreferences.getLocalizedString(UserPreferencesPanel.class, "preferences.title", new Object[0]);
    }

    private DefaultListCellRenderer getPatternRenderer() {
        return new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(final JList jList, Object object, int n, boolean bl, boolean bl2) {
                TextureImage textureImage = (TextureImage)object;
                Component component = super.getListCellRendererComponent((JList<?>)jList, "", n, bl, bl2);
                final BufferedImage bufferedImage = SwingTools.getPatternImage(textureImage, jList.getBackground(), jList.getForeground());
                this.setIcon(new Icon(){

                    public int getIconWidth() {
                        return bufferedImage.getWidth() * 4 + 1;
                    }

                    public int getIconHeight() {
                        return bufferedImage.getHeight() + 2;
                    }

                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        for (int i = 0; i < 4; ++i) {
                            graphics2D.drawImage((Image)bufferedImage, n + i * bufferedImage.getWidth(), n2 + 1, jList);
                        }
                        graphics2D.setColor(jList.getForeground());
                        graphics2D.drawRect(n, n2, this.getIconWidth() - 2, this.getIconHeight() - 1);
                    }
                });
                return component;
            }
        };
    }

    private void updateAutoSaveDelayForRecoveryComponents(UserPreferencesController userPreferencesController) {
        int n = userPreferencesController.getAutoSaveDelayForRecovery() / 60000;
        boolean bl = userPreferencesController.isAutoSaveForRecoveryEnabled();
        this.autoSaveDelayForRecoverySpinner.setEnabled(bl);
        this.autoSaveDelayForRecoveryCheckBox.setSelected(bl);
        if (bl) {
            this.autoSaveDelayForRecoverySpinner.setValue(n);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            if (this.languageLabel != null) {
                this.languageLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "languageLabel.mnemonic", new Object[0])).getKeyCode());
                this.languageLabel.setLabelFor(this.languageComboBox);
            }
            if (this.unitLabel != null) {
                this.unitLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitLabel.mnemonic", new Object[0])).getKeyCode());
                this.unitLabel.setLabelFor(this.unitComboBox);
            }
            if (this.furnitureCatalogViewLabel != null) {
                this.treeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "treeRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.listRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "listRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.navigationPanelLabel != null) {
                this.navigationPanelCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "navigationPanelCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.magnetismLabel != null) {
                this.magnetismCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "magnetismCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.aerialViewCenteredOnSelectionLabel != null) {
                this.aerialViewCenteredOnSelectionCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "aerialViewCenteredOnSelectionCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.rulersLabel != null) {
                this.rulersCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "rulersCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.gridLabel != null) {
                this.gridCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "gridCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.furnitureIconLabel != null) {
                this.catalogIconRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "catalogIconRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.topViewRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "topViewRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.roomRenderingLabel != null) {
                this.monochromeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "monochromeRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.floorColorOrTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "floorColorOrTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.newWallPatternLabel != null) {
                this.newWallPatternLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newWallPatternLabel.mnemonic", new Object[0])).getKeyCode());
                this.newWallPatternLabel.setLabelFor(this.newWallPatternComboBox);
            } else if (this.wallPatternLabel != null) {
                this.wallPatternLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "wallPatternLabel.mnemonic", new Object[0])).getKeyCode());
                this.wallPatternLabel.setLabelFor(this.wallPatternComboBox);
            }
            if (this.newWallThicknessLabel != null) {
                this.newWallThicknessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newWallThicknessLabel.mnemonic", new Object[0])).getKeyCode());
                this.newWallThicknessLabel.setLabelFor(this.newWallThicknessSpinner);
            }
            if (this.newWallHeightLabel != null) {
                this.newWallHeightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newWallHeightLabel.mnemonic", new Object[0])).getKeyCode());
                this.newWallHeightLabel.setLabelFor(this.newWallHeightSpinner);
            }
            if (this.newFloorThicknessLabel != null) {
                this.newFloorThicknessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newFloorThicknessLabel.mnemonic", new Object[0])).getKeyCode());
                this.newFloorThicknessLabel.setLabelFor(this.newFloorThicknessSpinner);
            }
            if (this.checkUpdatesCheckBox != null) {
                this.checkUpdatesCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "checkUpdatesCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.autoSaveDelayForRecoveryCheckBox != null) {
                this.autoSaveDelayForRecoveryCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "autoSaveDelayForRecoveryCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        Insets insets = new Insets(0, 0, 5, 5);
        Insets insets2 = new Insets(0, 0, 10, 5);
        Insets insets3 = new Insets(0, 0, 5, 0);
        Insets insets4 = new Insets(0, 0, 10, 0);
        if (this.languageLabel != null) {
            this.add((Component)this.languageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.languageComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(OperatingSystem.isMacOSX() ? 1 : 0, 0, 5, 0), 0, 0));
            if (this.languageLibraryImportButton != null) {
                this.add((Component)this.languageLibraryImportButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 5, 0), 0, 0));
            }
        }
        if (this.unitLabel != null) {
            this.add((Component)this.unitLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.unitComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        }
        if (this.furnitureCatalogViewLabel != null) {
            this.add((Component)this.furnitureCatalogViewLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.treeRadioButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
            this.add((Component)this.listRadioButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.navigationPanelLabel != null) {
            this.add((Component)this.navigationPanelLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.navigationPanelCheckBox, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.aerialViewCenteredOnSelectionLabel != null) {
            this.add((Component)this.aerialViewCenteredOnSelectionLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            this.add((Component)this.aerialViewCenteredOnSelectionCheckBox, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 21, 0, insets4, 0, 0));
        }
        if (this.magnetismLabel != null) {
            this.add((Component)this.magnetismLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.magnetismCheckBox, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.rulersLabel != null) {
            this.add((Component)this.rulersLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.rulersCheckBox, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.gridLabel != null) {
            this.add((Component)this.gridLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.gridCheckBox, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.furnitureIconLabel != null) {
            this.add((Component)this.furnitureIconLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.catalogIconRadioButton, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
            this.add((Component)this.topViewRadioButton, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.roomRenderingLabel != null) {
            this.add((Component)this.roomRenderingLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.monochromeRadioButton, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
            this.add((Component)this.floorColorOrTextureRadioButton, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.newWallPatternLabel != null) {
            this.add((Component)this.newWallPatternLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newWallPatternComboBox, new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        } else if (this.wallPatternLabel != null) {
            this.add((Component)this.wallPatternLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.wallPatternComboBox, new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.newWallThicknessLabel != null) {
            this.add((Component)this.newWallThicknessLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newWallThicknessSpinner, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        }
        if (this.newWallHeightLabel != null) {
            this.add((Component)this.newWallHeightLabel, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newWallHeightSpinner, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        }
        if (this.newFloorThicknessLabel != null) {
            this.add((Component)this.newFloorThicknessLabel, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newFloorThicknessSpinner, new GridBagConstraints(1, 14, 1, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        }
        if (this.checkUpdatesCheckBox != null || this.autoSaveDelayForRecoveryCheckBox != null) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            if (this.checkUpdatesCheckBox != null) {
                jPanel.add((Component)this.checkUpdatesCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
                jPanel.add((Component)this.checkUpdatesNowButton, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
            }
            if (this.autoSaveDelayForRecoveryCheckBox != null) {
                jPanel.add((Component)this.autoSaveDelayForRecoveryCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
                jPanel.add((Component)this.autoSaveDelayForRecoverySpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
                jPanel.add((Component)this.autoSaveDelayForRecoveryUnitLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.add((Component)jPanel, new GridBagConstraints(0, 15, 3, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        }
        if (this.resetDisplayedActionTipsButton.getText() != null && this.resetDisplayedActionTipsButton.getText().length() > 0) {
            this.add((Component)this.resetDisplayedActionTipsButton, new GridBagConstraints(0, 16, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.languageComboBox) == 0 && this.controller != null) {
            this.controller.modifyUserPreferences();
        }
    }

    private static class SpinnerLengthModel
    extends SpinnerNumberModel {
        private LengthUnit unit = LengthUnit.CENTIMETER;

        public SpinnerLengthModel(final float f, final float f2, final float f3, final float f4, final UserPreferencesController userPreferencesController) {
            super(new Float(1.0f), new Float(0.0f), new Float(100000.0f), new Float(f));
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.UNIT, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SpinnerLengthModel.this.updateStepsAndLength(f, f2, f3, f4, userPreferencesController);
                }
            });
            this.updateStepsAndLength(f, f2, f3, f4, userPreferencesController);
        }

        private void updateStepsAndLength(float f, float f2, float f3, float f4, UserPreferencesController userPreferencesController) {
            float f5 = this.getLength();
            this.unit = userPreferencesController.getUnit();
            switch (userPreferencesController.getUnit()) {
                case MILLIMETER: {
                    this.setStepSize(Float.valueOf(f3));
                    break;
                }
                case CENTIMETER: {
                    this.setStepSize(Float.valueOf(f));
                    break;
                }
                case METER: {
                    this.setStepSize(Float.valueOf(f4));
                    break;
                }
                case INCH: 
                case INCH_DECIMALS: {
                    this.setStepSize(Float.valueOf(f2));
                }
            }
            this.setLength(f5);
        }

        public float getLength() {
            return this.unit.unitToCentimeter(this.getNumber().floatValue());
        }

        public void setLength(float f) {
            this.setValue(Float.valueOf(this.unit.centimeterToUnit(f)));
        }
    }

    private static class SupportedLanguagesChangeListener
    implements PropertyChangeListener {
        private WeakReference<UserPreferencesPanel> userPreferencesPanel;

        public SupportedLanguagesChangeListener(UserPreferencesPanel userPreferencesPanel) {
            this.userPreferencesPanel = new WeakReference<UserPreferencesPanel>(userPreferencesPanel);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            UserPreferencesPanel userPreferencesPanel = (UserPreferencesPanel)this.userPreferencesPanel.get();
            if (userPreferencesPanel == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.SUPPORTED_LANGUAGES, this);
            } else {
                JComboBox jComboBox = userPreferencesPanel.languageComboBox;
                List<String> list = Arrays.asList((String[])propertyChangeEvent.getOldValue());
                String[] stringArray = (String[])propertyChangeEvent.getNewValue();
                jComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
                for (String string : stringArray) {
                    if (list.contains(string)) continue;
                    jComboBox.setSelectedItem(string);
                    return;
                }
                jComboBox.setSelectedItem(userPreferencesPanel.controller.getLanguage());
            }
        }
    }
}

