/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.j3d.HomePieceOfFurniture3D;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.sun.j3d.exp.swing.JCanvas3D;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelPreviewComponent
extends JComponent {
    private SimpleUniverse universe;
    private JPanel component3DPanel;
    private Component component3D;
    private BranchGroup sceneTree;
    private float viewYaw = 0.3926991f;
    private float viewPitch = -0.19634955f;
    private float viewScale = 1.0f;
    private boolean parallelProjection;
    private Object iconImageLock;
    private HomePieceOfFurniture previewedPiece;
    private Map<Texture, Texture> pieceTextures = new HashMap<Texture, Texture>();

    public ModelPreviewComponent() {
        this(false);
    }

    public ModelPreviewComponent(boolean bl) {
        this(true, bl, bl);
    }

    public ModelPreviewComponent(boolean bl, boolean bl2, boolean bl3) {
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.sceneTree = this.createSceneTree();
        this.component3DPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add(this.component3DPanel);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment.getScreenDevices().length == 1) {
            this.createComponent3D(graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration(), bl, bl2, bl3);
        }
        this.addAncestorListener(bl, bl2, bl3);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return new Dimension(200, 200);
    }

    @Override
    public void addMouseMotionListener(final MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        if (this.component3D != null) {
            this.component3D.addMouseMotionListener(new MouseMotionListener(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    mouseMotionListener.mouseMoved(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    mouseMotionListener.mouseDragged(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }
            });
        }
    }

    @Override
    public void addMouseListener(final MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this.component3D != null) {
            this.component3D.addMouseListener(new MouseListener(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    mouseListener.mouseReleased(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    mouseListener.mousePressed(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    mouseListener.mouseExited(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseListener.mouseEntered(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    mouseListener.mouseClicked(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }
            });
        }
    }

    JComponent getComponent3D() {
        return this.component3DPanel;
    }

    private void addAncestorListener(final boolean bl, final boolean bl2, final boolean bl3) {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (ModelPreviewComponent.this.component3D == null) {
                    ModelPreviewComponent.this.createComponent3D(ancestorEvent.getAncestor().getGraphicsConfiguration(), bl, bl2, bl3);
                }
                if (ModelPreviewComponent.this.universe == null) {
                    ModelPreviewComponent.this.createUniverse();
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (ModelPreviewComponent.this.universe != null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ModelPreviewComponent.this.disposeUniverse();
                            ModelPreviewComponent.this.component3DPanel.removeAll();
                            ModelPreviewComponent.this.component3D = null;
                        }
                    });
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void createComponent3D(GraphicsConfiguration graphicsConfiguration, boolean bl, boolean bl2, boolean bl3) {
        if (Boolean.getBoolean("com.eteks.sweethome3d.j3d.useOffScreen3DView")) {
            GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
            graphicsConfigTemplate3D.setSceneAntialiasing(2);
            try {
                this.component3D = (Component)Class.forName(ModelPreviewComponent.class.getName() + "$JCanvas3DWithNotifiedPaint").getConstructor(ModelPreviewComponent.class, GraphicsConfigTemplate3D.class).newInstance(this, graphicsConfigTemplate3D);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnsupportedOperationException("Java 3D 1.5 required to display an offscreen 3D view");
            }
            catch (Exception exception) {
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                unsupportedOperationException.initCause(exception);
                throw unsupportedOperationException;
            }
        } else {
            this.component3D = Component3DManager.getInstance().getOnscreenCanvas3D(graphicsConfiguration, new Component3DManager.RenderingObserver(){

                public void canvas3DPreRendered(Canvas3D canvas3D) {
                }

                public void canvas3DPostRendered(Canvas3D canvas3D) {
                }

                public void canvas3DSwapped(Canvas3D canvas3D) {
                    ModelPreviewComponent.this.canvas3DSwapped();
                }
            });
        }
        this.component3D.setBackground(new Color(0xE5E5E5));
        this.component3DPanel.setLayout(new GridLayout());
        this.component3DPanel.add(this.component3D);
        this.component3D.setFocusable(false);
        this.addMouseListeners(this.component3D, bl, bl2, bl3);
    }

    private void addMouseListeners(final Component component, final boolean bl, final boolean bl2, final boolean bl3) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private int xLastMouseMove;
            private int yLastMouseMove;

            public void mousePressed(MouseEvent mouseEvent) {
                this.xLastMouseMove = mouseEvent.getX();
                this.yLastMouseMove = mouseEvent.getY();
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ModelPreviewComponent.this.getModelNode() != null) {
                    if (bl) {
                        ModelPreviewComponent.this.setViewYaw(ModelPreviewComponent.this.getViewYaw() - 0.02f * (float)(mouseEvent.getX() - this.xLastMouseMove));
                    }
                    this.xLastMouseMove = mouseEvent.getX();
                    if (bl3 && mouseEvent.isAltDown()) {
                        ModelPreviewComponent.this.setViewScale(Math.max(0.5f, Math.min(1.3f, ModelPreviewComponent.this.getViewScale() * (float)Math.exp((float)(mouseEvent.getY() - this.yLastMouseMove) * 0.02f))));
                    } else if (bl2 && !mouseEvent.isAltDown()) {
                        ModelPreviewComponent.this.setViewPitch(Math.max(-0.7853982f, Math.min(0.0f, ModelPreviewComponent.this.getViewPitch() - 0.02f * (float)(mouseEvent.getY() - this.yLastMouseMove))));
                    }
                    this.yLastMouseMove = mouseEvent.getY();
                }
            }
        };
        component.addMouseListener(mouseInputAdapter);
        component.addMouseMotionListener(mouseInputAdapter);
        if (bl3) {
            component.addMouseWheelListener(new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    ModelPreviewComponent.this.setViewScale(Math.max(0.5f, Math.min(1.3f, ModelPreviewComponent.this.getViewScale() * (float)Math.exp((float)mouseWheelEvent.getWheelRotation() * 0.02f))));
                }
            });
        }
        for (final MouseMotionListener eventListener : (MouseMotionListener[])this.getListeners(MouseMotionListener.class)) {
            component.addMouseMotionListener(new MouseMotionListener(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    eventListener.mouseMoved(SwingUtilities.convertMouseEvent(component, mouseEvent, ModelPreviewComponent.this));
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    eventListener.mouseDragged(SwingUtilities.convertMouseEvent(component, mouseEvent, ModelPreviewComponent.this));
                }
            });
        }
        for (EventListener eventListener : (MouseListener[])this.getListeners(MouseListener.class)) {
            component.addMouseListener(new MouseListener((MouseListener)eventListener, component){
                final /* synthetic */ MouseListener val$l;
                final /* synthetic */ Component val$component3D;
                {
                    this.val$l = mouseListener;
                    this.val$component3D = component;
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.val$l.mouseReleased(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.val$l.mousePressed(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.val$l.mouseExited(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.val$l.mouseEntered(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.val$l.mouseClicked(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }
            });
        }
    }

    private void createUniverse() {
        Canvas3D canvas3D;
        if (this.component3D instanceof Canvas3D) {
            canvas3D = (Canvas3D)this.component3D;
        } else {
            try {
                canvas3D = (Canvas3D)Class.forName("com.sun.j3d.exp.swing.JCanvas3D").getMethod("getOffscreenCanvas3D", new Class[0]).invoke((Object)this.component3D, new Object[0]);
            }
            catch (Exception exception) {
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                unsupportedOperationException.initCause(exception);
                throw unsupportedOperationException;
            }
        }
        ViewingPlatform viewingPlatform = new ViewingPlatform();
        Viewer viewer = new Viewer(canvas3D);
        this.universe = new SimpleUniverse(viewingPlatform, viewer);
        this.universe.getViewer().getView().setProjectionPolicy(this.parallelProjection ? 0 : 1);
        this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        this.universe.addBranchGraph(this.sceneTree);
        this.revalidate();
        this.repaint();
        if (OperatingSystem.isMacOSX()) {
            final Component component = SwingUtilities.getRoot(this);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != component) {
                        component.requestFocus();
                    }
                }
            });
        }
    }

    private void disposeUniverse() {
        this.universe.getLocale().removeBranchGraph(this.sceneTree);
        this.universe.cleanup();
        this.universe = null;
    }

    protected float getViewYaw() {
        return this.viewYaw;
    }

    protected void setViewYaw(float f) {
        this.viewYaw = f;
        if (this.universe != null) {
            this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        }
    }

    protected float getViewScale() {
        return this.viewScale;
    }

    protected void setViewScale(float f) {
        this.viewScale = f;
        if (this.universe != null) {
            this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        }
    }

    protected float getViewPitch() {
        return this.viewPitch;
    }

    protected void setViewPitch(float f) {
        this.viewPitch = f;
        if (this.universe != null) {
            this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        }
    }

    protected void setParallelProjection(boolean bl) {
        this.parallelProjection = bl;
        if (this.universe != null) {
            this.universe.getViewer().getView().setProjectionPolicy(bl ? 0 : 1);
        }
    }

    protected boolean isParallelProjection() {
        return this.parallelProjection;
    }

    private void updateViewPlatformTransform(TransformGroup transformGroup, float f, float f2, float f3) {
        double d = 1.4 / Math.tan(0.39269908169872414);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX((double)f2);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY((double)f);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.setTranslation(new Vector3d(Math.sin(f) * d * Math.cos(f2), d * Math.sin(-f2), Math.cos(f) * d * Math.cos(f2)));
        Transform3D transform3D4 = new Transform3D();
        transform3D4.setScale((double)f3);
        transform3D2.mul(transform3D);
        transform3D3.mul(transform3D2);
        transform3D4.mul(transform3D3);
        transformGroup.setTransform(transform3D4);
    }

    private BranchGroup createSceneTree() {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.addChild(this.createModelTree());
        branchGroup.addChild(this.createBackgroundNode());
        for (Light light : this.createLights()) {
            branchGroup.addChild((Node)light);
        }
        return branchGroup;
    }

    private Node createBackgroundNode() {
        Background background = new Background(new Color3f(0.9f, 0.9f, 0.9f));
        background.setCapability(17);
        background.setApplicationBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        return background;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        ((Background)this.sceneTree.getChild(1)).setColor(new Color3f(color));
    }

    private Light[] createLights() {
        Light[] lightArray;
        for (Light light : lightArray = new Light[]{new DirectionalLight(new Color3f(0.9f, 0.9f, 0.9f), new Vector3f(1.732f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.9f, 0.9f, 0.9f), new Vector3f(-1.732f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.9f, 0.9f, 0.9f), new Vector3f(0.0f, -0.8f, 1.0f)), new DirectionalLight(new Color3f(0.66f, 0.66f, 0.66f), new Vector3f(0.0f, 1.0f, 0.0f)), new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f))}) {
            light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        }
        return lightArray;
    }

    private Node createModelTree() {
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.setCapability(14);
        transformGroup.setCapability(18);
        return transformGroup;
    }

    public Content getModel() {
        return this.previewedPiece.getModel();
    }

    public void setModel(final Content content) {
        final TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
        transformGroup.removeAllChildren();
        this.previewedPiece = null;
        this.pieceTextures.clear();
        if (content != null) {
            final AtomicReference atomicReference = new AtomicReference();
            ModelManager.getInstance().loadModel(content, true, new ModelManager.ModelObserver(){

                public void modelUpdated(BranchGroup branchGroup) {
                    if (branchGroup.numChildren() > 0) {
                        try {
                            Vector3f vector3f = ModelManager.getInstance().getSize((Node)branchGroup);
                            ModelPreviewComponent.this.previewedPiece = new HomePieceOfFurniture(new CatalogPieceOfFurniture(null, null, content, vector3f.x, vector3f.z, vector3f.y, 0.0f, false, null, null, false, 0.0f, false));
                            ModelPreviewComponent.this.previewedPiece.setX(0.0f);
                            ModelPreviewComponent.this.previewedPiece.setY(0.0f);
                            ModelPreviewComponent.this.previewedPiece.setElevation(-ModelPreviewComponent.this.previewedPiece.getHeight() / 2.0f);
                            Transform3D transform3D = new Transform3D();
                            transform3D.setScale(1.8 / (double)Math.max(Math.max(vector3f.x, vector3f.z), vector3f.y));
                            transformGroup.setTransform(transform3D);
                            HomePieceOfFurniture3D homePieceOfFurniture3D = new HomePieceOfFurniture3D(ModelPreviewComponent.this.previewedPiece, null, true, true);
                            if (OperatingSystem.isMacOSX()) {
                                ModelPreviewComponent.this.cloneTextures((Node)homePieceOfFurniture3D, ModelPreviewComponent.this.pieceTextures);
                            }
                            transformGroup.addChild((Node)homePieceOfFurniture3D);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }

                public void modelError(Exception exception) {
                    atomicReference.set(new IllegalArgumentException("Couldn't load model", exception));
                }
            });
            if (atomicReference.get() != null) {
                throw (IllegalArgumentException)atomicReference.get();
            }
        }
    }

    protected void setBackFaceShown(boolean bl) {
        if (this.previewedPiece != null) {
            this.previewedPiece = new HomePieceOfFurniture(new CatalogPieceOfFurniture(null, null, this.previewedPiece.getModel(), this.previewedPiece.getWidth(), this.previewedPiece.getDepth(), this.previewedPiece.getHeight(), 0.0f, false, this.previewedPiece.getColor(), null, bl, 0.0f, false));
            this.previewedPiece.setX(0.0f);
            this.previewedPiece.setY(0.0f);
            this.previewedPiece.setElevation(-this.previewedPiece.getHeight() / 2.0f);
            TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
            transformGroup.addChild((Node)new HomePieceOfFurniture3D(this.previewedPiece, null, true, true));
            if (transformGroup.numChildren() > 1) {
                transformGroup.removeChild(0);
            }
        }
    }

    private HomePieceOfFurniture3D getModelNode() {
        TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
        if (transformGroup.numChildren() > 0) {
            return (HomePieceOfFurniture3D)transformGroup.getChild(0);
        }
        return null;
    }

    protected void setModelRotation(float[][] fArray) {
        HomePieceOfFurniture3D homePieceOfFurniture3D = this.getModelNode();
        if (homePieceOfFurniture3D != null && homePieceOfFurniture3D.numChildren() > 0) {
            Transform3D transform3D;
            Transform3D transform3D2 = new Transform3D();
            if (fArray != null) {
                transform3D = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
                transform3D2.setRotation((Matrix3f)transform3D);
            }
            transform3D = new Transform3D();
            Vector3f vector3f = ModelManager.getInstance().getSize((Node)homePieceOfFurniture3D);
            transform3D.setScale(1.8 / (double)Math.max(Math.max(vector3f.x, vector3f.z), vector3f.y));
            transform3D.mul(transform3D2);
            TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
            transformGroup.setTransform(transform3D);
        }
    }

    protected void setModelRotationAndSize(float[][] fArray, float f, float f2, float f3) {
        HomePieceOfFurniture3D homePieceOfFurniture3D = this.getModelNode();
        if (homePieceOfFurniture3D != null && homePieceOfFurniture3D.numChildren() > 0) {
            Vector3f vector3f;
            Transform3D transform3D = ModelManager.getInstance().getNormalizedTransform((Node)homePieceOfFurniture3D, fArray, 1.0f);
            Transform3D transform3D2 = new Transform3D();
            if (f != 0.0f && f2 != 0.0f && f3 != 0.0f) {
                transform3D2.setScale(new Vector3d((double)f, (double)f3, (double)f2));
            }
            transform3D2.mul(transform3D);
            Transform3D transform3D3 = new Transform3D();
            if (f != 0.0f && f2 != 0.0f && f3 != 0.0f) {
                transform3D3.setScale(1.8 / (double)Math.max(Math.max(f, f3), f2));
            } else {
                vector3f = ModelManager.getInstance().getSize((Node)homePieceOfFurniture3D);
                transform3D3.setScale(1.8 / (double)Math.max(Math.max(vector3f.x, vector3f.z), vector3f.y));
            }
            transform3D3.mul(transform3D2);
            vector3f = (TransformGroup)this.sceneTree.getChild(0);
            vector3f.setTransform(transform3D3);
        }
    }

    protected void setModelColor(Integer n) {
        if (this.previewedPiece != null && this.previewedPiece.getColor() != n) {
            this.previewedPiece.setColor(n);
            this.getModelNode().update();
        }
    }

    public void setModelMaterials(HomeMaterial[] homeMaterialArray) {
        if (this.previewedPiece != null) {
            this.previewedPiece.setModelMaterials(homeMaterialArray);
            this.getModelNode().update();
            this.cloneTextures((Node)this.getModelNode(), this.pieceTextures);
        }
    }

    private void cloneTextures(Node node, Map<Texture, Texture> map) {
        Texture texture;
        Appearance appearance;
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.cloneTextures((Node)enumeration.nextElement(), map);
            }
        } else if (node instanceof Link) {
            this.cloneTextures((Node)((Link)node).getSharedGroup(), map);
        } else if (node instanceof Shape3D && (appearance = ((Shape3D)node).getAppearance()) != null && (texture = appearance.getTexture()) != null) {
            Texture texture2 = map.get(texture);
            if (texture2 == null) {
                texture2 = (Texture)texture.cloneNodeComponent(false);
                map.put(texture, texture2);
            }
            appearance.setTexture(texture2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getIconImage(int n) {
        Object object;
        Object object2;
        Color color = this.getBackground();
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = null;
        this.iconImageLock = new Object();
        try {
            Object object3;
            object2 = new Point();
            SwingUtilities.convertPointToScreen((Point)object2, this.component3D);
            object = new Robot();
            if (this.iconImageLock != null) {
                object3 = this.iconImageLock;
                synchronized (object3) {
                    this.setBackground(Color.WHITE);
                    try {
                        this.iconImageLock.wait(n / 2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            bufferedImage = ((Robot)object).createScreenCapture(new Rectangle((Point)object2, this.component3D.getSize()));
            if (this.iconImageLock != null) {
                object3 = this.iconImageLock;
                synchronized (object3) {
                    this.setBackground(Color.BLACK);
                    try {
                        this.iconImageLock.wait(n / 2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            bufferedImage2 = ((Robot)object).createScreenCapture(new Rectangle((Point)object2, this.component3D.getSize()));
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        finally {
            this.iconImageLock = null;
            this.setBackground(color);
        }
        object2 = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        object = bufferedImage2.getRGB(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null, 0, bufferedImage2.getWidth());
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (object[i] == object2[i] || object[i] != -16777216 || object2[i] != -1) continue;
            object2[i] = false;
        }
        BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage3.getGraphics();
        graphics2D.drawImage(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bufferedImage.getWidth(), bufferedImage.getHeight(), (int[])object2, 0, bufferedImage.getWidth())), null, null);
        graphics2D.dispose();
        return bufferedImage3;
    }

    public Content getIcon(int n) throws IOException {
        File file = OperatingSystem.createTemporaryFile("icon", ".png");
        ImageIO.write((RenderedImage)this.getIconImage(n), "png", file);
        return new TemporaryURLContent(file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canvas3DSwapped() {
        if (this.iconImageLock != null) {
            Object object = this.iconImageLock;
            synchronized (object) {
                this.iconImageLock.notify();
            }
        }
    }

    private static class JCanvas3DWithNotifiedPaint
    extends JCanvas3D {
        private final ModelPreviewComponent homeComponent3D;

        public JCanvas3DWithNotifiedPaint(ModelPreviewComponent modelPreviewComponent, GraphicsConfigTemplate3D graphicsConfigTemplate3D) {
            super(graphicsConfigTemplate3D);
            this.homeComponent3D = modelPreviewComponent;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.homeComponent3D.canvas3DSwapped();
        }
    }
}

