/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Wall;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.EventQueue;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wall3D
extends Object3DBranch {
    private static final TextureAttributes MODULATE_TEXTURE_ATTRIBUTES = new TextureAttributes();
    private static final float LEVEL_ELEVATION_SHIFT = 0.1f;
    private static final Area FULL_FACE_CUT_OUT_AREA = new Area(new Rectangle2D.Float(-0.5f, 0.5f, 1.0f, 1.0f));
    private static final int WALL_LEFT_SIDE = 0;
    private static final int WALL_RIGHT_SIDE = 1;
    private static Map<HomePieceOfFurniture, ModelRotationTuple> doorOrWindowRotatedModels;
    private static Map<ModelRotationTuple, Area> rotatedModelsFrontAreas;
    private final Home home;

    public Wall3D(Wall wall, Home home) {
        this(wall, home, false, false);
    }

    public Wall3D(Wall wall, Home home, boolean bl, boolean bl2) {
        this.setUserData(wall);
        this.home = home;
        this.setCapability(17);
        this.setCapability(12);
        for (int i = 0; i < 6; ++i) {
            Group group = new Group();
            group.setCapability(12);
            group.addChild(this.createWallPartShape(false));
            if (!bl) {
                group.addChild(this.createWallPartShape(true));
            }
            this.addChild((Node)group);
        }
        this.updateWallGeometry(bl2);
        this.updateWallAppearance(bl2);
    }

    private Node createWallPartShape(boolean bl) {
        Shape3D shape3D = new Shape3D();
        shape3D.setCapability(13);
        shape3D.setCapability(12);
        shape3D.setCapability(14);
        Appearance appearance = new Appearance();
        shape3D.setAppearance(appearance);
        appearance.setCapability(10);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setCapability(1);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setCapability(12);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        appearance.setRenderingAttributes(renderingAttributes);
        if (bl) {
            appearance.setColoringAttributes(Object3DBranch.OUTLINE_COLORING_ATTRIBUTES);
            appearance.setPolygonAttributes(Object3DBranch.OUTLINE_POLYGON_ATTRIBUTES);
            appearance.setLineAttributes(Object3DBranch.OUTLINE_LINE_ATTRIBUTES);
        } else {
            appearance.setCapability(1);
            appearance.setMaterial(DEFAULT_MATERIAL);
            appearance.setCapability(3);
            appearance.setCapability(2);
            appearance.setTextureAttributes(MODULATE_TEXTURE_ATTRIBUTES);
        }
        return shape3D;
    }

    @Override
    public void update() {
        this.updateWallGeometry(false);
        this.updateWallAppearance(false);
    }

    private void updateWallGeometry(boolean bl) {
        this.updateWallSideGeometry(0, ((Wall)this.getUserData()).getLeftSideTexture(), bl);
        this.updateWallSideGeometry(1, ((Wall)this.getUserData()).getRightSideTexture(), bl);
    }

    private void updateWallSideGeometry(int n, HomeTexture homeTexture, boolean bl) {
        int n2;
        Group[] groupArray = new Group[]{(Group)this.getChild(n * 3), (Group)this.getChild(n * 3 + 1), (Group)this.getChild(n * 3 + 2)};
        Shape3D[] shape3DArray = new Shape3D[groupArray.length];
        Shape3D[] shape3DArray2 = new Shape3D[groupArray.length];
        int[] nArray = new int[3];
        for (int i = 0; i < groupArray.length; ++i) {
            shape3DArray[i] = (Shape3D)groupArray[i].getChild(0);
            shape3DArray2[i] = groupArray[i].numChildren() > 1 ? (Shape3D)groupArray[i].getChild(1) : null;
            nArray[i] = shape3DArray[i].numGeometries();
        }
        Wall wall = (Wall)this.getUserData();
        if (wall.getLevel() == null || wall.getLevel().isVisible()) {
            List[] listArray = new List[]{new ArrayList(), new ArrayList(), new ArrayList()};
            this.createWallGeometries(listArray[0], listArray[1], listArray[2], n, homeTexture, bl);
            for (n2 = 0; n2 < groupArray.length; ++n2) {
                for (Geometry geometry : listArray[n2]) {
                    if (geometry == null) continue;
                    shape3DArray[n2].addGeometry(geometry);
                    if (shape3DArray2[n2] == null) continue;
                    shape3DArray2[n2].addGeometry(geometry);
                }
            }
        }
        for (int i = 0; i < groupArray.length; ++i) {
            for (n2 = nArray[i] - 1; n2 >= 0; --n2) {
                shape3DArray[i].removeGeometry(n2);
                if (shape3DArray2[i] == null) continue;
                shape3DArray2[i].removeGeometry(n2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createWallGeometries(List<Geometry> list, List<Geometry> list2, List<Geometry> list3, int n, HomeTexture homeTexture, boolean bl) {
        Object object;
        Object object22;
        Object object3;
        double d;
        double d2;
        boolean bl2;
        float[][] fArray = this.getWallSidePoints(n);
        float[] fArray2 = n == 0 ? fArray[0] : fArray[fArray.length - 1];
        Shape shape = this.getShape(fArray);
        Area area = new Area(shape);
        float f = this.getWallElevation();
        float f2 = this.getWallHeightAtStart();
        float f3 = this.getWallHeightAtEnd();
        float f4 = Math.max(f2, f3);
        Wall wall = (Wall)this.getUserData();
        double d3 = Math.atan2(wall.getYEnd() - wall.getYStart(), wall.getXEnd() - wall.getXStart());
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = d4 * (double)wall.getXStart() + d5 * (double)wall.getYStart();
        double d7 = d4 * (double)wall.getXEnd() + d5 * (double)wall.getYEnd();
        boolean bl3 = bl2 = wall.getArcExtent() != null && wall.getArcExtent().floatValue() != 0.0f;
        if (f2 == f3) {
            d2 = 0.0;
            d = f2;
        } else {
            d2 = (double)(f3 - f2) / (d7 - d6);
            d = (double)f2 - d2 * d6;
        }
        ArrayList<DoorOrWindowArea> arrayList = new ArrayList<DoorOrWindowArea>();
        ArrayList<HomePieceOfFurniture> arrayList2 = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture object62 : this.getVisibleDoorsAndWindows(this.home.getFurniture())) {
            float f5 = object62.getGroundElevation();
            if (!(f5 + object62.getHeight() > f) || !(f5 < f4)) continue;
            Shape shape2 = this.getShape(object62.getPoints());
            Area area2 = new Area(shape2);
            Area area3 = new Area(shape);
            area3.intersect(area2);
            if (area3.isEmpty()) continue;
            arrayList.add(new DoorOrWindowArea(area3, Arrays.asList(object62)));
            arrayList2.add(object62);
            area.subtract(area2);
        }
        if (arrayList.size() > 1) {
            for (int i = 0; i < arrayList.size(); ++i) {
                DoorOrWindowArea doorOrWindowArea = (DoorOrWindowArea)arrayList.get(i);
                ArrayList<DoorOrWindowArea> arrayList3 = new ArrayList<DoorOrWindowArea>();
                int n2 = 0;
                for (DoorOrWindowArea doorOrWindowArea2 : arrayList) {
                    if (doorOrWindowArea.getArea().isEmpty()) break;
                    if (n2 > i) {
                        object3 = new Area(doorOrWindowArea2.getArea());
                        ((Area)object3).intersect(doorOrWindowArea.getArea());
                        if (!((Area)object3).isEmpty()) {
                            doorOrWindowArea2.getArea().subtract((Area)object3);
                            doorOrWindowArea.getArea().subtract((Area)object3);
                            object22 = new ArrayList<HomePieceOfFurniture>(doorOrWindowArea.getDoorsOrWindows());
                            object22.addAll(doorOrWindowArea2.getDoorsOrWindows());
                            arrayList3.add(new DoorOrWindowArea((Area)object3, (List<HomePieceOfFurniture>)object22));
                        }
                    }
                    ++n2;
                }
                arrayList.addAll(arrayList3);
            }
        }
        ArrayList arrayList4 = new ArrayList(4);
        Object var34_31 = null;
        Object object4 = area.getPathIterator(null);
        while (!object4.isDone()) {
            void var34_32;
            float[] fArray3 = new float[2];
            if (object4.currentSegment(fArray3) == 4) {
                if (arrayList4.size() > 2) {
                    if (Arrays.equals((float[])arrayList4.get(0), (float[])arrayList4.get(arrayList4.size() - 1))) {
                        arrayList4.remove(arrayList4.size() - 1);
                    }
                    if (arrayList4.size() > 2) {
                        float[][] fArray4 = (float[][])arrayList4.toArray((T[])new float[arrayList4.size()][]);
                        list2.add(this.createWallVerticalPartGeometry(wall, fArray4, f, d4, d5, d2, d, homeTexture, fArray2, n));
                        list.add(this.createWallHorizontalPartGeometry(fArray4, f, true, bl2));
                        list3.add(this.createWallTopPartGeometry(fArray4, d4, d5, d2, d, bl2));
                    }
                }
                arrayList4.clear();
                Object var34_33 = null;
            } else if (var34_32 == null || !Arrays.equals(fArray3, (float[])var34_32)) {
                arrayList4.add(fArray3);
                float[] fArray5 = fArray3;
            }
            object4.next();
        }
        object4 = wall.getLevel();
        Object var34_35 = null;
        for (DoorOrWindowArea doorOrWindowArea : arrayList) {
            if (doorOrWindowArea.getArea().isEmpty()) continue;
            PathIterator pathIterator = doorOrWindowArea.getArea().getPathIterator(null);
            while (!pathIterator.isDone()) {
                void var34_36;
                object3 = new float[2];
                if (pathIterator.currentSegment((float[])object3) == 4) {
                    if (Arrays.equals((float[])arrayList4.get(0), (float[])arrayList4.get(arrayList4.size() - 1))) {
                        arrayList4.remove(arrayList4.size() - 1);
                    }
                    if (arrayList4.size() > 2) {
                        HomePieceOfFurniture homePieceOfFurniture;
                        float f6;
                        HomePieceOfFurniture homePieceOfFurniture2;
                        float f7;
                        object22 = (float[][])arrayList4.toArray((T[])new float[arrayList4.size()][]);
                        List<HomePieceOfFurniture> list4 = doorOrWindowArea.getDoorsOrWindows();
                        if (list4.size() > 1) {
                            Collections.sort(list4, new Comparator<HomePieceOfFurniture>(){

                                @Override
                                public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                                    float f;
                                    float f2 = homePieceOfFurniture.getGroundElevation();
                                    if (f2 < (f = homePieceOfFurniture2.getGroundElevation())) {
                                        return -1;
                                    }
                                    if (f2 > f) {
                                        return 1;
                                    }
                                    return 0;
                                }
                            });
                        }
                        if ((f7 = (homePieceOfFurniture2 = list4.get(0)).getGroundElevation()) > f) {
                            if (object4 != null && ((Level)object4).getElevation() != f && homePieceOfFurniture2.getElevation() < 0.1f) {
                                f7 -= 0.1f;
                            }
                            list2.add(this.createWallVerticalPartGeometry(wall, (float[][])object22, f, d4, d5, 0.0, f7, homeTexture, fArray2, n));
                            list.add(this.createWallHorizontalPartGeometry((float[][])object22, f, true, bl2));
                            list2.add(this.createWallHorizontalPartGeometry((float[][])object22, f7, false, bl2));
                        }
                        int n3 = 0;
                        while (n3 < list4.size() - 1) {
                            HomePieceOfFurniture homePieceOfFurniture3 = list4.get(n3);
                            f6 = homePieceOfFurniture3.getGroundElevation();
                            homePieceOfFurniture = list4.get(++n3);
                            float f8 = homePieceOfFurniture.getGroundElevation();
                            while (f6 + homePieceOfFurniture3.getHeight() >= f8 + homePieceOfFurniture.getHeight() && ++n3 < list4.size()) {
                                homePieceOfFurniture = list4.get(n3);
                            }
                            if (n3 >= list4.size() || !(f6 + homePieceOfFurniture3.getHeight() < f8)) continue;
                            list2.add(this.createWallVerticalPartGeometry(wall, (float[][])object22, f6 + homePieceOfFurniture3.getHeight(), d4, d5, 0.0, f8, homeTexture, fArray2, n));
                            list2.add(this.createWallHorizontalPartGeometry((float[][])object22, f6 + homePieceOfFurniture3.getHeight(), true, bl2));
                            list2.add(this.createWallHorizontalPartGeometry((float[][])object22, f8, false, bl2));
                        }
                        object = list4.get(list4.size() - 1);
                        float f9 = ((HomePieceOfFurniture)object).getGroundElevation();
                        for (int i = list4.size() - 2; i >= 0; --i) {
                            homePieceOfFurniture = list4.get(i);
                            if (!(homePieceOfFurniture.getGroundElevation() + homePieceOfFurniture.getHeight() > f9 + ((HomePieceOfFurniture)object).getHeight())) continue;
                            object = homePieceOfFurniture;
                        }
                        f6 = f9 + ((HomePieceOfFurniture)object).getHeight();
                        boolean bl4 = true;
                        for (int i = 0; i < ((Object)object22).length; ++i) {
                            double d8 = d4 * (double)object22[i][0] + d5 * (double)object22[i][1];
                            double d9 = d2 * d8 + d;
                            if (!((double)f6 > d9)) continue;
                            if (d2 == 0.0 || bl2) {
                                bl4 = false;
                                break;
                            }
                            double d10 = ((double)f6 - d9) / d2;
                            Object object5 = object22[i];
                            object5[0] = object5[0] + (float)(d10 * d4);
                            Object object6 = object22[i];
                            object6[1] = object6[1] + (float)(d10 * d5);
                        }
                        if (bl4) {
                            list2.add(this.createWallVerticalPartGeometry(wall, (float[][])object22, f6, d4, d5, d2, d, homeTexture, fArray2, n));
                            list2.add(this.createWallHorizontalPartGeometry((float[][])object22, f6, true, bl2));
                            list3.add(this.createWallTopPartGeometry((float[][])object22, d4, d5, d2, d, bl2));
                        }
                    }
                    arrayList4.clear();
                    Object var34_37 = null;
                } else if (var34_36 == null || !Arrays.equals((float[])object3, (float[])var34_36)) {
                    arrayList4.add(object3);
                    Object object7 = object3;
                }
                pathIterator.next();
            }
        }
        if (!bl2 && arrayList2.size() > 0) {
            ArrayList<Object> arrayList5 = new ArrayList<Object>(arrayList2.size());
            for (Object object22 : arrayList2) {
                double d11;
                if (!(object22 instanceof DoorOrWindow) || "M0,0 v1 h1 v-1 z".equals(((DoorOrWindow)object22).getCutOutShape()) || !((d11 = Math.abs(d3 - (double)((HomePieceOfFurniture)object22).getAngle()) % (Math.PI * 2)) < 0.004363323129985824) && !(d11 > 6.278821984049601) && !(Math.abs(d11 - Math.PI) < 0.004363323129985824)) continue;
                int n4 = Math.abs(d11 - Math.PI) < 0.004363323129985824 ? 1 : -1;
                object = doorOrWindowRotatedModels.get(object22);
                if (!(object == null || arrayList5.size() != 0 && bl)) {
                    this.createGeometriesSurroundingDoorOrWindow((HomePieceOfFurniture)object22, rotatedModelsFrontAreas.get(object), n4, wall, list2, list3, fArray, f, d4, d5, d2, d, homeTexture, fArray2, n);
                    continue;
                }
                arrayList5.add(object22);
            }
            if (arrayList5.size() > 0) {
                object3 = ModelManager.getInstance();
                for (final HomePieceOfFurniture homePieceOfFurniture : (List)arrayList5.clone()) {
                    double d12 = Math.abs(d3 - (double)homePieceOfFurniture.getAngle()) % (Math.PI * 2);
                    int n5 = Math.abs(d12 - Math.PI) < 0.004363323129985824 ? 1 : -1;
                    ((ModelManager)object3).loadModel(homePieceOfFurniture.getModel(), bl, new ModelManager.ModelObserver((ModelManager)object3, bl, n5, wall, list2, list3, fArray, f, d4, d5, d2, d, homeTexture, fArray2, n, arrayList5){
                        final /* synthetic */ ModelManager val$modelManager;
                        final /* synthetic */ boolean val$waitDoorOrWindowModelsLoadingEnd;
                        final /* synthetic */ int val$frontOrBackSide;
                        final /* synthetic */ Wall val$wall;
                        final /* synthetic */ List val$wallGeometries;
                        final /* synthetic */ List val$wallTopGeometries;
                        final /* synthetic */ float[][] val$wallSidePoints;
                        final /* synthetic */ float val$wallElevation;
                        final /* synthetic */ double val$cosWallYawAngle;
                        final /* synthetic */ double val$sinWallYawAngle;
                        final /* synthetic */ double val$topLineAlpha;
                        final /* synthetic */ double val$topLineBeta;
                        final /* synthetic */ HomeTexture val$texture;
                        final /* synthetic */ float[] val$textureReferencePoint;
                        final /* synthetic */ int val$wallSide;
                        final /* synthetic */ ArrayList val$missingModels;
                        {
                            this.val$modelManager = modelManager;
                            this.val$waitDoorOrWindowModelsLoadingEnd = bl;
                            this.val$frontOrBackSide = n;
                            this.val$wall = wall;
                            this.val$wallGeometries = list;
                            this.val$wallTopGeometries = list2;
                            this.val$wallSidePoints = fArray;
                            this.val$wallElevation = f;
                            this.val$cosWallYawAngle = d;
                            this.val$sinWallYawAngle = d2;
                            this.val$topLineAlpha = d3;
                            this.val$topLineBeta = d4;
                            this.val$texture = homeTexture;
                            this.val$textureReferencePoint = fArray2;
                            this.val$wallSide = n2;
                            this.val$missingModels = arrayList;
                        }

                        public void modelUpdated(BranchGroup branchGroup) {
                            Area area;
                            ModelRotationTuple modelRotationTuple = (ModelRotationTuple)doorOrWindowRotatedModels.get(homePieceOfFurniture);
                            if (modelRotationTuple == null) {
                                modelRotationTuple = new ModelRotationTuple(homePieceOfFurniture.getModel(), homePieceOfFurniture.getModelRotation());
                                area = (Area)rotatedModelsFrontAreas.get(modelRotationTuple);
                                if (area == null) {
                                    TransformGroup transformGroup = new TransformGroup(this.val$modelManager.getRotationTransformation(homePieceOfFurniture.getModelRotation()));
                                    transformGroup.addChild((Node)branchGroup);
                                    area = this.val$modelManager.getFrontArea(((DoorOrWindow)((Object)homePieceOfFurniture)).getCutOutShape(), (Node)transformGroup);
                                    rotatedModelsFrontAreas.put(modelRotationTuple, area);
                                }
                                doorOrWindowRotatedModels.put(homePieceOfFurniture, modelRotationTuple);
                            } else {
                                area = (Area)rotatedModelsFrontAreas.get(modelRotationTuple);
                            }
                            if (this.val$waitDoorOrWindowModelsLoadingEnd) {
                                Wall3D.this.createGeometriesSurroundingDoorOrWindow(homePieceOfFurniture, area, this.val$frontOrBackSide, this.val$wall, this.val$wallGeometries, this.val$wallTopGeometries, this.val$wallSidePoints, this.val$wallElevation, this.val$cosWallYawAngle, this.val$sinWallYawAngle, this.val$topLineAlpha, this.val$topLineBeta, this.val$texture, this.val$textureReferencePoint, this.val$wallSide);
                            } else {
                                this.val$missingModels.remove(homePieceOfFurniture);
                                if (this.val$missingModels.size() == 0) {
                                    EventQueue.invokeLater(new Runnable(){

                                        public void run() {
                                            Wall3D.this.updateWallSideGeometry(val$wallSide, val$texture, val$waitDoorOrWindowModelsLoadingEnd);
                                        }
                                    });
                                }
                            }
                        }

                        public void modelError(Exception exception) {
                            ModelRotationTuple modelRotationTuple = new ModelRotationTuple(homePieceOfFurniture.getModel(), homePieceOfFurniture.getModelRotation());
                            doorOrWindowRotatedModels.put(homePieceOfFurniture, modelRotationTuple);
                            if (rotatedModelsFrontAreas.get(modelRotationTuple) == null) {
                                rotatedModelsFrontAreas.put(modelRotationTuple, FULL_FACE_CUT_OUT_AREA);
                            }
                            if (!this.val$waitDoorOrWindowModelsLoadingEnd) {
                                this.val$missingModels.remove(homePieceOfFurniture);
                            }
                        }
                    });
                }
            }
        }
    }

    private List<HomePieceOfFurniture> getVisibleDoorsAndWindows(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(list.size());
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!homePieceOfFurniture.isVisible()) continue;
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getVisibleDoorsAndWindows(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                continue;
            }
            if (!homePieceOfFurniture.isDoorOrWindow()) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    private float[][] getWallSidePoints(int n) {
        Wall wall = (Wall)this.getUserData();
        float[][] fArray = wall.getPoints();
        if (n == 0) {
            for (int i = fArray.length / 2; i < fArray.length; ++i) {
                fArray[i][0] = (fArray[i][0] + fArray[fArray.length - i - 1][0]) / 2.0f;
                fArray[i][1] = (fArray[i][1] + fArray[fArray.length - i - 1][1]) / 2.0f;
            }
        } else {
            int n2 = fArray.length / 2;
            for (int i = 0; i < n2; ++i) {
                fArray[i][0] = (fArray[i][0] + fArray[fArray.length - i - 1][0]) / 2.0f;
                fArray[i][1] = (fArray[i][1] + fArray[fArray.length - i - 1][1]) / 2.0f;
            }
        }
        return fArray;
    }

    private Geometry createWallVerticalPartGeometry(Wall wall, float[][] fArray, float f, double d, double d2, double d3, double d4, HomeTexture homeTexture, float[] fArray2, int n) {
        float f2;
        Object object;
        Point3f point3f;
        int n2;
        Object object2;
        float f3 = this.home.getEnvironment().getSubpartSizeUnderLight();
        if (wall.getArcExtent() == null && f3 > 0.0f) {
            object2 = new ArrayList(fArray.length * 2);
            object2.add(fArray[0]);
            for (int i = 1; i < fArray.length; ++i) {
                double d5 = Point2D.distance(fArray[i - 1][0], fArray[i - 1][1], fArray[i][0], fArray[i][1]) - (double)(f3 / 2.0f);
                double d6 = Math.atan2(fArray[i][1] - fArray[i - 1][1], fArray[i][0] - fArray[i - 1][0]);
                double d7 = Math.cos(d6);
                double d8 = Math.sin(d6);
                for (double d9 = 0.0; d9 < d5; d9 += (double)f3) {
                    object2.add(new float[]{(float)((double)fArray[i - 1][0] + d9 * d7), (float)((double)fArray[i - 1][1] + d9 * d8)});
                }
                object2.add(fArray[i]);
            }
            fArray = (float[][])object2.toArray((T[])new float[object2.size()][]);
        }
        object2 = new Point3f[fArray.length];
        Point3f[] point3fArray = new Point3f[fArray.length];
        double[] dArray = new double[fArray.length];
        Float[] floatArray = new Float[fArray.length];
        float f4 = wall.getXStart();
        float f5 = wall.getYStart();
        float f6 = wall.getXEnd();
        float f7 = wall.getYEnd();
        Float f8 = wall.getArcExtent();
        float[] fArray3 = null;
        float f9 = 0.0f;
        float f10 = 0.0f;
        if (f8 != null && f8.floatValue() != 0.0f) {
            fArray3 = new float[]{wall.getXArcCircleCenter(), wall.getYArcCircleCenter()};
            f9 = (float)Point2D.distance(fArray3[0], fArray3[1], f4, f5);
            f10 = (float)Math.atan2(fArray2[1] - fArray3[1], fArray2[0] - fArray3[0]);
        }
        for (n2 = 0; n2 < fArray.length; ++n2) {
            object2[n2] = new Point3f(fArray[n2][0], f, fArray[n2][1]);
            if (fArray3 == null) {
                dArray[n2] = Line2D.ptLineDistSq(f4, f5, f6, f7, ((Point3f)object2[n2]).x, ((Point3f)object2[n2]).z);
            } else {
                dArray[n2] = (double)f9 - Point2D.distance(fArray3[0], fArray3[1], ((Point3f)object2[n2]).x, ((Point3f)object2[n2]).z);
                int n3 = n2;
                dArray[n3] = dArray[n3] * dArray[n2];
            }
            float f11 = this.getWallPointElevation(fArray[n2][0], fArray[n2][1], d, d2, d3, d4);
            point3fArray[n2] = new Point3f(fArray[n2][0], f11, fArray[n2][1]);
        }
        n2 = 0;
        boolean[] blArray = new boolean[fArray.length];
        for (int i = 0; i < fArray.length - 1; ++i) {
            boolean bl = blArray[i] = dArray[i] > (double)0.001f || dArray[i + 1] > (double)0.001f;
            if (!blArray[i]) continue;
            ++n2;
        }
        boolean bl = blArray[blArray.length - 1] = dArray[0] > (double)0.001f || dArray[fArray.length - 1] > (double)0.001f;
        if (blArray[blArray.length - 1]) {
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2 * 4);
        for (int i = 0; i < fArray.length; ++i) {
            if (!blArray[i]) continue;
            point3f = object2[i];
            int n4 = (i + 1) % fArray.length;
            object = object2[n4];
            if (f3 > 0.0f) {
                float f12 = Math.min(point3fArray[i].y, point3fArray[n4].y) - f3 / 2.0f;
                for (f2 = f; f2 < f12; f2 += f3) {
                    arrayList.add(point3f);
                    arrayList.add(object);
                    point3f = new Point3f(((Point3f)object2[i]).x, f2, ((Point3f)object2[i]).z);
                    object = new Point3f(((Point3f)object2[n4]).x, f2, ((Point3f)object2[n4]).z);
                    arrayList.add(object);
                    arrayList.add(point3f);
                }
            }
            arrayList.add(point3f);
            arrayList.add(object);
            arrayList.add(point3fArray[n4]);
            arrayList.add(point3fArray[i]);
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(arrayList.toArray(new Point3f[arrayList.size()]));
        if (homeTexture != null) {
            f2 = wall.getThickness() * wall.getThickness() / 4.0f;
            point3f = new TexCoord2f[arrayList.size()];
            float f13 = f / homeTexture.getHeight();
            object = new TexCoord2f(0.0f, f13);
            int n5 = 0;
            float f14 = fArray3 == null ? 1.0E-4f : f2 / 4.0f;
            for (int i = 0; i < fArray.length; ++i) {
                TexCoord2f texCoord2f;
                Object object3;
                float f15;
                float f16;
                float f17;
                if (!blArray[i]) continue;
                int n6 = (i + 1) % fArray.length;
                if (Math.abs(dArray[i] - (double)f2) < (double)f14 && Math.abs(dArray[n6] - (double)f2) < (double)f14) {
                    if (fArray3 == null) {
                        f17 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray[i][0], fArray[i][1]) / homeTexture.getWidth();
                        f16 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray[n6][0], fArray[n6][1]) / homeTexture.getWidth();
                    } else {
                        if (floatArray[i] == null) {
                            f15 = (float)Math.atan2(fArray[i][1] - fArray3[1], fArray[i][0] - fArray3[0]);
                            f15 = this.adjustAngleOnReferencePointAngle(f15, f10, f8.floatValue());
                            floatArray[i] = Float.valueOf((f15 - f10) * f9 / homeTexture.getWidth());
                        }
                        if (floatArray[n6] == null) {
                            f15 = (float)Math.atan2(fArray[n6][1] - fArray3[1], fArray[n6][0] - fArray3[0]);
                            f15 = this.adjustAngleOnReferencePointAngle(f15, f10, f8.floatValue());
                            floatArray[n6] = Float.valueOf((f15 - f10) * f9 / homeTexture.getWidth());
                        }
                        f17 = floatArray[i].floatValue();
                        f16 = floatArray[n6].floatValue();
                    }
                    if (n == 0 && homeTexture.isLeftToRightOriented()) {
                        f17 = -f17;
                        f16 = -f16;
                    }
                    object3 = new TexCoord2f(f17, f13);
                    texCoord2f = new TexCoord2f(f16, f13);
                } else {
                    object3 = object;
                    f17 = (float)Point2D.distance(fArray[i][0], fArray[i][1], fArray[n6][0], fArray[n6][1]) / homeTexture.getWidth();
                    texCoord2f = new TexCoord2f(f17, f13);
                }
                if (f3 > 0.0f) {
                    f16 = Math.min(point3fArray[i].y, point3fArray[n6].y) - f3 / 2.0f;
                    for (f17 = f; f17 < f16; f17 += f3) {
                        point3f[n5++] = object3;
                        point3f[n5++] = texCoord2f;
                        f15 = f17 / homeTexture.getHeight();
                        object3 = new TexCoord2f(((TexCoord2f)object3).x, f15);
                        texCoord2f = new TexCoord2f(texCoord2f.x, f15);
                        point3f[n5++] = texCoord2f;
                        point3f[n5++] = object3;
                    }
                }
                point3f[n5++] = object3;
                point3f[n5++] = texCoord2f;
                point3f[n5++] = new TexCoord2f(texCoord2f.x, point3fArray[n6].y / homeTexture.getHeight());
                point3f[n5++] = new TexCoord2f(((TexCoord2f)object3).x, point3fArray[i].y / homeTexture.getHeight());
            }
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, (TexCoord2f[])point3f);
        }
        NormalGenerator normalGenerator = new NormalGenerator();
        if (fArray3 == null) {
            normalGenerator.setCreaseAngle(0.0);
        }
        normalGenerator.generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private float getWallPointElevation(float f, float f2, double d, double d2, double d3, double d4) {
        double d5 = d * (double)f + d2 * (double)f2;
        return (float)(d3 * d5 + d4);
    }

    private float adjustAngleOnReferencePointAngle(float f, float f2, float f3) {
        if (f3 > 0.0f) {
            if (f2 > 0.0f && (f < 0.0f || f2 > f) || f2 < 0.0f && f < 0.0f && f2 > f) {
                f += (float)Math.PI * 2;
            }
        } else if (f2 < 0.0f && (f > 0.0f || f2 < f) || f2 > 0.0f && f > 0.0f && f2 < f) {
            f -= (float)Math.PI * 2;
        }
        return f;
    }

    private Geometry createWallHorizontalPartGeometry(float[][] fArray, float f, boolean bl, boolean bl2) {
        Point3f[] point3fArray = new Point3f[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            point3fArray[i] = new Point3f(fArray[i][0], f, fArray[i][1]);
        }
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(point3fArray);
        geometryInfo.setStripCounts(new int[]{point3fArray.length});
        if (bl) {
            geometryInfo.reverse();
        }
        NormalGenerator normalGenerator = new NormalGenerator();
        if (bl2) {
            normalGenerator.setCreaseAngle(0.0);
        }
        normalGenerator.generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private Geometry createWallTopPartGeometry(float[][] fArray, double d, double d2, double d3, double d4, boolean bl) {
        Point3f[] point3fArray = new Point3f[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            double d5 = d * (double)fArray[i][0] + d2 * (double)fArray[i][1];
            float f = (float)(d3 * d5 + d4);
            point3fArray[i] = new Point3f(fArray[i][0], f, fArray[i][1]);
        }
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(point3fArray);
        geometryInfo.setStripCounts(new int[]{point3fArray.length});
        NormalGenerator normalGenerator = new NormalGenerator();
        if (bl) {
            normalGenerator.setCreaseAngle(0.0);
        }
        normalGenerator.generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private void createGeometriesSurroundingDoorOrWindow(HomePieceOfFurniture homePieceOfFurniture, Area area, float f, Wall wall, List<Geometry> list, List<Geometry> list2, float[][] fArray, float f2, double d, double d2, double d3, double d4, HomeTexture homeTexture, float[] fArray2, int n) {
        Area area2 = new Area(FULL_FACE_CUT_OUT_AREA);
        area2.subtract(area);
        if (!area2.isEmpty()) {
            boolean bl;
            List<float[][]> list3;
            float f3 = homePieceOfFurniture.getDepth();
            float f4 = (float)((double)homePieceOfFurniture.getX() - (double)(f * f3 / 2.0f) * Math.sin(homePieceOfFurniture.getAngle()));
            float f5 = (float)((double)homePieceOfFurniture.getY() + (double)(f * f3 / 2.0f) * Math.cos(homePieceOfFurniture.getAngle()));
            float[] fArray3 = n == 0 ? fArray[0] : fArray[fArray.length - 1];
            float[] fArray4 = n == 0 ? fArray[fArray.length / 2 - 1] : fArray[fArray.length / 2];
            float f6 = (float)Line2D.ptLineDist(fArray3[0], fArray3[1], fArray4[0], fArray4[1], f4, f5);
            float f7 = Line2D.relativeCCW(fArray3[0], fArray3[1], fArray4[0], fArray4[1], f4, f5);
            float f8 = f * (0.5f - f7 * f6 / f3);
            Transform3D transform3D = ModelManager.getInstance().getPieceOFFurnitureNormalizedModelTransformation(homePieceOfFurniture);
            Transform3D transform3D2 = new Transform3D();
            transform3D2.setTranslation(new Vector3f(0.0f, 0.0f, f8));
            transform3D.mul(transform3D2);
            Transform3D transform3D3 = new Transform3D();
            transform3D3.invert(transform3D);
            GeneralPath generalPath = new GeneralPath();
            Point3f point3f = new Point3f(fArray3[0], f2, fArray3[1]);
            transform3D3.transform(point3f);
            generalPath.moveTo(point3f.x, point3f.y);
            point3f = new Point3f(fArray4[0], f2, fArray4[1]);
            transform3D3.transform(point3f);
            generalPath.lineTo(point3f.x, point3f.y);
            Point3f point3f2 = new Point3f(fArray4[0], this.getWallPointElevation(fArray4[0], fArray4[1], d, d2, d3, d4), fArray4[1]);
            transform3D3.transform(point3f2);
            generalPath.lineTo(point3f2.x, point3f2.y);
            Point3f point3f3 = new Point3f(fArray3[0], this.getWallPointElevation(fArray3[0], fArray3[1], d, d2, d3, d4), fArray3[1]);
            transform3D3.transform(point3f3);
            generalPath.lineTo(point3f3.x, point3f3.y);
            generalPath.closePath();
            GeneralPath generalPath2 = new GeneralPath();
            generalPath2.moveTo(-0.5f, -0.5f);
            generalPath2.lineTo(-0.5f, 0.5f);
            generalPath2.lineTo(0.5f, 0.5f);
            generalPath2.lineTo(0.5f, -0.5f);
            generalPath2.closePath();
            Area area3 = new Area(generalPath2);
            area3.intersect(new Area(generalPath));
            area3.subtract(area);
            float f9 = 0.5f / Math.max(homePieceOfFurniture.getWidth(), homePieceOfFurniture.getHeight());
            if (!area3.isEmpty() && !(list3 = this.getAreaPoints(area3, f9, bl = f > 0.0f ^ n == 1 ^ homePieceOfFurniture.isModelMirrored())).isEmpty()) {
                ArrayList<TexCoord2f> arrayList;
                TexCoord2f[] texCoord2fArray;
                int[] nArray = new int[list3.size()];
                int n2 = 0;
                for (int i = 0; i < list3.size(); ++i) {
                    float[][] fArray5 = list3.get(i);
                    nArray[i] = fArray5.length + 1;
                    n2 += nArray[i];
                }
                float f10 = wall.getThickness() / 2.0f;
                float f11 = (float)((double)f10 * d2);
                float f12 = -((float)((double)f10 * d));
                if (n == 0) {
                    f11 *= -1.0f;
                    f12 *= -1.0f;
                }
                Point3f[] point3fArray = new Point3f[n2];
                ArrayList<Point3f> arrayList2 = new ArrayList<Point3f>(4 * n2);
                ArrayList arrayList3 = new ArrayList();
                if (homeTexture != null) {
                    texCoord2fArray = new TexCoord2f[point3fArray.length];
                    arrayList = new ArrayList<TexCoord2f>(4 * n2);
                } else {
                    texCoord2fArray = null;
                    arrayList = null;
                }
                int n3 = 0;
                for (float[][] fArray6 : list3) {
                    Point3f point3f4 = new Point3f(fArray6[0][0], fArray6[0][1], 0.0f);
                    transform3D.transform(point3f4);
                    TexCoord2f texCoord2f = null;
                    if (homeTexture != null) {
                        float f13 = (float)Point2D.distance(fArray2[0], fArray2[1], point3f4.x, point3f4.z) / homeTexture.getWidth();
                        if (n == 0 && homeTexture.isLeftToRightOriented()) {
                            f13 = -f13;
                        }
                        texCoord2f = new TexCoord2f(f13, point3f4.y / homeTexture.getHeight());
                    }
                    double d5 = Line2D.ptLineDistSq(point3f2.x, point3f2.y, point3f3.x, point3f3.y, fArray6[0][0], fArray6[0][1]);
                    int n4 = 0;
                    while (n4 < fArray6.length) {
                        point3fArray[n3] = point3f4;
                        if (homeTexture != null) {
                            texCoord2fArray[n3] = texCoord2f;
                        }
                        int n5 = n4 < fArray6.length - 1 ? n4 + 1 : 0;
                        double d6 = Line2D.ptLineDistSq(point3f2.x, point3f2.y, point3f3.x, point3f3.y, fArray6[n5][0], fArray6[n5][1]);
                        ArrayList<Object> arrayList4 = d5 < 1.0E-10 && d6 < 1.0E-10 ? arrayList3 : arrayList2;
                        Point3f point3f5 = new Point3f(fArray6[n5][0], fArray6[n5][1], 0.0f);
                        transform3D.transform(point3f5);
                        arrayList4.add(point3f4);
                        arrayList4.add(new Point3f(point3f4.x + f11, point3f4.y, point3f4.z + f12));
                        arrayList4.add(new Point3f(point3f5.x + f11, point3f5.y, point3f5.z + f12));
                        arrayList4.add(point3f5);
                        TexCoord2f texCoord2f2 = null;
                        if (homeTexture != null) {
                            float f14 = (float)Point2D.distance(fArray2[0], fArray2[1], point3f5.x, point3f5.z) / homeTexture.getWidth();
                            if (n == 0 && homeTexture.isLeftToRightOriented()) {
                                f14 = -f14;
                            }
                            texCoord2f2 = new TexCoord2f(f14, point3f5.y / homeTexture.getHeight());
                            if (arrayList4 == arrayList2) {
                                arrayList.add(texCoord2f);
                                arrayList.add(texCoord2f);
                                arrayList.add(texCoord2f2);
                                arrayList.add(texCoord2f2);
                            }
                        }
                        d5 = d6;
                        point3f4 = point3f5;
                        texCoord2f = texCoord2f2;
                        ++n4;
                        ++n3;
                    }
                    point3fArray[n3] = point3f4;
                    if (homeTexture != null) {
                        texCoord2fArray[n3] = texCoord2f;
                    }
                    ++n3;
                }
                GeometryInfo geometryInfo = new GeometryInfo(5);
                geometryInfo.setStripCounts(nArray);
                geometryInfo.setCoordinates(point3fArray);
                if (homeTexture != null) {
                    geometryInfo.setTextureCoordinateParams(1, 2);
                    geometryInfo.setTextureCoordinates(0, texCoord2fArray);
                }
                new NormalGenerator().generateNormals(geometryInfo);
                list.add((Geometry)geometryInfo.getIndexedGeometryArray());
                if (arrayList2.size() > 0) {
                    geometryInfo = new GeometryInfo(2);
                    geometryInfo.setCoordinates(arrayList2.toArray(new Point3f[arrayList2.size()]));
                    if (homeTexture != null) {
                        geometryInfo.setTextureCoordinateParams(1, 2);
                        geometryInfo.setTextureCoordinates(0, arrayList.toArray(new TexCoord2f[arrayList.size()]));
                    }
                    new NormalGenerator(1.5707963267948966).generateNormals(geometryInfo);
                    list.add((Geometry)geometryInfo.getIndexedGeometryArray());
                }
                if (arrayList3.size() > 0) {
                    geometryInfo = new GeometryInfo(2);
                    geometryInfo.setCoordinates(arrayList3.toArray(new Point3f[arrayList3.size()]));
                    new NormalGenerator().generateNormals(geometryInfo);
                    list2.add((Geometry)geometryInfo.getIndexedGeometryArray());
                }
            }
        }
    }

    private float getWallElevation() {
        Wall wall = (Wall)this.getUserData();
        Level level = wall.getLevel();
        if (level == null) {
            return 0.0f;
        }
        float f = this.getFloorThicknessBottomWall();
        if (f > 0.0f) {
            f -= 0.1f;
        }
        return level.getElevation() - f;
    }

    private float getFloorThicknessBottomWall() {
        Wall wall = (Wall)this.getUserData();
        Level level = wall.getLevel();
        if (level == null) {
            return 0.0f;
        }
        List<Level> list = this.home.getLevels();
        if (!list.isEmpty() && list.get(0).getElevation() == level.getElevation()) {
            return 0.0f;
        }
        return level.getFloorThickness();
    }

    private float getWallHeightAtStart() {
        Float f = ((Wall)this.getUserData()).getHeight();
        float f2 = f != null ? f.floatValue() + this.getWallElevation() + this.getFloorThicknessBottomWall() : this.home.getWallHeight() + this.getWallElevation() + this.getFloorThicknessBottomWall();
        return f2 + this.getHeightElevationShift();
    }

    private float getHeightElevationShift() {
        List<Level> list;
        Level level = ((Wall)this.getUserData()).getLevel();
        if (level != null && (list = this.home.getLevels()).get(list.size() - 1) != level) {
            return 0.1f;
        }
        return 0.0f;
    }

    private float getWallHeightAtEnd() {
        Wall wall = (Wall)this.getUserData();
        if (wall.isTrapezoidal()) {
            return wall.getHeightAtEnd().floatValue() + this.getWallElevation() + this.getFloorThicknessBottomWall() + this.getHeightElevationShift();
        }
        return this.getWallHeightAtStart();
    }

    private void updateWallAppearance(boolean bl) {
        Wall wall = (Wall)this.getUserData();
        Integer n = wall.getTopColor();
        Group[] groupArray = new Group[]{(Group)this.getChild(0), (Group)this.getChild(1), (Group)this.getChild(2)};
        Group[] groupArray2 = new Group[]{(Group)this.getChild(3), (Group)this.getChild(4), (Group)this.getChild(5)};
        for (int i = 0; i < groupArray.length; ++i) {
            if (i % 3 != 2 || n == null) {
                this.updateFilledWallSideAppearance(((Shape3D)groupArray[i].getChild(0)).getAppearance(), wall.getLeftSideTexture(), bl, wall.getLeftSideColor(), wall.getLeftSideShininess());
                this.updateFilledWallSideAppearance(((Shape3D)groupArray2[i].getChild(0)).getAppearance(), wall.getRightSideTexture(), bl, wall.getRightSideColor(), wall.getRightSideShininess());
            } else {
                this.updateFilledWallSideAppearance(((Shape3D)groupArray[i].getChild(0)).getAppearance(), null, bl, n, 0.0f);
                this.updateFilledWallSideAppearance(((Shape3D)groupArray2[i].getChild(0)).getAppearance(), null, bl, n, 0.0f);
            }
            if (groupArray[i].numChildren() <= 1) continue;
            this.updateOutlineWallSideAppearance(((Shape3D)groupArray[i].getChild(1)).getAppearance());
            this.updateOutlineWallSideAppearance(((Shape3D)groupArray2[i].getChild(1)).getAppearance());
        }
    }

    private void updateFilledWallSideAppearance(final Appearance appearance, HomeTexture homeTexture, boolean bl, Integer n, float f) {
        if (homeTexture == null) {
            appearance.setMaterial(this.getMaterial(n, n, f));
            appearance.setTexture(null);
        } else {
            appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f));
            TextureManager textureManager = TextureManager.getInstance();
            textureManager.loadTexture(homeTexture.getImage(), bl, new TextureManager.TextureObserver(){

                public void textureUpdated(Texture texture) {
                    appearance.setTexture(Wall3D.this.getHomeTextureClone(texture, Wall3D.this.home));
                }
            });
        }
        float f2 = this.home.getEnvironment().getWallsAlpha();
        TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
        transparencyAttributes.setTransparency(f2);
        transparencyAttributes.setTransparencyMode(f2 == 0.0f ? 4 : 1);
        RenderingAttributes renderingAttributes = appearance.getRenderingAttributes();
        HomeEnvironment.DrawingMode drawingMode = this.home.getEnvironment().getDrawingMode();
        renderingAttributes.setVisible(drawingMode == null || drawingMode == HomeEnvironment.DrawingMode.FILL || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE);
    }

    private void updateOutlineWallSideAppearance(Appearance appearance) {
        RenderingAttributes renderingAttributes = appearance.getRenderingAttributes();
        HomeEnvironment.DrawingMode drawingMode = this.home.getEnvironment().getDrawingMode();
        renderingAttributes.setVisible(drawingMode == HomeEnvironment.DrawingMode.OUTLINE || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE);
    }

    static {
        MODULATE_TEXTURE_ATTRIBUTES.setTextureMode(2);
        doorOrWindowRotatedModels = new WeakHashMap<HomePieceOfFurniture, ModelRotationTuple>();
        rotatedModelsFrontAreas = new WeakHashMap<ModelRotationTuple, Area>();
    }

    private static class ModelRotationTuple {
        private Content model;
        private float[][] rotation;

        public ModelRotationTuple(Content content, float[][] fArray) {
            this.model = content;
            this.rotation = fArray;
        }

        public int hashCode() {
            int n = 31 * this.model.hashCode();
            for (float[] fArray : this.rotation) {
                n += Arrays.hashCode(fArray);
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ModelRotationTuple) {
                ModelRotationTuple modelRotationTuple = (ModelRotationTuple)object;
                if (this.model.equals(modelRotationTuple.model) && this.rotation.length == modelRotationTuple.rotation.length) {
                    for (int i = 0; i < this.rotation.length; ++i) {
                        if (Arrays.equals(this.rotation[i], modelRotationTuple.rotation[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoorOrWindowArea {
        private final Area area;
        private final List<HomePieceOfFurniture> doorsOrWindows;

        public DoorOrWindowArea(Area area, List<HomePieceOfFurniture> list) {
            this.area = area;
            this.doorsOrWindows = list;
        }

        public Area getArea() {
            return this.area;
        }

        public List<HomePieceOfFurniture> getDoorsOrWindows() {
            return this.doorsOrWindows;
        }
    }
}

