/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Room;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Texture;
import javax.vecmath.Color3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Object3DBranch
extends BranchGroup {
    protected static final ColoringAttributes OUTLINE_COLORING_ATTRIBUTES = new ColoringAttributes(new Color3f(0.16f, 0.16f, 0.16f), 0);
    protected static final PolygonAttributes OUTLINE_POLYGON_ATTRIBUTES = new PolygonAttributes(1, 1, 0.0f);
    protected static final LineAttributes OUTLINE_LINE_ATTRIBUTES = new LineAttributes(0.5f, 0, true);
    protected static final Integer DEFAULT_COLOR = 0xFFFFFF;
    protected static final Integer DEFAULT_AMBIENT_COLOR = 0x333333;
    protected static final Material DEFAULT_MATERIAL = new Material();
    private static final Map<Long, Material> materials = new HashMap<Long, Material>();
    private static final Map<Home, Map<Texture, Texture>> homesTextures = new WeakHashMap<Home, Map<Texture, Texture>>();

    public abstract void update();

    protected Texture getHomeTextureClone(Texture texture, Home home) {
        Texture texture2;
        if (home == null || texture == null) {
            return texture;
        }
        Map<Texture, Texture> map = homesTextures.get(home);
        if (map == null) {
            map = new WeakHashMap<Texture, Texture>();
            homesTextures.put(home, map);
        }
        if ((texture2 = map.get(texture)) == null) {
            texture2 = (Texture)texture.cloneNodeComponent(false);
            map.put(texture, texture2);
        }
        return texture2;
    }

    protected Shape getShape(float[][] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    protected Material getMaterial(Integer n, Integer n2, float f) {
        if (n != null) {
            Long l = new Long(n + (n2 << 24) + ((char)(f * 128.0f) << 48));
            Material material = materials.get(l);
            if (material == null) {
                Color3f color3f = new Color3f((float)(n2 >>> 16 & 0xFF) / 255.0f, (float)(n2 >>> 8 & 0xFF) / 255.0f, (float)(n2 & 0xFF) / 255.0f);
                Color3f color3f2 = new Color3f((float)(n >>> 16 & 0xFF) / 255.0f, (float)(n >>> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f);
                material = new Material(color3f, new Color3f(), color3f2, new Color3f(f, f, f), f * 128.0f);
                material.setCapability(0);
                materials.put(l, material);
            }
            return material;
        }
        return this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f);
    }

    protected List<float[][]> getAreaPoints(Area area, float f, boolean bl) {
        return this.getAreaPoints(area, null, null, f, bl);
    }

    protected List<float[][]> getAreaPoints(Area area, List<float[][]> list, List<float[][]> list2, float f, boolean bl) {
        Object object;
        Object object3;
        Object object4;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        ArrayList arrayList3 = null;
        float[] fArray = null;
        Object object5 = area.getPathIterator(null, f);
        while (!object5.isDone()) {
            object4 = new float[2];
            switch (object5.currentSegment((float[])object4)) {
                case 0: {
                    arrayList3 = new ArrayList();
                    arrayList3.add(object4);
                    fArray = object4;
                    break;
                }
                case 1: {
                    if (object4[0] != fArray[0] || object4[1] != fArray[1]) {
                        arrayList3.add(object4);
                    }
                    fArray = object4;
                    break;
                }
                case 4: {
                    float[][] object6;
                    object3 = (float[])arrayList3.get(0);
                    if (object3[0] == fArray[0] && object3[1] == fArray[1]) {
                        arrayList3.remove(arrayList3.size() - 1);
                    }
                    if (arrayList3.size() <= 2 || !(((Room)(object = new Room(object6 = (float[][])arrayList3.toArray((T[])new float[arrayList3.size()][])))).getArea() > 0.0f)) break;
                    boolean bl2 = ((Room)object).isClockwise();
                    if (bl2) {
                        arrayList2.add(arrayList3);
                    } else {
                        arrayList.add(arrayList3);
                    }
                    if (list == null && list2 == null) break;
                    if (bl2 ^ bl) {
                        arrayList3 = (ArrayList)arrayList3.clone();
                        Collections.reverse(arrayList3);
                        arrayList3.toArray((T[])object6);
                    }
                    if (bl2) {
                        if (list2 == null) break;
                        list2.add(object6);
                        break;
                    }
                    if (list == null) break;
                    list.add(object6);
                }
            }
            object5.next();
        }
        object5 = new ArrayList();
        if (arrayList2.isEmpty() && list != null) {
            object5.addAll(list);
        } else if (arrayList.isEmpty() && !arrayList2.isEmpty()) {
            if (list2 != null) {
                list2.clear();
            }
        } else {
            object4 = new ArrayList(arrayList.size());
            object3 = arrayList2.iterator();
            while (object3.hasNext()) {
                List list3 = (List)object3.next();
                object = null;
                if (arrayList.size() == 1) {
                    object = (List)arrayList.get(0);
                } else {
                    for (int i = 0; i < arrayList.size() && object == null; ++i) {
                        Area area2;
                        if (i >= object4.size()) {
                            List list4 = (List)arrayList.get(i);
                            area2 = new Area(this.getShape((float[][])list4.toArray((T[])new float[list4.size()][])));
                            object4.add(area2);
                        } else {
                            area2 = (Area)object4.get(i);
                        }
                        if (!area2.contains(((float[])list3.get(0))[0], ((float[])list3.get(0))[1])) continue;
                        object = (List)arrayList.get(i);
                    }
                }
                if (object == null) continue;
                float f2 = Float.MAX_VALUE;
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < list3.size() && f2 > 0.0f; ++i) {
                    for (int j = 0; j < object.size() && f2 > 0.0f; ++j) {
                        float f3 = (float)Point2D.distanceSq(((float[])list3.get(i))[0], ((float[])list3.get(i))[1], ((float[])object.get(j))[0], ((float[])object.get(j))[1]);
                        if (!(f3 < f2)) continue;
                        f2 = f3;
                        n = i;
                        n2 = j;
                    }
                }
                if (f2 != 0.0f) {
                    object.add(n2, object.get(n2));
                    object.add(++n2, list3.get(n));
                }
                List list5 = list3.subList(n, list3.size());
                object.addAll(n2, list5);
                object.addAll(n2 + list5.size(), list3.subList(0, n));
            }
            for (List list6 : arrayList) {
                if (bl) {
                    Collections.reverse(list6);
                }
                object5.add(list6.toArray((T[])new float[list6.size()][]));
            }
        }
        return object5;
    }

    static {
        DEFAULT_MATERIAL.setCapability(0);
        DEFAULT_MATERIAL.setShininess(1.0f);
        DEFAULT_MATERIAL.setSpecularColor(0.0f, 0.0f, 0.0f);
    }
}

