/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.DefaultLibrary;
import com.eteks.sweethome3d.io.URLContentClassLoader;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTexturesCatalog
extends TexturesCatalog {
    public static final String PLUGIN_TEXTURES_CATALOG_FAMILY = "PluginTexturesCatalog";
    private static final String ADDITIONAL_TEXTURES_CATALOG_FAMILY = "AdditionalTexturesCatalog";
    private List<Library> libraries;
    private static final Map<File, URL> pluginTexturesCatalogUrlUpdates = new HashMap<File, URL>();

    public DefaultTexturesCatalog() {
        this((File)null);
    }

    public DefaultTexturesCatalog(File file) {
        this(null, file);
    }

    public DefaultTexturesCatalog(UserPreferences userPreferences, File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this(userPreferences, fileArray);
    }

    public DefaultTexturesCatalog(UserPreferences userPreferences, File[] fileArray) {
        this.libraries = new ArrayList<Library>();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readDefaultTexturesCatalogs(userPreferences, arrayList);
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder(OperatingSystem.getFileVersionComparator()));
                for (File file2 : fileArray2) {
                    this.readPluginTexturesCatalog(file2, arrayList);
                }
            }
        }
    }

    public DefaultTexturesCatalog(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public DefaultTexturesCatalog(URL[] uRLArray, URL uRL) {
        this.libraries = new ArrayList<Library>();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkCreateClassLoader();
            }
            for (URL uRL2 : uRLArray) {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(PLUGIN_TEXTURES_CATALOG_FAMILY, Locale.getDefault(), new URLContentClassLoader(uRL2));
                    this.libraries.add(0, new DefaultLibrary(uRL2.toExternalForm(), "Textures library", resourceBundle));
                    this.readTextures(resourceBundle, uRL2, uRL, arrayList);
                }
                catch (MissingResourceException missingResourceException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (AccessControlException accessControlException) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PLUGIN_TEXTURES_CATALOG_FAMILY, Locale.getDefault());
            this.readTextures(resourceBundle, null, uRL, arrayList);
        }
    }

    public List<Library> getLibraries() {
        return Collections.unmodifiableList(this.libraries);
    }

    private void readPluginTexturesCatalog(File file, List<String> list) {
        try {
            Object object;
            Object object2;
            Object object3;
            long l = file.lastModified();
            URL uRL = pluginTexturesCatalogUrlUpdates.get(file);
            if (file.canWrite() && (uRL == null || uRL.openConnection().getLastModified() < l)) {
                object3 = TemporaryURLContent.copyToTemporaryURLContent(new URLContent(file.toURI().toURL()));
                object2 = ((URLContent)object3).getURL();
                pluginTexturesCatalogUrlUpdates.put(file, (URL)object2);
                object = object2;
            } else {
                object = uRL != null ? uRL : file.toURI().toURL();
            }
            object3 = new URLContentClassLoader((URL)object);
            object2 = ResourceBundle.getBundle(PLUGIN_TEXTURES_CATALOG_FAMILY, Locale.getDefault(), (ClassLoader)object3);
            this.libraries.add(0, new DefaultLibrary(file.getCanonicalPath(), "Textures library", (ResourceBundle)object2));
            this.readTextures((ResourceBundle)object2, (URL)object, null, list);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readDefaultTexturesCatalogs(UserPreferences userPreferences, List<String> list) {
        String string = DefaultTexturesCatalog.class.getName();
        this.readTexturesCatalog(string, userPreferences, list);
        String string2 = string.substring(0, string.lastIndexOf("."));
        this.readTexturesCatalog(string2 + "." + ADDITIONAL_TEXTURES_CATALOG_FAMILY, userPreferences, list);
    }

    private void readTexturesCatalog(final String string, final UserPreferences userPreferences, List<String> list) {
        ResourceBundle resourceBundle;
        if (userPreferences != null) {
            resourceBundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String string2) {
                    try {
                        return userPreferences.getLocalizedString(string, string2, new Object[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new MissingResourceException("Unknown key " + string2, string + "_" + Locale.getDefault(), string2);
                    }
                }

                @Override
                public Enumeration<String> getKeys() {
                    throw new UnsupportedOperationException();
                }
            };
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
        this.readTextures(resourceBundle, null, null, list);
    }

    private void readTextures(ResourceBundle resourceBundle, URL uRL, URL uRL2, List<String> list) {
        CatalogTexture catalogTexture;
        int n = 1;
        while ((catalogTexture = this.readTexture(resourceBundle, n, uRL, uRL2)) != null) {
            block4: {
                block3: {
                    if (catalogTexture.getId() == null) break block3;
                    if (list.contains(catalogTexture.getId())) break block4;
                    list.add(catalogTexture.getId());
                }
                TexturesCategory texturesCategory = this.readTexturesCategory(resourceBundle, n);
                this.add(texturesCategory, catalogTexture);
            }
            ++n;
        }
    }

    protected CatalogTexture readTexture(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
        String string = null;
        try {
            string = resourceBundle.getString(PropertyKey.NAME.getKey(n));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        Content content = this.getContent(resourceBundle, PropertyKey.IMAGE.getKey(n), uRL, uRL2);
        float f = Float.parseFloat(resourceBundle.getString(PropertyKey.WIDTH.getKey(n)));
        float f2 = Float.parseFloat(resourceBundle.getString(PropertyKey.HEIGHT.getKey(n)));
        String string2 = this.getOptionalString(resourceBundle, PropertyKey.CREATOR.getKey(n));
        String string3 = this.getOptionalString(resourceBundle, PropertyKey.ID.getKey(n));
        return new CatalogTexture(string3, string, content, f, f2, string2);
    }

    protected TexturesCategory readTexturesCategory(ResourceBundle resourceBundle, int n) {
        String string = resourceBundle.getString(PropertyKey.CATEGORY.getKey(n));
        return new TexturesCategory(string);
    }

    private Content getContent(ResourceBundle resourceBundle, String string, URL uRL, URL uRL2) {
        String string2 = resourceBundle.getString(string);
        try {
            URL uRL3 = uRL2 == null ? new URL(string2) : (string2.startsWith("?") ? new URL(uRL2 + string2) : new URL(uRL2, string2));
            return new URLContent(uRL3);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL == null) {
                return new ResourceURLContent(DefaultTexturesCatalog.class, string2);
            }
            try {
                return new ResourceURLContent(new URL("jar:" + uRL + "!" + string2), false);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException("Invalid URL", malformedURLException2);
            }
        }
    }

    private String getOptionalString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKey {
        ID("id"),
        NAME("name"),
        CATEGORY("category"),
        IMAGE("image"),
        WIDTH("width"),
        HEIGHT("height"),
        CREATOR("creator");

        private String keyPrefix;

        private PropertyKey(String string2) {
            this.keyPrefix = string2;
        }

        public String getKey(int n) {
            return this.keyPrefix + "#" + n;
        }
    }
}

