/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.ContentRecording;
import com.eteks.sweethome3d.io.HomeURLContent;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DefaultHomeInputStream
extends FilterInputStream {
    private final ContentRecording contentRecording;
    private File tempFile;

    public DefaultHomeInputStream(InputStream inputStream) throws IOException {
        this(inputStream, ContentRecording.INCLUDE_ALL_CONTENT);
    }

    public DefaultHomeInputStream(InputStream inputStream, ContentRecording contentRecording) throws IOException {
        super(inputStream);
        this.contentRecording = contentRecording;
    }

    private static void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Home readHome() throws IOException, ClassNotFoundException {
        Object object;
        Closeable closeable;
        if (this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
            this.tempFile = OperatingSystem.createTemporaryFile("open", ".sweethome3d");
            DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            closeable = null;
            try {
                int n;
                closeable = new FileOutputStream(this.tempFile);
                object = new byte[8192];
                while ((n = this.in.read((byte[])object)) != -1) {
                    ((OutputStream)closeable).write((byte[])object, 0, n);
                }
            }
            finally {
                if (closeable != null) {
                    ((OutputStream)closeable).close();
                }
            }
        }
        closeable = null;
        try {
            ZipEntry zipEntry;
            closeable = new ZipInputStream(this.contentRecording == ContentRecording.INCLUDE_NO_CONTENT ? this.in : new FileInputStream(this.tempFile));
            do {
                zipEntry = ((ZipInputStream)closeable).getNextEntry();
                object = zipEntry;
            } while (zipEntry != null && !"Home".equals(((ZipEntry)object).getName()));
            if (object == null) {
                throw new IOException("Missing entry \"Home\"");
            }
            DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            HomeObjectInputStream homeObjectInputStream = new HomeObjectInputStream((InputStream)closeable);
            Home home = (Home)homeObjectInputStream.readObject();
            return home;
        }
        finally {
            if (closeable != null) {
                ((ZipInputStream)closeable).close();
            }
        }
    }

    private class HomeObjectInputStream
    extends ObjectInputStream {
        public HomeObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            if (DefaultHomeInputStream.this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                this.enableResolveObject(true);
            }
        }

        protected Object resolveObject(Object object) throws IOException {
            if (object instanceof URLContent) {
                URL uRL = ((URLContent)object).getURL();
                String string = uRL.toString();
                if (string.startsWith("jar:file:temp!/")) {
                    String string2 = string.substring(string.indexOf(33) + 2);
                    URL uRL2 = new URL("jar:" + DefaultHomeInputStream.this.tempFile.toURI() + "!/" + string2);
                    HomeURLContent homeURLContent = new HomeURLContent(uRL2);
                    try {
                        homeURLContent.openStream().close();
                    }
                    catch (IOException iOException) {
                        throw new IOException("Missing entry \"" + string2 + "\"");
                    }
                    return homeURLContent;
                }
                return object;
            }
            return object;
        }
    }
}

