/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextureChoiceComponent
extends JButton
implements TextureChoiceView {
    private final UserPreferences preferences;

    public TextureChoiceComponent(final UserPreferences userPreferences, final TextureChoiceController textureChoiceController) {
        this.preferences = userPreferences;
        JLabel jLabel = new JLabel("Text");
        Dimension dimension = jLabel.getPreferredSize();
        final int n = dimension.height;
        textureChoiceController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextureChoiceComponent.this.repaint();
            }
        });
        this.setIcon(new Icon(){

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n;
            }

            public void paintIcon(Component component, Graphics graphics, int n3, int n2) {
                graphics.setColor(Color.BLACK);
                graphics.drawRect(n3 + 2, n2 + 2, n - 5, n - 5);
                HomeTexture homeTexture = textureChoiceController.getTexture();
                if (homeTexture != null) {
                    Icon icon = IconManager.getInstance().getIcon(homeTexture.getImage(), n - 6, TextureChoiceComponent.this);
                    if (icon.getIconWidth() != icon.getIconHeight()) {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        AffineTransform affineTransform = graphics2D.getTransform();
                        graphics2D.translate(n3 + 3, n2 + 3);
                        graphics2D.scale((float)icon.getIconHeight() / (float)icon.getIconWidth(), 1.0);
                        icon.paintIcon(component, graphics2D, 0, 0);
                        graphics2D.setTransform(affineTransform);
                    } else {
                        icon.paintIcon(component, graphics, n3 + 3, n2 + 3);
                    }
                }
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TexturePanel texturePanel = new TexturePanel(userPreferences, textureChoiceController);
                texturePanel.displayView(TextureChoiceComponent.this);
            }
        });
    }

    public boolean confirmDeleteSelectedCatalogTexture() {
        String string = this.preferences.getLocalizedString(TextureChoiceComponent.class, "confirmDeleteSelectedCatalogTexture.message", new Object[0]);
        String string2 = this.preferences.getLocalizedString(TextureChoiceComponent.class, "confirmDeleteSelectedCatalogTexture.title", new Object[0]);
        String string3 = this.preferences.getLocalizedString(TextureChoiceComponent.class, "confirmDeleteSelectedCatalogTexture.delete", new Object[0]);
        String string4 = this.preferences.getLocalizedString(TextureChoiceComponent.class, "confirmDeleteSelectedCatalogTexture.cancel", new Object[0]);
        return JOptionPane.showOptionDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), string, string2, 2, 3, null, new Object[]{string3, string4}, string4) == 0;
    }

    private static class TexturePanel
    extends JPanel {
        private static final int PREVIEW_ICON_HEIGHT = 64;
        private TextureChoiceController controller;
        private TextureImage previewTexture;
        private JLabel chosenTextureLabel;
        private JLabel texturePreviewLabel;
        private JLabel availableTexturesLabel;
        private JList availableTexturesList;
        private JButton importTextureButton;
        private JButton modifyTextureButton;
        private JButton deleteTextureButton;

        public TexturePanel(UserPreferences userPreferences, TextureChoiceController textureChoiceController) {
            super(new GridBagLayout());
            this.controller = textureChoiceController;
            this.createComponents(userPreferences, textureChoiceController);
            this.setMnemonics(userPreferences);
            this.layoutComponents();
        }

        private void createComponents(UserPreferences userPreferences, final TextureChoiceController textureChoiceController) {
            this.availableTexturesLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "availableTexturesLabel.text", new Object[0]));
            this.availableTexturesList = new JList(this.createListModel(userPreferences.getTexturesCatalog()));
            this.availableTexturesList.setSelectionMode(0);
            this.availableTexturesList.setCellRenderer(new TextureListCellRenderer());
            this.availableTexturesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    CatalogTexture catalogTexture = (CatalogTexture)TexturePanel.this.availableTexturesList.getSelectedValue();
                    TexturePanel.this.setPreviewTexture(catalogTexture);
                    if (TexturePanel.this.modifyTextureButton != null) {
                        TexturePanel.this.modifyTextureButton.setEnabled(catalogTexture != null && catalogTexture.isModifiable());
                    }
                    if (TexturePanel.this.deleteTextureButton != null) {
                        TexturePanel.this.deleteTextureButton.setEnabled(catalogTexture != null && catalogTexture.isModifiable());
                    }
                }
            });
            this.chosenTextureLabel = new JLabel(userPreferences.getLocalizedString(TextureChoiceComponent.class, "chosenTextureLabel.text", new Object[0]));
            this.texturePreviewLabel = new JLabel(){
                private int lastIconWidth;

                protected void paintComponent(Graphics graphics) {
                    Icon icon = this.getIcon();
                    if (icon != null && icon.getIconWidth() != this.lastIconWidth) {
                        this.lastIconWidth = icon.getIconWidth();
                        this.revalidate();
                    } else {
                        super.paintComponent(graphics);
                    }
                }

                public void setIcon(Icon icon) {
                    if (icon != null) {
                        this.lastIconWidth = icon.getIconWidth();
                    }
                    super.setIcon(icon);
                }
            };
            this.setPreviewTexture(textureChoiceController.getTexture());
            try {
                String string = SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "importTextureButton.text", new Object[0]);
                this.texturePreviewLabel.setBorder(SwingTools.getDropableComponentBorder());
                this.texturePreviewLabel.setTransferHandler(new TransferHandler(){

                    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                        return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
                    }

                    public boolean importData(JComponent jComponent, Transferable transferable) {
                        try {
                            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                            final String string = ((File)list.get(0)).getAbsolutePath();
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    textureChoiceController.importTexture(string);
                                }
                            });
                            return true;
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            return false;
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                });
                this.importTextureButton = new JButton(string);
                this.importTextureButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        textureChoiceController.importTexture();
                    }
                });
                this.modifyTextureButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "modifyTextureButton.text", new Object[0]));
                this.modifyTextureButton.setEnabled(false);
                this.modifyTextureButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        textureChoiceController.modifyTexture((CatalogTexture)TexturePanel.this.availableTexturesList.getSelectedValue());
                    }
                });
                this.deleteTextureButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, TextureChoiceComponent.class, "deleteTextureButton.text", new Object[0]));
                this.deleteTextureButton.setEnabled(false);
                this.deleteTextureButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        textureChoiceController.deleteTexture((CatalogTexture)TexturePanel.this.availableTexturesList.getSelectedValue());
                    }
                });
                userPreferences.getTexturesCatalog().addTexturesListener(new TexturesCatalogListener(this));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.texturePreviewLabel.setBorder(BorderFactory.createEtchedBorder(1));
            }
        }

        private void setMnemonics(UserPreferences userPreferences) {
            if (!OperatingSystem.isMacOSX()) {
                this.availableTexturesLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "availableTexturesLabel.mnemonic", new Object[0])).getKeyCode());
                this.availableTexturesLabel.setLabelFor(this.availableTexturesList);
                if (this.importTextureButton != null) {
                    this.importTextureButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "importTextureButton.mnemonic", new Object[0])).getKeyCode());
                    this.modifyTextureButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "modifyTextureButton.mnemonic", new Object[0])).getKeyCode());
                    this.deleteTextureButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(TextureChoiceComponent.class, "deleteTextureButton.mnemonic", new Object[0])).getKeyCode());
                }
            }
        }

        private void layoutComponents() {
            this.add((Component)this.availableTexturesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 15), 0, 0));
            this.add((Component)this.chosenTextureLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)new JScrollPane(this.availableTexturesList), new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 15), 50, 0));
            SwingTools.installFocusBorder(this.availableTexturesList);
            this.add((Component)this.texturePreviewLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 10, 0), 0, 0));
            if (this.importTextureButton != null) {
                JPanel jPanel = new JPanel(new GridLayout(3, 1, 2, 2));
                jPanel.add(this.importTextureButton);
                jPanel.add(this.modifyTextureButton);
                jPanel.add(this.deleteTextureButton);
                this.add((Component)jPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 10, 0), 0, 0));
            }
        }

        public TextureImage getPreviewTexture() {
            return this.previewTexture;
        }

        public void setPreviewTexture(TextureImage textureImage) {
            this.previewTexture = textureImage;
            if (textureImage != null) {
                this.texturePreviewLabel.setIcon(IconManager.getInstance().getIcon(textureImage.getImage(), 64, this.texturePreviewLabel));
                this.texturePreviewLabel.setToolTipText(textureImage.getName());
            } else {
                this.texturePreviewLabel.setIcon(new Icon(){

                    public int getIconHeight() {
                        return 64;
                    }

                    public int getIconWidth() {
                        return 64;
                    }

                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                    }
                });
                this.texturePreviewLabel.setToolTipText(null);
            }
            this.availableTexturesList.setSelectedValue(textureImage, true);
            if (this.availableTexturesList.getSelectedValue() != textureImage) {
                int n = this.availableTexturesList.getSelectedIndex();
                this.availableTexturesList.removeSelectionInterval(n, n);
            }
        }

        private AbstractListModel createListModel(TexturesCatalog texturesCatalog) {
            final CatalogTexture[] catalogTextureArray = this.getTextures(texturesCatalog);
            return new AbstractListModel(){

                public Object getElementAt(int n) {
                    return catalogTextureArray[n];
                }

                public int getSize() {
                    return catalogTextureArray.length;
                }
            };
        }

        private CatalogTexture[] getTextures(TexturesCatalog texturesCatalog) {
            ArrayList<CatalogTexture> arrayList = new ArrayList<CatalogTexture>();
            for (TexturesCategory texturesCategory : texturesCatalog.getCategories()) {
                for (CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                    arrayList.add(catalogTexture);
                }
            }
            return arrayList.toArray(new CatalogTexture[arrayList.size()]);
        }

        public void displayView(View view) {
            final JOptionPane jOptionPane = new JOptionPane(this, -1, 2);
            JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)((Object)view));
            if (jRootPane != null) {
                jOptionPane.setComponentOrientation(jRootPane.getComponentOrientation());
            }
            final JDialog jDialog = jOptionPane.createDialog(jRootPane, this.controller.getDialogTitle());
            jDialog.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
            jDialog.setResizable(true);
            jDialog.pack();
            jDialog.setMinimumSize(this.getPreferredSize());
            jDialog.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(TexturePanel.this);
                    jDialog.removeComponentListener(this);
                }
            });
            this.availableTexturesList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        jOptionPane.setValue(0);
                        TexturePanel.this.availableTexturesList.removeMouseListener(this);
                    }
                }
            });
            jDialog.setVisible(true);
            jDialog.dispose();
            if (Integer.valueOf(0).equals(jOptionPane.getValue())) {
                TextureImage textureImage = this.getPreviewTexture();
                if (textureImage instanceof HomeTexture || textureImage == null) {
                    this.controller.setTexture((HomeTexture)textureImage);
                } else {
                    this.controller.setTexture(new HomeTexture(textureImage));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class TexturesCatalogListener
        implements CollectionListener<CatalogTexture> {
            private WeakReference<TexturePanel> texturePanel;

            public TexturesCatalogListener(TexturePanel texturePanel) {
                this.texturePanel = new WeakReference<TexturePanel>(texturePanel);
            }

            @Override
            public void collectionChanged(CollectionEvent<CatalogTexture> collectionEvent) {
                TexturePanel texturePanel = (TexturePanel)this.texturePanel.get();
                if (texturePanel == null) {
                    ((TexturesCatalog)collectionEvent.getSource()).removeTexturesListener(this);
                } else {
                    texturePanel.availableTexturesList.setModel(texturePanel.createListModel((TexturesCatalog)collectionEvent.getSource()));
                    switch (collectionEvent.getType()) {
                        case ADD: {
                            texturePanel.availableTexturesList.setSelectedValue(collectionEvent.getItem(), true);
                            break;
                        }
                        case DELETE: {
                            texturePanel.availableTexturesList.clearSelection();
                        }
                    }
                }
            }
        }

        private static class TextureListCellRenderer
        extends DefaultListCellRenderer {
            private Font defaultFont;
            private Font modifiablePieceFont;

            private TextureListCellRenderer() {
            }

            public Component getListCellRendererComponent(final JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (this.defaultFont == null) {
                    this.defaultFont = this.getFont();
                    this.modifiablePieceFont = new Font(this.defaultFont.getFontName(), 2, this.defaultFont.getSize());
                }
                final CatalogTexture catalogTexture = (CatalogTexture)object;
                object = catalogTexture.getName();
                object = catalogTexture.getCategory().getName() + " - " + object;
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                this.setIcon(new Icon(){

                    public int getIconWidth() {
                        return 16;
                    }

                    public int getIconHeight() {
                        return 16;
                    }

                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        Icon icon = IconManager.getInstance().getIcon(catalogTexture.getImage(), this.getIconHeight(), jList);
                        if (icon.getIconWidth() != icon.getIconHeight()) {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            AffineTransform affineTransform = graphics2D.getTransform();
                            graphics2D.translate(n, n2);
                            graphics2D.scale((float)icon.getIconHeight() / (float)icon.getIconWidth(), 1.0);
                            icon.paintIcon(component, graphics2D, 0, 0);
                            graphics2D.setTransform(affineTransform);
                        } else {
                            icon.paintIcon(component, graphics, n, n2);
                        }
                    }
                });
                this.setFont(catalogTexture.isModifiable() ? this.modifiablePieceFont : this.defaultFont);
                return component;
            }
        }
    }
}

