/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeFurnitureGroup
extends HomePieceOfFurniture {
    private static final long serialVersionUID = 1L;
    private static final float[][] IDENTITY = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
    private List<HomePieceOfFurniture> furniture;
    private boolean resizable;
    private boolean deformable;
    private boolean texturable;
    private boolean doorOrWindow;
    private float fixedWidth;
    private float fixedDepth;
    private float fixedHeight;
    private String currency;
    private List<Integer> furnitureDefaultColors;
    private List<HomeTexture> furnitureDefaultTextures;

    public HomeFurnitureGroup(List<HomePieceOfFurniture> list, String string) {
        super(list.get(0));
        Level level;
        boolean bl;
        this.furniture = Collections.unmodifiableList(list);
        HomePieceOfFurniture homePieceOfFurniture = list.get(0);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-homePieceOfFurniture.getAngle());
        RectangularShape rectangularShape = null;
        for (HomePieceOfFurniture homePieceOfFurniture2 : this.getFurnitureWithoutGroups(list)) {
            GeneralPath generalPath = new GeneralPath();
            float[][] fArray = homePieceOfFurniture2.getPoints();
            generalPath.moveTo(fArray[0][0], fArray[0][1]);
            for (bl = true; bl < fArray.length; bl += 1) {
                generalPath.lineTo(fArray[bl][0], fArray[bl][1]);
            }
            generalPath.closePath();
            if (rectangularShape == null) {
                rectangularShape = generalPath.createTransformedShape(affineTransform).getBounds2D();
                continue;
            }
            ((Rectangle2D)rectangularShape).add(generalPath.createTransformedShape(affineTransform).getBounds2D());
        }
        Point2D.Float float_ = new Point2D.Float((float)rectangularShape.getCenterX(), (float)rectangularShape.getCenterY());
        affineTransform.setToRotation(homePieceOfFurniture.getAngle());
        affineTransform.transform(float_, float_);
        float f = Float.MAX_VALUE;
        float f2 = 0.0f;
        boolean bl2 = true;
        this.resizable = true;
        this.deformable = true;
        this.texturable = true;
        this.doorOrWindow = true;
        bl = false;
        boolean bl3 = true;
        this.currency = homePieceOfFurniture.getCurrency();
        Level level2 = null;
        for (HomePieceOfFurniture homePieceOfFurniture3 : list) {
            level = homePieceOfFurniture3.getLevel();
            if (level == null || level2 != null && !(level.getElevation() < level2.getElevation())) continue;
            level2 = level;
        }
        for (HomePieceOfFurniture homePieceOfFurniture3 : list) {
            level = homePieceOfFurniture3.getLevel();
            if (level != null) {
                f = Math.min(f, homePieceOfFurniture3.getGroundElevation() - level2.getElevation());
                continue;
            }
            f = Math.min(f, homePieceOfFurniture3.getElevation());
        }
        for (HomePieceOfFurniture homePieceOfFurniture3 : list) {
            if (homePieceOfFurniture3.getLevel() != null) {
                homePieceOfFurniture3.setElevation(homePieceOfFurniture3.getGroundElevation() - level2.getElevation());
            }
            homePieceOfFurniture3.setLevel(null);
            f2 = Math.max(f2, homePieceOfFurniture3.getElevation() + homePieceOfFurniture3.getHeight());
            bl2 &= homePieceOfFurniture3.isMovable();
            this.resizable &= homePieceOfFurniture3.isResizable();
            this.deformable &= homePieceOfFurniture3.isDeformable();
            this.texturable &= homePieceOfFurniture3.isTexturable();
            this.doorOrWindow &= homePieceOfFurniture3.isDoorOrWindow();
            bl |= homePieceOfFurniture3.isVisible();
            bl3 &= homePieceOfFurniture3.isModelMirrored();
            if (this.currency == null || homePieceOfFurniture3.getCurrency() != null && homePieceOfFurniture3.getCurrency().equals(this.currency)) continue;
            this.currency = null;
        }
        if (this.resizable) {
            super.setWidth((float)rectangularShape.getWidth());
            super.setDepth((float)rectangularShape.getHeight());
            super.setHeight(f2 - f);
            super.setModelMirrored(bl3);
        } else {
            this.fixedWidth = (float)rectangularShape.getWidth();
            this.fixedDepth = (float)rectangularShape.getHeight();
            this.fixedHeight = f2 - f;
        }
        this.setName(string);
        this.setNameVisible(false);
        this.setNameXOffset(0.0f);
        this.setNameYOffset(0.0f);
        this.setNameStyle(null);
        this.setDescription(null);
        this.setMovable(bl2);
        this.setVisible(bl);
        if (this.texturable) {
            super.setColor(null);
            super.setTexture(null);
        }
        super.setX((float)((Point2D)float_).getX());
        super.setY((float)((Point2D)float_).getY());
        super.setAngle(homePieceOfFurniture.getAngle());
        super.setElevation(f);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.deformable = true;
        this.texturable = true;
        objectInputStream.defaultReadObject();
    }

    private List<HomePieceOfFurniture> getFurnitureWithoutGroups(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getFurnitureWithoutGroups(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                continue;
            }
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public List<HomePieceOfFurniture> getFurniture() {
        return this.furniture;
    }

    @Override
    public String getCatalogId() {
        return null;
    }

    @Override
    public String getInformation() {
        return null;
    }

    @Override
    public boolean isMovable() {
        return super.isMovable();
    }

    @Override
    public void setMovable(boolean bl) {
        super.setMovable(bl);
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homePieceOfFurniture.setMovable(bl);
        }
    }

    @Override
    public boolean isDoorOrWindow() {
        return this.doorOrWindow;
    }

    @Override
    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public boolean isDeformable() {
        return this.deformable;
    }

    @Override
    public boolean isTexturable() {
        return this.texturable;
    }

    @Override
    public float getWidth() {
        if (!this.resizable) {
            return this.fixedWidth;
        }
        return super.getWidth();
    }

    @Override
    public float getDepth() {
        if (!this.resizable) {
            return this.fixedDepth;
        }
        return super.getDepth();
    }

    @Override
    public float getHeight() {
        if (!this.resizable) {
            return this.fixedHeight;
        }
        return super.getHeight();
    }

    @Override
    public Content getIcon() {
        return null;
    }

    @Override
    public Content getPlanIcon() {
        return null;
    }

    @Override
    public Content getModel() {
        return null;
    }

    @Override
    public float[][] getModelRotation() {
        return IDENTITY;
    }

    @Override
    public String getStaircaseCutOutShape() {
        return null;
    }

    @Override
    public String getCreator() {
        return null;
    }

    @Override
    public BigDecimal getPrice() {
        BigDecimal bigDecimal = null;
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (homePieceOfFurniture.getPrice() == null) continue;
            if (bigDecimal == null) {
                bigDecimal = homePieceOfFurniture.getPrice();
                continue;
            }
            bigDecimal = bigDecimal.add(homePieceOfFurniture.getPrice());
        }
        if (bigDecimal == null) {
            return super.getPrice();
        }
        return bigDecimal;
    }

    @Override
    public void setPrice(BigDecimal bigDecimal) {
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (homePieceOfFurniture.getPrice() == null) continue;
            throw new UnsupportedOperationException("Can't change the price of a group containing pieces with a price");
        }
        super.setPrice(bigDecimal);
    }

    @Override
    public BigDecimal getValueAddedTaxPercentage() {
        BigDecimal bigDecimal = this.furniture.get(0).getValueAddedTaxPercentage();
        if (bigDecimal != null) {
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                BigDecimal bigDecimal2 = homePieceOfFurniture.getValueAddedTaxPercentage();
                if (bigDecimal2 != null && bigDecimal2.equals(bigDecimal)) continue;
                return null;
            }
        }
        return bigDecimal;
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    @Override
    public BigDecimal getValueAddedTax() {
        BigDecimal bigDecimal = null;
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            BigDecimal bigDecimal2 = homePieceOfFurniture.getValueAddedTax();
            if (bigDecimal2 == null) continue;
            if (bigDecimal == null) {
                bigDecimal = bigDecimal2;
                continue;
            }
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getPriceValueAddedTaxIncluded() {
        BigDecimal bigDecimal = null;
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (homePieceOfFurniture.getPrice() == null) continue;
            if (bigDecimal == null) {
                bigDecimal = homePieceOfFurniture.getPriceValueAddedTaxIncluded();
                continue;
            }
            bigDecimal = bigDecimal.add(homePieceOfFurniture.getPriceValueAddedTaxIncluded());
        }
        return bigDecimal;
    }

    @Override
    public boolean isBackFaceShown() {
        return false;
    }

    @Override
    public void setColor(Integer n) {
        super.setColor(n);
        if (n != null) {
            this.storeDefaultColorsAndTextures();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setTexture(null);
                homePieceOfFurniture.setColor(n);
            }
        } else if (this.getTexture() == null) {
            this.restoreDefaultColorsAndTextures();
        }
    }

    @Override
    public void setTexture(HomeTexture homeTexture) {
        super.setTexture(homeTexture);
        if (homeTexture != null) {
            this.storeDefaultColorsAndTextures();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setColor(null);
                homePieceOfFurniture.setTexture(homeTexture);
            }
        } else if (this.getColor() == null) {
            this.restoreDefaultColorsAndTextures();
        }
    }

    private void storeDefaultColorsAndTextures() {
        if (this.furnitureDefaultColors == null) {
            Integer[] integerArray = new Integer[this.furniture.size()];
            HomeTexture[] homeTextureArray = new HomeTexture[this.furniture.size()];
            for (int i = 0; i < this.furniture.size(); ++i) {
                integerArray[i] = this.furniture.get(i).getColor();
                homeTextureArray[i] = this.furniture.get(i).getTexture();
            }
            this.furnitureDefaultColors = Arrays.asList(integerArray);
            this.furnitureDefaultTextures = Arrays.asList(homeTextureArray);
        }
    }

    private void restoreDefaultColorsAndTextures() {
        if (this.furnitureDefaultColors != null) {
            for (int i = 0; i < this.furniture.size(); ++i) {
                this.furniture.get(i).setColor(this.furnitureDefaultColors.get(i));
                this.furniture.get(i).setTexture(this.furnitureDefaultTextures.get(i));
            }
            this.furnitureDefaultColors = null;
            this.furnitureDefaultTextures = null;
        }
    }

    @Override
    public void setAngle(float f) {
        if (f != this.getAngle()) {
            float f2 = f - this.getAngle();
            super.setAngle(f);
            double d = Math.cos(f2);
            double d2 = Math.sin(f2);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setAngle(homePieceOfFurniture.getAngle() + f2);
                float f3 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d - (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f4 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                homePieceOfFurniture.setX(f3);
                homePieceOfFurniture.setY(f4);
            }
        }
    }

    @Override
    public void setX(float f) {
        if (f != this.getX()) {
            float f2 = f - this.getX();
            super.setX(f);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setX(homePieceOfFurniture.getX() + f2);
            }
        }
    }

    @Override
    public void setY(float f) {
        if (f != this.getY()) {
            float f2 = f - this.getY();
            super.setY(f);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setY(homePieceOfFurniture.getY() + f2);
            }
        }
    }

    @Override
    public void setWidth(float f) {
        if (f != this.getWidth()) {
            float f2 = f / this.getWidth();
            super.setWidth(f);
            float f3 = this.getAngle();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                float f4 = homePieceOfFurniture.getAngle() - f3;
                float f5 = homePieceOfFurniture.getWidth();
                float f6 = homePieceOfFurniture.getDepth();
                homePieceOfFurniture.setWidth(f5 + f5 * (f2 - 1.0f) * Math.abs((float)Math.cos(f4)));
                homePieceOfFurniture.setDepth(f6 + f6 * (f2 - 1.0f) * Math.abs((float)Math.sin(f4)));
                double d = Math.cos(f3);
                double d2 = Math.sin(f3);
                float f7 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f8 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                f7 = this.getX() + (f7 - this.getX()) * f2;
                homePieceOfFurniture.setX(this.getX() + (float)((double)(f7 - this.getX()) * d - (double)(f8 - this.getY()) * d2));
                homePieceOfFurniture.setY(this.getY() + (float)((double)(f7 - this.getX()) * d2 + (double)(f8 - this.getY()) * d));
            }
        }
    }

    @Override
    public void setDepth(float f) {
        if (f != this.getDepth()) {
            float f2 = f / this.getDepth();
            super.setDepth(f);
            float f3 = this.getAngle();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                float f4 = homePieceOfFurniture.getAngle() - f3;
                float f5 = homePieceOfFurniture.getWidth();
                float f6 = homePieceOfFurniture.getDepth();
                homePieceOfFurniture.setWidth(f5 + f5 * (f2 - 1.0f) * Math.abs((float)Math.sin(f4)));
                homePieceOfFurniture.setDepth(f6 + f6 * (f2 - 1.0f) * Math.abs((float)Math.cos(f4)));
                double d = Math.cos(f3);
                double d2 = Math.sin(f3);
                float f7 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f8 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                f8 = this.getY() + (f8 - this.getY()) * f2;
                homePieceOfFurniture.setX(this.getX() + (float)((double)(f7 - this.getX()) * d - (double)(f8 - this.getY()) * d2));
                homePieceOfFurniture.setY(this.getY() + (float)((double)(f7 - this.getX()) * d2 + (double)(f8 - this.getY()) * d));
            }
        }
    }

    @Override
    public void setHeight(float f) {
        if (f != this.getHeight()) {
            float f2 = f / this.getHeight();
            super.setHeight(f);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setHeight(homePieceOfFurniture.getHeight() * f2);
                homePieceOfFurniture.setElevation(this.getElevation() + (homePieceOfFurniture.getElevation() - this.getElevation()) * f2);
            }
        }
    }

    @Override
    public void setElevation(float f) {
        if (f != this.getElevation()) {
            float f2 = f - this.getElevation();
            super.setElevation(f);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setElevation(homePieceOfFurniture.getElevation() + f2);
            }
        }
    }

    @Override
    public void setModelMirrored(boolean bl) {
        if (bl != this.isModelMirrored()) {
            super.setModelMirrored(bl);
            float f = this.getAngle();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setModelMirrored(!homePieceOfFurniture.isModelMirrored());
                double d = Math.cos(f);
                double d2 = Math.sin(f);
                float f2 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f3 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                f2 = this.getX() - (f2 - this.getX());
                homePieceOfFurniture.setX(this.getX() + (float)((double)(f2 - this.getX()) * d - (double)(f3 - this.getY()) * d2));
                homePieceOfFurniture.setY(this.getY() + (float)((double)(f2 - this.getX()) * d2 + (double)(f3 - this.getY()) * d));
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homePieceOfFurniture.setVisible(bl);
        }
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homePieceOfFurniture.setLevel(level);
        }
    }

    @Override
    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (!homePieceOfFurniture.intersectsRectangle(f, f2, f3, f4)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsPoint(float f, float f2, float f3) {
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (!homePieceOfFurniture.containsPoint(f, f2, f3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HomeFurnitureGroup clone() {
        HomeFurnitureGroup homeFurnitureGroup = (HomeFurnitureGroup)super.clone();
        homeFurnitureGroup.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture.size());
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            HomePieceOfFurniture homePieceOfFurniture2 = homePieceOfFurniture.clone();
            homeFurnitureGroup.furniture.add(homePieceOfFurniture2);
            if (!(homePieceOfFurniture instanceof HomeDoorOrWindow) || !((HomeDoorOrWindow)homePieceOfFurniture).isBoundToWall()) continue;
            ((HomeDoorOrWindow)homePieceOfFurniture2).setBoundToWall(true);
        }
        homeFurnitureGroup.furniture = Collections.unmodifiableList(homeFurnitureGroup.furniture);
        if (this.furnitureDefaultColors != null) {
            homeFurnitureGroup.furnitureDefaultColors = new ArrayList<Integer>(this.furnitureDefaultColors);
        }
        if (this.furnitureDefaultTextures != null) {
            homeFurnitureGroup.furnitureDefaultTextures = new ArrayList<HomeTexture>(this.furnitureDefaultTextures);
        }
        return homeFurnitureGroup;
    }
}

