/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    public ObjectInputStreamWithClassLoader(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = loader.loadClass(name);
            if (clazz == null) {
                return super.resolveClass(desc);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
    }
}

