/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.management.impl;

import javax.management.MBeanOperationInfo;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.management.BroadcastGroupControl;
import org.hornetq.core.config.BroadcastGroupConfiguration;
import org.hornetq.core.management.impl.AbstractControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class BroadcastGroupControlImpl
extends AbstractControl
implements BroadcastGroupControl {
    private final BroadcastGroup broadcastGroup;
    private final BroadcastGroupConfiguration configuration;

    public BroadcastGroupControlImpl(BroadcastGroup broadcastGroup, StorageManager storageManager, BroadcastGroupConfiguration configuration) throws Exception {
        super(BroadcastGroupControl.class, storageManager);
        this.broadcastGroup = broadcastGroup;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBroadcastPeriod() {
        this.clearIO();
        try {
            long l = this.configuration.getBroadcastPeriod();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getConnectorPairs() {
        this.clearIO();
        try {
            Object[] ret = new Object[this.configuration.getConnectorInfos().size()];
            int i = 0;
            for (Pair<String, String> pair : this.configuration.getConnectorInfos()) {
                String[] opair = new String[]{(String)pair.a, pair.b != null ? (String)pair.b : null};
                ret[i++] = opair;
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectorPairsAsJSON() throws Exception {
        this.clearIO();
        try {
            JSONArray array = new JSONArray();
            for (Pair<String, String> pair : this.configuration.getConnectorInfos()) {
                JSONObject p = new JSONObject();
                p.put("a", pair.a);
                p.put("b", pair.b);
                array.put(p);
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGroupAddress() {
        this.clearIO();
        try {
            String string = this.configuration.getGroupAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getGroupPort() {
        this.clearIO();
        try {
            int n = this.configuration.getGroupPort();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalBindPort() {
        this.clearIO();
        try {
            int n = this.configuration.getLocalBindPort();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        this.clearIO();
        try {
            boolean bl = this.broadcastGroup.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.clearIO();
        try {
            this.broadcastGroup.start();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        this.clearIO();
        try {
            this.broadcastGroup.stop();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(BroadcastGroupControl.class);
    }
}

