/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.domain;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.classpool.base.BaseClassPool;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.logging.Logger;

public abstract class AbstractClassPoolDomain
implements ClassPoolDomain {
    protected final Logger logger = Logger.getLogger(this.getClass());

    protected abstract CtClass getCachedOrCreateFromParent(DelegatingClassPool var1, String var2, String var3, boolean var4, boolean var5);

    protected CtClass getCachedOrCreateFromPoolParent(DelegatingClassPool initiatingPool, String classname, boolean create, boolean trace) {
        if (initiatingPool == null) {
            if (trace) {
                this.logger.trace((Object)(this + " get cached or create " + classname + " from pool parent - no initiating pool"));
            }
            return null;
        }
        ClassPool parentPool = initiatingPool.getParent();
        if (parentPool == null) {
            if (trace) {
                this.logger.trace((Object)(this + " get cached or create " + classname + " from pool parent - no parent pool"));
            }
            return null;
        }
        return this.getCachedOrCreateFromPool(parentPool, classname, create, trace);
    }

    protected CtClass getCachedOrCreateFromPool(ClassPool pool, String classname, boolean create, boolean trace) {
        if (pool instanceof BaseClassPool) {
            return this.getCachedOrCreateFromPool((BaseClassPool)pool, classname, create, trace);
        }
        try {
            if (trace) {
                this.logger.trace((Object)(this + " get cached or create " + classname + " from non-BaseClassPool pool " + pool));
            }
            CtClass clazz = pool.get(classname);
            if (trace) {
                this.logger.trace((Object)(this + " got cached or create " + classname + " from non-BaseClassPool pool " + clazz.getClassPool()));
            }
            return clazz;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    protected CtClass getCachedOrCreateFromPool(BaseClassPool pool, String classname, boolean create, boolean trace) {
        if (pool == null) {
            if (trace) {
                this.logger.trace((Object)(this + " get cached or create " + classname + " from BaseClassPool - no pool"));
            }
            return null;
        }
        CtClass clazz = null;
        if (clazz == null) {
            if (trace) {
                this.logger.trace((Object)(this + " get cached or create " + classname + " from BaseClassPool - checking cache"));
            }
            if ((clazz = pool.getCached(classname)) == null && create) {
                if (trace) {
                    this.logger.trace((Object)(this + " get cached or create " + classname + " from BaseClassPool - creating"));
                }
                clazz = pool.createCtClass(classname, true);
            }
        }
        return clazz;
    }
}

