/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.NioByteInput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.util.IntKeyMap;
import org.jboss.remoting3.ReplyException;
import org.jboss.remoting3.ServiceNotFoundException;
import org.jboss.remoting3.ServiceOpenException;
import org.jboss.remoting3.ServiceURI;
import org.jboss.remoting3.remote.AbstractMessageHandler;
import org.jboss.remoting3.remote.InboundClient;
import org.jboss.remoting3.remote.InboundReplyExceptionTask;
import org.jboss.remoting3.remote.InboundReplyInputHandler;
import org.jboss.remoting3.remote.InboundReplyTask;
import org.jboss.remoting3.remote.InboundRequest;
import org.jboss.remoting3.remote.InboundRequestTask;
import org.jboss.remoting3.remote.InboundStream;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.OutboundClient;
import org.jboss.remoting3.remote.OutboundRequest;
import org.jboss.remoting3.remote.OutboundRequestHandler;
import org.jboss.remoting3.remote.OutboundStream;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.LocalReplyHandler;
import org.jboss.remoting3.spi.LocalRequestHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Pool;
import org.jboss.xnio.channels.MessageHandler;
import org.jboss.xnio.log.Logger;

final class RemoteMessageHandler
extends AbstractMessageHandler
implements MessageHandler {
    private final RemoteConnection connection;
    private final RemoteConnectionHandler remoteConnectionHandler;
    private static final Logger log = Loggers.main;

    RemoteMessageHandler(RemoteConnectionHandler remoteConnectionHandler, RemoteConnection connection) {
        super(connection);
        this.remoteConnectionHandler = remoteConnectionHandler;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(ByteBuffer buffer) {
        byte cmd = buffer.get();
        RemoteConnectionHandler connectionHandler = this.remoteConnectionHandler;
        switch (cmd) {
            case 16: {
                int id = buffer.getInt();
                String serviceType = Buffers.getModifiedUtf8Z((ByteBuffer)buffer);
                String groupName = Buffers.getModifiedUtf8Z((ByteBuffer)buffer);
                Pool<ByteBuffer> bufferPool = connectionHandler.getBufferPool();
                ByteInput input = Marshalling.createByteInput((ByteBuffer)buffer);
                ByteBuffer outBuf = (ByteBuffer)bufferPool.allocate();
                try {
                    OptionMap optionMap;
                    try {
                        Unmarshaller unmarshaller = this.remoteConnectionHandler.getMarshallerFactory().createUnmarshaller(this.remoteConnectionHandler.getMarshallingConfiguration());
                        try {
                            unmarshaller.start(input);
                            optionMap = (OptionMap)unmarshaller.readObject();
                            unmarshaller.finish();
                        }
                        finally {
                            IoUtils.safeClose((Closeable)unmarshaller);
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to unmarshall service request option map: %s", (Object)e);
                        outBuf.putInt(0);
                        outBuf.put((byte)19);
                        outBuf.putInt(id);
                        outBuf.flip();
                        try {
                            this.connection.sendBlocking(outBuf, true);
                        }
                        catch (IOException e1) {
                            log.trace("Send failed: %s", (Object)e);
                        }
                        bufferPool.free((Object)outBuf);
                        return;
                    }
                    LocalRequestHandler handler = connectionHandler.getConnectionContext().openService(serviceType, groupName, optionMap);
                    outBuf.putInt(0);
                    if (handler == null) {
                        outBuf.put((byte)17);
                    } else {
                        IntKeyMap<InboundClient> inboundClients;
                        InboundClient inboundClient = new InboundClient(connectionHandler, handler, id);
                        IntKeyMap<InboundClient> intKeyMap = inboundClients = connectionHandler.getInboundClients();
                        synchronized (intKeyMap) {
                            inboundClients.put(id, (Object)inboundClient);
                        }
                        outBuf.put((byte)18);
                    }
                    outBuf.putInt(id);
                    outBuf.flip();
                    try {
                        this.connection.sendBlocking(outBuf, true);
                    }
                    catch (IOException e) {
                        log.trace("Send failed: %s", (Object)e);
                    }
                    return;
                }
                finally {
                    bufferPool.free((Object)outBuf);
                }
            }
            case 17: {
                OutboundClient client;
                IntKeyMap<OutboundClient> outboundClients;
                int id = buffer.getInt();
                Object bufferPool = outboundClients = connectionHandler.getOutboundClients();
                synchronized (bufferPool) {
                    client = (OutboundClient)outboundClients.remove(id);
                }
                if (client == null) {
                    log.trace("Received service-not-found for unknown client %d", (Object)id);
                    return;
                }
                bufferPool = client;
                synchronized (bufferPool) {
                    client.getResult().setException((IOException)new ServiceNotFoundException(ServiceURI.create(client.getServiceType(), client.getGroupName(), null)));
                    client.setState(OutboundClient.State.CLOSED);
                }
                return;
            }
            case 19: {
                OutboundClient client;
                IntKeyMap<OutboundClient> outboundClients;
                int id = buffer.getInt();
                Object bufferPool = outboundClients = connectionHandler.getOutboundClients();
                synchronized (bufferPool) {
                    client = (OutboundClient)outboundClients.remove(id);
                }
                if (client == null) {
                    log.trace("Received service-error for unknown client %d", (Object)id);
                    return;
                }
                bufferPool = client;
                synchronized (bufferPool) {
                    client.getResult().setException((IOException)new ServiceOpenException("Remote side failed to open service"));
                    client.setState(OutboundClient.State.CLOSED);
                }
                return;
            }
            case 18: {
                OutboundClient client;
                IntKeyMap<OutboundClient> outboundClients;
                int id = buffer.getInt();
                Object bufferPool = outboundClients = connectionHandler.getOutboundClients();
                synchronized (bufferPool) {
                    client = (OutboundClient)outboundClients.get(id);
                }
                if (client == null) {
                    log.trace("Received service-client-opened for unknown client %d", (Object)id);
                    return;
                }
                bufferPool = client;
                synchronized (bufferPool) {
                    client.setState(OutboundClient.State.ESTABLISHED);
                    client.setResult(new OutboundRequestHandler(client));
                }
                return;
            }
            case 20: {
                InboundClient client;
                IntKeyMap<InboundClient> inboundClients;
                int id = buffer.getInt();
                Object bufferPool = inboundClients = connectionHandler.getInboundClients();
                synchronized (bufferPool) {
                    client = (InboundClient)inboundClients.remove(id);
                }
                if (client == null) {
                    log.trace("Received client-closed for unknown client %d", (Object)id);
                    return;
                }
                bufferPool = client;
                synchronized (bufferPool) {
                    IoUtils.safeClose((Closeable)client.getHandler());
                }
                return;
            }
            case 21: {
                OutboundClient client;
                IntKeyMap<OutboundClient> outboundClients;
                int id = buffer.getInt();
                Object bufferPool = outboundClients = connectionHandler.getOutboundClients();
                synchronized (bufferPool) {
                    client = (OutboundClient)outboundClients.remove(id);
                }
                if (client == null) {
                    log.trace("Received client-closed for unknown client %d", (Object)id);
                    return;
                }
                bufferPool = client;
                synchronized (bufferPool) {
                    IoUtils.safeClose((Closeable)client.getRequestHandler());
                }
                return;
            }
            case 48: {
                NioByteInput byteInput;
                InboundRequest inboundRequest;
                int cid;
                int rid = buffer.getInt();
                byte flags = buffer.get();
                IntKeyMap<InboundRequest> inboundRequests = connectionHandler.getInboundRequests();
                boolean start = false;
                Object object = inboundRequests;
                synchronized (object) {
                    if ((flags & 1) != 0) {
                        cid = buffer.getInt();
                        inboundRequest = new InboundRequest(connectionHandler, rid);
                        start = true;
                        inboundRequests.put(rid, (Object)inboundRequest);
                        log.trace("Received first request message %s for %s", (Object)buffer, (Object)inboundRequest);
                    } else {
                        cid = 0;
                        inboundRequest = (InboundRequest)inboundRequests.get(rid);
                        log.trace("Received subsequent request message %s for %s", (Object)buffer, (Object)inboundRequest);
                    }
                    if (inboundRequest == null) {
                        log.trace("Received request for unknown request ID %d", (Object)rid);
                    }
                }
                object = inboundRequest;
                synchronized (object) {
                    if (start) {
                        connectionHandler.getConnectionContext().getConnectionProviderContext().getExecutor().execute(new InboundRequestTask(connectionHandler, inboundRequest, rid, cid));
                    }
                    byteInput = inboundRequest.getByteInput();
                }
                byteInput.push(buffer);
                return;
            }
            case 49: {
                InboundRequest inboundRequest;
                IntKeyMap<InboundRequest> inboundRequests;
                int rid = buffer.getInt();
                Object byteInput = inboundRequests = connectionHandler.getInboundRequests();
                synchronized (byteInput) {
                    inboundRequest = (InboundRequest)inboundRequests.remove(rid);
                }
                if (inboundRequest == null) {
                    log.trace("Received request-abort for unknown request ID %d", (Object)rid);
                    return;
                }
                byteInput = inboundRequest;
                synchronized (byteInput) {
                    inboundRequest.getReplyHandler().setDone();
                    inboundRequest.getByteInput().pushException((IOException)new InterruptedIOException("Request aborted"));
                }
                return;
            }
            case 50: {
                OutboundRequest outboundRequest;
                IntKeyMap<OutboundRequest> outboundRequests;
                int rid = buffer.getInt();
                Object byteInput = outboundRequests = connectionHandler.getOutboundRequests();
                synchronized (byteInput) {
                    outboundRequest = (OutboundRequest)outboundRequests.get(rid);
                }
                if (outboundRequest == null) {
                    log.trace("Received request-ack-chunk for unknown request ID %d", (Object)rid);
                    return;
                }
                byteInput = outboundRequest;
                synchronized (byteInput) {
                    outboundRequest.ack();
                }
                return;
            }
            case 51: {
                NioByteInput byteInput;
                OutboundRequest outboundRequest;
                IntKeyMap<OutboundRequest> outboundRequests;
                int rid = buffer.getInt();
                byte flags = buffer.get();
                Object cid = outboundRequests = connectionHandler.getOutboundRequests();
                synchronized (cid) {
                    outboundRequest = (OutboundRequest)outboundRequests.get(rid);
                }
                if (outboundRequest == null) {
                    log.trace("Received reply for unknown request ID %d", (Object)rid);
                    return;
                }
                cid = outboundRequest;
                synchronized (cid) {
                    if ((flags & 1) != 0) {
                        log.trace("Received first reply message %s for %s", (Object)buffer, (Object)outboundRequest);
                        byteInput = new NioByteInput((NioByteInput.InputHandler)new InboundReplyInputHandler(outboundRequest, rid));
                        outboundRequest.setByteInput(byteInput);
                        connectionHandler.getConnectionContext().getConnectionProviderContext().getExecutor().execute(new InboundReplyTask(connectionHandler, outboundRequest));
                    } else {
                        log.trace("Received subsequent reply message %s for %s", (Object)buffer, (Object)outboundRequest);
                        byteInput = outboundRequest.getByteInput();
                    }
                }
                byteInput.push(buffer);
                return;
            }
            case 53: {
                InboundRequest inboundRequest;
                IntKeyMap<InboundRequest> inboundRequests;
                int rid = buffer.getInt();
                Object byteInput = inboundRequests = connectionHandler.getInboundRequests();
                synchronized (byteInput) {
                    inboundRequest = (InboundRequest)inboundRequests.get(rid);
                }
                if (inboundRequest == null) {
                    log.trace("Received reply-ack-chunk for unknown request ID %d", (Object)rid);
                    return;
                }
                byteInput = inboundRequest;
                synchronized (byteInput) {
                    inboundRequest.ack();
                }
                return;
            }
            case 52: {
                NioByteInput byteInput;
                OutboundRequest outboundRequest;
                IntKeyMap<OutboundRequest> outboundRequests;
                int rid = buffer.getInt();
                byte flags = buffer.get();
                Object cid = outboundRequests = connectionHandler.getOutboundRequests();
                synchronized (cid) {
                    outboundRequest = (OutboundRequest)outboundRequests.get(rid);
                }
                if (outboundRequest == null) {
                    log.trace("Received reply-exception for unknown request ID %d", (Object)rid);
                    return;
                }
                cid = outboundRequest;
                synchronized (cid) {
                    if ((flags & 1) != 0) {
                        byteInput = new NioByteInput((NioByteInput.InputHandler)new InboundReplyInputHandler(outboundRequest, rid));
                        outboundRequest.setByteInput(byteInput);
                        connectionHandler.getConnectionContext().getConnectionProviderContext().getExecutor().execute(new InboundReplyExceptionTask(connectionHandler, outboundRequest));
                    } else {
                        byteInput = outboundRequest.getByteInput();
                    }
                }
                byteInput.push(buffer);
                return;
            }
            case 54: {
                LocalReplyHandler replyHandler;
                OutboundRequest outboundRequest;
                NioByteInput outboundRequests;
                int rid = buffer.getInt();
                NioByteInput byteInput = outboundRequests = connectionHandler.getOutboundRequests();
                synchronized (byteInput) {
                    outboundRequest = (OutboundRequest)outboundRequests.get(rid);
                }
                if (outboundRequest == null) {
                    log.warn("Received reply-exception-abort for unknown request ID %d", (Object)rid);
                    return;
                }
                OutboundRequest cid = outboundRequest;
                synchronized (cid) {
                    byteInput = outboundRequest.getByteInput();
                    replyHandler = outboundRequest.getInboundReplyHandler();
                }
                ReplyException re = new ReplyException("Reply exception was aborted");
                if (byteInput != null) {
                    byteInput.pushException((IOException)re);
                }
                if (replyHandler != null) {
                    SpiUtils.safeHandleException(replyHandler, (IOException)re);
                }
                return;
            }
            case 99: {
                return;
            }
            case 35: {
                OutboundStream outboundStream;
                IntKeyMap<OutboundStream> outboundStreams;
                int sid = buffer.getInt();
                IntKeyMap<OutboundStream> intKeyMap = outboundStreams = connectionHandler.getOutboundStreams();
                synchronized (intKeyMap) {
                    outboundStream = (OutboundStream)outboundStreams.get(sid);
                }
                if (outboundStream == null) {
                    log.warn("Received stream-ack for unknown stream ID %d", (Object)sid);
                    return;
                }
                outboundStream.ack();
                return;
            }
            case 36: {
                OutboundStream outboundStream;
                IntKeyMap<OutboundStream> outboundStreams;
                int sid = buffer.getInt();
                IntKeyMap<OutboundStream> intKeyMap = outboundStreams = connectionHandler.getOutboundStreams();
                synchronized (intKeyMap) {
                    outboundStream = (OutboundStream)outboundStreams.get(sid);
                }
                if (outboundStream == null) {
                    log.warn("Received stream-ack for unknown stream ID %d", (Object)sid);
                    return;
                }
                outboundStream.asyncClose();
                return;
            }
            case 37: {
                OutboundStream outboundStream;
                IntKeyMap<OutboundStream> outboundStreams;
                int sid = buffer.getInt();
                IntKeyMap<OutboundStream> intKeyMap = outboundStreams = connectionHandler.getOutboundStreams();
                synchronized (intKeyMap) {
                    outboundStream = (OutboundStream)outboundStreams.get(sid);
                }
                if (outboundStream == null) {
                    log.warn("Received stream-async-exception for unknown stream ID %d", (Object)sid);
                    return;
                }
                outboundStream.asyncException();
                return;
            }
            case 38: {
                OutboundStream outboundStream;
                IntKeyMap<OutboundStream> outboundStreams;
                int sid = buffer.getInt();
                IntKeyMap<OutboundStream> intKeyMap = outboundStreams = connectionHandler.getOutboundStreams();
                synchronized (intKeyMap) {
                    outboundStream = (OutboundStream)outboundStreams.get(sid);
                }
                if (outboundStream == null) {
                    log.warn("Received stream-async-start for unknown stream ID %d", (Object)sid);
                    return;
                }
                outboundStream.asyncStart();
                return;
            }
            case 34: {
                InboundStream inboundStream;
                IntKeyMap<InboundStream> inboundStreams;
                int sid = buffer.getInt();
                IntKeyMap<InboundStream> intKeyMap = inboundStreams = connectionHandler.getInboundStreams();
                synchronized (intKeyMap) {
                    inboundStream = (InboundStream)inboundStreams.get(sid);
                }
                if (inboundStream == null) {
                    log.warn("Received stream-close for unknown stream ID %d", (Object)sid);
                    return;
                }
                inboundStream.getReceiver().pushEof();
                return;
            }
            case 32: {
                InboundStream inboundStream;
                IntKeyMap<InboundStream> inboundStreams;
                int sid = buffer.getInt();
                IntKeyMap<InboundStream> intKeyMap = inboundStreams = connectionHandler.getInboundStreams();
                synchronized (intKeyMap) {
                    inboundStream = (InboundStream)inboundStreams.get(sid);
                }
                if (inboundStream == null) {
                    log.warn("Received stream-data for unknown stream ID %d", (Object)sid);
                    return;
                }
                inboundStream.getReceiver().push(buffer);
                return;
            }
            case 33: {
                InboundStream inboundStream;
                IntKeyMap<InboundStream> inboundStreams;
                int sid = buffer.getInt();
                IntKeyMap<InboundStream> intKeyMap = inboundStreams = connectionHandler.getInboundStreams();
                synchronized (intKeyMap) {
                    inboundStream = (InboundStream)inboundStreams.get(sid);
                }
                if (inboundStream == null) {
                    log.warn("Received stream-exception for unknown stream ID %d", (Object)sid);
                    return;
                }
                inboundStream.getReceiver().pushException();
                return;
            }
        }
        log.error("Received invalid packet type on %s, closing", (Object)connectionHandler);
        IoUtils.safeClose((Closeable)connectionHandler);
    }
}

