/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.transaction.xa.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteTransaction
extends AbstractCacheTransaction
implements Cloneable {
    private static Log log = LogFactory.getLog(RemoteTransaction.class);
    private volatile boolean valid = true;

    public RemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
        this.modifications = modifications == null || modifications.length == 0 ? Collections.emptyList() : Arrays.asList(modifications);
        this.lookedUpEntries = new BidirectionalLinkedHashMap(this.modifications.size());
        this.tx = tx;
    }

    public RemoteTransaction(GlobalTransaction tx) {
        this.modifications = new LinkedList();
        this.lookedUpEntries = new BidirectionalLinkedHashMap();
        this.tx = tx;
    }

    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.valid) {
            if (log.isTraceEnabled()) {
                log.trace("Adding key " + key + " to tx " + this.getGlobalTransaction());
            }
        } else {
            throw new InvalidTransactionException("This remote transaction " + this.getGlobalTransaction() + " is invalid");
        }
        this.lookedUpEntries.put(key, e);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTransaction)) {
            return false;
        }
        RemoteTransaction that = (RemoteTransaction)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public Object clone() {
        try {
            RemoteTransaction dolly = (RemoteTransaction)super.clone();
            dolly.modifications = new ArrayList(this.modifications);
            dolly.lookedUpEntries = this.lookedUpEntries.clone();
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!!");
        }
    }

    public String toString() {
        return "RemoteTransaction{modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", tx=" + this.tx + '}';
    }

    public Set<Object> getLockedKeys() {
        HashSet<Object> result = new HashSet<Object>();
        for (Object e : this.getLookedUpEntries().keySet()) {
            result.add(e);
        }
        if (this.lookedUpEntries.entrySet().size() != result.size()) {
            throw new IllegalStateException("Different sizes!");
        }
        return result;
    }
}

