/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.infinispan.atomic.Operation;
import org.infinispan.marshall.Marshallable;

@Marshallable(externalizer=Externalizer.class, id=48)
public class RemoveOperation<K, V>
extends Operation<K, V> {
    private K key;
    private V oldValue;

    public RemoveOperation() {
    }

    RemoveOperation(K key, V oldValue) {
        this.key = key;
        this.oldValue = oldValue;
    }

    @Override
    public void rollback(Map<K, V> delegate) {
        if (this.oldValue != null) {
            delegate.put(this.key, this.oldValue);
        }
    }

    @Override
    public void replay(Map<K, V> delegate) {
        delegate.remove(this.key);
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            RemoveOperation remove = (RemoveOperation)object;
            output.writeObject(remove.key);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            RemoveOperation remove = new RemoveOperation();
            remove.key = input.readObject();
            return remove;
        }
    }
}

