/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.BARRIER;
import org.jgroups.protocols.PING;
import org.jgroups.protocols.VIEW_SYNC;
import org.jgroups.stack.Protocol;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class BARRIERTest {
    Address a1;
    Vector<Address> members;
    View v;
    Simulator s;
    BARRIER barrier_prot = new BARRIER();
    PING bottom_prot;

    @BeforeMethod
    public void setUp() throws Exception {
        this.a1 = UUID.randomUUID();
        this.members = new Vector();
        this.members.add(this.a1);
        this.v = new View(this.a1, 1L, this.members);
        this.s = new Simulator();
        this.s.setLocalAddress(this.a1);
        this.s.setView(this.v);
        this.s.addMember(this.a1);
        this.bottom_prot = new PING();
        VIEW_SYNC view_sync = new VIEW_SYNC();
        Protocol[] stack = new Protocol[]{view_sync, this.barrier_prot, this.bottom_prot};
        this.s.setProtocolStack(stack);
        this.s.start();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.s.stop();
    }

    public void testBlocking() {
        assert (!this.barrier_prot.isClosed());
        this.s.send(new Event(76));
        assert (this.barrier_prot.isClosed());
        this.s.send(new Event(77));
        assert (!this.barrier_prot.isClosed());
    }

    public void testThreadsBlockedOnBarrier() {
        MyReceiver receiver = new MyReceiver();
        this.s.setReceiver(receiver);
        this.s.send(new Event(76));
        for (int i = 0; i < 5; ++i) {
            new Thread(){

                @Override
                public void run() {
                    BARRIERTest.this.bottom_prot.up(new Event(1, new Message(null, null, null)));
                }
            }.start();
        }
        Util.sleep(2000L);
        int num_in_flight_threads = this.barrier_prot.getNumberOfInFlightThreads();
        assert (num_in_flight_threads == 0);
        this.s.send(new Event(77));
        Util.sleep(2000L);
        num_in_flight_threads = this.barrier_prot.getNumberOfInFlightThreads();
        assert (num_in_flight_threads == 0);
        int received_msgs = receiver.getNumberOfReceivedMessages();
        assert (received_msgs == 5) : "expected 5 messages but got " + received_msgs;
    }

    public void testThreadsBlockedOnMutex() throws InterruptedException {
        BlockingReceiver receiver = new BlockingReceiver();
        this.s.setReceiver(receiver);
        Thread thread = new Thread(){

            @Override
            public void run() {
                BARRIERTest.this.bottom_prot.up(new Event(1, new Message()));
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                BARRIERTest.this.bottom_prot.up(new Event(1, new Message()));
            }
        };
        thread.start();
        thread2.start();
        thread.join();
        thread2.join();
    }

    class BlockingReceiver
    implements Simulator.Receiver {
        BlockingReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Event evt) {
            System.out.println("Thread " + Thread.currentThread().getId() + " receive() called - about to enter mutex");
            BlockingReceiver blockingReceiver = this;
            synchronized (blockingReceiver) {
                System.out.println("Thread " + Thread.currentThread().getId() + " entered mutex");
                Util.sleep(2000L);
                System.out.println("Thread " + Thread.currentThread().getId() + " closing barrier");
                BARRIERTest.this.s.send(new Event(76));
                System.out.println("Thread " + Thread.currentThread().getId() + " closed barrier");
            }
        }
    }

    static class MyReceiver
    implements Simulator.Receiver {
        AtomicInteger num_mgs_received = new AtomicInteger(0);

        MyReceiver() {
        }

        @Override
        public void receive(Event evt) {
            if (evt.getType() == 1 && this.num_mgs_received.incrementAndGet() % 1000 == 0) {
                System.out.println("<== " + this.num_mgs_received.get());
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received.get();
        }
    }
}

